/*=====================================================================*/
/*    serrano/prgm/project/bigloo/fthread/src/DotNet/bglfthread.cs     */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Jan 30 10:40:23 2002                          */
/*    Last change :  Fri Mar 11 10:57:46 2005 (serrano)                */
/*    Copyright   :  2002-05 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    Bigloo Class for threads. Nothing fancy here.                    */
/*=====================================================================*/
using System;
using System.Threading;
using bigloo;

namespace bigloo.fthread {
   public class bglfthread {
      // global cpu token
      private static Object token;

      // Bigloo connection
      private Object bgl_obj;
      private Object ident;
      private procedure bgl_thunk;
      protected bgldynamic env;

      // parent thread (i.e. the Java thread that has entered this Bgl thread)
      private Thread parent;

      // The associated thread
      private readonly Thread thread;

      // class constructor
      static bglfthread() {
	 bglfdynamic.setup();
      }

      // public constructor
      public bglfthread() {
	 thread = new Thread( new ThreadStart( run ) );
      }

      // public constructor
      public bglfthread( procedure thunk ) {
	 bgl_thunk = thunk;
	 thread = new Thread( new ThreadStart( run ) );
      }

      // public constructor
      public bglfthread( procedure thunk, symbol name ) {
	 ident = name;
	 bgl_thunk = thunk;
	 thread = new Thread( new ThreadStart( run ) );
	 thread.Name = foreign.newstring( name.pname );
      }

      // Starts the thread
      public void start() {
	 thread.Start();
      }

      // This method is invoked by Bigloo when the Bigloo object
      // representing the thread has been allocated and the thread starts
      public void start( Object o ) {
	 bgl_obj = o;
	 start();
      }

      // This method is used for compatibility with the Posix implementation
      // Don't remove it
      public Object idSet( Object o ) {
	 ident = o;
	 return o;
      }

      // Return back the pointer to the Bigloo object
      public Object getBglObj() {
	 return bgl_obj;
      }

      // The thread entry-point
      private void run() {
	 Thread.SetData( Thread.GetNamedDataSlot( "bgldynamic" ), 
			 new bgldynamic( bgldynamic.abgldynamic.get() ) );
	 Thread.SetData( Thread.GetNamedDataSlot( "bglthread" ), thread );
	 try {
	    fairWait();
	    bgl_thunk.funcall0();
	 } catch( Exception e ) {
	    Console.Error.WriteLine( e.StackTrace );
	    try {
	       foreign.internalerror( e );
	    } catch( Exception ) {
	       Environment.Exit( 1 );
	    }
	 }
      }

      // wait for a notification
      public void fairWait() {
	 lock( this ) {
	    try {
	       while( token != this )
		  Monitor.Wait( this );
	    } catch( ThreadInterruptedException e ) {
	       Console.Error.WriteLine( "interrupted wait exception: " + e ); 
	    }
	 }
      }

      // switch to another thread
      public void fairSwitch( bglfthread next ) {
	 lock( next )
	    {
	       token = next;
	       Monitor.Pulse( next );
	    }
      }

      // enter the scheduler
      public void enter_scheduler() {
	 parent = Thread.CurrentThread;

	 /* switch into the scheduler thread */
	 fairSwitch( this );

	 /* wait for the token to be back */
	 lock( parent ) {
	    try {
	       while( token != parent )
		  Monitor.Wait( parent );
	    } catch( ThreadInterruptedException e ) {
	       Console.Error.WriteLine( "interrupted wait exception: " + e );
	    }
	 }
      }

      // leave scheduler
      public void leave_scheduler() {
	 token = null;

	 lock( parent ) {
	    token = parent;
	    Monitor.Pulse( parent );
	 }

	 lock( this ) {
	    while( token != this ) try
	    {
	       Monitor.Wait( this );
	    } catch( ThreadInterruptedException e ) {
	       Console.Error.WriteLine( "interrupted wait exception: " + e );
	    }
	 }
      }
   }
}
