;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Expand/mvalue.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Mar 22 10:35:52 2005                          */
;*    Last change :  Tue Mar 22 10:43:40 2005 (serrano)                */
;*    Copyright   :  2005 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    The macro expansion of multiple values                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module expand_multiple-values
   (include "Expand/expander.sch"
	    "Tools/trace.sch")
   (import  tools_progn
	    tools_args
	    tools_speek
	    tools_misc
	    expand_expander
	    expand_eps
	    expand_lambda
	    engine_param
	    type_type
	    ast_ident)
   (export  (expand-mvalue-bind ::obj ::procedure)
	    (expand-O-call-with-values ::obj ::procedure)
	    (expand-O-values ::obj ::procedure)))

;*---------------------------------------------------------------------*/
;*    expand-mvalue-bind ...                                           */
;*---------------------------------------------------------------------*/
(define (expand-mvalue-bind x e)
   (match-case x
      ((?- ?vars ?call . ?exprs)
       (expand-O-call-with-values `(call-with-values (lambda () ,call)
						     (lambda ,vars ,@exprs))
				  e))
      (else
       (error "multiple-value-bind" "Illegal form" x))))

;*---------------------------------------------------------------------*/
;*    expand-O-call-with-values ...                                    */
;*---------------------------------------------------------------------*/
(define (expand-O-call-with-values x e)
   (e (match-case x
	 ((?- ?producer (lambda () . ?body))
	  `(begin
	      ,(match-case producer
		  ((lambda () . ?prod)
		   `(begin ,@prod))
		  (else
		   `(,producer)))
	      ,@body))
	 ((?- ?producer (lambda (?v0) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      ,@body))
	 ((?- ?producer (lambda (?v0 ?v1) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4 ?v5) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4))
		    (,v5 ((@ %get-mvalues-val __r5_control_features_6_4) 5)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4 ?v5 ?v6) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4))
		    (,v5 ((@ %get-mvalues-val __r5_control_features_6_4) 5))
		    (,v6 ((@ %get-mvalues-val __r5_control_features_6_4) 6)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4 ?v5 ?v6 ?v7) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4))
		    (,v5 ((@ %get-mvalues-val __r5_control_features_6_4) 5))
		    (,v6 ((@ %get-mvalues-val __r5_control_features_6_4) 6))
		    (,v7 ((@ %get-mvalues-val __r5_control_features_6_4) 7)))
		 ,@body)))
	 (else
	  `((@ call-with-values __r5_control_features_6_4) ,@(cdr x))))
      e))

;*---------------------------------------------------------------------*/
;*    expand-O-values ...                                              */
;*---------------------------------------------------------------------*/
(define (expand-O-values x e)
   (match-case x
      ((?-)
       '((@ %set-mvalues-number! __r5_control_features_6_4) 0))
      ((?- ?val0)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_))))
	  `(let ((,g0 ,(e val0 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 1)
	      ,g0)))
      ((?- ?val0 ?val1)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 5)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4 ?val5)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_)))
	     (g5 (mark-symbol-non-user! (gensym 'val5_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e))
		 (,g5 ,(e val5 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 6)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 5 ,g5)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4 ?val5 ?val6)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_)))
	     (g5 (mark-symbol-non-user! (gensym 'val5_)))
	     (g6 (mark-symbol-non-user! (gensym 'val6_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e))
		 (,g5 ,(e val5 e))
		 (,g6 ,(e val6 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 7)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 5 ,g5)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 6 ,g6)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4 ?val5 ?val6 ?val7)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_)))
	     (g5 (mark-symbol-non-user! (gensym 'val5_)))
	     (g6 (mark-symbol-non-user! (gensym 'val6_)))
	     (g7 (mark-symbol-non-user! (gensym 'val7_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e))
		 (,g5 ,(e val5 e))
		 (,g6 ,(e val6 e))
		 (,g7 ,(e val7 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 5 ,g5)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 6 ,g6)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 7 ,g7)
	      ,g0)))
      (else
       (let ((g0 (mark-symbol-non-user! (gensym 'val_))))
	  `(let ((,g0 (list ,@(map (lambda (x) (e x e)) (cdr x)))))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) -1)
	      ,g0)))))
