/*
 * Biloba
 * Copyright (C) 2004-2008 Guillaume Demougeot, Colin Leroy
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

/**
 * Biloba - Q1 2005
	* Game by Guillaume Demougeot <dmgt@wanadoo.fr>
	* Code by Colin Leroy <colin@colino.net>
	*
	* i18n stuff
	*/

#include <stdlib.h>
#include <string.h>
#include "msg.h"
#include "utils.h"

int lang = -1;

static const char *msg[3][11];

void init_msgs(void)
{
	msg[0][M_ROUND]="Au tour de ";
	msg[0][M_DRAW]="Match nul";
	msg[0][M_WINS]=" vainqueur";
	msg[0][M_PLAYER_WINS]="Joueur x vainqueur";
	msg[0][M_PLAYER]="Joueur ";
	msg[0][M_WAITING]="Attente de %d joueur%s";
	msg[0][M_JOINED]="%s nous a rejoint";
	msg[0][M_NEWGAME]="Nouvelle partie";
	msg[0][M_ENOCONN]="Connexion impossible";
	msg[0][M_PLAYER_LEAVES]="Joueur x abandonne";
	msg[0][M_LEAVES]=" abandonne";
	
	msg[1][M_ROUND]="Up to ";
	msg[1][M_DRAW]="Draw";
	msg[1][M_WINS]=" wins";
	msg[1][M_PLAYER_WINS]="Player x wins";
	msg[1][M_PLAYER]="Player ";
	msg[1][M_WAITING]="Waiting for %d player%s";
	msg[1][M_JOINED]="%s joined";
	msg[1][M_NEWGAME]="New game";
	msg[1][M_ENOCONN]="Connection failed";
	msg[1][M_PLAYER_LEAVES]="Player x leaves";
	msg[1][M_LEAVES]=" leaves";
	
	msg[2][M_ROUND]="Turno de ";
	msg[2][M_DRAW]="Empate";
	msg[2][M_WINS]=" victorias";
	msg[2][M_PLAYER_WINS]="El jugador x gana";
	msg[2][M_PLAYER]="Jugador ";
	msg[2][M_WAITING]="Esperando por %d jugador%s";
	msg[2][M_JOINED]="%s se ha unido";
	msg[2][M_NEWGAME]="Nuevo juego";
	msg[2][M_ENOCONN]="Fallo al conectar";
	msg[2][M_PLAYER_LEAVES]="El jugador x abandona";
	msg[2][M_LEAVES]=" abandona";
}

const char *get_msg(MsgId id)
{
	if (lang < 0) {
		set_language();
		assert(langpath != NULL);

		if (!strcmp(langpath, "fr"))
			lang = 0;
		else if (!strcmp(langpath, "en"))
			lang = 1;
		else if (!strcmp(langpath, "es"))
			lang = 2;

		init_msgs();
	}
	assert (lang >= 0);

	return msg[lang][id];
}

