(*pp cpp $ARCH_FLAGS *)

(* File: size.mli

    Copyright (C) 2007-

      Jane Street Holding, LLC
      Author: Markus Mottl
      email: mmottl\@janestcapital.com
      WWW: http://www.janestcapital.com/ocaml

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

(** Size: compute size of values in the binary protocol. *)

open Common

type 'a sizer = 'a -> int
type ('a, 'b) sizer1 = 'a sizer -> 'b sizer
type ('a, 'b, 'c) sizer2 = 'a sizer -> ('b, 'c) sizer1
type ('a, 'b, 'c, 'd) sizer3 = 'a sizer -> ('b, 'c, 'd) sizer2

val bin_size_unit : unit sizer
val bin_size_bool : bool sizer
val bin_size_string : string sizer
val bin_size_char : char sizer
val bin_size_int : int sizer
val bin_size_float : float sizer
val bin_size_int32 : int32 sizer
val bin_size_int64 : int64 sizer
val bin_size_nativeint : nativeint sizer
val bin_size_nat0 : Nat0.t sizer
val bin_size_ref : ('a, 'a ref) sizer1
val bin_size_lazy : ('a, 'a lazy_t) sizer1
val bin_size_option : ('a, 'a option) sizer1
val bin_size_pair : ('a, 'b, 'a * 'b) sizer2
val bin_size_triple : ('a, 'b, 'c, 'a * 'b * 'c) sizer3
val bin_size_list : ('a, 'a list) sizer1
val bin_size_array : ('a, 'a array) sizer1
val bin_size_hashtbl : ('a, 'b, ('a, 'b) Hashtbl.t) sizer2
val bin_size_float32_vec : vec32 sizer
val bin_size_float64_vec : vec64 sizer
val bin_size_vec : vec sizer
val bin_size_float32_mat : mat32 sizer
val bin_size_float64_mat : mat64 sizer
val bin_size_mat : mat sizer
val bin_size_bigstring : buf sizer
val bin_size_float_array : float array sizer
val bin_size_variant_tag : [> ] sizer
val bin_size_int_8bit : int sizer
val bin_size_int_16bit : int sizer
val bin_size_int_32bit : int sizer

#ifdef ARCH_SIXTYFOUR
val bin_size_int_64bit : int sizer
#endif

val bin_size_int64_bits : int64 sizer
val bin_size_array_no_length : ('a, 'a array) sizer1
