#include "../src/mime.h"
#include "../src/mime-utils.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define INDENT(a) for (int i = 0; i < (a); ++i) printf(" ");

void printDoc(const Binc::MimePart &mime, int indent = 0)
{
  Binc::HeaderItem hi;
  if (mime.h.getFirstHeader("from", hi)) {
    INDENT(indent); printf("-- From: %s\n", hi.getValue().c_str());
  }
  if (mime.h.getFirstHeader("subject", hi)) {
    INDENT(indent); printf("-- Subject: %s\n", hi.getValue().c_str());
  }

  if (mime.multipart) {
    INDENT(indent); printf("Multipart: %i parts\n", mime.members.size());
    INDENT(indent); printf("Boundary: %s\n", mime.boundary.c_str());
  } else if (mime.messagerfc822) {
    INDENT(indent); printf("Message/RFC822: %i lines\n", mime.nbodylines);
  } else {
    INDENT(indent); printf("Subtype: %s\n", mime.subtype.c_str());
    INDENT(indent); printf("Total lines: %i\n", mime.nlines);
    INDENT(indent); printf("Body lines: %i\n", mime.nbodylines);
    INDENT(indent); printf("Size: %i\n", mime.size);
  }

  if (mime.members.size() > 0) {
    INDENT(indent); printf("Members {\n", mime.members.size());
    for (int i = 0; i < mime.members.size(); ++i) {
      if (i != 0) printf("\n");
      INDENT(indent + 2); printf("Child %i\n", i);
      printDoc(mime.members[i], indent + 2);
    }
    INDENT(indent); printf("}\n");
  }
}

int main(int argc, char *argv[])
{
    crlffile = open(argv[1], O_RDONLY);
    if (crlffile == -1) {
      perror(argv[1]);
      return 1;
    }

    Binc::MimeDocument mime;
    mime.parseFull(crlffile);
    printDoc(mime);
    close(crlffile);
    crlfReset();

  return 0;
}
