/*
 *  xalloc.c -- wrappers for malloc(), realloc(), strdup()
 *
 *  xalloc.c is a part of binkd project
 *
 *  Copyright (C) 1998  Dima Maloff, 5047/13
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. See COPYING.
 */

/*
 * $Id: xalloc.c,v 2.0 2001/01/10 12:12:39 gul Exp $
 *
 * $Log: xalloc.c,v $
 * Revision 2.0  2001/01/10 12:12:39  gul
 * Binkd is under CVS again
 *
 * Revision 1.1  1998/05/08  03:37:28  mff
 * Initial revision
 *
 */
#include <stdlib.h>
#include <string.h>

#include "tools.h"

void *xalloc (unsigned long size)
{
  void *p;
  
#if defined(DOS) && defined(__MSC__)
  if (size > 64535ul) Log (0, "Too large block for malloc (%lu bytes)", size);
#endif

  p = malloc (size);

  if (!p)
    Log (0, "Not enough memory (failed to allocate %lu byte(s))",
	 (unsigned long) size);
  return p;
}

void *xrealloc (void *ptr, unsigned long size)
{
  void *p = ptr;

#if defined(DOS) && defined(__MSC__)
  if (size > 64535ul) Log (0, "Too large block for realloc (%lu bytes)", size);
#endif
  
  if ((ptr = realloc (ptr, size)) == NULL)
    Log (0, "Not enough memory (failed to realloc %p to %lu byte(s))",
	 p, (unsigned long) size);
  return ptr;
}

void *xstrdup (const char *str)
{
  void *p = strdup (str);

  if (!p)
    Log (0, "Not enough memory (failed to strdup %lu byte(s) at %p)",
	 (unsigned long) strlen (str), str);
  return p;
}
