/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#define ALT_MENU 30

#define ALT_TOOLBAR 32

#define LARGH_BUTTON_BAR 62
#define ALT_FIN 200
#define LARGH_FIN 800

#define ALT_BUTT_LEFT 28
#define LARG_BUTTON_LEFT 28

#define LARG_BUTTON_LEFT_L (LARGH_BUTTON_BAR/2 - 2)
#define LARG_BUTTON_TOP 28
#define ALT_BUTT_TOP    28

#define HEIGHT_INF_BAR  (ALT_BUTT_TOP / 2)


#define PADD_BUTT 2

#define SPACER ALT_BUTT_LEFT


void export_image(std::string format);

void editor_window_cb(Fl_Widget* w , void* d);

void editor_3D_rotation_cb(Fl_Widget* w, void* d);


void start_plugin_cb(Fl_Widget* w, void* d);


/*
  flip 
*/

void editor_flip_v_cb(Fl_Widget* w, void* d);


/*
  flip
*/

void editor_flip_h_cb(Fl_Widget* w, void* d);

/**
 *Copia dagli appunti(!)
 */

void editor_paste_cb(Fl_Widget* w, void* d);

/**
 *Disegna la catena
 */

void editor_draw_chain(Fl_Widget* w, void* d);

/**
 *esporta
 */

void editor_export(Fl_Widget* w, void* d);

/**
 *esporta in png
 */

void editor_save_as_png_cb(Fl_Widget* w, void* d);





/**
 *esporta in ps
 */

void editor_save_as_ps_cb(Fl_Widget* w, void* d);



/**
 *undo!
 */

void editor_undo_cb(Fl_Widget* w, void* d);

/**
 *Riporta la configurazione ai valori hardcoded
 */

void editor_set_def_cb(Fl_Widget* w, void* d);



/**
 *Genera la finestra per editare le preferenze
 */

void config_cb(Fl_Widget* w, void* v);

/**
 *Finestra "about"
 */

void edit_about_cb(Fl_Widget* w, void* v);

/**
 *Finestra "no warranty"
 */

void edit_nowar_cb(Fl_Widget* w, void* v);

/**
 *Crea una finestra di dialogo  per scegliere gli oggetti della libreria
 *da aggiungere.
 */

void add_lib_cb(Fl_Widget* w, void* v);


/**
 *Crea una nuova finestra //DA FARE
 */

void copy_cb(Fl_Widget* w, void* v);


/**
 *Callbak per eliminare un elemento con un singolo click
 */

void kill_cb(Fl_Widget* w, void* v);

/**
 *Callback per scegliere il font
 */
void choose_font_cb(Fl_Widget* w, void* v);


/**
 *Callback per chiudere il programma
 *
 */

void quit_cb(Fl_Widget* w, void* v);


/**
 *Callback per aprire un file
 */

void open_file_cb(Fl_Widget* w, void* v);


/**
 *
 *Apre una finestra per slvare un file nel formato nativo
 */

void save_as_native_file_cb(Fl_Widget* w, void* v);



/**
 *salva
 */

void editor_save_native(Fl_Widget* w, void* v);

/**
 *Callback per la selezione degli atomi.
 */
void select_atom_cb(Fl_Widget* w, void* v);

/**
 *Callback per la selezione dei gruppi.
 */

void select_group_cb(Fl_Widget* w, void* v);


/**
 *cambia il colore degli elementi selezionati
 */

void select_color_cb(Fl_Widget* w, void* v);

/**
 *passa in modalita' selezione box
 */

void select_box_cb(Fl_Widget* w, void* v);


/**
 *Elimina gli elementi selezionati
 */

void delete_selected_cb(Fl_Widget* w, void* v);



/**
 *disegna un legame singolo
 */

void draw_single_bond_cb(Fl_Widget* w, void* v);

/**
 *disegna un legame doppio
 */

void draw_double_bond_cb(Fl_Widget* w, void* v);


/**
 *disegna un legame triplo
 */

void draw_triple_bond_cb(Fl_Widget* w, void* v);

/**
 *Disegna una freccia
 */

void draw_arrow_cb(Fl_Widget* w, void* v);

/**
 *disegna una curva di bezier
 */

void draw_bezier_cb(Fl_Widget* w, void* v);

/**
 *disegna una ellisse
 */

void draw_arc_cb(Fl_Widget* w, void* v);

/**
 * Disegna un etichetta
 */

void draw_etich_cb(Fl_Widget* w, void* v);

/**
 *Trasla gli elementi selezionati
 */

void translate_selected_cb(Fl_Widget* w, void* v);

/**
 *Ruota gli elementi selezionati
 */

void rotate_selected_cb(Fl_Widget* w, void* v);


/**
 *Ruota gli elementi selezionati di un angolo fisso
 */


void editor_rotate_selected_fixed_cb(Fl_Widget* w, void* v);


/**
 *Scala gli elementi selezionati
 */

void scale_selected_cb(Fl_Widget* w, void* v);


/**
 *Disegna un orbitale p;
 */

void draw_orb_cb(Fl_Widget* w, void* v);

//void draw_orb_cb(Fl_Widget* w, void* v);



void editor_zoom_cb(Fl_Widget* w, void* d);

void editor_unzoom_cb(Fl_Widget* w, void* d);

void editor_unzoom_1o1_cb(Fl_Widget* w, void* d);

/**
 *Questa classe rappresenta la finestra del programma
 */

class editor: public finestra_pr, public Fl_Double_Window {
  friend void editor_window_cb(Fl_Widget* w, void* d);
  friend void editor_flip_v_cb(Fl_Widget* w, void* d);
  friend void editor_flip_h_cb(Fl_Widget* w, void* d);
  friend void editor_paste_cb(Fl_Widget* w, void* d);
  friend void editor_draw_chain(Fl_Widget* w, void* d);
  friend void save_as_native_file_cb(Fl_Widget* w, void* v);
  friend void editor_save_native(Fl_Widget* w, void* v);
  friend void editor_rotate_selected_fixed_cb(Fl_Widget* w, void* v);
  friend void editor_undo_cb(Fl_Widget* w, void* d);
  friend void edit_nowar_cb(Fl_Widget* w, void* v);
  friend void edit_about_cb(Fl_Widget* w, void* v);
  friend void add_lib_cb(Fl_Widget* w, void* v);
  friend void draw_orb_cb(Fl_Widget* w, void* v);
  friend void scale_selected_cb(Fl_Widget* w, void* v);
  friend void rotate_selected_cb(Fl_Widget* w, void* v);
  friend void translate_selected_cb(Fl_Widget* w, void* v);
  friend void select_atom_cb(Fl_Widget* w, void* v);
  friend void select_group_cb(Fl_Widget* w, void* v);
  friend void select_box_cb(Fl_Widget* w, void* v);
  friend void select_color_cb(Fl_Widget* w, void* v);
  friend void delete_selected_cb(Fl_Widget* w, void* v);
  friend void kill_cb(Fl_Widget* w, void* v);
  friend void draw_single_bond_cb(Fl_Widget* w, void* v);
  friend void draw_double_bond_cb(Fl_Widget* w, void* v);
  friend void draw_triple_bond_cb(Fl_Widget* w, void* v);
  friend void draw_arrow_cb(Fl_Widget* w, void* v);
  friend void draw_bezier_cb(Fl_Widget* w, void* v);
  friend void draw_arc_cb(Fl_Widget* w, void* v);
  friend void draw_etich_cb(Fl_Widget* w, void* v);
  friend void open_file_cb(Fl_Widget* w, void* v);
  friend void start_plugin_cb(Fl_Widget* w, void* d);
  friend void editor_3D_rotation_cb(Fl_Widget* w, void* d);
  friend void editor_zoom_cb(Fl_Widget* w, void* d);
  friend void editor_unzoom_cb(Fl_Widget* w, void* d);
  friend void editor_unzoom_1o1_cb(Fl_Widget* w, void* d);
public:


  editor(int W,int H,const char * titolo);

  virtual ~editor();

  void file_inp(string file);
  

  /**
   *Registra  un  immagine nello  stack  degli  undo,  va richiamata  da
   *mol_canvas ogni volta che si modifica l'immagine.
   */

  void register_images_undo(immagine* imm);
  

  /**
   *\return the size of the deque useful to check if an imaggine hase been modified
   */

  deque<immagine>::size_type no_of_images_undo();

  virtual Fl_Scroll*  ritorna_scroll();
  virtual immagine*   ritorna_immagine();
  virtual mol_canvas* ritorna_mol_canvas();


  bist_plugin* actual_plugin();

  /**
   *cambia le dimensioni della canvas
   */

  void canvas_resize(int nw_width,int nw_height);


protected:
  editor()
  :Fl_Double_Window(800,600,"bist"),
   _scroller(LARGH_BUTTON_BAR,ALT_MENU+ALT_TOOLBAR, w()-LARGH_BUTTON_BAR, h()-ALT_MENU-ALT_TOOLBAR),
   _mol_can(LARGH_BUTTON_BAR,ALT_MENU+ALT_TOOLBAR,w(),h()),
   _il_menu(0, 0,w() , ALT_MENU),

   //barra di sinistra
   //_translate_sel(PADD_BUTT,ALT_MENU+ALT_TOOLBAR+PADD_BUTT,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),
   _select_atom(PADD_BUTT,ALT_MENU+ALT_TOOLBAR+PADD_BUTT,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),
   _select_group(PADD_BUTT,ALT_MENU*2+PADD_BUTT*2+ALT_TOOLBAR,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),
   _rotate_sel(PADD_BUTT,ALT_MENU*2+PADD_BUTT*2+ALT_TOOLBAR,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),
   _b_fixed_rotation(PADD_BUTT+LARG_BUTTON_TOP*2,
		     h()-ALT_TOOLBAR+PADD_BUTT,
		     LARG_BUTTON_TOP,ALT_BUTT_TOP),

   _b_rotate_3d(PADD_BUTT+LARG_BUTTON_TOP*2,
		h()-ALT_TOOLBAR+PADD_BUTT,
		LARG_BUTTON_TOP,ALT_BUTT_TOP),
   _scale_sel(PADD_BUTT,ALT_MENU*3+PADD_BUTT*3+ALT_TOOLBAR,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),


   _b_flip_v(PADD_BUTT+LARG_BUTTON_TOP*2,
	     h()-ALT_TOOLBAR+PADD_BUTT,
	     LARG_BUTTON_TOP,ALT_BUTT_TOP),
   _b_flip_h(PADD_BUTT+LARG_BUTTON_TOP*2,
	     h()-ALT_TOOLBAR+PADD_BUTT,
	     LARG_BUTTON_TOP,ALT_BUTT_TOP),


   _kill(PADD_BUTT,ALT_MENU*4+PADD_BUTT*4+ALT_TOOLBAR,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),
   _select_color(LARGH_BUTTON_BAR+PADD_BUTT,ALT_MENU+PADD_BUTT,LARG_BUTTON_TOP,ALT_BUTT_LEFT),


   //_select_box(PADD_BUTT,ALT_MENU*3+PADD_BUTT*3+ALT_TOOLBAR,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),

   _draw_single_bond(PADD_BUTT,ALT_MENU*5+PADD_BUTT*5+ALT_TOOLBAR,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),
   _draw_arrow(PADD_BUTT,ALT_MENU*8+PADD_BUTT*8+ALT_TOOLBAR,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),

   _draw_double_bond(PADD_BUTT,ALT_MENU*6+PADD_BUTT*6+ALT_TOOLBAR,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),
   _draw_bezier(PADD_BUTT,ALT_MENU*9+PADD_BUTT*9+ALT_TOOLBAR,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),
   _draw_triple_bond(PADD_BUTT,ALT_MENU*7+PADD_BUTT*7+ALT_TOOLBAR,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),
   _draw_arc(PADD_BUTT,ALT_MENU*10+PADD_BUTT*10+ALT_TOOLBAR,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),
   _draw_chain(PADD_BUTT+LARG_BUTTON_TOP*2,
		     h()-ALT_TOOLBAR+PADD_BUTT,
	       LARG_BUTTON_TOP,ALT_BUTT_TOP),

   _draw_etich(PADD_BUTT,ALT_MENU*10+PADD_BUTT*10+ALT_TOOLBAR,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),
   _draw_orb(PADD_BUTT,ALT_MENU*10+PADD_BUTT*10+ALT_TOOLBAR,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),
   _add_lib(PADD_BUTT,ALT_MENU*16+PADD_BUTT*16+ALT_TOOLBAR,LARG_BUTTON_LEFT,ALT_BUTT_LEFT),
   //riga sotto il menu
   _sup_frame(FL_UP_FRAME, 0, 0, 0, ALT_MENU,""),
   _new_b(PADD_BUTT,ALT_MENU+PADD_BUTT,LARG_BUTTON_TOP,ALT_BUTT_TOP),
   _open_file_b(PADD_BUTT,ALT_TOOLBAR+PADD_BUTT,LARG_BUTTON_TOP,ALT_BUTT_TOP),
   _save_file_b(PADD_BUTT+LARG_BUTTON_TOP,ALT_MENU+PADD_BUTT,LARG_BUTTON_TOP,ALT_BUTT_TOP),
   _save_file_as_b(PADD_BUTT+LARG_BUTTON_TOP,ALT_MENU+PADD_BUTT,LARG_BUTTON_TOP,ALT_BUTT_TOP),
   _exp_ps_b(PADD_BUTT+LARG_BUTTON_TOP,ALT_MENU+PADD_BUTT,LARG_BUTTON_TOP,ALT_BUTT_TOP),
   _exp_png_b(PADD_BUTT+LARG_BUTTON_TOP*4,ALT_MENU+PADD_BUTT,LARG_BUTTON_TOP,ALT_BUTT_TOP),
   _delete_selected(LARGH_BUTTON_BAR+PADD_BUTT+LARG_BUTTON_TOP,
		    ALT_MENU+PADD_BUTT,LARG_BUTTON_TOP,ALT_BUTT_LEFT),

   _undo_b(PADD_BUTT+LARG_BUTTON_TOP*5,ALT_MENU+PADD_BUTT,LARG_BUTTON_TOP,ALT_BUTT_TOP),

   _b_paste(PADD_BUTT+LARG_BUTTON_TOP*2,
	    h()-ALT_TOOLBAR+PADD_BUTT,
	    LARG_BUTTON_TOP,ALT_BUTT_TOP),



   _zoom_b(PADD_BUTT+LARG_BUTTON_TOP*7,ALT_MENU+PADD_BUTT,LARG_BUTTON_TOP,ALT_BUTT_TOP),
   _unzoom_1o1_b(PADD_BUTT+LARG_BUTTON_TOP*8,ALT_MENU+PADD_BUTT,LARG_BUTTON_TOP,ALT_BUTT_TOP),
   _unzoom_b(PADD_BUTT+LARG_BUTTON_TOP*8,ALT_MENU+PADD_BUTT,LARG_BUTTON_TOP,ALT_BUTT_TOP),
   _inf_frame(FL_EMBOSSED_BOX,0,0,0,0,"")


   //_select_font_face(LARGH_BUTTON_BAR+PADD_BUTT+LARG_BUTTON_LEFT*3-10,ALT_MENU+PADD_BUTT,
   //	     LARG_BUTTON_LEFT*2,ALT_BUTT_LEFT,"Font face:"),
   //_select_font_dimension(LARGH_BUTTON_BAR+PADD_BUTT+LARG_BUTTON_LEFT*7,
   //			  ALT_MENU+PADD_BUTT,
   //			  LARG_BUTTON_LEFT,
   //			  ALT_BUTT_LEFT,
   //			  "Font dimension:"),
   // _select_font_color(LARGH_BUTTON_BAR+PADD_BUTT+LARG_BUTTON_LEFT*8,
   // 		      ALT_MENU+PADD_BUTT,
   // 		      LARG_BUTTON_TOP,
   // 		      ALT_BUTT_LEFT)

  {


  }


  virtual void draw();

  virtual int handle(int e);

  /**
   *Draw mouse coordinate in information_bar
   *\return width of the string;
   */

  int draw_mouse_cordinate_inf_bar(int x=0, int font_size=14);

  /**
   *set button in gui and optionally action too
   */
  void set_button(int which, bool set_action=true);


  //Fl_Menu_Item  voci_menu[22];

  bist_plugin* _actual_plugin;

  Fl_Scroll _scroller;

  mol_canvas _mol_can;

  Fl_Help_Dialog* _help_dialog;

  Fl_Menu_Bar _il_menu;


  //Fl_Button  _translate_sel;

  Fl_Button  _select_atom;
  Fl_Button  _select_group;
  Fl_Button  _rotate_sel;
  Fl_Button  _b_fixed_rotation;
  Fl_Button  _b_rotate_3d;
  Fl_Button  _scale_sel;
  Fl_Button  _b_flip_v;
  Fl_Button  _b_flip_h;


  Fl_Button  _kill;
  Fl_Button  _select_color;
  Fl_Button  _draw_single_bond;
  Fl_Button  _draw_arrow;
  Fl_Button  _draw_double_bond;
  Fl_Button  _draw_bezier;

  Fl_Button  _draw_triple_bond;
  Fl_Button  _draw_arc;
  Fl_Button  _draw_chain;
  Fl_Button  _draw_etich;
  Fl_Button  _draw_orb;
  Fl_Button  _add_lib;

  Fl_Box     _sup_frame;
  Fl_Button  _new_b;
  Fl_Button  _open_file_b;
  Fl_Button  _save_file_b;
  Fl_Button  _save_file_as_b;
  Fl_Button  _exp_ps_b;
  Fl_Button  _exp_png_b;
  Fl_Button  _delete_selected;
  Fl_Button  _undo_b;


  //Fl_Box _inf_frame;


  Fl_Button     _b_paste;


  Fl_Button  _zoom_b;
  Fl_Button  _unzoom_1o1_b;
  Fl_Button  _unzoom_b;


  Fl_Box _inf_frame;


  string _file_opened;


  /**
   *i path dei plugin
   *
   */
  vector <string> _dl_plugin_path;

  /*
   *l'indirizzo dei simboli della libreria
   */

  void* _dl_handle;


  
  /**
   *      front
   *   +---------------+
   *   |       	       |
   *   |       	       |
   *   |               |
   *   |               |
   *   |               |
   *   |               |
   *   +---------------+
   *      back
   */


  

  deque<immagine> _immagini;


  bool _file_saved;

};
