# THIS FILE IS AUTOMATICALLY GENERATED.  EDIT THE SOURCE FILE NOT THIS ONE

"""Various descriptions of data specific to the Samsung SCH-U750 (Alias 2) Phone"""

from prototypes import *
from prototypes_samsung import *
from p_brew import *
from p_samsungschu470 import *

SND_PATH='brew/mod/18067'
SND_INDEX_FILE_NAME=SND_PATH+'/MsInfo.db'
SND_EXCLUDED_FILES=('MsInfo.db',)
SND_PRELOADED_PREFIX=SND_PATH+'/SCH-U750_PRELOADED_'

# phonebook stuff,
PB_WP_CACHE_WIDTH=80
PB_WP_CACHE_HEIGHT=106
PB_MAX_IMNAME_LEN=50
PB_MAX_STREET_LEN=50
PB_MAX_CITY_LEN=50
PB_MAX_STATE_LEN=50
PB_MAX_ZIP_LEN=10
PB_MAX_COUNTRY_LEN=50
# Flag
PB_FLG_IMNAME1=0x8000
# Flag 2
PB_FLG_IMNAME2=0x0001
PB_FLG_STREET=0x0002
PB_FLG_CITY=0x0004
PB_FLG_STATE=0x0008
PB_FLG_ZIP=0x0010
PB_FLG_COUNTRY=0x0020
PB_FLG_ENTRY_WP=0x0100
PB_FLG_ENTRY_RT=0x0080
PB_FLG_ENTRY_CACHED_WP=0x0040
# each number entry flag
PB_FLG_DUNNO1=0x04
class WSoundsIndexEntry(BaseProtogenClass):
    __fields=['name', 'path_prefix', 'pathname', 'eor']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(WSoundsIndexEntry,self).__init__(**dict)
        if self.__class__ is WSoundsIndexEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(WSoundsIndexEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(WSoundsIndexEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_name
        except:
            self.__field_name=STRING()


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_path_prefix
        except:
            self.__field_path_prefix=STRING(**{ 'terminator': None,               'default': '/ff/' })
        self.__field_path_prefix.writetobuffer(buf)
        self.__field_pathname.writetobuffer(buf)
        try: self.__field_eor
        except:
            self.__field_eor=STRING(**{ 'terminator': None,               'default': '|0|7\x0A' })
        self.__field_eor.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_path_prefix=STRING(**{ 'terminator': None,               'default': '/ff/' })
        self.__field_path_prefix.readfrombuffer(buf)
        self.__field_pathname=STRING(**{ 'terminator': None })
        self.__field_pathname.readfrombuffer(buf)
        self.__field_eor=STRING(**{ 'terminator': None,               'default': '|0|7\x0A' })
        self.__field_eor.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,STRING):
            self.__field_name=value
        else:
            self.__field_name=STRING(value,)

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_path_prefix(self):
        try: self.__field_path_prefix
        except:
            self.__field_path_prefix=STRING(**{ 'terminator': None,               'default': '/ff/' })
        return self.__field_path_prefix.getvalue()

    def __setfield_path_prefix(self, value):
        if isinstance(value,STRING):
            self.__field_path_prefix=value
        else:
            self.__field_path_prefix=STRING(value,**{ 'terminator': None,               'default': '/ff/' })

    def __delfield_path_prefix(self): del self.__field_path_prefix

    path_prefix=property(__getfield_path_prefix, __setfield_path_prefix, __delfield_path_prefix, None)

    def __getfield_pathname(self):
        return self.__field_pathname.getvalue()

    def __setfield_pathname(self, value):
        if isinstance(value,STRING):
            self.__field_pathname=value
        else:
            self.__field_pathname=STRING(value,**{ 'terminator': None })

    def __delfield_pathname(self): del self.__field_pathname

    pathname=property(__getfield_pathname, __setfield_pathname, __delfield_pathname, None)

    def __getfield_eor(self):
        try: self.__field_eor
        except:
            self.__field_eor=STRING(**{ 'terminator': None,               'default': '|0|7\x0A' })
        return self.__field_eor.getvalue()

    def __setfield_eor(self, value):
        if isinstance(value,STRING):
            self.__field_eor=value
        else:
            self.__field_eor=STRING(value,**{ 'terminator': None,               'default': '|0|7\x0A' })

    def __delfield_eor(self): del self.__field_eor

    eor=property(__getfield_eor, __setfield_eor, __delfield_eor, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('name', self.__field_name, None)
        yield ('path_prefix', self.__field_path_prefix, None)
        yield ('pathname', self.__field_pathname, None)
        yield ('eor', self.__field_eor, None)




class WSoundsIndexFile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(WSoundsIndexFile,self).__init__(**dict)
        if self.__class__ is WSoundsIndexFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(WSoundsIndexFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(WSoundsIndexFile,kwargs)
        if len(args):
            dict2={ 'elementclass': WSoundsIndexEntry }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': WSoundsIndexEntry })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': WSoundsIndexEntry })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': WSoundsIndexEntry })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': WSoundsIndexEntry })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class RSoundIndexEntry(BaseProtogenClass):
    __fields=['pathname', 'misc']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(RSoundIndexEntry,self).__init__(**dict)
        if self.__class__ is RSoundIndexEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(RSoundIndexEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(RSoundIndexEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pathname.writetobuffer(buf)
        self.__field_misc.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pathname=STRING(**{ 'terminator': 0x7C })
        self.__field_pathname.readfrombuffer(buf)
        self.__field_misc=STRING(**{ 'terminator': 0x0A })
        self.__field_misc.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pathname(self):
        return self.__field_pathname.getvalue()

    def __setfield_pathname(self, value):
        if isinstance(value,STRING):
            self.__field_pathname=value
        else:
            self.__field_pathname=STRING(value,**{ 'terminator': 0x7C })

    def __delfield_pathname(self): del self.__field_pathname

    pathname=property(__getfield_pathname, __setfield_pathname, __delfield_pathname, None)

    def __getfield_misc(self):
        return self.__field_misc.getvalue()

    def __setfield_misc(self, value):
        if isinstance(value,STRING):
            self.__field_misc=value
        else:
            self.__field_misc=STRING(value,**{ 'terminator': 0x0A })

    def __delfield_misc(self): del self.__field_misc

    misc=property(__getfield_misc, __setfield_misc, __delfield_misc, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pathname', self.__field_pathname, None)
        yield ('misc', self.__field_misc, None)




class RSoundsIndexFile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(RSoundsIndexFile,self).__init__(**dict)
        if self.__class__ is RSoundsIndexFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(RSoundsIndexFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(RSoundsIndexFile,kwargs)
        if len(args):
            dict2={ 'elementclass': RSoundIndexEntry }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': RSoundIndexEntry })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': RSoundIndexEntry })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': RSoundIndexEntry })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': RSoundIndexEntry })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class NumberEntry(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['number', 'option', 'speeddial']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(NumberEntry,self).__init__(**dict)
        if self.__class__ is NumberEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(NumberEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(NumberEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_number=STRING(**{ 'terminator': None,               'pascal': True })
        self.__field_number.readfrombuffer(buf)
        self.__field_option=UINT(**{'sizeinbytes': 1})
        self.__field_option.readfrombuffer(buf)
        if self.has_speeddial:
            self.__field_speeddial=UINT(**{'sizeinbytes': 2})
            self.__field_speeddial.readfrombuffer(buf)
        if self.has_dunno1:
            DONTCARE(**{'sizeinbytes': 4}).readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_number(self):
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,STRING):
            self.__field_number=value
        else:
            self.__field_number=STRING(value,**{ 'terminator': None,               'pascal': True })

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def __getfield_option(self):
        return self.__field_option.getvalue()

    def __setfield_option(self, value):
        if isinstance(value,UINT):
            self.__field_option=value
        else:
            self.__field_option=UINT(value,**{'sizeinbytes': 1})

    def __delfield_option(self): del self.__field_option

    option=property(__getfield_option, __setfield_option, __delfield_option, None)

    def __getfield_speeddial(self):
        return self.__field_speeddial.getvalue()

    def __setfield_speeddial(self, value):
        if isinstance(value,UINT):
            self.__field_speeddial=value
        else:
            self.__field_speeddial=UINT(value,**{'sizeinbytes': 2})

    def __delfield_speeddial(self): del self.__field_speeddial

    speeddial=property(__getfield_speeddial, __setfield_speeddial, __delfield_speeddial, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('number', self.__field_number, None)
        yield ('option', self.__field_option, None)
        if self.has_speeddial:
            yield ('speeddial', self.__field_speeddial, None)
        if self.has_dunno1:
            pass

    @property
    def has_speeddial(self):
        return bool(self.option & PB_FLG_SPEEDDIAL)
    @property
    def has_dunno1(self):
        return bool(self.option & PB_FLG_DUNNO1)
    @property
    def is_primary(self):
        return bool(self.option & PB_FLG_PRIMARY)
    @property
    def has_ringtone(self):
        return False




class PBEntry(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['info', 'info2', 'name', 'email', 'email2', 'home', 'work', 'cell', 'fax', 'cell2', 'note', 'datetime', 'group', 'im_name', 'im_type', 'street', 'city', 'state', 'zipcode', 'country', 'cached_wp', 'cached_wp_num', 'ringtone', 'wallpaper']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PBEntry,self).__init__(**dict)
        if self.__class__ is PBEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PBEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PBEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_info=UINT(**{'sizeinbytes': 2})
        self.__field_info.readfrombuffer(buf)
        self.__field_info2=UINT(**{'sizeinbytes': 2})
        self.__field_info2.readfrombuffer(buf)
        if self.has_name:
            self.__field_name=USTRING(**{ 'terminator': None,                    'encoding': ENCODING,                    'pascal': True })
            self.__field_name.readfrombuffer(buf)
        if self.has_email:
            self.__field_email=USTRING(**{ 'terminator': None,                    'encoding': ENCODING,                    'pascal': True })
            self.__field_email.readfrombuffer(buf)
        if self.has_email2:
            self.__field_email2=USTRING(**{ 'terminator': None,                    'encoding': ENCODING,                   'pascal': True })
            self.__field_email2.readfrombuffer(buf)
        if self.has_home:
            self.__field_home=NumberEntry()
            self.__field_home.readfrombuffer(buf)
        if self.has_work:
            self.__field_work=NumberEntry()
            self.__field_work.readfrombuffer(buf)
        if self.has_cell:
            self.__field_cell=NumberEntry()
            self.__field_cell.readfrombuffer(buf)
        if self.has_fax:
            self.__field_fax=NumberEntry()
            self.__field_fax.readfrombuffer(buf)
        if self.has_cell2:
            self.__field_cell2=NumberEntry()
            self.__field_cell2.readfrombuffer(buf)
        if self.has_note:
            self.__field_note=STRING(**{ 'terminator': None,                   'pascal': True })
            self.__field_note.readfrombuffer(buf)
        if self.has_date:
            self.__field_datetime=DateTime(**{'sizeinbytes': 4})
            self.__field_datetime.readfrombuffer(buf)
        if self.has_group:
            self.__field_group=UINT(**{'sizeinbytes': 4})
            self.__field_group.readfrombuffer(buf)
        if self.has_im_name:
            self.__field_im_name=STRING(**{ 'terminator': None,                   'pascal': True })
            self.__field_im_name.readfrombuffer(buf)
            self.__field_im_type=UINT(**{'sizeinbytes': 1})
            self.__field_im_type.readfrombuffer(buf)
        if self.has_street:
            self.__field_street=STRING(**{ 'terminator': None,                   'pascal': True })
            self.__field_street.readfrombuffer(buf)
        if self.has_city:
            self.__field_city=STRING(**{ 'terminator': None,                   'pascal': True })
            self.__field_city.readfrombuffer(buf)
        if self.has_state:
            self.__field_state=STRING(**{ 'terminator': None,                   'pascal': True })
            self.__field_state.readfrombuffer(buf)
        if self.has_zipcode:
            self.__field_zipcode=STRING(**{ 'terminator': None,                   'pascal': True })
            self.__field_zipcode.readfrombuffer(buf)
        if self.has_country:
            self.__field_country=STRING(**{ 'terminator': None,                   'pascal': True })
            self.__field_country.readfrombuffer(buf)
        if self.has_cached_wp:
            self.__field_cached_wp=STRING(**{ 'terminator': None,                   'pascal': True })
            self.__field_cached_wp.readfrombuffer(buf)
            self.__field_cached_wp_num=UINT(**{'sizeinbytes': 4})
            self.__field_cached_wp_num.readfrombuffer(buf)
        if self.has_ringtone:
            self.__field_ringtone=STRING(**{ 'terminator': None,                   'pascal': True })
            self.__field_ringtone.readfrombuffer(buf)
        if self.has_wallpaper:
            self.__field_wallpaper=STRING(**{ 'terminator': None,                   'pascal': True })
            self.__field_wallpaper.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_info(self):
        return self.__field_info.getvalue()

    def __setfield_info(self, value):
        if isinstance(value,UINT):
            self.__field_info=value
        else:
            self.__field_info=UINT(value,**{'sizeinbytes': 2})

    def __delfield_info(self): del self.__field_info

    info=property(__getfield_info, __setfield_info, __delfield_info, None)

    def __getfield_info2(self):
        return self.__field_info2.getvalue()

    def __setfield_info2(self, value):
        if isinstance(value,UINT):
            self.__field_info2=value
        else:
            self.__field_info2=UINT(value,**{'sizeinbytes': 2})

    def __delfield_info2(self): del self.__field_info2

    info2=property(__getfield_info2, __setfield_info2, __delfield_info2, None)

    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{ 'terminator': None,                    'encoding': ENCODING,                    'pascal': True })

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_email(self):
        return self.__field_email.getvalue()

    def __setfield_email(self, value):
        if isinstance(value,USTRING):
            self.__field_email=value
        else:
            self.__field_email=USTRING(value,**{ 'terminator': None,                    'encoding': ENCODING,                    'pascal': True })

    def __delfield_email(self): del self.__field_email

    email=property(__getfield_email, __setfield_email, __delfield_email, None)

    def __getfield_email2(self):
        return self.__field_email2.getvalue()

    def __setfield_email2(self, value):
        if isinstance(value,USTRING):
            self.__field_email2=value
        else:
            self.__field_email2=USTRING(value,**{ 'terminator': None,                    'encoding': ENCODING,                   'pascal': True })

    def __delfield_email2(self): del self.__field_email2

    email2=property(__getfield_email2, __setfield_email2, __delfield_email2, None)

    def __getfield_home(self):
        return self.__field_home.getvalue()

    def __setfield_home(self, value):
        if isinstance(value,NumberEntry):
            self.__field_home=value
        else:
            self.__field_home=NumberEntry(value,)

    def __delfield_home(self): del self.__field_home

    home=property(__getfield_home, __setfield_home, __delfield_home, None)

    def __getfield_work(self):
        return self.__field_work.getvalue()

    def __setfield_work(self, value):
        if isinstance(value,NumberEntry):
            self.__field_work=value
        else:
            self.__field_work=NumberEntry(value,)

    def __delfield_work(self): del self.__field_work

    work=property(__getfield_work, __setfield_work, __delfield_work, None)

    def __getfield_cell(self):
        return self.__field_cell.getvalue()

    def __setfield_cell(self, value):
        if isinstance(value,NumberEntry):
            self.__field_cell=value
        else:
            self.__field_cell=NumberEntry(value,)

    def __delfield_cell(self): del self.__field_cell

    cell=property(__getfield_cell, __setfield_cell, __delfield_cell, None)

    def __getfield_fax(self):
        return self.__field_fax.getvalue()

    def __setfield_fax(self, value):
        if isinstance(value,NumberEntry):
            self.__field_fax=value
        else:
            self.__field_fax=NumberEntry(value,)

    def __delfield_fax(self): del self.__field_fax

    fax=property(__getfield_fax, __setfield_fax, __delfield_fax, None)

    def __getfield_cell2(self):
        return self.__field_cell2.getvalue()

    def __setfield_cell2(self, value):
        if isinstance(value,NumberEntry):
            self.__field_cell2=value
        else:
            self.__field_cell2=NumberEntry(value,)

    def __delfield_cell2(self): del self.__field_cell2

    cell2=property(__getfield_cell2, __setfield_cell2, __delfield_cell2, None)

    def __getfield_note(self):
        return self.__field_note.getvalue()

    def __setfield_note(self, value):
        if isinstance(value,STRING):
            self.__field_note=value
        else:
            self.__field_note=STRING(value,**{ 'terminator': None,                   'pascal': True })

    def __delfield_note(self): del self.__field_note

    note=property(__getfield_note, __setfield_note, __delfield_note, None)

    def __getfield_datetime(self):
        return self.__field_datetime.getvalue()

    def __setfield_datetime(self, value):
        if isinstance(value,DateTime):
            self.__field_datetime=value
        else:
            self.__field_datetime=DateTime(value,**{'sizeinbytes': 4})

    def __delfield_datetime(self): del self.__field_datetime

    datetime=property(__getfield_datetime, __setfield_datetime, __delfield_datetime, None)

    def __getfield_group(self):
        return self.__field_group.getvalue()

    def __setfield_group(self, value):
        if isinstance(value,UINT):
            self.__field_group=value
        else:
            self.__field_group=UINT(value,**{'sizeinbytes': 4})

    def __delfield_group(self): del self.__field_group

    group=property(__getfield_group, __setfield_group, __delfield_group, None)

    def __getfield_im_name(self):
        return self.__field_im_name.getvalue()

    def __setfield_im_name(self, value):
        if isinstance(value,STRING):
            self.__field_im_name=value
        else:
            self.__field_im_name=STRING(value,**{ 'terminator': None,                   'pascal': True })

    def __delfield_im_name(self): del self.__field_im_name

    im_name=property(__getfield_im_name, __setfield_im_name, __delfield_im_name, None)

    def __getfield_im_type(self):
        return self.__field_im_type.getvalue()

    def __setfield_im_type(self, value):
        if isinstance(value,UINT):
            self.__field_im_type=value
        else:
            self.__field_im_type=UINT(value,**{'sizeinbytes': 1})

    def __delfield_im_type(self): del self.__field_im_type

    im_type=property(__getfield_im_type, __setfield_im_type, __delfield_im_type, None)

    def __getfield_street(self):
        return self.__field_street.getvalue()

    def __setfield_street(self, value):
        if isinstance(value,STRING):
            self.__field_street=value
        else:
            self.__field_street=STRING(value,**{ 'terminator': None,                   'pascal': True })

    def __delfield_street(self): del self.__field_street

    street=property(__getfield_street, __setfield_street, __delfield_street, None)

    def __getfield_city(self):
        return self.__field_city.getvalue()

    def __setfield_city(self, value):
        if isinstance(value,STRING):
            self.__field_city=value
        else:
            self.__field_city=STRING(value,**{ 'terminator': None,                   'pascal': True })

    def __delfield_city(self): del self.__field_city

    city=property(__getfield_city, __setfield_city, __delfield_city, None)

    def __getfield_state(self):
        return self.__field_state.getvalue()

    def __setfield_state(self, value):
        if isinstance(value,STRING):
            self.__field_state=value
        else:
            self.__field_state=STRING(value,**{ 'terminator': None,                   'pascal': True })

    def __delfield_state(self): del self.__field_state

    state=property(__getfield_state, __setfield_state, __delfield_state, None)

    def __getfield_zipcode(self):
        return self.__field_zipcode.getvalue()

    def __setfield_zipcode(self, value):
        if isinstance(value,STRING):
            self.__field_zipcode=value
        else:
            self.__field_zipcode=STRING(value,**{ 'terminator': None,                   'pascal': True })

    def __delfield_zipcode(self): del self.__field_zipcode

    zipcode=property(__getfield_zipcode, __setfield_zipcode, __delfield_zipcode, None)

    def __getfield_country(self):
        return self.__field_country.getvalue()

    def __setfield_country(self, value):
        if isinstance(value,STRING):
            self.__field_country=value
        else:
            self.__field_country=STRING(value,**{ 'terminator': None,                   'pascal': True })

    def __delfield_country(self): del self.__field_country

    country=property(__getfield_country, __setfield_country, __delfield_country, None)

    def __getfield_cached_wp(self):
        return self.__field_cached_wp.getvalue()

    def __setfield_cached_wp(self, value):
        if isinstance(value,STRING):
            self.__field_cached_wp=value
        else:
            self.__field_cached_wp=STRING(value,**{ 'terminator': None,                   'pascal': True })

    def __delfield_cached_wp(self): del self.__field_cached_wp

    cached_wp=property(__getfield_cached_wp, __setfield_cached_wp, __delfield_cached_wp, None)

    def __getfield_cached_wp_num(self):
        return self.__field_cached_wp_num.getvalue()

    def __setfield_cached_wp_num(self, value):
        if isinstance(value,UINT):
            self.__field_cached_wp_num=value
        else:
            self.__field_cached_wp_num=UINT(value,**{'sizeinbytes': 4})

    def __delfield_cached_wp_num(self): del self.__field_cached_wp_num

    cached_wp_num=property(__getfield_cached_wp_num, __setfield_cached_wp_num, __delfield_cached_wp_num, None)

    def __getfield_ringtone(self):
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,STRING):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=STRING(value,**{ 'terminator': None,                   'pascal': True })

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def __getfield_wallpaper(self):
        return self.__field_wallpaper.getvalue()

    def __setfield_wallpaper(self, value):
        if isinstance(value,STRING):
            self.__field_wallpaper=value
        else:
            self.__field_wallpaper=STRING(value,**{ 'terminator': None,                   'pascal': True })

    def __delfield_wallpaper(self): del self.__field_wallpaper

    wallpaper=property(__getfield_wallpaper, __setfield_wallpaper, __delfield_wallpaper, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('info', self.__field_info, None)
        yield ('info2', self.__field_info2, None)
        if self.has_name:
            yield ('name', self.__field_name, None)
        if self.has_email:
            yield ('email', self.__field_email, None)
        if self.has_email2:
            yield ('email2', self.__field_email2, None)
        if self.has_home:
            yield ('home', self.__field_home, None)
        if self.has_work:
            yield ('work', self.__field_work, None)
        if self.has_cell:
            yield ('cell', self.__field_cell, None)
        if self.has_fax:
            yield ('fax', self.__field_fax, None)
        if self.has_cell2:
            yield ('cell2', self.__field_cell2, None)
        if self.has_note:
            yield ('note', self.__field_note, None)
        if self.has_date:
            yield ('datetime', self.__field_datetime, None)
        if self.has_group:
            yield ('group', self.__field_group, None)
        if self.has_im_name:
            yield ('im_name', self.__field_im_name, None)
            yield ('im_type', self.__field_im_type, None)
        if self.has_street:
            yield ('street', self.__field_street, None)
        if self.has_city:
            yield ('city', self.__field_city, None)
        if self.has_state:
            yield ('state', self.__field_state, None)
        if self.has_zipcode:
            yield ('zipcode', self.__field_zipcode, None)
        if self.has_country:
            yield ('country', self.__field_country, None)
        if self.has_cached_wp:
            yield ('cached_wp', self.__field_cached_wp, None)
            yield ('cached_wp_num', self.__field_cached_wp_num, None)
        if self.has_ringtone:
            yield ('ringtone', self.__field_ringtone, None)
        if self.has_wallpaper:
            yield ('wallpaper', self.__field_wallpaper, None)

    @property
    def has_name(self):
        return bool(self.info & PB_FLG_NAME)
    @property
    def has_email(self):
        return bool(self.info & PB_FLG_EMAIL)
    @property
    def has_email2(self):
        return bool(self.info & PB_FLG_EMAIL2)
    @property
    def has_home(self):
        return bool(self.info & PB_FLG_HOME)
    @property
    def has_work(self):
        return bool(self.info & PB_FLG_WORK)
    @property
    def has_cell(self):
        return bool(self.info & PB_FLG_CELL)
    @property
    def has_fax(self):
        return bool(self.info & PB_FLG_FAX)
    @property
    def has_cell2(self):
        return bool(self.info & PB_FLG_CELL2)
    @property
    def has_note(self):
        return bool(self.info & PB_FLG_NOTE)
    @property
    def has_date(self):
        return bool(self.info & PB_FLG_DATE)
    @property
    def has_group(self):
        return bool(self.info & PB_FLG_GROUP)
    @property
    def has_im_name(self):
        return bool((self.info & PB_FLG_IMNAME1) and (self.info2 & PB_FLG_IMNAME2))
    @property
    def has_street(self):
        return bool(self.info2 & PB_FLG_STREET)
    @property
    def has_city(self):
        return bool(self.info2 & PB_FLG_CITY)
    @property
    def has_state(self):
        return bool(self.info2 & PB_FLG_STATE)
    @property
    def has_zipcode(self):
        return bool(self.info2 & PB_FLG_ZIP)
    @property
    def has_country(self):
        return bool(self.info2 & PB_FLG_COUNTRY)
    @property
    def has_cached_wp(self):
        return bool(self.info2 & PB_FLG_ENTRY_CACHED_WP)
    @property
    def has_ringtone(self):
        return bool(self.info2 & PB_FLG_ENTRY_RT)
    @property
    def has_wallpaper(self):
        return bool(self.info2 & PB_FLG_ENTRY_WP)
    @property
    def has_address(self):
        # return True if this has at least one valid address item
        return self.has_street or self.has_city or self.has_state or \
               self.has_zipcode or self.has_country
    @property
    def address(self):
        # return the address in a BitPim phonebook addresses dict
        _addr={}
        if self.has_street:
            _addr['street']=self.street
        if self.has_city:
            _addr['city']=self.city
        if self.has_state:
            _addr['state']=self.state
        if self.has_zipcode:
            _addr['postalcode']=self.zipcode
        if self.has_country:
            _addr['country']=self.country
        return _addr




class LenEntry(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['itemlen']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(LenEntry,self).__init__(**dict)
        if self.__class__ is LenEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(LenEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(LenEntry,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2,  'default': 0 }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_itemlen=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_itemlen=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_itemlen.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_itemlen(self):
        try: self.__field_itemlen
        except:
            self.__field_itemlen=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_itemlen.getvalue()

    def __setfield_itemlen(self, value):
        if isinstance(value,UINT):
            self.__field_itemlen=value
        else:
            self.__field_itemlen=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_itemlen(self): del self.__field_itemlen

    itemlen=property(__getfield_itemlen, __setfield_itemlen, __delfield_itemlen, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('itemlen', self.__field_itemlen, None)




class PBFile(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['lens', 'items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PBFile,self).__init__(**dict)
        if self.__class__ is PBFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PBFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PBFile,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_lens=LIST(**{ 'elementclass': LenEntry,             'length': 8,             'createdefault': True })
        self.__field_lens.readfrombuffer(buf)
        self.__field_items=LIST(**{ 'elementclass': PBEntry })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_lens(self):
        try: self.__field_lens
        except:
            self.__field_lens=LIST(**{ 'elementclass': LenEntry,             'length': 8,             'createdefault': True })
        return self.__field_lens.getvalue()

    def __setfield_lens(self, value):
        if isinstance(value,LIST):
            self.__field_lens=value
        else:
            self.__field_lens=LIST(value,**{ 'elementclass': LenEntry,             'length': 8,             'createdefault': True })

    def __delfield_lens(self): del self.__field_lens

    lens=property(__getfield_lens, __setfield_lens, __delfield_lens, None)

    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': PBEntry })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': PBEntry })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('lens', self.__field_lens, None)
        yield ('items', self.__field_items, None)




class PBFileHeader(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['lens']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PBFileHeader,self).__init__(**dict)
        if self.__class__ is PBFileHeader:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PBFileHeader,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PBFileHeader,kwargs)
        if len(args):
            dict2={ 'elementclass': LenEntry,             'length': 8,             'createdefault': True }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_lens=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_lens=LIST(**{ 'elementclass': LenEntry,             'length': 8,             'createdefault': True })
        self.__field_lens.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_lens(self):
        try: self.__field_lens
        except:
            self.__field_lens=LIST(**{ 'elementclass': LenEntry,             'length': 8,             'createdefault': True })
        return self.__field_lens.getvalue()

    def __setfield_lens(self, value):
        if isinstance(value,LIST):
            self.__field_lens=value
        else:
            self.__field_lens=LIST(value,**{ 'elementclass': LenEntry,             'length': 8,             'createdefault': True })

    def __delfield_lens(self): del self.__field_lens

    lens=property(__getfield_lens, __setfield_lens, __delfield_lens, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('lens', self.__field_lens, None)




class ss_cmd_hdr(BaseProtogenClass):
    __fields=['commandcode', 'command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_cmd_hdr,self).__init__(**dict)
        if self.__class__ is ss_cmd_hdr:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_cmd_hdr,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_cmd_hdr,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_commandcode
        except:
            self.__field_commandcode=UINT(**{'sizeinbytes': 4,  'default': 0xfb4b })
        self.__field_commandcode.writetobuffer(buf)
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_commandcode=UINT(**{'sizeinbytes': 4,  'default': 0xfb4b })
        self.__field_commandcode.readfrombuffer(buf)
        self.__field_command=UINT(**{'sizeinbytes': 1})
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_commandcode(self):
        try: self.__field_commandcode
        except:
            self.__field_commandcode=UINT(**{'sizeinbytes': 4,  'default': 0xfb4b })
        return self.__field_commandcode.getvalue()

    def __setfield_commandcode(self, value):
        if isinstance(value,UINT):
            self.__field_commandcode=value
        else:
            self.__field_commandcode=UINT(value,**{'sizeinbytes': 4,  'default': 0xfb4b })

    def __delfield_commandcode(self): del self.__field_commandcode

    commandcode=property(__getfield_commandcode, __setfield_commandcode, __delfield_commandcode, None)

    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('commandcode', self.__field_commandcode, None)
        yield ('command', self.__field_command, None)




class ss_cmd_resp(BaseProtogenClass):
    __fields=['cmd_hdr', 'data']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_cmd_resp,self).__init__(**dict)
        if self.__class__ is ss_cmd_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_cmd_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_cmd_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_cmd_hdr.writetobuffer(buf)
        self.__field_data.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd_hdr=ss_cmd_hdr()
        self.__field_cmd_hdr.readfrombuffer(buf)
        self.__field_data=DATA()
        self.__field_data.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd_hdr(self):
        return self.__field_cmd_hdr.getvalue()

    def __setfield_cmd_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_cmd_hdr=value
        else:
            self.__field_cmd_hdr=ss_cmd_hdr(value,)

    def __delfield_cmd_hdr(self): del self.__field_cmd_hdr

    cmd_hdr=property(__getfield_cmd_hdr, __setfield_cmd_hdr, __delfield_cmd_hdr, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,)

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd_hdr', self.__field_cmd_hdr, None)
        yield ('data', self.__field_data, None)




class ss_sw_req(BaseProtogenClass):
    __fields=['hdr']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_sw_req,self).__init__(**dict)
        if self.__class__ is ss_sw_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_sw_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_sw_req,kwargs)
        if len(args):
            dict2={ 'command': SS_CMD_SW_VERSION }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_hdr=ss_cmd_hdr(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_SW_VERSION })
        self.__field_hdr.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_SW_VERSION })
        self.__field_hdr.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_SW_VERSION })
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,**{ 'command': SS_CMD_SW_VERSION })

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)




class ss_sw_resp(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['hdr', 'sw_version']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_sw_resp,self).__init__(**dict)
        if self.__class__ is ss_sw_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_sw_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_sw_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr()
        self.__field_hdr.readfrombuffer(buf)
        self.__field_sw_version=STRING(**{ 'terminator': 0 })
        self.__field_sw_version.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,)

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def __getfield_sw_version(self):
        return self.__field_sw_version.getvalue()

    def __setfield_sw_version(self, value):
        if isinstance(value,STRING):
            self.__field_sw_version=value
        else:
            self.__field_sw_version=STRING(value,**{ 'terminator': 0 })

    def __delfield_sw_version(self): del self.__field_sw_version

    sw_version=property(__getfield_sw_version, __setfield_sw_version, __delfield_sw_version, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)
        yield ('sw_version', self.__field_sw_version, None)




class ss_hw_req(BaseProtogenClass):
    __fields=['hdr']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_hw_req,self).__init__(**dict)
        if self.__class__ is ss_hw_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_hw_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_hw_req,kwargs)
        if len(args):
            dict2={ 'command': SS_CMD_HW_VERSION }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_hdr=ss_cmd_hdr(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_HW_VERSION })
        self.__field_hdr.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_HW_VERSION })
        self.__field_hdr.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_HW_VERSION })
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,**{ 'command': SS_CMD_HW_VERSION })

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)




class ss_hw_resp(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['hdr', 'hw_version']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_hw_resp,self).__init__(**dict)
        if self.__class__ is ss_hw_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_hw_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_hw_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr()
        self.__field_hdr.readfrombuffer(buf)
        self.__field_hw_version=STRING(**{ 'terminator': 0 })
        self.__field_hw_version.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,)

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def __getfield_hw_version(self):
        return self.__field_hw_version.getvalue()

    def __setfield_hw_version(self, value):
        if isinstance(value,STRING):
            self.__field_hw_version=value
        else:
            self.__field_hw_version=STRING(value,**{ 'terminator': 0 })

    def __delfield_hw_version(self): del self.__field_hw_version

    hw_version=property(__getfield_hw_version, __setfield_hw_version, __delfield_hw_version, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)
        yield ('hw_version', self.__field_hw_version, None)




class ss_pb_count_req(BaseProtogenClass):
    __fields=['hdr']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_pb_count_req,self).__init__(**dict)
        if self.__class__ is ss_pb_count_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_pb_count_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_pb_count_req,kwargs)
        if len(args):
            dict2={ 'command': SS_CMD_PB_COUNT }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_hdr=ss_cmd_hdr(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_COUNT })
        self.__field_hdr.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_COUNT })
        self.__field_hdr.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_COUNT })
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,**{ 'command': SS_CMD_PB_COUNT })

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)




class ss_pb_count_resp(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['hdr', 'count']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_pb_count_resp,self).__init__(**dict)
        if self.__class__ is ss_pb_count_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_pb_count_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_pb_count_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr()
        self.__field_hdr.readfrombuffer(buf)
        DONTCARE(**{'sizeinbytes': 1}).readfrombuffer(buf)
        self.__field_count=UINT(**{'sizeinbytes': 2})
        self.__field_count.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,)

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def __getfield_count(self):
        return self.__field_count.getvalue()

    def __setfield_count(self, value):
        if isinstance(value,UINT):
            self.__field_count=value
        else:
            self.__field_count=UINT(value,**{'sizeinbytes': 2})

    def __delfield_count(self): del self.__field_count

    count=property(__getfield_count, __setfield_count, __delfield_count, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)
        yield ('count', self.__field_count, None)




class ss_pb_read_req(BaseProtogenClass):
    __fields=['hdr', 'index']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_pb_read_req,self).__init__(**dict)
        if self.__class__ is ss_pb_read_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_pb_read_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_pb_read_req,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_READ })
        self.__field_hdr.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_276
        except:
            self.__field__gen_p_samsungschu750_276=DONTCARE(**{'sizeinbytes': 1})
        self.__field__gen_p_samsungschu750_276.writetobuffer(buf)
        self.__field_index.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_READ })
        self.__field_hdr.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_276=DONTCARE(**{'sizeinbytes': 1})
        self.__field__gen_p_samsungschu750_276.readfrombuffer(buf)
        self.__field_index=UINT(**{'sizeinbytes': 2})
        self.__field_index.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_READ })
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,**{ 'command': SS_CMD_PB_READ })

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 2})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)
        yield ('index', self.__field_index, None)




class ss_pb_read_resp(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['hdr', 'index', 'data']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_pb_read_resp,self).__init__(**dict)
        if self.__class__ is ss_pb_read_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_pb_read_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_pb_read_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr()
        self.__field_hdr.readfrombuffer(buf)
        DONTCARE(**{'sizeinbytes': 1}).readfrombuffer(buf)
        self.__field_index=UINT(**{'sizeinbytes': 2})
        self.__field_index.readfrombuffer(buf)
        DONTCARE(**{'sizeinbytes': 1}).readfrombuffer(buf)
        self.__field_data=DATA()
        self.__field_data.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,)

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 2})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,)

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)
        yield ('index', self.__field_index, None)
        yield ('data', self.__field_data, None)




class ss_pb_voicemail_read_req(BaseProtogenClass):
    __fields=['hdr', 'param']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_pb_voicemail_read_req,self).__init__(**dict)
        if self.__class__ is ss_pb_voicemail_read_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_pb_voicemail_read_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_pb_voicemail_read_req,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_VOICEMAIL_READ })
        self.__field_hdr.writetobuffer(buf)
        try: self.__field_param
        except:
            self.__field_param=UINT(**{'sizeinbytes': 1,  'constant': SS_CMD_PB_VOICEMAIL_PARAM })
        self.__field_param.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_VOICEMAIL_READ })
        self.__field_hdr.readfrombuffer(buf)
        self.__field_param=UINT(**{'sizeinbytes': 1,  'constant': SS_CMD_PB_VOICEMAIL_PARAM })
        self.__field_param.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_VOICEMAIL_READ })
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,**{ 'command': SS_CMD_PB_VOICEMAIL_READ })

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def __getfield_param(self):
        try: self.__field_param
        except:
            self.__field_param=UINT(**{'sizeinbytes': 1,  'constant': SS_CMD_PB_VOICEMAIL_PARAM })
        return self.__field_param.getvalue()

    def __setfield_param(self, value):
        if isinstance(value,UINT):
            self.__field_param=value
        else:
            self.__field_param=UINT(value,**{'sizeinbytes': 1,  'constant': SS_CMD_PB_VOICEMAIL_PARAM })

    def __delfield_param(self): del self.__field_param

    param=property(__getfield_param, __setfield_param, __delfield_param, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)
        yield ('param', self.__field_param, None)




class ss_pb_voicemail_resp(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['hdr', 'param', 'number']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_pb_voicemail_resp,self).__init__(**dict)
        if self.__class__ is ss_pb_voicemail_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_pb_voicemail_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_pb_voicemail_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr()
        self.__field_hdr.readfrombuffer(buf)
        self.__field_param=UINT(**{'sizeinbytes': 1})
        self.__field_param.readfrombuffer(buf)
        self.__field_number=STRING(**{ 'terminator': 0 })
        self.__field_number.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,)

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def __getfield_param(self):
        return self.__field_param.getvalue()

    def __setfield_param(self, value):
        if isinstance(value,UINT):
            self.__field_param=value
        else:
            self.__field_param=UINT(value,**{'sizeinbytes': 1})

    def __delfield_param(self): del self.__field_param

    param=property(__getfield_param, __setfield_param, __delfield_param, None)

    def __getfield_number(self):
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,STRING):
            self.__field_number=value
        else:
            self.__field_number=STRING(value,**{ 'terminator': 0 })

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)
        yield ('param', self.__field_param, None)
        yield ('number', self.__field_number, None)




class ss_pb_voicemail_write_req(BaseProtogenClass):
    __fields=['hdr', 'param', 'number']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_pb_voicemail_write_req,self).__init__(**dict)
        if self.__class__ is ss_pb_voicemail_write_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_pb_voicemail_write_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_pb_voicemail_write_req,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_VOICEMAIL_WRITE })
        self.__field_hdr.writetobuffer(buf)
        try: self.__field_param
        except:
            self.__field_param=UINT(**{'sizeinbytes': 1,  'constant': SS_CMD_PB_VOICEMAIL_PARAM })
        self.__field_param.writetobuffer(buf)
        try: self.__field_number
        except:
            self.__field_number=STRING(**{ 'terminator': 0,               'default': PB_DEFAULT_VOICEMAIL_NUMBER })
        self.__field_number.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_VOICEMAIL_WRITE })
        self.__field_hdr.readfrombuffer(buf)
        self.__field_param=UINT(**{'sizeinbytes': 1,  'constant': SS_CMD_PB_VOICEMAIL_PARAM })
        self.__field_param.readfrombuffer(buf)
        self.__field_number=STRING(**{ 'terminator': 0,               'default': PB_DEFAULT_VOICEMAIL_NUMBER })
        self.__field_number.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_VOICEMAIL_WRITE })
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,**{ 'command': SS_CMD_PB_VOICEMAIL_WRITE })

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def __getfield_param(self):
        try: self.__field_param
        except:
            self.__field_param=UINT(**{'sizeinbytes': 1,  'constant': SS_CMD_PB_VOICEMAIL_PARAM })
        return self.__field_param.getvalue()

    def __setfield_param(self, value):
        if isinstance(value,UINT):
            self.__field_param=value
        else:
            self.__field_param=UINT(value,**{'sizeinbytes': 1,  'constant': SS_CMD_PB_VOICEMAIL_PARAM })

    def __delfield_param(self): del self.__field_param

    param=property(__getfield_param, __setfield_param, __delfield_param, None)

    def __getfield_number(self):
        try: self.__field_number
        except:
            self.__field_number=STRING(**{ 'terminator': 0,               'default': PB_DEFAULT_VOICEMAIL_NUMBER })
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,STRING):
            self.__field_number=value
        else:
            self.__field_number=STRING(value,**{ 'terminator': 0,               'default': PB_DEFAULT_VOICEMAIL_NUMBER })

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)
        yield ('param', self.__field_param, None)
        yield ('number', self.__field_number, None)




class ss_pb_clear_req(BaseProtogenClass):
    __fields=['hdr']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_pb_clear_req,self).__init__(**dict)
        if self.__class__ is ss_pb_clear_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_pb_clear_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_pb_clear_req,kwargs)
        if len(args):
            dict2={ 'command': SS_CMD_PB_CLEAR }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_hdr=ss_cmd_hdr(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_CLEAR })
        self.__field_hdr.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_CLEAR })
        self.__field_hdr.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_CLEAR })
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,**{ 'command': SS_CMD_PB_CLEAR })

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)




class ss_pb_clear_resp(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['hdr', 'flg']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_pb_clear_resp,self).__init__(**dict)
        if self.__class__ is ss_pb_clear_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_pb_clear_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_pb_clear_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr()
        self.__field_hdr.readfrombuffer(buf)
        self.__field_flg=UINT(**{'sizeinbytes': 2})
        self.__field_flg.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,)

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def __getfield_flg(self):
        return self.__field_flg.getvalue()

    def __setfield_flg(self, value):
        if isinstance(value,UINT):
            self.__field_flg=value
        else:
            self.__field_flg=UINT(value,**{'sizeinbytes': 2})

    def __delfield_flg(self): del self.__field_flg

    flg=property(__getfield_flg, __setfield_flg, __delfield_flg, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)
        yield ('flg', self.__field_flg, None)




class ss_number_entry(BaseProtogenClass):
    __fields=['number', 'speeddial', 'primary', 'ringtone']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_number_entry,self).__init__(**dict)
        if self.__class__ is ss_number_entry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_number_entry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_number_entry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_number
        except:
            self.__field_number=STRING(**{ 'terminator': 0,               'default': '',               'maxsizeinbytes': PB_MAX_NUMBER_LEN,               'raiseontruncate': False })
        self.__field_number.writetobuffer(buf)
        try: self.__field_speeddial
        except:
            self.__field_speeddial=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_speeddial.writetobuffer(buf)
        try: self.__field_primary
        except:
            self.__field_primary=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_primary.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_309
        except:
            self.__field__gen_p_samsungschu750_309=DONTCARE(**{'sizeinbytes': 8})
        self.__field__gen_p_samsungschu750_309.writetobuffer(buf)
        try: self.__field_ringtone
        except:
            self.__field_ringtone=STRING(**{ 'terminator': 0,               'default': '' })
        self.__field_ringtone.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_number=STRING(**{ 'terminator': 0,               'default': '',               'maxsizeinbytes': PB_MAX_NUMBER_LEN,               'raiseontruncate': False })
        self.__field_number.readfrombuffer(buf)
        self.__field_speeddial=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_speeddial.readfrombuffer(buf)
        self.__field_primary=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_primary.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_309=DONTCARE(**{'sizeinbytes': 8})
        self.__field__gen_p_samsungschu750_309.readfrombuffer(buf)
        self.__field_ringtone=STRING(**{ 'terminator': 0,               'default': '' })
        self.__field_ringtone.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_number(self):
        try: self.__field_number
        except:
            self.__field_number=STRING(**{ 'terminator': 0,               'default': '',               'maxsizeinbytes': PB_MAX_NUMBER_LEN,               'raiseontruncate': False })
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,STRING):
            self.__field_number=value
        else:
            self.__field_number=STRING(value,**{ 'terminator': 0,               'default': '',               'maxsizeinbytes': PB_MAX_NUMBER_LEN,               'raiseontruncate': False })

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def __getfield_speeddial(self):
        try: self.__field_speeddial
        except:
            self.__field_speeddial=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_speeddial.getvalue()

    def __setfield_speeddial(self, value):
        if isinstance(value,UINT):
            self.__field_speeddial=value
        else:
            self.__field_speeddial=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_speeddial(self): del self.__field_speeddial

    speeddial=property(__getfield_speeddial, __setfield_speeddial, __delfield_speeddial, None)

    def __getfield_primary(self):
        try: self.__field_primary
        except:
            self.__field_primary=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_primary.getvalue()

    def __setfield_primary(self, value):
        if isinstance(value,UINT):
            self.__field_primary=value
        else:
            self.__field_primary=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_primary(self): del self.__field_primary

    primary=property(__getfield_primary, __setfield_primary, __delfield_primary, None)

    def __getfield_ringtone(self):
        try: self.__field_ringtone
        except:
            self.__field_ringtone=STRING(**{ 'terminator': 0,               'default': '' })
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,STRING):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=STRING(value,**{ 'terminator': 0,               'default': '' })

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('number', self.__field_number, None)
        yield ('speeddial', self.__field_speeddial, None)
        yield ('primary', self.__field_primary, None)
        yield ('ringtone', self.__field_ringtone, None)




class ss_pb_entry(BaseProtogenClass):
    __fields=['name', 'email', 'email2', 'note', 'wallpaper', 'wallpaper_range', 'home', 'work', 'cell', 'dummy', 'fax', 'cell2', 'group', 'street', 'city', 'state', 'zipcode', 'country', 'im_name', 'im_type']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_pb_entry,self).__init__(**dict)
        if self.__class__ is ss_pb_entry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_pb_entry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_pb_entry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_name.writetobuffer(buf)
        try: self.__field_email
        except:
            self.__field_email=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })
        self.__field_email.writetobuffer(buf)
        try: self.__field_email2
        except:
            self.__field_email2=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })
        self.__field_email2.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_328
        except:
            self.__field__gen_p_samsungschu750_328=DONTCARE(**{'sizeinbytes': 2})
        self.__field__gen_p_samsungschu750_328.writetobuffer(buf)
        try: self.__field_note
        except:
            self.__field_note=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_NOTE_LEN,                'raiseontruncate': False,                'default': '' })
        self.__field_note.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_334
        except:
            self.__field__gen_p_samsungschu750_334=DONTCARE(**{'sizeinbytes': 1})
        self.__field__gen_p_samsungschu750_334.writetobuffer(buf)
        try: self.__field_wallpaper
        except:
            self.__field_wallpaper=STRING(**{ 'terminator': 0,               'default': '' })
        self.__field_wallpaper.writetobuffer(buf)
        try: self.__field_wallpaper_range
        except:
            self.__field_wallpaper_range=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_wallpaper_range.writetobuffer(buf)
        try: self.__field_home
        except:
            self.__field_home=ss_number_entry()
        self.__field_home.writetobuffer(buf)
        try: self.__field_work
        except:
            self.__field_work=ss_number_entry()
        self.__field_work.writetobuffer(buf)
        try: self.__field_cell
        except:
            self.__field_cell=ss_number_entry()
        self.__field_cell.writetobuffer(buf)
        try: self.__field_dummy
        except:
            self.__field_dummy=ss_number_entry()
        self.__field_dummy.writetobuffer(buf)
        try: self.__field_fax
        except:
            self.__field_fax=ss_number_entry()
        self.__field_fax.writetobuffer(buf)
        try: self.__field_cell2
        except:
            self.__field_cell2=ss_number_entry()
        self.__field_cell2.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_344
        except:
            self.__field__gen_p_samsungschu750_344=DONTCARE(**{'sizeinbytes': 4})
        self.__field__gen_p_samsungschu750_344.writetobuffer(buf)
        try: self.__field_group
        except:
            self.__field_group=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_group.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_346
        except:
            self.__field__gen_p_samsungschu750_346=DONTCARE(**{'sizeinbytes': 2})
        self.__field__gen_p_samsungschu750_346.writetobuffer(buf)
        try: self.__field_street
        except:
            self.__field_street=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_STREET_LEN,                'raiseontruncate': False,                'default': '' })
        self.__field_street.writetobuffer(buf)
        try: self.__field_city
        except:
            self.__field_city=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_CITY_LEN,                'raiseontruncate': False,                'default': '' })
        self.__field_city.writetobuffer(buf)
        try: self.__field_state
        except:
            self.__field_state=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_STATE_LEN,                'raiseontruncate': False,                'default': '' })
        self.__field_state.writetobuffer(buf)
        try: self.__field_zipcode
        except:
            self.__field_zipcode=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_ZIP_LEN,                'raiseontruncate': False,                'default': '' })
        self.__field_zipcode.writetobuffer(buf)
        try: self.__field_country
        except:
            self.__field_country=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_COUNTRY_LEN,                'raiseontruncate': False,                'default': '' })
        self.__field_country.writetobuffer(buf)
        try: self.__field_im_name
        except:
            self.__field_im_name=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_IMNAME_LEN,                'raiseontruncate': False,                'default': '' })
        self.__field_im_name.writetobuffer(buf)
        try: self.__field_im_type
        except:
            self.__field_im_type=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_im_type.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_name=USTRING(**{ 'terminator': 0,                'maxsizeinbytes': PB_MAX_NAME_LEN,                'encoding': ENCODING,                'raiseontruncate': False })
        self.__field_name.readfrombuffer(buf)
        self.__field_email=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })
        self.__field_email.readfrombuffer(buf)
        self.__field_email2=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })
        self.__field_email2.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_328=DONTCARE(**{'sizeinbytes': 2})
        self.__field__gen_p_samsungschu750_328.readfrombuffer(buf)
        self.__field_note=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_NOTE_LEN,                'raiseontruncate': False,                'default': '' })
        self.__field_note.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_334=DONTCARE(**{'sizeinbytes': 1})
        self.__field__gen_p_samsungschu750_334.readfrombuffer(buf)
        self.__field_wallpaper=STRING(**{ 'terminator': 0,               'default': '' })
        self.__field_wallpaper.readfrombuffer(buf)
        self.__field_wallpaper_range=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_wallpaper_range.readfrombuffer(buf)
        self.__field_home=ss_number_entry()
        self.__field_home.readfrombuffer(buf)
        self.__field_work=ss_number_entry()
        self.__field_work.readfrombuffer(buf)
        self.__field_cell=ss_number_entry()
        self.__field_cell.readfrombuffer(buf)
        self.__field_dummy=ss_number_entry()
        self.__field_dummy.readfrombuffer(buf)
        self.__field_fax=ss_number_entry()
        self.__field_fax.readfrombuffer(buf)
        self.__field_cell2=ss_number_entry()
        self.__field_cell2.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_344=DONTCARE(**{'sizeinbytes': 4})
        self.__field__gen_p_samsungschu750_344.readfrombuffer(buf)
        self.__field_group=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_group.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_346=DONTCARE(**{'sizeinbytes': 2})
        self.__field__gen_p_samsungschu750_346.readfrombuffer(buf)
        self.__field_street=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_STREET_LEN,                'raiseontruncate': False,                'default': '' })
        self.__field_street.readfrombuffer(buf)
        self.__field_city=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_CITY_LEN,                'raiseontruncate': False,                'default': '' })
        self.__field_city.readfrombuffer(buf)
        self.__field_state=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_STATE_LEN,                'raiseontruncate': False,                'default': '' })
        self.__field_state.readfrombuffer(buf)
        self.__field_zipcode=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_ZIP_LEN,                'raiseontruncate': False,                'default': '' })
        self.__field_zipcode.readfrombuffer(buf)
        self.__field_country=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_COUNTRY_LEN,                'raiseontruncate': False,                'default': '' })
        self.__field_country.readfrombuffer(buf)
        self.__field_im_name=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_IMNAME_LEN,                'raiseontruncate': False,                'default': '' })
        self.__field_im_name.readfrombuffer(buf)
        self.__field_im_type=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_im_type.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{ 'terminator': 0,                'maxsizeinbytes': PB_MAX_NAME_LEN,                'encoding': ENCODING,                'raiseontruncate': False })

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_email(self):
        try: self.__field_email
        except:
            self.__field_email=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })
        return self.__field_email.getvalue()

    def __setfield_email(self, value):
        if isinstance(value,USTRING):
            self.__field_email=value
        else:
            self.__field_email=USTRING(value,**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })

    def __delfield_email(self): del self.__field_email

    email=property(__getfield_email, __setfield_email, __delfield_email, None)

    def __getfield_email2(self):
        try: self.__field_email2
        except:
            self.__field_email2=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })
        return self.__field_email2.getvalue()

    def __setfield_email2(self, value):
        if isinstance(value,USTRING):
            self.__field_email2=value
        else:
            self.__field_email2=USTRING(value,**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })

    def __delfield_email2(self): del self.__field_email2

    email2=property(__getfield_email2, __setfield_email2, __delfield_email2, None)

    def __getfield_note(self):
        try: self.__field_note
        except:
            self.__field_note=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_NOTE_LEN,                'raiseontruncate': False,                'default': '' })
        return self.__field_note.getvalue()

    def __setfield_note(self, value):
        if isinstance(value,USTRING):
            self.__field_note=value
        else:
            self.__field_note=USTRING(value,**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_NOTE_LEN,                'raiseontruncate': False,                'default': '' })

    def __delfield_note(self): del self.__field_note

    note=property(__getfield_note, __setfield_note, __delfield_note, None)

    def __getfield_wallpaper(self):
        try: self.__field_wallpaper
        except:
            self.__field_wallpaper=STRING(**{ 'terminator': 0,               'default': '' })
        return self.__field_wallpaper.getvalue()

    def __setfield_wallpaper(self, value):
        if isinstance(value,STRING):
            self.__field_wallpaper=value
        else:
            self.__field_wallpaper=STRING(value,**{ 'terminator': 0,               'default': '' })

    def __delfield_wallpaper(self): del self.__field_wallpaper

    wallpaper=property(__getfield_wallpaper, __setfield_wallpaper, __delfield_wallpaper, None)

    def __getfield_wallpaper_range(self):
        try: self.__field_wallpaper_range
        except:
            self.__field_wallpaper_range=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_wallpaper_range.getvalue()

    def __setfield_wallpaper_range(self, value):
        if isinstance(value,UINT):
            self.__field_wallpaper_range=value
        else:
            self.__field_wallpaper_range=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_wallpaper_range(self): del self.__field_wallpaper_range

    wallpaper_range=property(__getfield_wallpaper_range, __setfield_wallpaper_range, __delfield_wallpaper_range, None)

    def __getfield_home(self):
        try: self.__field_home
        except:
            self.__field_home=ss_number_entry()
        return self.__field_home.getvalue()

    def __setfield_home(self, value):
        if isinstance(value,ss_number_entry):
            self.__field_home=value
        else:
            self.__field_home=ss_number_entry(value,)

    def __delfield_home(self): del self.__field_home

    home=property(__getfield_home, __setfield_home, __delfield_home, None)

    def __getfield_work(self):
        try: self.__field_work
        except:
            self.__field_work=ss_number_entry()
        return self.__field_work.getvalue()

    def __setfield_work(self, value):
        if isinstance(value,ss_number_entry):
            self.__field_work=value
        else:
            self.__field_work=ss_number_entry(value,)

    def __delfield_work(self): del self.__field_work

    work=property(__getfield_work, __setfield_work, __delfield_work, None)

    def __getfield_cell(self):
        try: self.__field_cell
        except:
            self.__field_cell=ss_number_entry()
        return self.__field_cell.getvalue()

    def __setfield_cell(self, value):
        if isinstance(value,ss_number_entry):
            self.__field_cell=value
        else:
            self.__field_cell=ss_number_entry(value,)

    def __delfield_cell(self): del self.__field_cell

    cell=property(__getfield_cell, __setfield_cell, __delfield_cell, None)

    def __getfield_dummy(self):
        try: self.__field_dummy
        except:
            self.__field_dummy=ss_number_entry()
        return self.__field_dummy.getvalue()

    def __setfield_dummy(self, value):
        if isinstance(value,ss_number_entry):
            self.__field_dummy=value
        else:
            self.__field_dummy=ss_number_entry(value,)

    def __delfield_dummy(self): del self.__field_dummy

    dummy=property(__getfield_dummy, __setfield_dummy, __delfield_dummy, None)

    def __getfield_fax(self):
        try: self.__field_fax
        except:
            self.__field_fax=ss_number_entry()
        return self.__field_fax.getvalue()

    def __setfield_fax(self, value):
        if isinstance(value,ss_number_entry):
            self.__field_fax=value
        else:
            self.__field_fax=ss_number_entry(value,)

    def __delfield_fax(self): del self.__field_fax

    fax=property(__getfield_fax, __setfield_fax, __delfield_fax, None)

    def __getfield_cell2(self):
        try: self.__field_cell2
        except:
            self.__field_cell2=ss_number_entry()
        return self.__field_cell2.getvalue()

    def __setfield_cell2(self, value):
        if isinstance(value,ss_number_entry):
            self.__field_cell2=value
        else:
            self.__field_cell2=ss_number_entry(value,)

    def __delfield_cell2(self): del self.__field_cell2

    cell2=property(__getfield_cell2, __setfield_cell2, __delfield_cell2, None)

    def __getfield_group(self):
        try: self.__field_group
        except:
            self.__field_group=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_group.getvalue()

    def __setfield_group(self, value):
        if isinstance(value,UINT):
            self.__field_group=value
        else:
            self.__field_group=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_group(self): del self.__field_group

    group=property(__getfield_group, __setfield_group, __delfield_group, None)

    def __getfield_street(self):
        try: self.__field_street
        except:
            self.__field_street=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_STREET_LEN,                'raiseontruncate': False,                'default': '' })
        return self.__field_street.getvalue()

    def __setfield_street(self, value):
        if isinstance(value,USTRING):
            self.__field_street=value
        else:
            self.__field_street=USTRING(value,**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_STREET_LEN,                'raiseontruncate': False,                'default': '' })

    def __delfield_street(self): del self.__field_street

    street=property(__getfield_street, __setfield_street, __delfield_street, None)

    def __getfield_city(self):
        try: self.__field_city
        except:
            self.__field_city=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_CITY_LEN,                'raiseontruncate': False,                'default': '' })
        return self.__field_city.getvalue()

    def __setfield_city(self, value):
        if isinstance(value,USTRING):
            self.__field_city=value
        else:
            self.__field_city=USTRING(value,**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_CITY_LEN,                'raiseontruncate': False,                'default': '' })

    def __delfield_city(self): del self.__field_city

    city=property(__getfield_city, __setfield_city, __delfield_city, None)

    def __getfield_state(self):
        try: self.__field_state
        except:
            self.__field_state=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_STATE_LEN,                'raiseontruncate': False,                'default': '' })
        return self.__field_state.getvalue()

    def __setfield_state(self, value):
        if isinstance(value,USTRING):
            self.__field_state=value
        else:
            self.__field_state=USTRING(value,**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_STATE_LEN,                'raiseontruncate': False,                'default': '' })

    def __delfield_state(self): del self.__field_state

    state=property(__getfield_state, __setfield_state, __delfield_state, None)

    def __getfield_zipcode(self):
        try: self.__field_zipcode
        except:
            self.__field_zipcode=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_ZIP_LEN,                'raiseontruncate': False,                'default': '' })
        return self.__field_zipcode.getvalue()

    def __setfield_zipcode(self, value):
        if isinstance(value,USTRING):
            self.__field_zipcode=value
        else:
            self.__field_zipcode=USTRING(value,**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_ZIP_LEN,                'raiseontruncate': False,                'default': '' })

    def __delfield_zipcode(self): del self.__field_zipcode

    zipcode=property(__getfield_zipcode, __setfield_zipcode, __delfield_zipcode, None)

    def __getfield_country(self):
        try: self.__field_country
        except:
            self.__field_country=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_COUNTRY_LEN,                'raiseontruncate': False,                'default': '' })
        return self.__field_country.getvalue()

    def __setfield_country(self, value):
        if isinstance(value,USTRING):
            self.__field_country=value
        else:
            self.__field_country=USTRING(value,**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_COUNTRY_LEN,                'raiseontruncate': False,                'default': '' })

    def __delfield_country(self): del self.__field_country

    country=property(__getfield_country, __setfield_country, __delfield_country, None)

    def __getfield_im_name(self):
        try: self.__field_im_name
        except:
            self.__field_im_name=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_IMNAME_LEN,                'raiseontruncate': False,                'default': '' })
        return self.__field_im_name.getvalue()

    def __setfield_im_name(self, value):
        if isinstance(value,USTRING):
            self.__field_im_name=value
        else:
            self.__field_im_name=USTRING(value,**{ 'terminator': 0,                'encoding': ENCODING,                'maxsizeinbytes': PB_MAX_IMNAME_LEN,                'raiseontruncate': False,                'default': '' })

    def __delfield_im_name(self): del self.__field_im_name

    im_name=property(__getfield_im_name, __setfield_im_name, __delfield_im_name, None)

    def __getfield_im_type(self):
        try: self.__field_im_type
        except:
            self.__field_im_type=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_im_type.getvalue()

    def __setfield_im_type(self, value):
        if isinstance(value,UINT):
            self.__field_im_type=value
        else:
            self.__field_im_type=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_im_type(self): del self.__field_im_type

    im_type=property(__getfield_im_type, __setfield_im_type, __delfield_im_type, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('name', self.__field_name, None)
        yield ('email', self.__field_email, None)
        yield ('email2', self.__field_email2, None)
        yield ('note', self.__field_note, None)
        yield ('wallpaper', self.__field_wallpaper, None)
        yield ('wallpaper_range', self.__field_wallpaper_range, None)
        yield ('home', self.__field_home, None)
        yield ('work', self.__field_work, None)
        yield ('cell', self.__field_cell, None)
        yield ('dummy', self.__field_dummy, None)
        yield ('fax', self.__field_fax, None)
        yield ('cell2', self.__field_cell2, None)
        yield ('group', self.__field_group, None)
        yield ('street', self.__field_street, None)
        yield ('city', self.__field_city, None)
        yield ('state', self.__field_state, None)
        yield ('zipcode', self.__field_zipcode, None)
        yield ('country', self.__field_country, None)
        yield ('im_name', self.__field_im_name, None)
        yield ('im_type', self.__field_im_type, None)

    def _set_address(self, addr):
        # set address fields based on BitPim phonebook address dict
        if not isinstance(addr, dict):
            raise TypeError('addr must be of type dict')
        self.street=addr.get('street', '')
        self.city=addr.get('city', '')
        self.state=addr.get('state', '')
        self.zipcode=addr.get('postalcode', '')
        self.country=addr.get('country', '')
    def _get_address(self):
        # return address items in BitPim phonebook address dict
        return { 'street': self.street, 'city': self.city,
                 'state': self.state, 'postalcode': self.zipcode,
                 'country': self.country }
    address=property(fget=_get_address, fset=_set_address)




class ss_pb_write_req(BaseProtogenClass):
    __fields=['hdr', 'entry']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_pb_write_req,self).__init__(**dict)
        if self.__class__ is ss_pb_write_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_pb_write_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_pb_write_req,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_WRITE })
        self.__field_hdr.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_398
        except:
            self.__field__gen_p_samsungschu750_398=DONTCARE(**{'sizeinbytes': 1})
        self.__field__gen_p_samsungschu750_398.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_WRITE })
        self.__field_hdr.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_398=DONTCARE(**{'sizeinbytes': 1})
        self.__field__gen_p_samsungschu750_398.readfrombuffer(buf)
        self.__field_entry=ss_pb_entry()
        self.__field_entry.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_WRITE })
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,**{ 'command': SS_CMD_PB_WRITE })

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,ss_pb_entry):
            self.__field_entry=value
        else:
            self.__field_entry=ss_pb_entry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)
        yield ('entry', self.__field_entry, None)




class ss_pb_write_resp(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['hdr', 'index']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_pb_write_resp,self).__init__(**dict)
        if self.__class__ is ss_pb_write_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_pb_write_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_pb_write_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr()
        self.__field_hdr.readfrombuffer(buf)
        DONTCARE(**{'sizeinbytes': 1}).readfrombuffer(buf)
        self.__field_index=UINT(**{'sizeinbytes': 2})
        self.__field_index.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,)

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 2})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)
        yield ('index', self.__field_index, None)




class cl_list(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['index']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(cl_list,self).__init__(**dict)
        if self.__class__ is cl_list:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(cl_list,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(cl_list,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_index=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_index=UINT(**{'sizeinbytes': 2})
        self.__field_index.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 2})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('index', self.__field_index, None)




class cl_index_file(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['incoming', 'outgoing', 'missed', 'incoming_count', 'outgoing_count', 'missed_count']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(cl_index_file,self).__init__(**dict)
        if self.__class__ is cl_index_file:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(cl_index_file,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(cl_index_file,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_incoming=LIST(**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })
        self.__field_incoming.readfrombuffer(buf)
        self.__field_outgoing=LIST(**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })
        self.__field_outgoing.readfrombuffer(buf)
        self.__field_missed=LIST(**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })
        self.__field_missed.readfrombuffer(buf)
        DONTCARE(**{'sizeinbytes': 1374}).readfrombuffer(buf)
        self.__field_incoming_count=UINT(**{'sizeinbytes': 4})
        self.__field_incoming_count.readfrombuffer(buf)
        self.__field_outgoing_count=UINT(**{'sizeinbytes': 4})
        self.__field_outgoing_count.readfrombuffer(buf)
        self.__field_missed_count=UINT(**{'sizeinbytes': 4})
        self.__field_missed_count.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_incoming(self):
        return self.__field_incoming.getvalue()

    def __setfield_incoming(self, value):
        if isinstance(value,LIST):
            self.__field_incoming=value
        else:
            self.__field_incoming=LIST(value,**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })

    def __delfield_incoming(self): del self.__field_incoming

    incoming=property(__getfield_incoming, __setfield_incoming, __delfield_incoming, None)

    def __getfield_outgoing(self):
        return self.__field_outgoing.getvalue()

    def __setfield_outgoing(self, value):
        if isinstance(value,LIST):
            self.__field_outgoing=value
        else:
            self.__field_outgoing=LIST(value,**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })

    def __delfield_outgoing(self): del self.__field_outgoing

    outgoing=property(__getfield_outgoing, __setfield_outgoing, __delfield_outgoing, None)

    def __getfield_missed(self):
        return self.__field_missed.getvalue()

    def __setfield_missed(self, value):
        if isinstance(value,LIST):
            self.__field_missed=value
        else:
            self.__field_missed=LIST(value,**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })

    def __delfield_missed(self): del self.__field_missed

    missed=property(__getfield_missed, __setfield_missed, __delfield_missed, None)

    def __getfield_incoming_count(self):
        return self.__field_incoming_count.getvalue()

    def __setfield_incoming_count(self, value):
        if isinstance(value,UINT):
            self.__field_incoming_count=value
        else:
            self.__field_incoming_count=UINT(value,**{'sizeinbytes': 4})

    def __delfield_incoming_count(self): del self.__field_incoming_count

    incoming_count=property(__getfield_incoming_count, __setfield_incoming_count, __delfield_incoming_count, None)

    def __getfield_outgoing_count(self):
        return self.__field_outgoing_count.getvalue()

    def __setfield_outgoing_count(self, value):
        if isinstance(value,UINT):
            self.__field_outgoing_count=value
        else:
            self.__field_outgoing_count=UINT(value,**{'sizeinbytes': 4})

    def __delfield_outgoing_count(self): del self.__field_outgoing_count

    outgoing_count=property(__getfield_outgoing_count, __setfield_outgoing_count, __delfield_outgoing_count, None)

    def __getfield_missed_count(self):
        return self.__field_missed_count.getvalue()

    def __setfield_missed_count(self, value):
        if isinstance(value,UINT):
            self.__field_missed_count=value
        else:
            self.__field_missed_count=UINT(value,**{'sizeinbytes': 4})

    def __delfield_missed_count(self): del self.__field_missed_count

    missed_count=property(__getfield_missed_count, __setfield_missed_count, __delfield_missed_count, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('incoming', self.__field_incoming, None)
        yield ('outgoing', self.__field_outgoing, None)
        yield ('missed', self.__field_missed, None)
        yield ('incoming_count', self.__field_incoming_count, None)
        yield ('outgoing_count', self.__field_outgoing_count, None)
        yield ('missed_count', self.__field_missed_count, None)




class cl_file(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['cl_type', 'number', 'datetime', 'duration']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(cl_file,self).__init__(**dict)
        if self.__class__ is cl_file:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(cl_file,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(cl_file,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cl_type=UINT(**{'sizeinbytes': 1})
        self.__field_cl_type.readfrombuffer(buf)
        self.__field_number=STRING(**{'sizeinbytes': 51,  'terminator': 0 })
        self.__field_number.readfrombuffer(buf)
        self.__field_datetime=DateTime2(**{'sizeinbytes': 4})
        self.__field_datetime.readfrombuffer(buf)
        DONTCARE(**{'sizeinbytes': 4}).readfrombuffer(buf)
        self.__field_duration=UINT(**{'sizeinbytes': 4})
        self.__field_duration.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cl_type(self):
        return self.__field_cl_type.getvalue()

    def __setfield_cl_type(self, value):
        if isinstance(value,UINT):
            self.__field_cl_type=value
        else:
            self.__field_cl_type=UINT(value,**{'sizeinbytes': 1})

    def __delfield_cl_type(self): del self.__field_cl_type

    cl_type=property(__getfield_cl_type, __setfield_cl_type, __delfield_cl_type, None)

    def __getfield_number(self):
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,STRING):
            self.__field_number=value
        else:
            self.__field_number=STRING(value,**{'sizeinbytes': 51,  'terminator': 0 })

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def __getfield_datetime(self):
        return self.__field_datetime.getvalue()

    def __setfield_datetime(self, value):
        if isinstance(value,DateTime2):
            self.__field_datetime=value
        else:
            self.__field_datetime=DateTime2(value,**{'sizeinbytes': 4})

    def __delfield_datetime(self): del self.__field_datetime

    datetime=property(__getfield_datetime, __setfield_datetime, __delfield_datetime, None)

    def __getfield_duration(self):
        return self.__field_duration.getvalue()

    def __setfield_duration(self, value):
        if isinstance(value,UINT):
            self.__field_duration=value
        else:
            self.__field_duration=UINT(value,**{'sizeinbytes': 4})

    def __delfield_duration(self): del self.__field_duration

    duration=property(__getfield_duration, __setfield_duration, __delfield_duration, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cl_type', self.__field_cl_type, None)
        yield ('number', self.__field_number, None)
        yield ('datetime', self.__field_datetime, None)
        yield ('duration', self.__field_duration, None)

    @property
    def valid(self):
        global CL_VALID_TYPE
        return bool(self.cl_type in CL_VALID_TYPE and self.number)




class CalIndexEntry(BaseProtogenClass):
    __fields=['index']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(CalIndexEntry,self).__init__(**dict)
        if self.__class__ is CalIndexEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(CalIndexEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(CalIndexEntry,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2,  'default': 0 }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_index=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_index
        except:
            self.__field_index=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_index.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_index=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_index.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_index(self):
        try: self.__field_index
        except:
            self.__field_index=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('index', self.__field_index, None)




class CalIndexFile(BaseProtogenClass):
    __fields=['next_index', 'numofevents', 'numofnotes', 'numofactiveevents', 'events', 'notes', 'activeevents']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(CalIndexFile,self).__init__(**dict)
        if self.__class__ is CalIndexFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(CalIndexFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(CalIndexFile,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_next_index.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_440
        except:
            self.__field__gen_p_samsungschu750_440=DONTCARE(**{'sizeinbytes': 12})
        self.__field__gen_p_samsungschu750_440.writetobuffer(buf)
        self.__field_numofevents.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_442
        except:
            self.__field__gen_p_samsungschu750_442=DONTCARE(**{'sizeinbytes': 6})
        self.__field__gen_p_samsungschu750_442.writetobuffer(buf)
        self.__field_numofnotes.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_444
        except:
            self.__field__gen_p_samsungschu750_444=DONTCARE(**{'sizeinbytes': 6})
        self.__field__gen_p_samsungschu750_444.writetobuffer(buf)
        self.__field_numofactiveevents.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_446
        except:
            self.__field__gen_p_samsungschu750_446=DONTCARE(**{'sizeinbytes': 112})
        self.__field__gen_p_samsungschu750_446.writetobuffer(buf)
        try: self.__field_events
        except:
            self.__field_events=LIST(**{ 'elementclass': CalIndexEntry,             'length': 103,             'createdefault': True })
        self.__field_events.writetobuffer(buf)
        try: self.__field_notes
        except:
            self.__field_notes=LIST(**{ 'elementclass': CalIndexEntry,             'length': 35,             'createdefault': True })
        self.__field_notes.writetobuffer(buf)
        try: self.__field_activeevents
        except:
            self.__field_activeevents=LIST(**{ 'elementclass': CalIndexEntry,             'length': 319,             'createdefault': True })
        self.__field_activeevents.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_next_index=UINT(**{'sizeinbytes': 2})
        self.__field_next_index.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_440=DONTCARE(**{'sizeinbytes': 12})
        self.__field__gen_p_samsungschu750_440.readfrombuffer(buf)
        self.__field_numofevents=UINT(**{'sizeinbytes': 2})
        self.__field_numofevents.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_442=DONTCARE(**{'sizeinbytes': 6})
        self.__field__gen_p_samsungschu750_442.readfrombuffer(buf)
        self.__field_numofnotes=UINT(**{'sizeinbytes': 2})
        self.__field_numofnotes.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_444=DONTCARE(**{'sizeinbytes': 6})
        self.__field__gen_p_samsungschu750_444.readfrombuffer(buf)
        self.__field_numofactiveevents=UINT(**{'sizeinbytes': 2})
        self.__field_numofactiveevents.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_446=DONTCARE(**{'sizeinbytes': 112})
        self.__field__gen_p_samsungschu750_446.readfrombuffer(buf)
        self.__field_events=LIST(**{ 'elementclass': CalIndexEntry,             'length': 103,             'createdefault': True })
        self.__field_events.readfrombuffer(buf)
        self.__field_notes=LIST(**{ 'elementclass': CalIndexEntry,             'length': 35,             'createdefault': True })
        self.__field_notes.readfrombuffer(buf)
        self.__field_activeevents=LIST(**{ 'elementclass': CalIndexEntry,             'length': 319,             'createdefault': True })
        self.__field_activeevents.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_next_index(self):
        return self.__field_next_index.getvalue()

    def __setfield_next_index(self, value):
        if isinstance(value,UINT):
            self.__field_next_index=value
        else:
            self.__field_next_index=UINT(value,**{'sizeinbytes': 2})

    def __delfield_next_index(self): del self.__field_next_index

    next_index=property(__getfield_next_index, __setfield_next_index, __delfield_next_index, None)

    def __getfield_numofevents(self):
        return self.__field_numofevents.getvalue()

    def __setfield_numofevents(self, value):
        if isinstance(value,UINT):
            self.__field_numofevents=value
        else:
            self.__field_numofevents=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numofevents(self): del self.__field_numofevents

    numofevents=property(__getfield_numofevents, __setfield_numofevents, __delfield_numofevents, None)

    def __getfield_numofnotes(self):
        return self.__field_numofnotes.getvalue()

    def __setfield_numofnotes(self, value):
        if isinstance(value,UINT):
            self.__field_numofnotes=value
        else:
            self.__field_numofnotes=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numofnotes(self): del self.__field_numofnotes

    numofnotes=property(__getfield_numofnotes, __setfield_numofnotes, __delfield_numofnotes, None)

    def __getfield_numofactiveevents(self):
        return self.__field_numofactiveevents.getvalue()

    def __setfield_numofactiveevents(self, value):
        if isinstance(value,UINT):
            self.__field_numofactiveevents=value
        else:
            self.__field_numofactiveevents=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numofactiveevents(self): del self.__field_numofactiveevents

    numofactiveevents=property(__getfield_numofactiveevents, __setfield_numofactiveevents, __delfield_numofactiveevents, None)

    def __getfield_events(self):
        try: self.__field_events
        except:
            self.__field_events=LIST(**{ 'elementclass': CalIndexEntry,             'length': 103,             'createdefault': True })
        return self.__field_events.getvalue()

    def __setfield_events(self, value):
        if isinstance(value,LIST):
            self.__field_events=value
        else:
            self.__field_events=LIST(value,**{ 'elementclass': CalIndexEntry,             'length': 103,             'createdefault': True })

    def __delfield_events(self): del self.__field_events

    events=property(__getfield_events, __setfield_events, __delfield_events, None)

    def __getfield_notes(self):
        try: self.__field_notes
        except:
            self.__field_notes=LIST(**{ 'elementclass': CalIndexEntry,             'length': 35,             'createdefault': True })
        return self.__field_notes.getvalue()

    def __setfield_notes(self, value):
        if isinstance(value,LIST):
            self.__field_notes=value
        else:
            self.__field_notes=LIST(value,**{ 'elementclass': CalIndexEntry,             'length': 35,             'createdefault': True })

    def __delfield_notes(self): del self.__field_notes

    notes=property(__getfield_notes, __setfield_notes, __delfield_notes, None)

    def __getfield_activeevents(self):
        try: self.__field_activeevents
        except:
            self.__field_activeevents=LIST(**{ 'elementclass': CalIndexEntry,             'length': 319,             'createdefault': True })
        return self.__field_activeevents.getvalue()

    def __setfield_activeevents(self, value):
        if isinstance(value,LIST):
            self.__field_activeevents=value
        else:
            self.__field_activeevents=LIST(value,**{ 'elementclass': CalIndexEntry,             'length': 319,             'createdefault': True })

    def __delfield_activeevents(self): del self.__field_activeevents

    activeevents=property(__getfield_activeevents, __setfield_activeevents, __delfield_activeevents, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('next_index', self.__field_next_index, None)
        yield ('numofevents', self.__field_numofevents, None)
        yield ('numofnotes', self.__field_numofnotes, None)
        yield ('numofactiveevents', self.__field_numofactiveevents, None)
        yield ('events', self.__field_events, None)
        yield ('notes', self.__field_notes, None)
        yield ('activeevents', self.__field_activeevents, None)




class CalEntry(BaseProtogenClass):
    __fields=['titlelen', 'title', 'start', 'start2', 'end', 'repeat', 'alarm', 'alert', 'reminder', 'duration', 'timezone', 'creationtime', 'modifiedtime', 'ringtonelen', 'ringtone']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(CalEntry,self).__init__(**dict)
        if self.__class__ is CalEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(CalEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(CalEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_titlelen.writetobuffer(buf)
        self.__field_title.writetobuffer(buf)
        self.__field_start.writetobuffer(buf)
        try: self.__field_start2
        except:
            self.__field_start2=DateTime2(**{'sizeinbytes': 4,  'default': self.start })
        self.__field_start2.writetobuffer(buf)
        self.__field_end.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_465
        except:
            self.__field__gen_p_samsungschu750_465=DONTCARE(**{'sizeinbytes': 1,  'default': '\x01' })
        self.__field__gen_p_samsungschu750_465.writetobuffer(buf)
        self.__field_repeat.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_467
        except:
            self.__field__gen_p_samsungschu750_467=DONTCARE(**{'sizeinbytes': 1,  'default': '\x03' })
        self.__field__gen_p_samsungschu750_467.writetobuffer(buf)
        self.__field_alarm.writetobuffer(buf)
        self.__field_alert.writetobuffer(buf)
        try: self.__field_reminder
        except:
            self.__field_reminder=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_reminder.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_471
        except:
            self.__field__gen_p_samsungschu750_471=DONTCARE(**{'sizeinbytes': 5})
        self.__field__gen_p_samsungschu750_471.writetobuffer(buf)
        self.__field_duration.writetobuffer(buf)
        self.__field_timezone.writetobuffer(buf)
        self.__field_creationtime.writetobuffer(buf)
        try: self.__field_modifiedtime
        except:
            self.__field_modifiedtime=DateTime2(**{'sizeinbytes': 4,  'default': self.creationtime })
        self.__field_modifiedtime.writetobuffer(buf)
        self.__field_ringtonelen.writetobuffer(buf)
        self.__field_ringtone.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_479
        except:
            self.__field__gen_p_samsungschu750_479=DONTCARE(**{'sizeinbytes': 2})
        self.__field__gen_p_samsungschu750_479.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_titlelen=UINT(**{'sizeinbytes': 2})
        self.__field_titlelen.readfrombuffer(buf)
        self.__field_title=USTRING(**{ 'sizeinbytes': self.titlelen,                'encoding': ENCODING,                'terminator': None })
        self.__field_title.readfrombuffer(buf)
        self.__field_start=DateTime2(**{'sizeinbytes': 4})
        self.__field_start.readfrombuffer(buf)
        self.__field_start2=DateTime2(**{'sizeinbytes': 4,  'default': self.start })
        self.__field_start2.readfrombuffer(buf)
        self.__field_end=DateTime2(**{'sizeinbytes': 4})
        self.__field_end.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_465=DONTCARE(**{'sizeinbytes': 1,  'default': '\x01' })
        self.__field__gen_p_samsungschu750_465.readfrombuffer(buf)
        self.__field_repeat=UINT(**{'sizeinbytes': 1})
        self.__field_repeat.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_467=DONTCARE(**{'sizeinbytes': 1,  'default': '\x03' })
        self.__field__gen_p_samsungschu750_467.readfrombuffer(buf)
        self.__field_alarm=UINT(**{'sizeinbytes': 1})
        self.__field_alarm.readfrombuffer(buf)
        self.__field_alert=UINT(**{'sizeinbytes': 1})
        self.__field_alert.readfrombuffer(buf)
        self.__field_reminder=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_reminder.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_471=DONTCARE(**{'sizeinbytes': 5})
        self.__field__gen_p_samsungschu750_471.readfrombuffer(buf)
        self.__field_duration=UINT(**{'sizeinbytes': 4})
        self.__field_duration.readfrombuffer(buf)
        self.__field_timezone=UINT(**{'sizeinbytes': 1})
        self.__field_timezone.readfrombuffer(buf)
        self.__field_creationtime=DateTime2(**{'sizeinbytes': 4})
        self.__field_creationtime.readfrombuffer(buf)
        self.__field_modifiedtime=DateTime2(**{'sizeinbytes': 4,  'default': self.creationtime })
        self.__field_modifiedtime.readfrombuffer(buf)
        self.__field_ringtonelen=UINT(**{'sizeinbytes': 2})
        self.__field_ringtonelen.readfrombuffer(buf)
        self.__field_ringtone=STRING(**{ 'sizeinbytes': self.ringtonelen,               'terminator': None })
        self.__field_ringtone.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_479=DONTCARE(**{'sizeinbytes': 2})
        self.__field__gen_p_samsungschu750_479.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_titlelen(self):
        return self.__field_titlelen.getvalue()

    def __setfield_titlelen(self, value):
        if isinstance(value,UINT):
            self.__field_titlelen=value
        else:
            self.__field_titlelen=UINT(value,**{'sizeinbytes': 2})

    def __delfield_titlelen(self): del self.__field_titlelen

    titlelen=property(__getfield_titlelen, __setfield_titlelen, __delfield_titlelen, None)

    def __getfield_title(self):
        return self.__field_title.getvalue()

    def __setfield_title(self, value):
        if isinstance(value,USTRING):
            self.__field_title=value
        else:
            self.__field_title=USTRING(value,**{ 'sizeinbytes': self.titlelen,                'encoding': ENCODING,                'terminator': None })

    def __delfield_title(self): del self.__field_title

    title=property(__getfield_title, __setfield_title, __delfield_title, None)

    def __getfield_start(self):
        return self.__field_start.getvalue()

    def __setfield_start(self, value):
        if isinstance(value,DateTime2):
            self.__field_start=value
        else:
            self.__field_start=DateTime2(value,**{'sizeinbytes': 4})

    def __delfield_start(self): del self.__field_start

    start=property(__getfield_start, __setfield_start, __delfield_start, None)

    def __getfield_start2(self):
        try: self.__field_start2
        except:
            self.__field_start2=DateTime2(**{'sizeinbytes': 4,  'default': self.start })
        return self.__field_start2.getvalue()

    def __setfield_start2(self, value):
        if isinstance(value,DateTime2):
            self.__field_start2=value
        else:
            self.__field_start2=DateTime2(value,**{'sizeinbytes': 4,  'default': self.start })

    def __delfield_start2(self): del self.__field_start2

    start2=property(__getfield_start2, __setfield_start2, __delfield_start2, None)

    def __getfield_end(self):
        return self.__field_end.getvalue()

    def __setfield_end(self, value):
        if isinstance(value,DateTime2):
            self.__field_end=value
        else:
            self.__field_end=DateTime2(value,**{'sizeinbytes': 4})

    def __delfield_end(self): del self.__field_end

    end=property(__getfield_end, __setfield_end, __delfield_end, None)

    def __getfield_repeat(self):
        return self.__field_repeat.getvalue()

    def __setfield_repeat(self, value):
        if isinstance(value,UINT):
            self.__field_repeat=value
        else:
            self.__field_repeat=UINT(value,**{'sizeinbytes': 1})

    def __delfield_repeat(self): del self.__field_repeat

    repeat=property(__getfield_repeat, __setfield_repeat, __delfield_repeat, None)

    def __getfield_alarm(self):
        return self.__field_alarm.getvalue()

    def __setfield_alarm(self, value):
        if isinstance(value,UINT):
            self.__field_alarm=value
        else:
            self.__field_alarm=UINT(value,**{'sizeinbytes': 1})

    def __delfield_alarm(self): del self.__field_alarm

    alarm=property(__getfield_alarm, __setfield_alarm, __delfield_alarm, None)

    def __getfield_alert(self):
        return self.__field_alert.getvalue()

    def __setfield_alert(self, value):
        if isinstance(value,UINT):
            self.__field_alert=value
        else:
            self.__field_alert=UINT(value,**{'sizeinbytes': 1})

    def __delfield_alert(self): del self.__field_alert

    alert=property(__getfield_alert, __setfield_alert, __delfield_alert, None)

    def __getfield_reminder(self):
        try: self.__field_reminder
        except:
            self.__field_reminder=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_reminder.getvalue()

    def __setfield_reminder(self, value):
        if isinstance(value,UINT):
            self.__field_reminder=value
        else:
            self.__field_reminder=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_reminder(self): del self.__field_reminder

    reminder=property(__getfield_reminder, __setfield_reminder, __delfield_reminder, None)

    def __getfield_duration(self):
        return self.__field_duration.getvalue()

    def __setfield_duration(self, value):
        if isinstance(value,UINT):
            self.__field_duration=value
        else:
            self.__field_duration=UINT(value,**{'sizeinbytes': 4})

    def __delfield_duration(self): del self.__field_duration

    duration=property(__getfield_duration, __setfield_duration, __delfield_duration, None)

    def __getfield_timezone(self):
        return self.__field_timezone.getvalue()

    def __setfield_timezone(self, value):
        if isinstance(value,UINT):
            self.__field_timezone=value
        else:
            self.__field_timezone=UINT(value,**{'sizeinbytes': 1})

    def __delfield_timezone(self): del self.__field_timezone

    timezone=property(__getfield_timezone, __setfield_timezone, __delfield_timezone, None)

    def __getfield_creationtime(self):
        return self.__field_creationtime.getvalue()

    def __setfield_creationtime(self, value):
        if isinstance(value,DateTime2):
            self.__field_creationtime=value
        else:
            self.__field_creationtime=DateTime2(value,**{'sizeinbytes': 4})

    def __delfield_creationtime(self): del self.__field_creationtime

    creationtime=property(__getfield_creationtime, __setfield_creationtime, __delfield_creationtime, None)

    def __getfield_modifiedtime(self):
        try: self.__field_modifiedtime
        except:
            self.__field_modifiedtime=DateTime2(**{'sizeinbytes': 4,  'default': self.creationtime })
        return self.__field_modifiedtime.getvalue()

    def __setfield_modifiedtime(self, value):
        if isinstance(value,DateTime2):
            self.__field_modifiedtime=value
        else:
            self.__field_modifiedtime=DateTime2(value,**{'sizeinbytes': 4,  'default': self.creationtime })

    def __delfield_modifiedtime(self): del self.__field_modifiedtime

    modifiedtime=property(__getfield_modifiedtime, __setfield_modifiedtime, __delfield_modifiedtime, None)

    def __getfield_ringtonelen(self):
        return self.__field_ringtonelen.getvalue()

    def __setfield_ringtonelen(self, value):
        if isinstance(value,UINT):
            self.__field_ringtonelen=value
        else:
            self.__field_ringtonelen=UINT(value,**{'sizeinbytes': 2})

    def __delfield_ringtonelen(self): del self.__field_ringtonelen

    ringtonelen=property(__getfield_ringtonelen, __setfield_ringtonelen, __delfield_ringtonelen, None)

    def __getfield_ringtone(self):
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,STRING):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=STRING(value,**{ 'sizeinbytes': self.ringtonelen,               'terminator': None })

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('titlelen', self.__field_titlelen, None)
        yield ('title', self.__field_title, None)
        yield ('start', self.__field_start, None)
        yield ('start2', self.__field_start2, None)
        yield ('end', self.__field_end, None)
        yield ('repeat', self.__field_repeat, None)
        yield ('alarm', self.__field_alarm, None)
        yield ('alert', self.__field_alert, None)
        yield ('reminder', self.__field_reminder, None)
        yield ('duration', self.__field_duration, None)
        yield ('timezone', self.__field_timezone, None)
        yield ('creationtime', self.__field_creationtime, None)
        yield ('modifiedtime', self.__field_modifiedtime, None)
        yield ('ringtonelen', self.__field_ringtonelen, None)
        yield ('ringtone', self.__field_ringtone, None)




class NotePadEntry(BaseProtogenClass):
    __fields=['textlen', 'text', 'creation', 'creation2', 'modified', 'modified2']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(NotePadEntry,self).__init__(**dict)
        if self.__class__ is NotePadEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(NotePadEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(NotePadEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_textlen.writetobuffer(buf)
        self.__field_text.writetobuffer(buf)
        self.__field_creation.writetobuffer(buf)
        try: self.__field_creation2
        except:
            self.__field_creation2=DateTime2(**{'sizeinbytes': 4,  'default': self.creation })
        self.__field_creation2.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_488
        except:
            self.__field__gen_p_samsungschu750_488=DONTCARE(**{'sizeinbytes': 6})
        self.__field__gen_p_samsungschu750_488.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_489
        except:
            self.__field__gen_p_samsungschu750_489=DONTCARE(**{'sizeinbytes': 1,  'default': '\x05' })
        self.__field__gen_p_samsungschu750_489.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_490
        except:
            self.__field__gen_p_samsungschu750_490=DONTCARE(**{'sizeinbytes': 12})
        self.__field__gen_p_samsungschu750_490.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_491
        except:
            self.__field__gen_p_samsungschu750_491=DONTCARE(**{'sizeinbytes': 1,  'default': '\x30' })
        self.__field__gen_p_samsungschu750_491.writetobuffer(buf)
        try: self.__field_modified
        except:
            self.__field_modified=DateTime2(**{'sizeinbytes': 4,  'default': self.creation })
        self.__field_modified.writetobuffer(buf)
        try: self.__field_modified2
        except:
            self.__field_modified2=DateTime2(**{'sizeinbytes': 4,  'default': self.modified })
        self.__field_modified2.writetobuffer(buf)
        try: self.__field__gen_p_samsungschu750_494
        except:
            self.__field__gen_p_samsungschu750_494=DONTCARE(**{'sizeinbytes': 4})
        self.__field__gen_p_samsungschu750_494.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_textlen=UINT(**{'sizeinbytes': 2})
        self.__field_textlen.readfrombuffer(buf)
        self.__field_text=USTRING(**{ 'terminator': None,                'encoding': ENCODING,                'sizeinbytes': self.textlen })
        self.__field_text.readfrombuffer(buf)
        self.__field_creation=DateTime2(**{'sizeinbytes': 4})
        self.__field_creation.readfrombuffer(buf)
        self.__field_creation2=DateTime2(**{'sizeinbytes': 4,  'default': self.creation })
        self.__field_creation2.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_488=DONTCARE(**{'sizeinbytes': 6})
        self.__field__gen_p_samsungschu750_488.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_489=DONTCARE(**{'sizeinbytes': 1,  'default': '\x05' })
        self.__field__gen_p_samsungschu750_489.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_490=DONTCARE(**{'sizeinbytes': 12})
        self.__field__gen_p_samsungschu750_490.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_491=DONTCARE(**{'sizeinbytes': 1,  'default': '\x30' })
        self.__field__gen_p_samsungschu750_491.readfrombuffer(buf)
        self.__field_modified=DateTime2(**{'sizeinbytes': 4,  'default': self.creation })
        self.__field_modified.readfrombuffer(buf)
        self.__field_modified2=DateTime2(**{'sizeinbytes': 4,  'default': self.modified })
        self.__field_modified2.readfrombuffer(buf)
        self.__field__gen_p_samsungschu750_494=DONTCARE(**{'sizeinbytes': 4})
        self.__field__gen_p_samsungschu750_494.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_textlen(self):
        return self.__field_textlen.getvalue()

    def __setfield_textlen(self, value):
        if isinstance(value,UINT):
            self.__field_textlen=value
        else:
            self.__field_textlen=UINT(value,**{'sizeinbytes': 2})

    def __delfield_textlen(self): del self.__field_textlen

    textlen=property(__getfield_textlen, __setfield_textlen, __delfield_textlen, None)

    def __getfield_text(self):
        return self.__field_text.getvalue()

    def __setfield_text(self, value):
        if isinstance(value,USTRING):
            self.__field_text=value
        else:
            self.__field_text=USTRING(value,**{ 'terminator': None,                'encoding': ENCODING,                'sizeinbytes': self.textlen })

    def __delfield_text(self): del self.__field_text

    text=property(__getfield_text, __setfield_text, __delfield_text, None)

    def __getfield_creation(self):
        return self.__field_creation.getvalue()

    def __setfield_creation(self, value):
        if isinstance(value,DateTime2):
            self.__field_creation=value
        else:
            self.__field_creation=DateTime2(value,**{'sizeinbytes': 4})

    def __delfield_creation(self): del self.__field_creation

    creation=property(__getfield_creation, __setfield_creation, __delfield_creation, None)

    def __getfield_creation2(self):
        try: self.__field_creation2
        except:
            self.__field_creation2=DateTime2(**{'sizeinbytes': 4,  'default': self.creation })
        return self.__field_creation2.getvalue()

    def __setfield_creation2(self, value):
        if isinstance(value,DateTime2):
            self.__field_creation2=value
        else:
            self.__field_creation2=DateTime2(value,**{'sizeinbytes': 4,  'default': self.creation })

    def __delfield_creation2(self): del self.__field_creation2

    creation2=property(__getfield_creation2, __setfield_creation2, __delfield_creation2, None)

    def __getfield_modified(self):
        try: self.__field_modified
        except:
            self.__field_modified=DateTime2(**{'sizeinbytes': 4,  'default': self.creation })
        return self.__field_modified.getvalue()

    def __setfield_modified(self, value):
        if isinstance(value,DateTime2):
            self.__field_modified=value
        else:
            self.__field_modified=DateTime2(value,**{'sizeinbytes': 4,  'default': self.creation })

    def __delfield_modified(self): del self.__field_modified

    modified=property(__getfield_modified, __setfield_modified, __delfield_modified, None)

    def __getfield_modified2(self):
        try: self.__field_modified2
        except:
            self.__field_modified2=DateTime2(**{'sizeinbytes': 4,  'default': self.modified })
        return self.__field_modified2.getvalue()

    def __setfield_modified2(self, value):
        if isinstance(value,DateTime2):
            self.__field_modified2=value
        else:
            self.__field_modified2=DateTime2(value,**{'sizeinbytes': 4,  'default': self.modified })

    def __delfield_modified2(self): del self.__field_modified2

    modified2=property(__getfield_modified2, __setfield_modified2, __delfield_modified2, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('textlen', self.__field_textlen, None)
        yield ('text', self.__field_text, None)
        yield ('creation', self.__field_creation, None)
        yield ('creation2', self.__field_creation2, None)
        yield ('modified', self.__field_modified, None)
        yield ('modified2', self.__field_modified2, None)




class pBOOL(BaseProtogenClass):
    __fields=['value']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pBOOL,self).__init__(**dict)
        if self.__class__ is pBOOL:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pBOOL,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pBOOL,kwargs)
        if len(args):
            dict2={'sizeinbytes': 'P'}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_value=BOOL(*args,**dict2)
        # Make all P fields that haven't already been constructed
        try: self.__field_value
        except:
            self.__field_value=BOOL()


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_value(self):
        return self.__field_value.getvalue()

    def __setfield_value(self, value):
        if isinstance(value,BOOL):
            self.__field_value=value
        else:
            self.__field_value=BOOL(value,)

    def __delfield_value(self): del self.__field_value

    value=property(__getfield_value, __setfield_value, __delfield_value, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('value', self.__field_value, None)




class sms_header(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['index', 'msg_len', 'callback_len', 'bitmap1', 'bitmap2', 'body_len', 'file_type', 'msg_type', 'enhance_delivery', 'is_txt_msg', 'in_msg', 'sent_msg', 'draft_msg', 'body']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_header,self).__init__(**dict)
        if self.__class__ is sms_header:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_header,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_header,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_index=UINT(**{'sizeinbytes': 2})
        self.__field_index.readfrombuffer(buf)
        DONTCARE(**{'sizeinbytes': 1}).readfrombuffer(buf)
        self.__field_msg_len=UINT(**{'sizeinbytes': 1})
        self.__field_msg_len.readfrombuffer(buf)
        DONTCARE(**{'sizeinbytes': 1}).readfrombuffer(buf)
        self.__field_callback_len=UINT(**{'sizeinbytes': 1})
        self.__field_callback_len.readfrombuffer(buf)
        self.__field_bitmap1=UINT(**{'sizeinbytes': 1})
        self.__field_bitmap1.readfrombuffer(buf)
        self.__field_bitmap2=UINT(**{'sizeinbytes': 1})
        self.__field_bitmap2.readfrombuffer(buf)
        DONTCARE(**{'sizeinbytes': 6}).readfrombuffer(buf)
        self.__field_body_len=UINT(**{'sizeinbytes': 2})
        self.__field_body_len.readfrombuffer(buf)
        self.__field_file_type=UINT(**{'sizeinbytes': 2})
        self.__field_file_type.readfrombuffer(buf)
        self.__field_msg_type=UINT(**{'sizeinbytes': 1})
        self.__field_msg_type.readfrombuffer(buf)
        self.__field_enhance_delivery=UINT(**{'sizeinbytes': 1})
        self.__field_enhance_delivery.readfrombuffer(buf)
        self.__field_is_txt_msg=pBOOL(**{ 'value': self.file_type==SMS_TXT_TYPE and self.msg_type in SMS_VALID_TYPE })
        self.__field_is_txt_msg.readfrombuffer(buf)
        self.__field_in_msg=pBOOL(**{ 'value': self.msg_type==SMS_TYPE_IN })
        self.__field_in_msg.readfrombuffer(buf)
        self.__field_sent_msg=pBOOL(**{ 'value': self.msg_type==SMS_TYPE_SENT })
        self.__field_sent_msg.readfrombuffer(buf)
        self.__field_draft_msg=pBOOL(**{ 'value': self.msg_type==SMS_TYPE_DRAFT })
        self.__field_draft_msg.readfrombuffer(buf)
        if self.is_txt_msg.value:
            self.__field_body=sms_body(**{            'msg_len': self.msg_len,            'has_callback': self.bitmap2 & SMS_FLG2_CALLBACK,            'has_priority': self.bitmap2 & SMS_FLG2_PRIORITY,            'has_1byte': (self.bitmap2 & SMS_FLG2_SOMETHING) or (not self.bitmap2),            'has_1byte2': self.bitmap2 & SMS_FLG2_MSG,            'has_40bytes': self.bitmap1 & SMS_FLG1_HAS40 })
            self.__field_body.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 2})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_msg_len(self):
        return self.__field_msg_len.getvalue()

    def __setfield_msg_len(self, value):
        if isinstance(value,UINT):
            self.__field_msg_len=value
        else:
            self.__field_msg_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_msg_len(self): del self.__field_msg_len

    msg_len=property(__getfield_msg_len, __setfield_msg_len, __delfield_msg_len, None)

    def __getfield_callback_len(self):
        return self.__field_callback_len.getvalue()

    def __setfield_callback_len(self, value):
        if isinstance(value,UINT):
            self.__field_callback_len=value
        else:
            self.__field_callback_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_callback_len(self): del self.__field_callback_len

    callback_len=property(__getfield_callback_len, __setfield_callback_len, __delfield_callback_len, None)

    def __getfield_bitmap1(self):
        return self.__field_bitmap1.getvalue()

    def __setfield_bitmap1(self, value):
        if isinstance(value,UINT):
            self.__field_bitmap1=value
        else:
            self.__field_bitmap1=UINT(value,**{'sizeinbytes': 1})

    def __delfield_bitmap1(self): del self.__field_bitmap1

    bitmap1=property(__getfield_bitmap1, __setfield_bitmap1, __delfield_bitmap1, None)

    def __getfield_bitmap2(self):
        return self.__field_bitmap2.getvalue()

    def __setfield_bitmap2(self, value):
        if isinstance(value,UINT):
            self.__field_bitmap2=value
        else:
            self.__field_bitmap2=UINT(value,**{'sizeinbytes': 1})

    def __delfield_bitmap2(self): del self.__field_bitmap2

    bitmap2=property(__getfield_bitmap2, __setfield_bitmap2, __delfield_bitmap2, None)

    def __getfield_body_len(self):
        return self.__field_body_len.getvalue()

    def __setfield_body_len(self, value):
        if isinstance(value,UINT):
            self.__field_body_len=value
        else:
            self.__field_body_len=UINT(value,**{'sizeinbytes': 2})

    def __delfield_body_len(self): del self.__field_body_len

    body_len=property(__getfield_body_len, __setfield_body_len, __delfield_body_len, None)

    def __getfield_file_type(self):
        return self.__field_file_type.getvalue()

    def __setfield_file_type(self, value):
        if isinstance(value,UINT):
            self.__field_file_type=value
        else:
            self.__field_file_type=UINT(value,**{'sizeinbytes': 2})

    def __delfield_file_type(self): del self.__field_file_type

    file_type=property(__getfield_file_type, __setfield_file_type, __delfield_file_type, None)

    def __getfield_msg_type(self):
        return self.__field_msg_type.getvalue()

    def __setfield_msg_type(self, value):
        if isinstance(value,UINT):
            self.__field_msg_type=value
        else:
            self.__field_msg_type=UINT(value,**{'sizeinbytes': 1})

    def __delfield_msg_type(self): del self.__field_msg_type

    msg_type=property(__getfield_msg_type, __setfield_msg_type, __delfield_msg_type, None)

    def __getfield_enhance_delivery(self):
        return self.__field_enhance_delivery.getvalue()

    def __setfield_enhance_delivery(self, value):
        if isinstance(value,UINT):
            self.__field_enhance_delivery=value
        else:
            self.__field_enhance_delivery=UINT(value,**{'sizeinbytes': 1})

    def __delfield_enhance_delivery(self): del self.__field_enhance_delivery

    enhance_delivery=property(__getfield_enhance_delivery, __setfield_enhance_delivery, __delfield_enhance_delivery, None)

    def __getfield_is_txt_msg(self):
        return self.__field_is_txt_msg.getvalue()

    def __setfield_is_txt_msg(self, value):
        if isinstance(value,pBOOL):
            self.__field_is_txt_msg=value
        else:
            self.__field_is_txt_msg=pBOOL(value,**{ 'value': self.file_type==SMS_TXT_TYPE and self.msg_type in SMS_VALID_TYPE })

    def __delfield_is_txt_msg(self): del self.__field_is_txt_msg

    is_txt_msg=property(__getfield_is_txt_msg, __setfield_is_txt_msg, __delfield_is_txt_msg, None)

    def __getfield_in_msg(self):
        return self.__field_in_msg.getvalue()

    def __setfield_in_msg(self, value):
        if isinstance(value,pBOOL):
            self.__field_in_msg=value
        else:
            self.__field_in_msg=pBOOL(value,**{ 'value': self.msg_type==SMS_TYPE_IN })

    def __delfield_in_msg(self): del self.__field_in_msg

    in_msg=property(__getfield_in_msg, __setfield_in_msg, __delfield_in_msg, None)

    def __getfield_sent_msg(self):
        return self.__field_sent_msg.getvalue()

    def __setfield_sent_msg(self, value):
        if isinstance(value,pBOOL):
            self.__field_sent_msg=value
        else:
            self.__field_sent_msg=pBOOL(value,**{ 'value': self.msg_type==SMS_TYPE_SENT })

    def __delfield_sent_msg(self): del self.__field_sent_msg

    sent_msg=property(__getfield_sent_msg, __setfield_sent_msg, __delfield_sent_msg, None)

    def __getfield_draft_msg(self):
        return self.__field_draft_msg.getvalue()

    def __setfield_draft_msg(self, value):
        if isinstance(value,pBOOL):
            self.__field_draft_msg=value
        else:
            self.__field_draft_msg=pBOOL(value,**{ 'value': self.msg_type==SMS_TYPE_DRAFT })

    def __delfield_draft_msg(self): del self.__field_draft_msg

    draft_msg=property(__getfield_draft_msg, __setfield_draft_msg, __delfield_draft_msg, None)

    def __getfield_body(self):
        return self.__field_body.getvalue()

    def __setfield_body(self, value):
        if isinstance(value,sms_body):
            self.__field_body=value
        else:
            self.__field_body=sms_body(value,**{            'msg_len': self.msg_len,            'has_callback': self.bitmap2 & SMS_FLG2_CALLBACK,            'has_priority': self.bitmap2 & SMS_FLG2_PRIORITY,            'has_1byte': (self.bitmap2 & SMS_FLG2_SOMETHING) or (not self.bitmap2),            'has_1byte2': self.bitmap2 & SMS_FLG2_MSG,            'has_40bytes': self.bitmap1 & SMS_FLG1_HAS40 })

    def __delfield_body(self): del self.__field_body

    body=property(__getfield_body, __setfield_body, __delfield_body, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('index', self.__field_index, None)
        yield ('msg_len', self.__field_msg_len, None)
        yield ('callback_len', self.__field_callback_len, None)
        yield ('bitmap1', self.__field_bitmap1, None)
        yield ('bitmap2', self.__field_bitmap2, None)
        yield ('body_len', self.__field_body_len, None)
        yield ('file_type', self.__field_file_type, None)
        yield ('msg_type', self.__field_msg_type, None)
        yield ('enhance_delivery', self.__field_enhance_delivery, None)
        yield ('is_txt_msg', self.__field_is_txt_msg, None)
        yield ('in_msg', self.__field_in_msg, None)
        yield ('sent_msg', self.__field_sent_msg, None)
        yield ('draft_msg', self.__field_draft_msg, None)
        if self.is_txt_msg.value:
            yield ('body', self.__field_body, None)




class sms_msg_stat_list(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['status']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_msg_stat_list,self).__init__(**dict)
        if self.__class__ is sms_msg_stat_list:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_msg_stat_list,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_msg_stat_list,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_status=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_status=UINT(**{'sizeinbytes': 1})
        self.__field_status.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_status(self):
        return self.__field_status.getvalue()

    def __setfield_status(self, value):
        if isinstance(value,UINT):
            self.__field_status=value
        else:
            self.__field_status=UINT(value,**{'sizeinbytes': 1})

    def __delfield_status(self): del self.__field_status

    status=property(__getfield_status, __setfield_status, __delfield_status, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('status', self.__field_status, None)




class sms_datetime_list(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['datetime']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_datetime_list,self).__init__(**dict)
        if self.__class__ is sms_datetime_list:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_datetime_list,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_datetime_list,kwargs)
        if len(args):
            dict2={'sizeinbytes': 4}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_datetime=DateTime2(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_datetime=DateTime2(**{'sizeinbytes': 4})
        self.__field_datetime.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_datetime(self):
        return self.__field_datetime.getvalue()

    def __setfield_datetime(self, value):
        if isinstance(value,DateTime2):
            self.__field_datetime=value
        else:
            self.__field_datetime=DateTime2(value,**{'sizeinbytes': 4})

    def __delfield_datetime(self): del self.__field_datetime

    datetime=property(__getfield_datetime, __setfield_datetime, __delfield_datetime, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('datetime', self.__field_datetime, None)




class sms_delivered_datetime(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['datetime']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_delivered_datetime,self).__init__(**dict)
        if self.__class__ is sms_delivered_datetime:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_delivered_datetime,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_delivered_datetime,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_datetime=LIST(**{ 'elementclass': sms_datetime_list,             'length': 10 })
        self.__field_datetime.readfrombuffer(buf)
        DONTCARE(**{'sizeinbytes': 20}).readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_datetime(self):
        return self.__field_datetime.getvalue()

    def __setfield_datetime(self, value):
        if isinstance(value,LIST):
            self.__field_datetime=value
        else:
            self.__field_datetime=LIST(value,**{ 'elementclass': sms_datetime_list,             'length': 10 })

    def __delfield_datetime(self): del self.__field_datetime

    datetime=property(__getfield_datetime, __setfield_datetime, __delfield_datetime, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('datetime', self.__field_datetime, None)




class sms_body(BaseProtogenClass):
    # Read-From-Buffer-Only Class
    __fields=['msg_len', 'has_callback', 'has_priority', 'has_1byte', 'has_1byte2', 'has_40bytes', 'msg', 'msg', 'callback_len', 'callback', 'priority', 'datetime', 'addr_len0', 'addr_len1', 'addr_len2', 'addr_len3', 'addr_len4', 'addr_len5', 'addr_len6', 'addr_len7', 'addr_len8', 'addr_len9', 'addr0', 'addr1', 'addr2', 'addr3', 'addr4', 'addr5', 'addr6', 'addr7', 'addr8', 'addr9', 'msg_stat']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_body,self).__init__(**dict)
        if self.__class__ is sms_body:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_body,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_body,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_msg_len
        except:
            self.__field_msg_len=UINT()
        try: self.__field_has_callback
        except:
            self.__field_has_callback=BOOL(**{ 'default': True })
        try: self.__field_has_priority
        except:
            self.__field_has_priority=BOOL(**{ 'default': False })
        try: self.__field_has_1byte
        except:
            self.__field_has_1byte=BOOL(**{ 'default': False })
        try: self.__field_has_1byte2
        except:
            self.__field_has_1byte2=BOOL(**{ 'default': True })
        try: self.__field_has_40bytes
        except:
            self.__field_has_40bytes=BOOL(**{ 'default': False })
        try: self.__field_msg
        except:
            self.__field_msg=USTRING(**{'default': '' })


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        raise NotImplementedError


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        if self.msg_len:
            DONTCARE(**{'sizeinbytes': 54}).readfrombuffer(buf)
            self.__field_msg=USTRING(**{ 'sizeinbytes': self.msg_len,                    'encoding': ENCODING,                    'terminator': None })
            self.__field_msg.readfrombuffer(buf)
        else:
            DONTCARE(**{'sizeinbytes': 53}).readfrombuffer(buf)
        if self.has_callback:
            DONTCARE(**{'sizeinbytes': 4}).readfrombuffer(buf)
            self.__field_callback_len=UINT(**{'sizeinbytes': 1})
            self.__field_callback_len.readfrombuffer(buf)
            self.__field_callback=STRING(**{ 'sizeinbytes': self.callback_len,                   'terminator': None })
            self.__field_callback.readfrombuffer(buf)
        if self.has_priority:
            self.__field_priority=UINT(**{'sizeinbytes': 1})
            self.__field_priority.readfrombuffer(buf)
        if self.has_1byte:
            DONTCARE(**{'sizeinbytes': 1}).readfrombuffer(buf)
        DONTCARE(**{'sizeinbytes': 40}).readfrombuffer(buf)
        self.__field_datetime=DateTime1(**{'sizeinbytes': 4})
        self.__field_datetime.readfrombuffer(buf)
        DONTCARE(**{'sizeinbytes': 13}).readfrombuffer(buf)
        self.__field_addr_len0=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len0.readfrombuffer(buf)
        self.__field_addr_len1=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len1.readfrombuffer(buf)
        self.__field_addr_len2=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len2.readfrombuffer(buf)
        self.__field_addr_len3=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len3.readfrombuffer(buf)
        self.__field_addr_len4=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len4.readfrombuffer(buf)
        self.__field_addr_len5=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len5.readfrombuffer(buf)
        self.__field_addr_len6=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len6.readfrombuffer(buf)
        self.__field_addr_len7=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len7.readfrombuffer(buf)
        self.__field_addr_len8=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len8.readfrombuffer(buf)
        self.__field_addr_len9=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len9.readfrombuffer(buf)
        if self.addr_len0:
            self.__field_addr0=STRING(**{ 'sizeinbytes': self.addr_len0,                   'terminator': None })
            self.__field_addr0.readfrombuffer(buf)
        if self.addr_len1:
            self.__field_addr1=STRING(**{ 'sizeinbytes': self.addr_len1,                   'terminator': None })
            self.__field_addr1.readfrombuffer(buf)
        if self.addr_len2:
            self.__field_addr2=STRING(**{ 'sizeinbytes': self.addr_len2,                   'terminator': None })
            self.__field_addr2.readfrombuffer(buf)
        if self.addr_len3:
            self.__field_addr3=STRING(**{ 'sizeinbytes': self.addr_len3,                   'terminator': None })
            self.__field_addr3.readfrombuffer(buf)
        if self.addr_len4:
            self.__field_addr4=STRING(**{ 'sizeinbytes': self.addr_len4,                   'terminator': None })
            self.__field_addr4.readfrombuffer(buf)
        if self.addr_len5:
            self.__field_addr5=STRING(**{ 'sizeinbytes': self.addr_len5,                   'terminator': None })
            self.__field_addr5.readfrombuffer(buf)
        if self.addr_len6:
            self.__field_addr6=STRING(**{ 'sizeinbytes': self.addr_len6,                   'terminator': None })
            self.__field_addr6.readfrombuffer(buf)
        if self.addr_len7:
            self.__field_addr7=STRING(**{ 'sizeinbytes': self.addr_len7,                   'terminator': None })
            self.__field_addr7.readfrombuffer(buf)
        if self.addr_len8:
            self.__field_addr8=STRING(**{ 'sizeinbytes': self.addr_len8,                   'terminator': None })
            self.__field_addr8.readfrombuffer(buf)
        if self.addr_len9:
            self.__field_addr9=STRING(**{ 'sizeinbytes': self.addr_len9,                   'terminator': None })
            self.__field_addr9.readfrombuffer(buf)
        if not self.has_1byte and self.has_1byte2:
            DONTCARE(**{'sizeinbytes': 1}).readfrombuffer(buf)
        if self.has_1byte2:
            DONTCARE(**{'sizeinbytes': 1}).readfrombuffer(buf)
        DONTCARE(**{'sizeinbytes': 81}).readfrombuffer(buf)
        if self.has_40bytes:
            DONTCARE(**{'sizeinbytes': 40}).readfrombuffer(buf)
        self.__field_msg_stat=LIST(**{ 'elementclass': sms_msg_stat_list,             'length': 10 })
        self.__field_msg_stat.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_msg_len(self):
        return self.__field_msg_len.getvalue()

    def __setfield_msg_len(self, value):
        if isinstance(value,UINT):
            self.__field_msg_len=value
        else:
            self.__field_msg_len=UINT(value,)

    def __delfield_msg_len(self): del self.__field_msg_len

    msg_len=property(__getfield_msg_len, __setfield_msg_len, __delfield_msg_len, None)

    def __getfield_has_callback(self):
        try: self.__field_has_callback
        except:
            self.__field_has_callback=BOOL(**{ 'default': True })
        return self.__field_has_callback.getvalue()

    def __setfield_has_callback(self, value):
        if isinstance(value,BOOL):
            self.__field_has_callback=value
        else:
            self.__field_has_callback=BOOL(value,**{ 'default': True })

    def __delfield_has_callback(self): del self.__field_has_callback

    has_callback=property(__getfield_has_callback, __setfield_has_callback, __delfield_has_callback, None)

    def __getfield_has_priority(self):
        try: self.__field_has_priority
        except:
            self.__field_has_priority=BOOL(**{ 'default': False })
        return self.__field_has_priority.getvalue()

    def __setfield_has_priority(self, value):
        if isinstance(value,BOOL):
            self.__field_has_priority=value
        else:
            self.__field_has_priority=BOOL(value,**{ 'default': False })

    def __delfield_has_priority(self): del self.__field_has_priority

    has_priority=property(__getfield_has_priority, __setfield_has_priority, __delfield_has_priority, None)

    def __getfield_has_1byte(self):
        try: self.__field_has_1byte
        except:
            self.__field_has_1byte=BOOL(**{ 'default': False })
        return self.__field_has_1byte.getvalue()

    def __setfield_has_1byte(self, value):
        if isinstance(value,BOOL):
            self.__field_has_1byte=value
        else:
            self.__field_has_1byte=BOOL(value,**{ 'default': False })

    def __delfield_has_1byte(self): del self.__field_has_1byte

    has_1byte=property(__getfield_has_1byte, __setfield_has_1byte, __delfield_has_1byte, None)

    def __getfield_has_1byte2(self):
        try: self.__field_has_1byte2
        except:
            self.__field_has_1byte2=BOOL(**{ 'default': True })
        return self.__field_has_1byte2.getvalue()

    def __setfield_has_1byte2(self, value):
        if isinstance(value,BOOL):
            self.__field_has_1byte2=value
        else:
            self.__field_has_1byte2=BOOL(value,**{ 'default': True })

    def __delfield_has_1byte2(self): del self.__field_has_1byte2

    has_1byte2=property(__getfield_has_1byte2, __setfield_has_1byte2, __delfield_has_1byte2, None)

    def __getfield_has_40bytes(self):
        try: self.__field_has_40bytes
        except:
            self.__field_has_40bytes=BOOL(**{ 'default': False })
        return self.__field_has_40bytes.getvalue()

    def __setfield_has_40bytes(self, value):
        if isinstance(value,BOOL):
            self.__field_has_40bytes=value
        else:
            self.__field_has_40bytes=BOOL(value,**{ 'default': False })

    def __delfield_has_40bytes(self): del self.__field_has_40bytes

    has_40bytes=property(__getfield_has_40bytes, __setfield_has_40bytes, __delfield_has_40bytes, None)

    def __getfield_msg(self):
        return self.__field_msg.getvalue()

    def __setfield_msg(self, value):
        if isinstance(value,USTRING):
            self.__field_msg=value
        else:
            self.__field_msg=USTRING(value,**{ 'sizeinbytes': self.msg_len,                    'encoding': ENCODING,                    'terminator': None })

    def __delfield_msg(self): del self.__field_msg

    msg=property(__getfield_msg, __setfield_msg, __delfield_msg, None)

    def __getfield_msg(self):
        try: self.__field_msg
        except:
            self.__field_msg=USTRING(**{'default': '' })
        return self.__field_msg.getvalue()

    def __setfield_msg(self, value):
        if isinstance(value,USTRING):
            self.__field_msg=value
        else:
            self.__field_msg=USTRING(value,**{'default': '' })

    def __delfield_msg(self): del self.__field_msg

    msg=property(__getfield_msg, __setfield_msg, __delfield_msg, None)

    def __getfield_callback_len(self):
        return self.__field_callback_len.getvalue()

    def __setfield_callback_len(self, value):
        if isinstance(value,UINT):
            self.__field_callback_len=value
        else:
            self.__field_callback_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_callback_len(self): del self.__field_callback_len

    callback_len=property(__getfield_callback_len, __setfield_callback_len, __delfield_callback_len, None)

    def __getfield_callback(self):
        return self.__field_callback.getvalue()

    def __setfield_callback(self, value):
        if isinstance(value,STRING):
            self.__field_callback=value
        else:
            self.__field_callback=STRING(value,**{ 'sizeinbytes': self.callback_len,                   'terminator': None })

    def __delfield_callback(self): del self.__field_callback

    callback=property(__getfield_callback, __setfield_callback, __delfield_callback, None)

    def __getfield_priority(self):
        return self.__field_priority.getvalue()

    def __setfield_priority(self, value):
        if isinstance(value,UINT):
            self.__field_priority=value
        else:
            self.__field_priority=UINT(value,**{'sizeinbytes': 1})

    def __delfield_priority(self): del self.__field_priority

    priority=property(__getfield_priority, __setfield_priority, __delfield_priority, None)

    def __getfield_datetime(self):
        return self.__field_datetime.getvalue()

    def __setfield_datetime(self, value):
        if isinstance(value,DateTime1):
            self.__field_datetime=value
        else:
            self.__field_datetime=DateTime1(value,**{'sizeinbytes': 4})

    def __delfield_datetime(self): del self.__field_datetime

    datetime=property(__getfield_datetime, __setfield_datetime, __delfield_datetime, None)

    def __getfield_addr_len0(self):
        return self.__field_addr_len0.getvalue()

    def __setfield_addr_len0(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len0=value
        else:
            self.__field_addr_len0=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len0(self): del self.__field_addr_len0

    addr_len0=property(__getfield_addr_len0, __setfield_addr_len0, __delfield_addr_len0, None)

    def __getfield_addr_len1(self):
        return self.__field_addr_len1.getvalue()

    def __setfield_addr_len1(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len1=value
        else:
            self.__field_addr_len1=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len1(self): del self.__field_addr_len1

    addr_len1=property(__getfield_addr_len1, __setfield_addr_len1, __delfield_addr_len1, None)

    def __getfield_addr_len2(self):
        return self.__field_addr_len2.getvalue()

    def __setfield_addr_len2(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len2=value
        else:
            self.__field_addr_len2=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len2(self): del self.__field_addr_len2

    addr_len2=property(__getfield_addr_len2, __setfield_addr_len2, __delfield_addr_len2, None)

    def __getfield_addr_len3(self):
        return self.__field_addr_len3.getvalue()

    def __setfield_addr_len3(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len3=value
        else:
            self.__field_addr_len3=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len3(self): del self.__field_addr_len3

    addr_len3=property(__getfield_addr_len3, __setfield_addr_len3, __delfield_addr_len3, None)

    def __getfield_addr_len4(self):
        return self.__field_addr_len4.getvalue()

    def __setfield_addr_len4(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len4=value
        else:
            self.__field_addr_len4=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len4(self): del self.__field_addr_len4

    addr_len4=property(__getfield_addr_len4, __setfield_addr_len4, __delfield_addr_len4, None)

    def __getfield_addr_len5(self):
        return self.__field_addr_len5.getvalue()

    def __setfield_addr_len5(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len5=value
        else:
            self.__field_addr_len5=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len5(self): del self.__field_addr_len5

    addr_len5=property(__getfield_addr_len5, __setfield_addr_len5, __delfield_addr_len5, None)

    def __getfield_addr_len6(self):
        return self.__field_addr_len6.getvalue()

    def __setfield_addr_len6(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len6=value
        else:
            self.__field_addr_len6=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len6(self): del self.__field_addr_len6

    addr_len6=property(__getfield_addr_len6, __setfield_addr_len6, __delfield_addr_len6, None)

    def __getfield_addr_len7(self):
        return self.__field_addr_len7.getvalue()

    def __setfield_addr_len7(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len7=value
        else:
            self.__field_addr_len7=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len7(self): del self.__field_addr_len7

    addr_len7=property(__getfield_addr_len7, __setfield_addr_len7, __delfield_addr_len7, None)

    def __getfield_addr_len8(self):
        return self.__field_addr_len8.getvalue()

    def __setfield_addr_len8(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len8=value
        else:
            self.__field_addr_len8=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len8(self): del self.__field_addr_len8

    addr_len8=property(__getfield_addr_len8, __setfield_addr_len8, __delfield_addr_len8, None)

    def __getfield_addr_len9(self):
        return self.__field_addr_len9.getvalue()

    def __setfield_addr_len9(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len9=value
        else:
            self.__field_addr_len9=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len9(self): del self.__field_addr_len9

    addr_len9=property(__getfield_addr_len9, __setfield_addr_len9, __delfield_addr_len9, None)

    def __getfield_addr0(self):
        return self.__field_addr0.getvalue()

    def __setfield_addr0(self, value):
        if isinstance(value,STRING):
            self.__field_addr0=value
        else:
            self.__field_addr0=STRING(value,**{ 'sizeinbytes': self.addr_len0,                   'terminator': None })

    def __delfield_addr0(self): del self.__field_addr0

    addr0=property(__getfield_addr0, __setfield_addr0, __delfield_addr0, None)

    def __getfield_addr1(self):
        return self.__field_addr1.getvalue()

    def __setfield_addr1(self, value):
        if isinstance(value,STRING):
            self.__field_addr1=value
        else:
            self.__field_addr1=STRING(value,**{ 'sizeinbytes': self.addr_len1,                   'terminator': None })

    def __delfield_addr1(self): del self.__field_addr1

    addr1=property(__getfield_addr1, __setfield_addr1, __delfield_addr1, None)

    def __getfield_addr2(self):
        return self.__field_addr2.getvalue()

    def __setfield_addr2(self, value):
        if isinstance(value,STRING):
            self.__field_addr2=value
        else:
            self.__field_addr2=STRING(value,**{ 'sizeinbytes': self.addr_len2,                   'terminator': None })

    def __delfield_addr2(self): del self.__field_addr2

    addr2=property(__getfield_addr2, __setfield_addr2, __delfield_addr2, None)

    def __getfield_addr3(self):
        return self.__field_addr3.getvalue()

    def __setfield_addr3(self, value):
        if isinstance(value,STRING):
            self.__field_addr3=value
        else:
            self.__field_addr3=STRING(value,**{ 'sizeinbytes': self.addr_len3,                   'terminator': None })

    def __delfield_addr3(self): del self.__field_addr3

    addr3=property(__getfield_addr3, __setfield_addr3, __delfield_addr3, None)

    def __getfield_addr4(self):
        return self.__field_addr4.getvalue()

    def __setfield_addr4(self, value):
        if isinstance(value,STRING):
            self.__field_addr4=value
        else:
            self.__field_addr4=STRING(value,**{ 'sizeinbytes': self.addr_len4,                   'terminator': None })

    def __delfield_addr4(self): del self.__field_addr4

    addr4=property(__getfield_addr4, __setfield_addr4, __delfield_addr4, None)

    def __getfield_addr5(self):
        return self.__field_addr5.getvalue()

    def __setfield_addr5(self, value):
        if isinstance(value,STRING):
            self.__field_addr5=value
        else:
            self.__field_addr5=STRING(value,**{ 'sizeinbytes': self.addr_len5,                   'terminator': None })

    def __delfield_addr5(self): del self.__field_addr5

    addr5=property(__getfield_addr5, __setfield_addr5, __delfield_addr5, None)

    def __getfield_addr6(self):
        return self.__field_addr6.getvalue()

    def __setfield_addr6(self, value):
        if isinstance(value,STRING):
            self.__field_addr6=value
        else:
            self.__field_addr6=STRING(value,**{ 'sizeinbytes': self.addr_len6,                   'terminator': None })

    def __delfield_addr6(self): del self.__field_addr6

    addr6=property(__getfield_addr6, __setfield_addr6, __delfield_addr6, None)

    def __getfield_addr7(self):
        return self.__field_addr7.getvalue()

    def __setfield_addr7(self, value):
        if isinstance(value,STRING):
            self.__field_addr7=value
        else:
            self.__field_addr7=STRING(value,**{ 'sizeinbytes': self.addr_len7,                   'terminator': None })

    def __delfield_addr7(self): del self.__field_addr7

    addr7=property(__getfield_addr7, __setfield_addr7, __delfield_addr7, None)

    def __getfield_addr8(self):
        return self.__field_addr8.getvalue()

    def __setfield_addr8(self, value):
        if isinstance(value,STRING):
            self.__field_addr8=value
        else:
            self.__field_addr8=STRING(value,**{ 'sizeinbytes': self.addr_len8,                   'terminator': None })

    def __delfield_addr8(self): del self.__field_addr8

    addr8=property(__getfield_addr8, __setfield_addr8, __delfield_addr8, None)

    def __getfield_addr9(self):
        return self.__field_addr9.getvalue()

    def __setfield_addr9(self, value):
        if isinstance(value,STRING):
            self.__field_addr9=value
        else:
            self.__field_addr9=STRING(value,**{ 'sizeinbytes': self.addr_len9,                   'terminator': None })

    def __delfield_addr9(self): del self.__field_addr9

    addr9=property(__getfield_addr9, __setfield_addr9, __delfield_addr9, None)

    def __getfield_msg_stat(self):
        return self.__field_msg_stat.getvalue()

    def __setfield_msg_stat(self, value):
        if isinstance(value,LIST):
            self.__field_msg_stat=value
        else:
            self.__field_msg_stat=LIST(value,**{ 'elementclass': sms_msg_stat_list,             'length': 10 })

    def __delfield_msg_stat(self): del self.__field_msg_stat

    msg_stat=property(__getfield_msg_stat, __setfield_msg_stat, __delfield_msg_stat, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('msg_len', self.__field_msg_len, None)
        yield ('has_callback', self.__field_has_callback, None)
        yield ('has_priority', self.__field_has_priority, None)
        yield ('has_1byte', self.__field_has_1byte, None)
        yield ('has_1byte2', self.__field_has_1byte2, None)
        yield ('has_40bytes', self.__field_has_40bytes, None)
        if self.msg_len:
            yield ('msg', self.__field_msg, None)
        else:
            yield ('msg', self.__field_msg, None)
        if self.has_callback:
            yield ('callback_len', self.__field_callback_len, None)
            yield ('callback', self.__field_callback, None)
        if self.has_priority:
            yield ('priority', self.__field_priority, None)
        if self.has_1byte:
            pass
        yield ('datetime', self.__field_datetime, None)
        yield ('addr_len0', self.__field_addr_len0, None)
        yield ('addr_len1', self.__field_addr_len1, None)
        yield ('addr_len2', self.__field_addr_len2, None)
        yield ('addr_len3', self.__field_addr_len3, None)
        yield ('addr_len4', self.__field_addr_len4, None)
        yield ('addr_len5', self.__field_addr_len5, None)
        yield ('addr_len6', self.__field_addr_len6, None)
        yield ('addr_len7', self.__field_addr_len7, None)
        yield ('addr_len8', self.__field_addr_len8, None)
        yield ('addr_len9', self.__field_addr_len9, None)
        if self.addr_len0:
            yield ('addr0', self.__field_addr0, None)
        if self.addr_len1:
            yield ('addr1', self.__field_addr1, None)
        if self.addr_len2:
            yield ('addr2', self.__field_addr2, None)
        if self.addr_len3:
            yield ('addr3', self.__field_addr3, None)
        if self.addr_len4:
            yield ('addr4', self.__field_addr4, None)
        if self.addr_len5:
            yield ('addr5', self.__field_addr5, None)
        if self.addr_len6:
            yield ('addr6', self.__field_addr6, None)
        if self.addr_len7:
            yield ('addr7', self.__field_addr7, None)
        if self.addr_len8:
            yield ('addr8', self.__field_addr8, None)
        if self.addr_len9:
            yield ('addr9', self.__field_addr9, None)
        if not self.has_1byte and self.has_1byte2:
            pass
        if self.has_1byte2:
            pass
        if self.has_40bytes:
            pass
        yield ('msg_stat', self.__field_msg_stat, None)




