/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxcoo
 * Create Date:	2004-03-06 14:41
 */

#ifndef _BINTEGER_H_
#define _BINTEGER_H_

#include <string.h>
#include <string>
#include <stdio.h>
#include "bobject.h"

class CBInteger:public CBObject
{
public:
	CBInteger(void)
		:CBObject(1)
		,m_value(0)
		{};
	~CBInteger(void){};

private:
	int64_t m_value;
public:
	int64_t getValue(void)
	{
		return m_value;
	};
	int parse(const char* buf,unsigned long bufLen)
	{
		int result=-1;
		
		if(buf[0]=='i')
		{
			unsigned long i=1;
			while(buf[i]!='e' && i<bufLen)
			{
				++i;
			}
				
			if(buf[i]=='e')
			{
				char* temp=new char[i];
				if(temp!=NULL)
				{
					strncpy(temp,&buf[1],i-1);
					temp[i-1]='\0';
					m_value=atoll(temp);
					delete temp;
					result=i+1;
				}
			}
		}
		return result;
	};
	
	void get_bestr(std::string& str)
	{
		char buf[1024];
		memset(buf,0,sizeof(buf));
		sprintf(buf,"i%llde",m_value);
		str+=buf;
	};	
};

#endif
