
#ifndef MC940_IMAGE_H
#define MC940_IMAGE_H

//* @package glow.image

#include <stdio.h>

#define GMAX(a,b,c) (((a>=b)&&(a>=c))?a:((b>c)?b:c))
#define GMIN(a,b,c) (((a<=b)&&(a<=c))?a:((b<c)?b:c))

//* A color triplet, be it RGB, YCbCr or HSV
class Triplet {
 public:
  static int R(int triplet);
  static int G(int triplet);
  static int B(int triplet);

  /// makes a triplet out of 3 values (usually R,G,B)
  static int value(int r,int g,int b);

  /// slower but provides range checking
  static int safeValue(int r,int g,int b);

  static int inline Y(int triplet)  { return(R(triplet)); }
  static int inline Cb(int triplet) { return(G(triplet)); }
  static int inline Cr(int triplet) { return(B(triplet)); }

  static int inline H(int triplet)  { return(R(triplet)); }
  static int inline S(int triplet)  { return(G(triplet)); }
  static int inline V(int triplet)  { return(B(triplet)); }

  static int RGB2HSV(int triplet);
  static int HSV2RGB(int triplet);

  static int RGB2YCbCr(int triplet);
  static int YCbCr2RGB(int triplet);

  virtual void dont_try_to_instantiate_me()=0;
};

class BitPlane {
 public:
  /// creates a new 8-bit plane with the given size, filled with zeroes
  BitPlane(int width,int height);

  /// deallocates memory
  ~BitPlane();

  /// returns position value
  int getPixel(int x,int y);

  /// sets position value
  void setPixel(int x,int y,int value);

  /// sets a whole row with the given value
  void fillRow(int y,int value);

  /// copies full row srcy to desty
  void copyRow(int desty,int srcy);

  /// plane size
  int Width,Height;

  /// returns buffer address, be careful
  unsigned char *getBase();

 private:
  unsigned char *data;
  int *rowoffset;
};

class Image {

 public:
  /// creates a new image, initialized to full black
  Image(int width,int height);

  /// creates a new image from the given file. NULL means stdin
  Image(char *filename);

  /// deallocates memory
  ~Image();

  /// returns RGB triplet of pixel
  int getPixel(int x,int y);

  /// sets pixel value, given in a RGB triplet (e.g. 0xff80e0)
  void setPixel(int x,int y,int value);

  /// sets a whole row with the given RGB value
  void fillRow(int y,int value);

  /// copies full row srcy to desty
  void copyRow(int desty,int srcy);

  /// image size
  int Width, Height;
  
  /// saves in P6 format, returns 0 if ok, <0 on error. filename == NULL means stdout
  int  saveP6(char *filename);

  /// saves in HSV. filename==NULL means stdout
  int  saveHSV(char *filename);
  
  /// saves in YCbCr.  filename==NULL means stdout
  int  saveYCbCr(char *filename);

  /// if != 0 saves additional P2 files with each plane
  int SavePlanes;

 private:
  BitPlane *red,*green,*blue;

  /// guesses image format
  void iread(FILE *f);

  void readYCbCr(FILE *f);
  void readP6(FILE *f);
  void readHSV(FILE *f);
  void readHeader(FILE *f);
};


#endif
