#ifdef offsetof
#define Blt_Offset(type, field) ((int) offsetof(type, field))
#else
#define Blt_Offset(type, field) ((int) ((char *) &((type *) 0)->field))
#endif

typedef int (Blt_SwitchParseProc) _ANSI_ARGS_((ClientData clientData,
	Tcl_Interp *interp, char *value, char *record, int offset));

typedef struct {
    Blt_SwitchParseProc *parseProc;	/* Procedure to call to parse an
					 * option and store it in converted
					 * form. */
    ClientData clientData;		/* Arbitrary one-word value used by
					 * option parser:  passed to
					 * parseProc and printProc. */
} Blt_CustomSwitch;

/*
 * Type values for Blt_SwitchSpec structures.  See the user
 * documentation for details.
 */
typedef enum {
    BLT_SWITCH_BOOLEAN, BLT_SWITCH_INT, BLT_SWITCH_INT_POSITIVE,
    BLT_SWITCH_INT_NONNEGATIVE, BLT_SWITCH_DOUBLE, BLT_SWITCH_STRING, 
    BLT_SWITCH_LIST, BLT_SWITCH_FLAG, BLT_SWITCH_VALUE, BLT_SWITCH_CUSTOM, 
    BLT_SWITCH_END
} Blt_SwitchTypes;

typedef struct {
    Blt_SwitchTypes type;	/* Type of option, such as BLT_SWITCH_COLOR;
				 * see definitions below.  Last option in
				 * table must have type BLT_SWITCH_END. */
    char *name;			/* Switch used to specify option in argv.
				 * NULL means this spec is part of a group. */
    int offset;			/* Where in widget record to store value;
				 * use Blt_Offset macro to generate values
				 * for this. */
    int flags;			/* Any combination of the values defined
				 * below. */
    Blt_CustomSwitch *customPtr; /* If type is TK_SWITCH_CUSTOM then this is
				 * a pointer to info about how to parse and
				 * print the option.  Otherwise it is
				 * irrelevant. */
    int value;
} Blt_SwitchSpec;

#define BLT_SWITCH_ARGV_ONLY		1
/*
 * Possible flag values for Blt_SwitchSpec structures.  Any bits at
 * or above BLT_SWITCH_USER_BIT may be used by clients for selecting
 * certain entries.  
 */
#define BLT_SWITCH_NULL_OK		1
#define BLT_SWITCH_DONT_SET_DEFAULT	8
#define BLT_SWITCH_SPECIFIED		0x10 
#define BLT_SWITCH_USER_BIT		0x100

extern int Blt_ProcessSwitches _ANSI_ARGS_((Tcl_Interp *interp, 
	Blt_SwitchSpec *specs, int argc, char **argv, char *record, int flags));

extern void Blt_FreeSwitches _ANSI_ARGS_((Blt_SwitchSpec *specs, char *record, 
	int flags));

extern int Blt_SwitchChanged _ANSI_ARGS_(TCL_VARARGS(Blt_SwitchSpec *, specs));

#if (TCL_VERSION_NUMBER >= _VERSION(8,0,0)) 
extern int Blt_ProcessObjSwitches _ANSI_ARGS_((Tcl_Interp *interp, 
	Blt_SwitchSpec *specPtr, int objc, Tcl_Obj **objv, char *record, 
	int flags));
#endif
