/* Bluefish HTML Editor
 * filter.h - external filter backend interface
 *
 * Copyright (c) 2000 Antti-Juhani Kaijanaho
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FILTER_H_
#define __FILTER_H_

#include <stddef.h>

#define buf_elem_t char

typedef struct {
	buf_elem_t *buf;
	size_t capacity;
	size_t length;
} buffer_t;

/* Return zero iff problems. */
int filter_buffer(char const *commandline, buffer_t in_buf, buffer_t * out_buf);

#endif
