#define BLOCK_SIZE	512		/* The block size. It is 512. */
#define BR_GOOD_FLAG    0XAA55          /* Good Boot Record Flag */
#define BR_FLAG_OFF     0x01FE          /* the Offset of Boot Record Flag */
#define PART_TBL_OFF    0x01BE          /* the offset of the partition table */

#define BOOT_OFF        0x7C00          /* boot sector startup offset (in mem)*/
#define PART_OFF        0x0600          /* partition table offset (in mem) */
#define SECTOR_SIZE     0x200           /* size of a sector */

#define SBMK_MAGIC      0x4B4D4253      /* magic number of
                                           Smart Boot Manager kernel. */
#ifndef SBMK_VERSION
  #define SBMK_VERSION    0x0306          /* version of kernel. */
#endif


#define SBMT_MAGIC      0x544D4253      /* magic number of
                                           Smart Boot Manager theme. */

#ifndef SBMT_VERSION
  #define SBMT_VERSION    0x0306          /* version of theme. */
#endif

#define SBML_MAGIC      0x4C4D4253      /* magic number of
                                           Smart Boot Manager loader. */

#ifndef SBML_VERSION
  #define SBML_VERSION    0x0301          /* version of loader. */
#endif

#define SIZE_OF_MBR     446
#define MAX_SBM_SIZE    30000           /* the max size of Smart Boot Manager */

#define MAX_RECORD_NUM  32

/* the macros that used in struct struc_sbmk_data */
#define KNLFLAG_FIRSTRUN    0x01        /* this flag indicates that the kernel
                                           runs the first time. */
#define KNLFLAG_SECURITY    0x02        /* this flag indicates that the kernel
                                           is in security lock mode */
#define KNLFLAG_FLOPPY_OK   0x04        /* this flag indicates that the floppy
                                           driver is ok */
#define KNLFLAG_HIDEFLAGS   0x08        /* this flag tell sbm do not show
                                           the flags column in boot menu */

#define KNLFLAG_NOAUTOSCAN  0x10
#define KNLFLAG_REMLAST     0x20
#define KNLFLAG_NOINT13EXT  0x40        /* this flag tell sbm do not use 
                                           Extended Int13H */

/* the macros that used in struct struc_bootrecord */
/* all flags in ext_flags were integrated into flags */

#define INFOFLAG_SCHEDULED  0x8000        /*1000,0000,0000,0000B*/
#define INFOFLAG_HAVEKEYS   0x4000        /*0100,0000,0000,0000B*/
#define INFOFLAG_SWAPDRVID  0x2000        /*0010,0000,0000,0000B*/
#define INFOFLAG_AUTOACTIVE 0x1000        /*0001,0000,0000,0000B*/
#define INFOFLAG_ACTIVE     0x0800        /*0000,1000,0000,0000B*/
#define INFOFLAG_AUTOHIDE   0x0400        /*0000,0100,0000,0000B*/
#define INFOFLAG_HIDDEN     0x0200        /*0000,0010,0000,0000B*/
#define INFOFLAG_LOGICAL    0x0100        /*0000,0001,0000,0000B*/
#define INFOFLAG_ISDRIVER   0x0080        /*0000,0000,1000,0000B*/
#define INFOFLAG_ISSPECIAL  0X0008        /*0000,0000,0000,1000B*/

#define DRVFLAG_DRIVEOK     0x0001        
#define DRVFLAG_CHSVALID    0x0002        /* used in driveinfo structure */
#define DRVFLAG_REMOVABLE   0x0004        /* and bootrecord structure */
#define DRVFLAG_EXTOK      0x0008
#define DRVFLAG_ISCDROM     0x0010


#define DRVFLAG_EXTOK       0x0008       
#define DRVFLAG_MASK        0x0015        /* 0000,0000,0001,0101B */


#define MIN_CDROM_ID        0xE0

struct struc_fat12_header
{
/*=================== For floppy FAT12 filesystem ======================*/
  byte  bsOEM [8];		// OEM String
  word  bsSectSize;		// Bytes per sector
  byte  bsClustSize;		// Sectors per cluster
  word  bsRessect;		// # of reserved sectors
  byte  bsFatCnt;		// # of fat copies
  word  bsRootSize;		// size of root directory
  word  bsTotalSect;		// total # of sectors if < 32 meg
  byte  bsMedia;		// Media Descriptor
  word  bsFatSize;		// Size of each FAT
  word  bsTrackSect;		// Sectors per track
  word  bsHeadCnt;		// number of read-write heads
  dword bsHidenSect;		// number of hidden sectors
  dword bsHugeSect;		// if bsTotalSect is 0 this value is
				// the number of sectors
  byte  bsBootDrv;		// holds drive that the bs came from
  byte  bsReserv;		// not used for anything
  byte  bsBootSign;		// boot signature 29h
  dword bsVolID;		// Disk volume ID also used for temp
				// sector # / # sectors to load
  byte  bsVoLabel [11];		// Volume Label
  byte  bsFSType [8];		// File System type
/*====================================================================*/
}
__attribute__ ((packed));


/*=============================================================*\
 * the header structure of Smart Boot Manager Loader           *
 * the loader is stored in the first sector of the harddisk or *
 * floppy (MBR). see loader.asm for details.                   *
 *                                                             *
 * this data struct is stored from the first byte of the loader*
 * The kernel that mentioned below is the Smart BootManager's  *
 * main program, it has nothing to do with the linux kernel.   *
\*=============================================================*/

// The data fat12 and sects2, addr2, sects3, addr3 ... are reserved
// for future installation program which supports installing the kernel of
// SBM into a filesystem (including floppy).
// There can be no more than five non-continue blocks for SBM kernel which 
// installed into a filesystem.

struct struc_sbml_header	// the header of smart boot manager
{				// loader.

  byte  jmp_cmd[3];		// For floppy filesystem installation
				// it must exactly equal to 0xEB, 0x3C, 0x90!
				// ie: 
				//     jmp short jmp_cmd2
				//     nop
				//
				// But for harddisk MBR installation,
				// the first byte must equal to 0xFA (cli),
				// if not, WinNT 4 will crash.
				// For this case, the first two commands are:
				//     cli
				//     jmp short to_actual_code

  struct struc_fat12_header fat12;	// data for fat12 filesystem.
  word  jmp_cmd2;		// 0xEB, 0x1F (jmp short to actual code)

  dword magic;			// magic number.
  word  version;		// version.

  byte  kernel_sects1;		// size and address of kernel block 1
  dword kernel_addr1;		//
  byte  kernel_sects2;		// size and address of kernel block 2
  dword kernel_addr2;		//
  byte  kernel_sects3;		// size and address of kernel block 3
  dword kernel_addr3;		//
  byte  kernel_sects4;		// size and address of kernel block 4
  dword kernel_addr4;		//
  byte  kernel_sects5;		// size and address of kernel block 5
  dword kernel_addr5;		//
}
__attribute__ ((packed));


/*=============================================================*\
 * the header structure of smart boot manager kernel           *
 * the kernel is stored in the sectors right after the loader  *
 * (in current install program), in fact, it can be stored into*
 * anywhere.                                                   *
 * this data struct is stored from the first byte of the kernel*
\*=============================================================*/
struct struc_sbmk_header	// the header of smart boot manager
{				// kernel.
  dword jmp_cmd;		// jmp and nop command.
  dword magic;			// magic number.
  word  version;		// version.
  word  kernel_size;		// the size of kernel code.
  word  checksum_size;		// the number of bytes that will
                                // be counted in checksum.
  byte  checksum;		// checksum value.
  byte  kernel_sectors;		// the total sectors that kernel
                                // and theme used.
  byte  kernel_drvid;		// driver id
  byte  kernel_sects1;		// size and address of kernel block 1
  dword kernel_addr1;
  byte  kernel_sects2;		// size and address of kernel block 2
  dword kernel_addr2;
  byte  kernel_sects3;		// size and address of kernel block 3
  dword kernel_addr3;
  byte  kernel_sects4;		// size and address of kernel block 4
  dword kernel_addr4;
  byte  kernel_sects5;		// size and address of kernel block 5
  dword kernel_addr5;

  word  reserved;
}
__attribute__ ((packed));


/*=============================================================*\
 * the header structure of smart boot manager theme            *
 * the theme  is stored right after the kernel                 *
 * see sbminst.c for details.                                  *
 * this data struct is stored from the first byte of the kernel*
\*=============================================================*/

struct struc_sbmt_header
{
      dword magic;             /* magic number. SBMT_MAGIC */
      word  reserved;
      byte  lang[6];           /* language info. */
      word  version;           /* theme version. SBMT_VERSION */
      word  size;              /* theme size. */
} __attribute__ ((packed));

/*=============================================================*\
 * the structure of boot record, including removable drives and*
 * partitions.                                                 *
 * the boot records data is stored in struct struc_sbmk_data   *
 * see below.                                                  *
\*=============================================================*/

struct struc_bootrecord
{
      word  flags;          /* type flags of this record, 
                               see macros INFOFLAG_x,
                               if INFOFLAG_ISDRIVER is set, this record
                               is a floppy- or harddrive, otherwise it's a
                               partition on fixed drive.
                               If this is a floppy driver, DRVFLAG_REMOVABLE
                               muse be set. All valid record must set
                               DRVFLAG_DRIVEOK */


      byte  drive_id;       /* drive id = 0 to 255, 0 = the first floppy
                               0x80 = the first harddisk */
                                 ; 
      byte  part_id;        /* partition id used in linux, 
                               1-4 for primary partitions,
                               > 5 for logical partitions. */

                            
      byte  type;           /* partition type,  0 = free, 0x83 = linux native */

      byte  reserved;

      dword father_abs_addr;/* father partition's LBA address,
                               for primary partition and floppy, it is zero,
                               for logical partition, it's the LBA address of
                               the extended partition that this logical part
                               stayed in.

                               each logical partition have it's own father 
                               partition, the father of /dev/hda5 is the first
                               extended partition whose record is stored in
                               MBR's partition table. The record of /dev/hda6's
                               father partition is stored in the partition 
                               table of the first extended partition, it's the
                               second entry. */
                               

      dword abs_addr;       /* partition's abs LBA address */
      dword password;       /* password of this record, 0 = no passwd 
                               the password is encrypted by func calc_password
                               see file utils.asm */

      dword schedule_time;  /* schedule time and days info
                               first 12 bits(bit 0 - bit 11)
                               is the begin schedule time (in minutes),
                               the following 12 bits(bit 12 - bit 23)
                               is the end schedule time (in minutes),
                               the following 7 bits(bit 24 - bit 30)
                               is the days info, each bit indicates a day
                               (from Sunday, bit 24 to Saturday, bit 30), 
                               if all these bits is zero (no day is selected)
                               that all days will be selected. */
                               
      byte  name[16];       /* name of this record, zero ending. */

      word keystrokes[13];  /* keystrokes to be preloaded into the keyboard
                               buffer, while booting the OS. 
                               each key occupied 1 word, high byte is the 
                               keyboard scan code, low byte is the ascii code */

} __attribute__ ((packed));

/*=============================================================*\
 * the structure of Smart BootManager kernel's data area,      *
 * it is stored right after the struc_sbmk_header data         * 
\*=============================================================*/

struct struc_sbmk_data
{
     byte kernel_flags;    /* kernel flags, see macros KNLFLAGS_x 
                               the install program must set this field
                               to KNLFLAGS_FIRSTRUN | KNLFLAGS_FLOPPY_OK */

      byte delay_time;      /* delay time in second, 0 = boot the default
                               record directly, 255 = no delay, wait user
                               choose. */
      byte direct_boot_record; /* the bootrecord index in the boot_records 
                                  array.
                                  is this record is a valid bootrecord,
                                  Smart BootManager will boot this record
                                  directly and this field will be reset to
                                  0xff. So the value of this field only affect
                                  one time. */
      byte default_record;  /* the bootrecord index in the boot_records array,
                               this record will be booted automatically if
                               the delay time is up or ESC key is pressed. */
      dword root_password;  /* the adiministration password, encrypted by
                               func calc_password */

      word bootmenu_style;  /* 0 = show all, 1 = hide Flags, 2 = hide Flags and
                               Number, 3 = only show Name */
      word cdrom_ioports[2]; /* additional CD-ROM I/O ports */

      struct struc_bootrecord boot_records[MAX_RECORD_NUM];
                            /* the array of boot records */

      byte sbml_codes[SIZE_OF_MBR]; /* when install SBM, put 
                                       SBM Loader (first 446 bytes of 
                                       loader.bin) here */

      byte previous_mbr[SECTOR_SIZE]; /* when install SBM, put previous MBR
                                         (512 bytes) here */

} __attribute__ ((packed));


struct struc_sbmk
{
	struct struc_sbmk_header header;
	struct struc_sbmk_data data;
} __attribute__ ((packed));

/*

the data layout of Smart BootManager kernel (main.bin) is:

    Offset      Data type
====================================
     0          struc_sbmk_header  sbmk_header;
                struc_sbmk_data    sbmk_data;

     .
     .          program codes
     . 

kernel_size     struc_sbmt_header  sbmt_header;

     .
     .          theme data
     .


note: the kernel_size is a member of struct struc_sbmk_header

      the total size of the kernel and theme is:

      sbmk_header.kernel_size + sbmt_header.size

      the total sectors that kernel and theme occupied is :

      (sbmk_header.kernel_size + sbmt_header.size + 511) / 512

*/

