//
// libhal++ (C) GPL 2006 M. Derezynski
//

#ifndef _HAL_CC_STORAGE_TYPES_HH_
#define _HAL_CC_STORAGE_TYPES_HH_

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif //HAVE_CONFIG_H

#include <libhal-storage.h>

namespace Hal
{
  enum DriveBus
  {
    DRIVE_BUS_UNKNOWN   = LIBHAL_DRIVE_BUS_UNKNOWN, 
    DRIVE_BUS_IDE       = LIBHAL_DRIVE_BUS_IDE, 
    DRIVE_BUS_SCSI      = LIBHAL_DRIVE_BUS_SCSI,
    DRIVE_BUS_USB       = LIBHAL_DRIVE_BUS_USB,
    DRIVE_BUS_IEEE1394  = LIBHAL_DRIVE_BUS_IEEE1394,
    DRIVE_BUS_CCW       = LIBHAL_DRIVE_BUS_CCW 
  };

  enum DriveType
  {
    DRIVE_TYPE_REMOVABLE_DISK         = LIBHAL_DRIVE_TYPE_REMOVABLE_DISK,
    DRIVE_TYPE_DISK                   = LIBHAL_DRIVE_TYPE_DISK,
    DRIVE_TYPE_CDROM                  = LIBHAL_DRIVE_TYPE_CDROM,
    DRIVE_TYPE_FLOPPY                 = LIBHAL_DRIVE_TYPE_FLOPPY,
    DRIVE_TYPE_TAPE                   = LIBHAL_DRIVE_TYPE_TAPE,
    DRIVE_TYPE_COMPACT_FLASH          = LIBHAL_DRIVE_TYPE_COMPACT_FLASH,
    DRIVE_TYPE_MEMORY_STICK           = LIBHAL_DRIVE_TYPE_MEMORY_STICK,
    DRIVE_TYPE_SMART_MEDIA            = LIBHAL_DRIVE_TYPE_SMART_MEDIA,
    DRIVE_TYPE_SD_MMC                 = LIBHAL_DRIVE_TYPE_SD_MMC,
    DRIVE_TYPE_CAMERA                 = LIBHAL_DRIVE_TYPE_CAMERA,
    DRIVE_TYPE_PORTABLE_AUDIO_PLAYER  = LIBHAL_DRIVE_TYPE_PORTABLE_AUDIO_PLAYER,
    DRIVE_TYPE_ZIP                    = LIBHAL_DRIVE_TYPE_ZIP,
    DRIVE_TYPE_JAZ                    = LIBHAL_DRIVE_TYPE_JAZ,
    DRIVE_TYPE_FLASHKEY               = LIBHAL_DRIVE_TYPE_FLASHKEY
  };

  enum DriveCdromCaps
  {
    DRIVE_CDROM_CAPS_CDROM            = LIBHAL_DRIVE_CDROM_CAPS_CDROM,
    DRIVE_CDROM_CAPS_CDR              = LIBHAL_DRIVE_CDROM_CAPS_CDR,
    DRIVE_CDROM_CAPS_CDRW             = LIBHAL_DRIVE_CDROM_CAPS_CDRW,
    DRIVE_CDROM_CAPS_DVDRAM           = LIBHAL_DRIVE_CDROM_CAPS_DVDRAM,
    DRIVE_CDROM_CAPS_DVDROM           = LIBHAL_DRIVE_CDROM_CAPS_DVDROM,
    DRIVE_CDROM_CAPS_DVDR             = LIBHAL_DRIVE_CDROM_CAPS_DVDR,
    DRIVE_CDROM_CAPS_DVDRW            = LIBHAL_DRIVE_CDROM_CAPS_DVDRW,
    DRIVE_CDROM_CAPS_DVDPLUSR         = LIBHAL_DRIVE_CDROM_CAPS_DVDPLUSR,
    DRIVE_CDROM_CAPS_DVDPLUSRW        = LIBHAL_DRIVE_CDROM_CAPS_DVDPLUSRW,
    DRIVE_CDROM_CAPS_DVDPLUSRDL       = LIBHAL_DRIVE_CDROM_CAPS_DVDPLUSRDL,
#ifdef HAVE_HAL_058
    DRIVE_CDROM_CAPS_DVDPLUSRWDL      = LIBHAL_DRIVE_CDROM_CAPS_DVDPLUSRWDL,
#endif //HAVE_HAL_058
    DRIVE_CDROM_CAPS_BDROM            = LIBHAL_DRIVE_CDROM_CAPS_BDROM,
    DRIVE_CDROM_CAPS_BDR              = LIBHAL_DRIVE_CDROM_CAPS_BDR,
    DRIVE_CDROM_CAPS_BDRE             = LIBHAL_DRIVE_CDROM_CAPS_BDRE,
    DRIVE_CDROM_CAPS_HDDVDROM         = LIBHAL_DRIVE_CDROM_CAPS_HDDVDROM,
    DRIVE_CDROM_CAPS_HDDVDR           = LIBHAL_DRIVE_CDROM_CAPS_HDDVDR,
    DRIVE_CDROM_CAPS_HDDVDRW          = LIBHAL_DRIVE_CDROM_CAPS_HDDVDRW,
  };
  
  enum VolumeUsage
  {
    VOLUME_USAGE_MOUNTABLE_FILESYSTEM = LIBHAL_VOLUME_USAGE_MOUNTABLE_FILESYSTEM,
    VOLUME_USAGE_PARTITION_TABLE      = LIBHAL_VOLUME_USAGE_PARTITION_TABLE,
    VOLUME_USAGE_RAID_MEMBER          = LIBHAL_VOLUME_USAGE_RAID_MEMBER,
    VOLUME_USAGE_CRYPTO               = LIBHAL_VOLUME_USAGE_CRYPTO,
    VOLUME_USAGE_UNKNOWN              = LIBHAL_VOLUME_USAGE_UNKNOWN,
#ifdef HAVE_HAL_058
    VOLUME_USAGE_OTHER                = LIBHAL_VOLUME_USAGE_OTHER
#endif
  };

  enum VolumeDiscType
  {
    VOLUME_DISC_TYPE_CDROM            = LIBHAL_VOLUME_DISC_TYPE_CDROM,
    VOLUME_DISC_TYPE_CDR              = LIBHAL_VOLUME_DISC_TYPE_CDR,
    VOLUME_DISC_TYPE_CDRW             = LIBHAL_VOLUME_DISC_TYPE_CDRW,
    VOLUME_DISC_TYPE_DVDROM           = LIBHAL_VOLUME_DISC_TYPE_DVDROM,
    VOLUME_DISC_TYPE_DVDRAM           = LIBHAL_VOLUME_DISC_TYPE_DVDRAM,
    VOLUME_DISC_TYPE_DVDR             = LIBHAL_VOLUME_DISC_TYPE_DVDR,
    VOLUME_DISC_TYPE_DVDRW            = LIBHAL_VOLUME_DISC_TYPE_DVDRW,
    VOLUME_DISC_TYPE_DVDPLUSR         = LIBHAL_VOLUME_DISC_TYPE_DVDPLUSR,
    VOLUME_DISC_TYPE_DVDPLUSRW        = LIBHAL_VOLUME_DISC_TYPE_DVDPLUSRW,
    VOLUME_DISC_TYPE_DVDPLUSR_DL      = LIBHAL_VOLUME_DISC_TYPE_DVDPLUSR_DL,
    VOLUME_DISC_TYPE_BDROM            = LIBHAL_VOLUME_DISC_TYPE_BDROM,
    VOLUME_DISC_TYPE_BDR              = LIBHAL_VOLUME_DISC_TYPE_BDR,
    VOLUME_DISC_TYPE_BDRE             = LIBHAL_VOLUME_DISC_TYPE_BDRE,
    VOLUME_DISC_TYPE_HDDVDROM         = LIBHAL_VOLUME_DISC_TYPE_HDDVDROM,
    VOLUME_DISC_TYPE_HDDVDR           = LIBHAL_VOLUME_DISC_TYPE_HDDVDR,
    VOLUME_DISC_TYPE_HDDVDRW          = LIBHAL_VOLUME_DISC_TYPE_HDDVDRW,
  };

  /** Bitfield representation of disc properties,
    * see HAL::Volume::get_disc_properties
    */
  enum DiscProperties 
  {
    DISC_PROPERTIES_NONE              = 0, 
    DISC_HAS_AUDIO                    = 1 << 0,
    DISC_HAS_DATA                     = 1 << 1,
    DISC_IS_BLANK                     = 1 << 2,
    DISC_IS_REWRITABLE                = 1 << 3,
    DISC_IS_APPENDABLE                = 1 << 4,
  };
}

#endif //!_HAL_CC_STORAGE_TYPES_HH_
