//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#include <glibmm.h>

#include <iostream>
#include <sstream>

#include <ne_basic.h>
#include <ne_compress.h>
#include <ne_socket.h>
#include <ne_utils.h>
#include <ne_props.h>
#include <ne_session.h>
#include <ne_request.h>

#include <src/util.hh>
#include <src/uri++.hh>
#include <src/network.hh>

#include <src/vfs.hh>

namespace
{
  int
  read_block (void *data, const char *buf, size_t len)
  {
    std::vector<unsigned char> *vec = (std::vector<unsigned char>*)data;

    for (unsigned int n = 0; n < len; ++n)
      vec->push_back ((unsigned char)buf[n]);

    return 0;
  }
}

namespace Bmp
{
  namespace VFS
  {
      class PluginTransportHTTP
        : public Bmp::VFS::PluginTransportBase
      {

        public:

          virtual bool	
          can_process (const Glib::ustring& uri)
          {
              Bmp::URI u (uri); 
              return (u.get_protocol () == Bmp::URI::PROTOCOL_HTTP); 
          }

          virtual bool
          handle_read (Bmp::VFS::Handle& handle)	  
          {
            ne_session                       *sess;
            ne_request                       *req;
            char                             *path;
            std::vector<unsigned char>        vec;

            Bmp::URI uri (handle.get_uri());
            if (!uri.port) uri.port = 80;

            if (!Network::check_host (uri.hostname, uri.port))
              {
                return false;
              }

            if (!uri.query.empty())
              {
                path = g_strconcat (uri.path.c_str(), "?", uri.query.c_str(), NULL);
              }
            else
              {
                path = g_strdup (uri.path.c_str());
              }

            sess = ne_session_create (uri.scheme.c_str(), uri.hostname.c_str(), uri.port);
            ne_set_read_timeout (sess, 15);
            req = ne_request_create (sess, "GET", path);

            g_free (path);

            ne_add_response_body_reader (req, ne_accept_2xx, read_block, &vec);

            if (ne_request_dispatch (req) != NE_OK)
              {
                ne_request_destroy (req);
                ne_session_destroy (sess);
                return false;
              }

            ne_request_destroy (req);
            ne_session_destroy (sess);

            vec.push_back ((unsigned char)'\0');
            handle.set_buffer (reinterpret_cast<const unsigned char *>(&vec[0]), vec.size());
            return true;
          }

          virtual bool
          handle_write  (const Bmp::VFS::Handle& handle)
          {
            return false;
          }

      };

    }
}
  
extern "C" Bmp::VFS::PluginTransportBase* plugin_create ()
{
  return new Bmp::VFS::PluginTransportHTTP;
}

extern "C" void plugin_delete (Bmp::VFS::PluginTransportHTTP* p)
{
  delete p;
}
