//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#include <glibmm.h>
#include <glib/gi18n.h>

#include <ne_uri.h>

#include <boost/format.hpp>
#include <boost/algorithm/string.hpp>
#include <boost/algorithm/string/replace.hpp>

#include <iostream>
#include <sstream>
#include <fstream>
#include <vector>

#include "util.hh"
#include "xml.hh"
#include "main.hh"
#include "paths.hh"

#include "uri++.hh"
#include "neon++/request.hh"

#include "lyrics.hh"

namespace
{
    const char* param[] = {
      "act",
      "cln",
      "clv",
      "ar",
      "ti",
      "al",
      "co",
      "yr",
      "txt",
      "and",
      "id",
    };

    enum ParamID
    {
      LT_ACTION,
      LT_CLIENT,
      LT_CLVERSION,
      LT_ARTIST,
      LT_TITLE,
      LT_ALBUM,
      LT_COMPOSER,
      LT_YEAR,
      LT_TEXT,
      LT_AND,
      LT_ID,
    };

    const char * LT_BASE_HOST = "lyrictracker.com";
}

namespace Bmp
{
  namespace Lyrictracker
  {
    bool get_lyrics ( Glib::ustring const& artist,
                      Glib::ustring const& title, 
                      Glib::ustring      & lyrics  )
    {
      using namespace Glib;
      using namespace std;

      string data   = artist  .lowercase().c_str() 
                    + string  ("_") 
                    + title   .lowercase().c_str();

      string md5_hex = Util::md5_hex ((char* const)data.c_str(), strlen(data.c_str()));
      string text_path = build_filename (BMP_PATH_LYRIC_CACHE_DIR, md5_hex + ustring(".txt")); 

      if (file_test (text_path, FILE_TEST_EXISTS))
        { 
          try {
              lyrics = file_get_contents (text_path);
              return true;
            }
          catch (...) { return false; }
        }
 
      string _artist = artist .c_str();
      string _title  = title  .c_str(); 

      boost::replace_all (_artist,  "'", "\\'");
      boost::replace_all (_title,   "'", "\\'");

      char * _artist_e = ne_path_escape ( _artist.c_str() );
      char * _title_e  = ne_path_escape ( _title.c_str()  );

      ustring uri;
      uri   .append( "/soap.php?" )
            .append( param[LT_CLIENT] )
            .append( "=bmp&" )
            .append( param[LT_CLVERSION] )
            .append( "=0.34&" )
            .append( param[LT_TITLE] )
            .append( "=" )
            .append( _title_e )
            .append( "&" )
            .append( param[LT_ARTIST] )
            .append( "=" )
            .append( _artist_e )
            .append( "&" )
            .append( param[LT_ACTION] )
            .append( "=query&" )
            .append( param[LT_AND] )
            .append( "=1" );

      g_free (_artist_e);
      g_free (_title_e);

      Neon::Request r1 (LT_BASE_HOST, uri.c_str() );
      std::string response;

      try 
        {
          r1 >> response;
          if (!response.size()) return false;
        }
      catch (Bmp::URI::Exception& cxe)
        {
          return false;
        }

      xmlDocPtr         doc       = 0;
      xmlXPathObjectPtr xpathobj  = 0;
      xmlNodeSetPtr     nv        = 0;

      doc = xmlParseMemory (response.c_str(), response.size()); 
      if (!doc)
          return false;

      xpathobj = xml_execute_xpath_expression (doc, BAD_CAST "//result", NULL);
      nv = xpathobj->nodesetval;
      if ((!nv) || (!nv->nodeNr)) return false;
      xmlChar *id = xmlGetProp (nv->nodeTab[0], BAD_CAST "id");
      if (!id) return false;

      uri = Glib::ustring ();
      uri   .append( "/soap.php?" )
            .append( param[LT_CLIENT] ) 
            .append( "=bmp&" ) 
            .append( param[LT_CLVERSION] )
            .append( "=0.34&" )
            .append( param[LT_ID] )
            .append( "=" ) 
            .append( (const char*)id )
            .append( "&" )
            .append( param[LT_ACTION] )
            .append( "=detail" );

      g_free (id);

      Neon::Request r2 ( LT_BASE_HOST, uri.c_str() );
      response = std::string();
      try 
        {
          r2 >> response;
          if (!response.size()) return false;
        }
      catch (Bmp::URI::Exception& cxe)
        {
          return false;
        }
      catch (...)
        {
          return false;
        }

      lyrics = response; 

      try
        {
          std::ofstream o;      
          o.open (text_path.c_str ());
          o << std::string(lyrics); 
          o.close ();
        }
      catch (...) {}
      return true;
    }
  }
}
