//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2006 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non GPL-compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_PREFERENCES_HH
#define BMP_PREFERENCES_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <vector>
#include <map>
#include <set>

#include <glibmm.h>
#include <gtkmm.h>
#include <libglademm.h>

#include <mcs/mcs.h>

#include "audio.hh"

#ifdef HAVE_HAL
#  include "hal.hh"
#endif //HAVE_HAL

struct BmpTooltipEntry
{
    char *widget_name;
    char *tooltip_text;
    char *stock_id;
};

namespace Bmp
{
  /** Preferences dialog
   *
   * Bmp::Preferences is a complex dialog for adjusting run time parameters
   * of BMP trough the GUI instead of having to manipulate the configuration
   * file.
   */
  class Preferences : public Gtk::Window
  {

  public:

      Preferences (BaseObjectType                       * obj,
                   Glib::RefPtr<Gnome::Glade::Xml> const& xml);
      static Preferences* create ();
      ~Preferences () {}

#ifdef HAVE_HAL
      void rescan_devices ();
#endif //HAVE_HAL

  private:

      void on_category_changed ();

      class CategoryView;
      class ListColumnView;

#ifdef HAVE_HAL

      class HALView : public Gtk::TreeView
      {
          public:

            HALView (BaseObjectType                       * obj,
                     Glib::RefPtr<Gnome::Glade::Xml> const& xml);

            void rescan_devices ();

          private:

            typedef std::pair <std::string, std::string> VolumeKey;

            class CrVolumes : public Gtk::TreeModel::ColumnRecord
            {
              public:

                Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> >  devicon;
                Gtk::TreeModelColumn<Glib::ustring>               voltype;
                Gtk::TreeModelColumn<Glib::ustring>               volname;
                Gtk::TreeModelColumn<Library::HAL::Volume>        volume;
                Gtk::TreeModelColumn<bool>                        mounted;

                CrVolumes ()
                {
                  add (devicon);
                  add (voltype);
                  add (volname);
                  add (volume);
                  add (mounted);
                }
            };
          CrVolumes cvolume;

          Glib::RefPtr<Gtk::ListStore>    m_list_store;
          Glib::RefPtr<Gnome::Glade::Xml> m_ref_xml;

          enum Labels
          {
            L_VOLUME_UDI,
            L_DEVICE_UDI,
            L_MOUNT_PATH,
            L_DEVICE_SERIAL,
            L_VOLUME_NAME,
            L_DEVICE_FILE,
            L_DRIVE_BUS,
            L_DRIVE_TYPE,
            L_SIZE,
            L_DRIVE_SIZE,
            L_MOUNT_TIME,

            N_LABELS
          };

          Gtk::Label  * m_label[N_LABELS];
          Gtk::Image  * m_device_icon;

          void update_volume_details ();

          void cell_data_func_mounted       (Gtk::CellRenderer* cell, Gtk::TreeModel::iterator const& iter);
          void cell_data_func_mountpath     (Gtk::CellRenderer* cell, Gtk::TreeModel::iterator const& iter);
          void cell_data_func_device_udi    (Gtk::CellRenderer* cell, Gtk::TreeModel::iterator const& iter);
          void cell_data_func_volume_udi    (Gtk::CellRenderer* cell, Gtk::TreeModel::iterator const& iter);
          void cell_data_func_volume_name   (Gtk::CellRenderer* cell, Gtk::TreeModel::iterator const& iter);

          void hal_volume_add   (Library::HAL::Volume volume);
          void hal_volume_del   (Library::HAL::Volume volume);

          int  store_sort_func  (Gtk::TreeModel::iterator const& a,
                                 Gtk::TreeModel::iterator const& b);

          typedef std::map < VolumeKey, Gtk::TreeModel::RowReference > MVolumes;
          MVolumes m_volumes;
      };

#endif //HAVE_HAL

      Glib::RefPtr<Gnome::Glade::Xml>     m_ref_xml;

      Gtk::Notebook                     * m_category_notebook;
      CategoryView                      * m_category_view;

      // Audio 

#ifdef HAVE_ALSA

      struct AlsaDevice
      {
        /** Description of the device
        *
        */
        std::string   description;

        /** ALSA device string of this device
        *
        */
        std::string   dev;
            
        /** ALSA card id of this device 
        *
        */
        int	          card_id;

        /** ALSA device id of this device
        *
        */
        int	          device_id;
      };
      typedef std::vector<AlsaDevice> AlsaDevices;

      struct AlsaCard
      {
        /** Description of the card
         *
         */
        std::string   description;

        /** ALSA device string of this card 
         *
         */
        std::string   dev;

        /** ALSA card id of this card 
         *
         */
        int	          card_id;

        /** List of devices on this card 
         *
         */
        AlsaDevices   devices;  
    };
    typedef std::vector<AlsaCard> AlsaCards;

    // ALSA card columns record
    class AlsaCardColumnRecord : public Gtk::TreeModel::ColumnRecord
    {
        public:

          Gtk::TreeModelColumn<Glib::ustring> name;
          Gtk::TreeModelColumn<AlsaCard>      card;

          AlsaCardColumnRecord ()
          {
              add (name);
              add (card);
          }
    };

    // ALSA device columns record
    class AlsaDeviceColumnRecord : public Gtk::TreeModel::ColumnRecord
    {
      public:

        Gtk::TreeModelColumn<Glib::ustring> name;
        Gtk::TreeModelColumn<AlsaDevice>    device;

        AlsaDeviceColumnRecord ()
        {
            add (name);
            add (device);
        }
    };

    AlsaCardColumnRecord     alsa_card_columns;
    AlsaDeviceColumnRecord   alsa_device_columns;

    /** Returns a list of all ALSA cards present on the system, each containing a list of devices
     *
     * @returns A list of ALSA cards
     *
     */
    AlsaCards get_alsa_cards ();

    void on_cbox_alsa_card_changed ();

    Gtk::ComboBox                     * cbox_alsa_card;
    Gtk::ComboBox                     * cbox_alsa_device;
    Gtk::SpinButton                   * alsa_buffer_time;
    Glib::RefPtr<Gtk::ListStore>        list_store_alsa_cards;
    Glib::RefPtr<Gtk::ListStore>        list_store_alsa_device;

#endif //HAVE_ALSA

    // Audio System column record
    class AudioSystemColumnRecord : public Gtk::TreeModel::ColumnRecord
    {
      public:

        Gtk::TreeModelColumn<Glib::ustring>       description;
        Gtk::TreeModelColumn<std::string>         name;
        Gtk::TreeModelColumn<int>                 tab;
        Gtk::TreeModelColumn<Bmp::Audio::Sink>    sink;

        AudioSystemColumnRecord()
        {
            add (description);
            add (name);
            add (tab);
            add (sink);
        }
    };
    AudioSystemColumnRecord  audio_system_columns;

    void setup_audio ();

    void audio_system_apply_set_sensitive ();

    void on_cbox_audio_system_changed ();
    void on_audio_system_apply ();

    Gtk::Button                       * audio_system_apply;
    Gtk::ComboBox                     * cbox_audio_system;
    Gtk::HBox                         * audio_system_changed_warning;
    Gtk::Notebook                     * notebook_audio_system;
    Glib::RefPtr<Gtk::ListStore>        list_store_audio_systems;
    std::set<Glib::ustring>             m_sinks;

    // OSS
    Gtk::ComboBoxEntry                * cbe_oss_device;
    Gtk::SpinButton                   * oss_buffer_time;

    // ESD
    Gtk::Entry                        * esd_host;
    Gtk::SpinButton                   * esd_buffer_time;

#ifdef HAVE_SUN
    Gtk::ComboBoxEntry                * cbe_sun_device;
    Gtk::SpinButton                   * sun_buffer_time;
#endif //HAVE_SUN

    // Podcasts
    Gtk::FileChooserButton            * m_podcasts_fcb;

#ifdef HAVE_HAL
    // Hal Volumes
    HALView                           * m_volumes_view;
#endif //HAVE_HAL

  }; // class Preferences
} // namespace Bmp

#endif // BMP_PREFERENCES_HH
