//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef STREAMS_HH
#define STREAMS_HH

#include <gtkmm.h>
#include <libglademm.h>
#include <sigc++/sigc++.h>

namespace Bmp
{
  namespace Streams
  {
    struct StreamInfo
    {
      Glib::ustring   name;
      unsigned int    bitrate;
      Glib::ustring   genre;
      Glib::ustring   uri;
      StreamInfo () : name (""), bitrate (0), genre (""), uri ("") {}
    };
    typedef std::list<StreamInfo> StreamList;

    typedef sigc::signal <void, StreamList const&> SignalListUpdated;
    typedef sigc::signal <void> SignalStartStop;

    namespace Shoutcast
    {
      class Streams : public Gtk::TreeView
      {
        private:

          class Columns : public Gtk::TreeModel::ColumnRecord
          {
            public:

              Gtk::TreeModelColumn<Glib::ustring> name;
              Gtk::TreeModelColumn<unsigned int>  bitrate;
              Gtk::TreeModelColumn<Glib::ustring> genre;
              Gtk::TreeModelColumn<Glib::ustring> uri;

              Columns ()
              {
                add (name);
                add (bitrate);
                add (genre);
                add (uri);
              }
          };
          Columns columns; 

          bool visible (Gtk::TreeModel::iterator const& iter);
          void column_clicked (int column);

          Glib::RefPtr<Gtk::ListStore>        m_streams;
          Glib::RefPtr<Gtk::TreeModelFilter>  m_filtered;
          Glib::ustring                       m_filter;

        public:

          Streams (BaseObjectType                       *cobject,
                   const Glib::RefPtr<Gnome::Glade::Xml> &xml);
          ~Streams () {}

          void filter (Glib::ustring const& filter);
          void set_streams (StreamList const& list);
          void get_stream (Glib::ustring& title, Glib::ustring& uri);

      }; // !Streams

      class Genres  : public Gtk::TreeView
      {

        public:

          Genres (BaseObjectType                       *cobject,
                  const Glib::RefPtr<Gnome::Glade::Xml> &xml);
          ~Genres () { g_hash_table_destroy (cache); }

          void refresh (bool force = false);

          SignalListUpdated&
          s_list_updated () { return s_list_updated_; }

          SignalStartStop&
          s_start () { return s_start_; }
          SignalStartStop&
          s_stop  () { return s_stop_; }

        private:

          SignalListUpdated s_list_updated_;

          SignalStartStop s_start_;
          SignalStartStop s_stop_;
  
          class GenresC : public Gtk::TreeModel::ColumnRecord
          {
            public:
            Gtk::TreeModelColumn<Glib::ustring> name;
            GenresC() { add (name); }
          };
          GenresC genres; 

          void refresh_wrap ();
          void build_genre_list ();
          void genre_cell_data (Gtk::CellRenderer *cell, Gtk::TreeModel::iterator const& iter);

          GHashTable                         *cache;
          Glib::RefPtr<Gtk::ListStore>        m_genres;
          StreamList                          m_stream_list;

      }; // !Genres
    } // !Shoutcast::
  } // !Streams::
} // !Bmp::

#endif // !STREAM_LISTER_HH
