//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_XDS_HPP
#define BMP_XDS_HPP

#include <gtkmm.h>

namespace Bmp
{
  typedef sigc::signal <void, int>   DragStart;
  typedef sigc::signal <void>	     DragStep;
  typedef sigc::signal <void>	     DragEnd;

  class XDS
  {
    public:
      
      XDS ();
      virtual ~XDS ();

      virtual void
      xds_drag_end	  (const Glib::RefPtr<Gdk::DragContext>& context);
  
      virtual void
      xds_drag_begin	  (const Glib::RefPtr<Gdk::DragContext>& context, Glib::ustring const& basename);

      virtual void
      xds_drag_data_get	  (const Glib::RefPtr<Gdk::DragContext>& context, Gtk::SelectionData& selection_data, guint info, guint time);

      void
      xds_set		  ();

      void
      xds_unset		  ();

    protected:

      virtual void
      xds_drag_action	  (Glib::ustring const& path) = 0;

      virtual bool
      xds_acceptable	  (Glib::ustring const& path) = 0;

  };

} // namespace Bmp

#endif // BMP_XDS_HPP

