/*
 * Bognor-Regis - a media player/queue daemon.
 * Copyright © 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BOGNOR_QUEUE_H__
#define __BOGNOR_QUEUE_H__

#include <glib-object.h>
#include <gio/gio.h>

G_BEGIN_DECLS

#define BOGNOR_TYPE_QUEUE                                               \
   (bognor_queue_get_type())
#define BOGNOR_QUEUE(obj)                                               \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                BOGNOR_TYPE_QUEUE,                      \
                                BognorQueue))
#define BOGNOR_QUEUE_CLASS(klass)                                       \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             BOGNOR_TYPE_QUEUE,                         \
                             BognorQueueClass))
#define IS_BOGNOR_QUEUE(obj)                                            \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                BOGNOR_TYPE_QUEUE))
#define IS_BOGNOR_QUEUE_CLASS(klass)                                    \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             BOGNOR_TYPE_QUEUE))
#define BOGNOR_QUEUE_GET_CLASS(obj)                                     \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               BOGNOR_TYPE_QUEUE,                       \
                               BognorQueueClass))

typedef struct _BognorQueuePrivate BognorQueuePrivate;
typedef struct _BognorQueue      BognorQueue;
typedef struct _BognorQueueClass BognorQueueClass;

typedef struct _BognorQueueItem {
    char *uri;
    char *mimetype;
    GFile *file;
    GFileMonitor *monitor;
} BognorQueueItem;

struct _BognorQueue {
    GObject parent;

    BognorQueuePrivate *priv;
};

struct _BognorQueueClass {
    GObjectClass parent_class;

    gboolean (*set_uri) (BognorQueue      *queue,
                         BognorQueueItem *item);

    gboolean (*set_playing) (BognorQueue *queue,
                             gboolean     playing);
    gboolean (*set_position) (BognorQueue *queue,
                              double       position);
    gboolean (*get_position) (BognorQueue *queue,
                              double      *position);
    gboolean (*add_item_to_recent) (BognorQueue     *queue,
                                    BognorQueueItem *item);
};

GType bognor_queue_get_type (void) G_GNUC_CONST;

gboolean bognor_queue_play (BognorQueue *queue,
                            GError     **error);

void bognor_queue_set_name (BognorQueue *queue,
                            const char  *name);
void bognor_queue_emit_position_changed (BognorQueue *queue,
                                         double       position);

BognorQueueItem *bognor_queue_get_current_item (BognorQueue *queue);
BognorQueueItem *bognor_queue_get_next_item (BognorQueue *queue);
void bognor_queue_play_next (BognorQueue *queue);
gboolean bognor_queue_get_is_playing (BognorQueue *queue);
void bognor_queue_notify_unknown_format (BognorQueue *queue,
                                         const char  *uri);

G_END_DECLS

#endif /* __BOGNOR_QUEUE_H__ */
