/*
   bogosort - sorts or doesn't sort files or its standard input

   Copyright (C) 2000 Ulrik Haugen

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/
/* $Id: sortedp.c,v 1.1 2000/09/17 19:11:29 qha Exp $ */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <sys/types.h>
#include "system.h"

#include "sortedp.h"

/*
 * sortedp: return 1 if lines is sorted otherwise return 0
 * lines is a pointer to an array of strings, the last string is followed by a
 * NULL-pointer
 */
int
sortedp(char **lines)
{
    int i;

    for (i = 1; lines[i] != NULL; i++)
	if (strcmp(lines[i - 1], lines[i]) > 0)
	    return 0;
    return 1;
}

