/***************************************************************************
                 browserbk.h  -  BrowserBk Class Definition
                             -------------------
    begin                : Sun Sep 15 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *    This class serves as an abstract base class for all code specific to *
 *    a particular browser.  A derivative of this class exists for each    *
 *    supported browser.                                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BROWSERBK_H
#define BROWSERBK_H

#include "bknode.h"
#include "bkexcept.h"
#include "bridgecfg.h"

#include <QWidget>

class BrowserBk
{
public:
	BrowserBk(void) { };
	virtual ~BrowserBk(void)	{ }

	virtual bool    AreBookmarksReadonly(const QString &bookmarks);
	virtual bool    AreBookmarksValid(const QString &bookmarks) = 0;
	virtual bool    BrowseForBookmarks(
		const BridgeCfg &cfg, QString &bookmarks, QWidget *parent=0) = 0;
	static BrowserBk *classFactory(void);

	virtual bool	DetectBrowser(const BridgeCfg &cfg, QStringList &paths);

	virtual bool	IsBrowserRunning(void) { return false; }

	void			scrubBookmarks(void) throw(BkException)
								{ scrubFolder(root()); }

	virtual void	readBookmarks(const QString &path, BRWSNUM browserOrd)
						throw(BkException) = 0;
	void			findDifferences(BkFolder &mRoot) throw(BkException)
								{ findDifferencesX(mRoot, root()); }
	virtual BkFolder &		root(void) = 0;

protected:
	void			findDifferencesX(BkFolder &mFolder, const BkFolder &bFolder)
						throw(BkException);
	void			scrubFolder(BkFolder &folder) throw(BkException);
	void			scrubTitle(QString &title, bool isFolder);
};

/******************************************************************************
 *                                                                            *
 *    The following class and function are helpers for browser classes to     *
 *    easily sort the bookmarks and folders back to the original order when   *
 *    saving bookmarks.                                                       *
 *                                                                            *
 ******************************************************************************/

class SortedNodeList
{
public:
	SortedNodeList(FolderLst::iterator fit, int order) :
		m_fit(fit),
		m_order(order),
		m_type(NODETYPE_FOLDER) { };
	SortedNodeList(BookmarkLst::iterator bit, int order) :
		m_bit(bit),
		m_order(order),
		m_type(NODETYPE_BOOKMARK) { };
	SortedNodeList(SeparatorLst::iterator sit, int order) :
		m_sit(sit),
		m_order(order),
		m_type(NODETYPE_SEPARATOR) { };
	SortedNodeList(const SortedNodeList &node) :
		m_fit(node.m_fit),
		m_bit(node.m_bit),
		m_sit(node.m_sit),
		m_order(node.m_order),
		m_type(node.m_type) { };
	SortedNodeList & operator=(const SortedNodeList &node)
	{
		if(this != &node)
		{
			m_fit = node.m_fit;
			m_bit = node.m_bit;
			m_sit = node.m_sit;
			m_order = node.m_order;
			m_type = node.m_type;
		}
		
		return *this;
	}
	
	bool operator <(const SortedNodeList &node) const
	{
		if(m_order != node.m_order)
			return m_order < node.m_order;
		else
		{
			if(m_type == NODETYPE_FOLDER)
			{
				if(node.m_type == NODETYPE_FOLDER)
					return *m_fit < *node.m_fit;
				else if(node.m_type == NODETYPE_BOOKMARK)
					return *m_fit < *node.m_bit;
				else if(node.m_type == NODETYPE_SEPARATOR)
					return *m_fit < *node.m_sit;
				else
					BKEXCEPT("Internal Error: Unrecognized Bookmark Type");
			}
			else if(m_type == NODETYPE_BOOKMARK)
			{
				if(node.m_type == NODETYPE_FOLDER)
					return *m_bit < *node.m_fit;
				else if(node.m_type == NODETYPE_BOOKMARK)
					return *m_bit < *node.m_bit;
				else if(node.m_type == NODETYPE_SEPARATOR)
					return *m_bit < *node.m_sit;
				else
					BKEXCEPT("Internal Error: Unrecognized Bookmark Type");
			}
			else if(m_type == NODETYPE_SEPARATOR)
			{
				if(node.m_type == NODETYPE_FOLDER)
					return *m_sit < *node.m_fit;
				else if(node.m_type == NODETYPE_BOOKMARK)
					return *m_sit < *node.m_bit;
				else if(node.m_type == NODETYPE_SEPARATOR)
					return *m_sit < *node.m_sit;
				else
					BKEXCEPT("Internal Error: Unrecognized Bookmark Type");
			}
			else
				BKEXCEPT("Internal Error: Unrecognized Bookmark Type");
		}
	}
		
	FolderLst::iterator m_fit;
	BookmarkLst::iterator m_bit;
	SeparatorLst::iterator m_sit;
	int m_order;
	BKNODET	m_type;
};

void SortNodes(BkFolder &folder, std::vector<SortedNodeList> &list, BRWSNUM browser);

#endif // end of BROWSERBK_H
