#include <string.h>
#include <stdio.h>
#include <sys/mount.h>
#include "dbootstrap.h"
#include "net-fetch.h"
#include "lang.h"
#include <syslog.h> 
#include "util.h"

char *base_filenames[] = { "base12", "base14", NULL };

int extract_from_file (const char *fil, const char *descr)
{
  int status;

  sprintf(prtbuf,_("The %s is being extracted from %s..."),descr,fil);
  pleaseWaitBox(prtbuf);
  chdir("/target");
  sprintf(prtbuf,"zcat %s | tar -x",fil);
  status=execlog(prtbuf, LOG_INFO);
  chdir("/");
  boxPopWindow();
  if (status) {
    sprintf(prtbuf,_("There was a problem extracting the %s from %s"),descr,fil);
    problemBox(prtbuf,_("File error!"));
    return 1;
  }
  return 0;
}

static int extract_from_floppy (const char *device, const char *file,
  const char *descr, char **basenames, const char *series) {
  int status;
  struct stat statbuf;
  const char tmpdir[]="/target/tmp";

  if (NAME_ISREG(file,&statbuf)) {
    unlink(file);
  }
  if (! NAME_ISDIR( tmpdir, &statbuf ) ) {
/*    struct FileInfo finfo;
    finfo.source = tmpdir;
    finfo.orWithMode = 01777;
    finfo.makeParentDirectories = 1;*/
    if (! mkdir(tmpdir, 01777)) {
      chown(tmpdir, 0, 3); /* root_uid= 0 , sys_gid= 3 */
    }
  }
  status=getFloppies(_("The system is being installed from the %s floppy drive.\n\nPlease insert base disk %d."),
		     device,file,basenames,series);
  if (status == 0) {
    status=extract_from_file(file,descr);
  } else if (status != DLG_CANCEL) {
    sprintf(prtbuf,_("There was a problem reading the %s from %s"),descr,device); 
    problemBox(prtbuf,_("Floppy Error!"));
  }
  if (NAME_ISREG(file,&statbuf)) {
    unlink(file);
  }
  return (status);
}

int extract_base (void) {
  int status;
  struct stat statbuf;
  char *file;

  /* Sanity Check */
  if (NAME_ISREG ("/target/etc/debian_version", &statbuf)) {
    if (yesNoBox(_("It looks like either you have already installed the base system once or there is a Debian system installed already. This installer routine is not intended to overwrite an existing system. It's safer to start from scratch, i.e. umount the partition, create a new filesystem upon it and come back to this step.  Installing the base system over an existing system will cause existing data to be overwritten. Do you want to continue?"), _("Warning")) == DLG_NO)
      return DLG_CANCEL;
  } else {
    if (NAME_ISREG ("/target/sbin/init", &statbuf)) {
      if (yesNoBox(_("It looks like you are trying to install Debian GNU/Linux over an existing Linux system. This installer routine is not intended to overwrite an existing system. It's safer to start from scratch, i.e. umount the partition, create a new filesystem upon it and come back to this step.  Installing the base system over an existing system will result in existing data being overwritten. Do you want to continue?"), _("Warning")) == DLG_NO)
      return DLG_CANCEL;
    }
  }

  disqtype=base;
  if ( choose_medium() ) return 1;

  if (!strcmp (Archive_Dir, "netfetch"))
    {
      status = nf_install_base ();
    }
  else
  if (  strncmp(Archive_Dir,"/dev/fd",7)
#ifdef SCSI_FLOPPY
     && strncmp(Archive_Dir,"/dev/sfd",8)
#endif
     ) {
    sprintf(prtbuf,"%s/%s",Archive_Dir,BASETGZ);
    file=strdup(prtbuf);
    status=extract_from_file(file,_("Base System"));
    free(file);
    if (status == 0) { /* Don't extract add-ons if extraction of base system failed. */
      sprintf(prtbuf,"%s/%s",Archive_Dir,ADDONS);
      if (NAME_ISREG( prtbuf,&statbuf)) {
        file=strdup(prtbuf);
        status=extract_from_file(file,_("Add-ons Set"));
        free(file);
      }
    }
    execlog("umount /instmnt", LOG_INFO);
  } else {
    status=extract_from_floppy(Archive_Dir,"/target/" BASETGZ,_("Base System"), base_filenames, _("the base series"));
  }
  if (status) return 1;

  if (NAME_ISREG("/target/etc/inittab",&statbuf)) {
    rename("/target/etc/inittab","/target/etc/inittab.real");
  }
  sprintf(prtbuf,"cp %s %s","/etc/inittab.install","/target/etc/inittab"); 
  execlog(prtbuf, LOG_INFO);

  sync();
  return 0;
}
