#include "dbootstrap.h"
#include <stdio.h>
#include "lang.h"
#include "kbdconfig.h"
#include <syslog.h> 
#include "util.h"

int configure_keyboard_m (void) {
	return configure_keyboard(NULL);
}

int configure_keyboard (char *kbd)
{
  int rs=-1;
  char *prefix;
  char *msg=_("Please select a keyboard. If you don't find the exact right choice below, please choose something close.\nYou'll be able to configure more keyboard choices by running 'kbdconfig' once you have installed the base system.");
  char *title=_("Select a keyboard");

#if #cpu (m68k)
  struct d_choices keymaps_ami[]={
    { "amiga-de",        "Germany (Amiga)"           , KBD_de_DE},
    { "amiga-es",        "Spain (Amiga)"             , KBD_es_ES},
    { "amiga-fr",        "France (Amiga)"            , KBD_fr_FR},
    { "amiga-it",        "Italy (Amiga)"             , KBD_it_IT},
    { "amiga-us",        "U.S. English (Amiga)"      , KBD_C},
    { "amiga-se",        "Sweden (Amiga)"            , KBD_sv_SE},
    { "amiga-sg",        "Swiss German (Amiga)"      , KBD_de_CH}
  };
  int nchoices_ami=sizeof(keymaps_ami)/sizeof(struct d_choices);
  struct d_choices keymaps_ata[]={
    { "atari-us",        "U.S. English (Atari)"      , KBD_C},
    { "atari-de",        "Germany (Atari)"           , KBD_de_DE},
    { "atari-se",        "Sweden (Atari)"            , KBD_sv_SE},
    { "atari-uk",        "U.K. English (Atari)"      , KBD_en_UK},
  };
  int nchoices_ata=sizeof(keymaps_ata)/sizeof(struct d_choices);
  struct d_choices keymaps_mac[]={
    { "mac-us-std",      "U.S. English (Mac, 82 keys)"     , KBD_C},
    { "mac-us-ext",      "U.S. English (Mac, extended kbd)", 0},
    { "mac-de-latin1-nodeadkeys",    "Germany (Mac)"       , KBD_de_DE},
    { "mac-de2-ext",     "Germany (Mac, extended kbd)"     , 0},
    { "mac-fr2-ext",     "France (Mac, extended kbd)"      , KBD_fr_FR},
    { "mac-fr3",         "France (Mac, alternate)"         , 0},
  };
  int nchoices_mac=sizeof(keymaps_mac)/sizeof(struct d_choices);
#elif #cpu (powerpc)
  struct d_choices keymaps[]={
    { "qwerty/us",                  "U.S. English (QWERTY)"           , KBD_C},
    { "azerty/be-latin1",           "Belgium"                         , KBD_fr_BE},
    { "qwerty/br-abnt2",            "Brazilian (ABNT2 layout)"        , KBD_pt_BR2}, 
    { "qwerty/br-latin1",           "Brazilian (EUA layout)"          , KBD_pt_BR},
    { "qwerty/bg",                  "Bulgarian Cyrillic"              , 0},
    { "qwertz/croat",               "Croatian"                        , 0},
    { "qwerty/cz-lat2",             "Czech"                           , KBD_cs_CZ},
    { "qwerty/dk-latin1",           "Danish"                          , KBD_da_DK},
    { "dvorak/dvorak",              "Dvorak"                          , 0},
    { "qwerty/es",                  "Spain"                           , KBD_es_ES},
    { "qwerty/fi-latin1",           "Finland"                         , KBD_fi_FI},
    { "azerty/fr-latin0",           "France (with Euro)"              , KBD_fr_FR0},
    { "azerty/fr-latin1",           "France"                          , KBD_fr_FR},
    { "qwerty/cf",                  "French Canadian"                 , KBD_fr_CA},
    { "qwertz/de-latin1-nodeadkeys","Germany"                         , KBD_de_DE},
    { "qwerty/gr",                  "Greek"                           , KBD_el_GR},
    { "qwerty/hebrew",              "Hebrew"                          , 0},
    { "qwertz/hu",                  "Hungary"                         , KBD_hu_HU},
    { "qwerty/is-latin1",           "Iceland"                         , KBD_is_IS},
    { "qwerty/it",                  "Italy"                           , KBD_it_IT},
    { "qwerty/jp106",               "Japan"                           , KBD_ja_JP},
    { "qwerty/no-latin1",           "Norway"                          , KBD_no_NO},
    { "qwerty/pl",                  "Poland"                          , KBD_pl_PL},
    { "qwerty/pt-latin1",           "Portuguese"                      , KBD_pt_PT},
    { "qwerty/ru",                  "Russia"                          , KBD_ru_RU},
    { "qwerty/se-latin1",           "Sweden"                          , KBD_sv_SE},
    { "qwertz/slovene",             "Slovene"                         , 0},
    { "qwerty/sk-qwerty",           "Slovak"                          , 0},
    { "qwerty/trq",                 "Turkish Q"                       , KBD_tr_TR},
    { "qwerty/uk",                  "United Kingdom"                  , KBD_en_UK},
  };
  struct d_choices keymaps_mac[]={
    { "mac-us-ext",      "U.S. English (Mac, extended kbd)", 0},
    { "mac-us-std",      "U.S. English (Mac, 82 keys)"     , KBD_C},
    { "mac-fr2-ext",     "France (Mac, extended kbd)"      , KBD_fr_FR},
# if 0
	/* Not currently available? */
    { "mac-de-latin1-nodeadkeys",    "Germany (Mac)"       , KBD_de_DE},
    { "mac-de2-ext",     "Germany (Mac, extended kbd)"     , 0},
    { "mac-fr3",         "France (Mac, alternate)"         , 0},
# endif
  };
  int nchoices_mac=sizeof(keymaps_mac)/sizeof(struct d_choices);
  struct d_choices keymaps_ami[]={
    { "amiga-us",        "U.S. English (Amiga)"      , KBD_C},
    { "amiga-fr",        "France (Amiga)"            , KBD_fr_FR},
    { "amiga-de",        "Germany (Amiga)"           , KBD_de_DE},
    { "amiga-it",        "Italy (Amiga)"             , KBD_it_IT},
    { "amiga-es",        "Spain (Amiga)"             , KBD_es_ES},
    { "amiga-se",        "Sweden (Amiga)"            , KBD_sv_SE},
    { "amiga-sg",        "Swiss German (Amiga)"      , KBD_de_CH}
  };
  int nchoices_ami=sizeof(keymaps_ami)/sizeof(struct d_choices);
#elif #cpu (sparc)
  struct d_choices keymaps[]={
    { "sun/sunkeymap",		"U.S. (Type 4/5)"	, KBD_C},
    { "i386/qwerty/us",		"U.S. (PS/2)"		, 0 },
    { "sun/sundvorak",		"Dvorak (Type 4/5)"	, KBD_dvorak},
    { "sun/sunt5-fi-latin1",	"Finland (Type 5)"	, KBD_fi_FI},
    { "sun/sunt5-fr-latin1",	"France (Type 5)"	, KBD_fr_FR},
    { "sun/sunt5-de-latin1",	"Germany (Type 5)"	, KBD_de_DE},
    { "sun/sunt5-ru",		"Russia (Type 5)"	, KBD_ru_RU},
    { "sun/sunt4-es",		"Spain (Type 4)"	, KBD_es_ES},
    { "sun/sunt5-es",		"Spain (Type 5)"	, 0},
    { "sun/sun-pl",		"Poland (Type 4/5)"	, KBD_pl_PL},
    { "sun/sunt5-cz-us",	"Czech (Type 5)"	, KBD_cs_CZ},
    { "sun/sunt5-uk",		"United Kingdom"	, KBD_en_UK}
  };
#elif #cpu (arm)
  struct d_choices keymaps[]={
    { "qwerty/us",		"U.S. English (QWERTY)"	, KBD_C },
    { "azerty/be-latin1",	"Belgium"		, KBD_fr_BE },
    { "qwerty/br-abnt2",	"Brazilian (ABNT2 layout)", KBD_pt_BR2 },
    { "qwerty/br-latin1",	"Brazilian (EUA layout)", KBD_pt_BR }, 
    { "qwerty/bg",		"Bulgarian Cyrillic"	, 0 },
    { "qwertz/croat",		"Croatian"		, 0 },
    { "qwerty/cz-lat2",		"Czech"			, KBD_cs_CZ },
    { "qwerty/dk-latin1",	"Danish"		, KBD_da_DK },
    { "dvorak/dvorak",		"Dvorak"		, KBD_dvorak },
    { "qwerty/fi-latin1",	"Finland"		, KBD_fi_FI },
    { "azerty/fr-latin0",	"France (with Euro)"	, KBD_fr_FR0 },
    { "azerty/fr-latin1",	"France"		, KBD_fr_FR },
    { "qwerty/cf",		"French Canadian"	, KBD_fr_CA },
    { "qwertz/de-latin1-nodeadkeys", "Germany"		, KBD_de_DE },
    { "qwerty/gr",		"Greek"			, KBD_el_GR },
    { "qwerty/hebrew",		"Hebrew"		, 0 },
    { "qwertz/hu",		"Hungary"		, KBD_hu_HU },
    { "qwerty/is-latin1",	"Iceland"		, KBD_is_IS },
    { "qwerty/it",		"Italy"			, KBD_it_IT },
    { "qwerty/jp106",		"Japan"			, KBD_ja_JP },
    { "qwerty/no-latin1",	"Norway"		, KBD_no_NO },
    { "qwerty/pl",		"Poland"		, KBD_pl_PL },
    { "qwerty/pt-latin1",	"Portuguese"		, KBD_pt_PT },
    { "qwerty/ru",		"Russia"		, KBD_ru_RU },
    { "qwerty/se-latin1",	"Sweden"		, KBD_sv_SE },
    { "qwertz/slovene",		"Slovene"		, 0 },
    { "qwerty/sk-qwerty",	"Slovak"		, 0 },
    { "qwerty/es",		"Spain"			, KBD_es_ES },
    { "qwerty/trq",		"Turkish Q"		, KBD_tr_TR },
    { "qwerty/uk",		"United Kingdom"	, KBD_en_UK }
  };
  struct d_choices keymaps_acorn[] = {
    { "uk",			"United Kingdom"	, 0 }
  };
#else
  struct d_choices keymaps[]={
    { "qwerty/us",		"U.S. English (QWERTY)"	, KBD_C },
    { "azerty/be-latin1",	"Belgium"		, KBD_fr_BE },
    { "qwerty/br-abnt2",	"Brazilian (ABNT2 layout)", KBD_pt_BR2 },
    { "qwerty/br-latin1",	"Brazilian (EUA layout)", KBD_pt_BR }, 
    { "qwerty/bg",		"Bulgarian Cyrillic"	, 0 },
    { "qwertz/croat",		"Croatian"		, 0 },
    { "qwerty/cz-lat2",		"Czech"			, KBD_cs_CZ },
    { "qwerty/dk-latin1",	"Danish"		, KBD_da_DK },
    { "dvorak/dvorak",		"Dvorak"		, KBD_dvorak },
    { "qwerty/fi-latin1",	"Finland"		, KBD_fi_FI },
    { "azerty/fr-latin0",	"France (with Euro)"	, KBD_fr_FR0 },
    { "azerty/fr-latin1",	"France"		, KBD_fr_FR },
    { "qwerty/cf",		"French Canadian"	, KBD_fr_CA },
    { "qwertz/de-latin1-nodeadkeys", "Germany"		, KBD_de_DE },
    { "qwerty/gr",		"Greek"			, KBD_el_GR },
    { "qwerty/hebrew",		"Hebrew"		, 0 },
    { "qwertz/hu",		"Hungary"		, KBD_hu_HU },
    { "qwerty/is-latin1",	"Iceland"		, KBD_is_IS },
    { "qwerty/it",		"Italy"			, KBD_it_IT },
    { "qwerty/jp106",		"Japan"			, KBD_ja_JP },
    { "qwerty/no-latin1",	"Norway"		, KBD_no_NO },
    { "qwerty/pl",		"Poland"		, KBD_pl_PL },
    { "qwerty/pt-latin1",	"Portuguese"		, KBD_pt_PT },
    { "qwerty/ru",		"Russia"		, KBD_ru_RU },
    { "qwerty/se-latin1",	"Sweden"		, KBD_sv_SE },
    { "qwertz/slovene",		"Slovene"		, 0 },
    { "qwerty/sk-qwerty",	"Slovak"		, 0 },
    { "qwerty/es",		"Spain"			, KBD_es_ES },
    { "qwerty/trq",		"Turkish Q"		, KBD_tr_TR },
    { "qwerty/uk",		"United Kingdom"	, KBD_en_UK }
  };
#endif
  int nchoices;
  struct d_choices* choices;

#if #cpu (m68k)
    if (strcmp(Arch2, "Atari") == 0) {
	choices = keymaps_ata;
	nchoices = nchoices_ata;
	prefix="atari/";
    }
    else if (strcmp(Arch2, "Amiga") == 0) {
	choices = keymaps_ami;
	nchoices = nchoices_ami;
	prefix="amiga/";
    }
    else if (strcmp(Arch2, "Macintosh") == 0) {
	choices = keymaps_mac;
	nchoices = nchoices_mac;
	prefix="mac/";
    }
    else if (strcmp(Arch2, "VME") == 0) {
	problemBox(_("VME console does not support keymaps."),_("Information"));
	return 255;
    }
    else
	return 255;
#elif #cpu (sparc)
    prefix="";
    choices= keymaps;
    nchoices=sizeof(keymaps)/sizeof(struct d_choices);
#elif #cpu (powerpc)
    if (strcmp(Arch2, "apus") == 0) {
	choices = keymaps_ami;
	nchoices = nchoices_ami;
	prefix="amiga/";
    }
    else if (strcmp(Arch2, "PowerMac") == 0) {
    	choices = keymaps_mac;
    	nchoices = nchoices_mac;
    	prefix = "mac/";
    } else {
        choices= keymaps;
        nchoices=sizeof(keymaps)/sizeof(struct d_choices);
        prefix="i386/";
    }
#elif #cpu (arm)
    if (strcmp(Arch2, "riscpc") == 0) {
        choices = keymaps_acorn;
        nchoices = sizeof(keymaps_acorn)/sizeof(struct d_choices);
        prefix = "acorn/";
    } else {
        choices = keymaps;
        nchoices = sizeof(keymaps)/sizeof(struct d_choices);
        prefix = "i386/";
    }
#else
    prefix = "i386/";
    choices = keymaps;
    nchoices = sizeof(keymaps) / sizeof(struct d_choices);
#endif

    if (kbd) {
	int i;
	for (i=0;i<nchoices;i++) {
		if (0 == strcmp(choices[i].tag,kbd)) {
			rs=i;
			break;
		}
	}
	if (rs == -1)
		vaproblemBox(_("Problem"), 
                             _("Couldn't find a keyboard mapping file named '%s'.  If you used the 'kbd=<name>' boot parameter, the value passed as 'name' must be incorrect.\n\nPress <ENTER> to select a keyboard manually."),
                             kbd);
    }
    if (rs == -1)
	    rs=menuBox(msg, title, choices, nchoices, 1);

    if (rs != -1) {
	FILE *kbdconf;
	if (NULL == (kbdconf = fopen(KEYBD_SETTINGS_FILE, "w"))) {
	  vaproblemBox(_("Write error"),
		       _("Can't write to temporary user settings file %s"),
		       KEYBD_SETTINGS_FILE);
	  return 1;
	}
	fprintf(kbdconf, "KEYBD='%s%s'\n", prefix, choices[rs].tag);
        fclose(kbdconf);
	sprintf(prtbuf,
		"zcat /etc/keymaps.tgz | tar -xOf - %s%s.bmap | loadkmap",
		prefix, choices[rs].tag);
#ifdef _TESTING_
	problemBox(prtbuf,"Test Box");
#else
	if ( execlog(prtbuf, LOG_INFO) != 0 ) {
	  vaproblemBox(_("Keyboard load error"), 
		       _("Error loading the keymap %s%s.bmap from /etc/keymaps.tgz"),
		       prefix, choices[rs].tag);
	  return 1;
	}
#endif
    }
#ifdef _TESTING_
    else {
	problemBox("Configuration Cancelled","Test Box");
    }
#endif
  return rs;
}


#ifdef _TESTING_
/* To test, compile using: make kbdconfig_test */
int main(void)
{
    LOAD_TRMFILE("test.trm");
    get_kver();
#if #cpu (m68k)
    Arch2 = "Atari";
#endif
    boxInit();

/* Use the following to test automatic kbd selection */
//    configure_keyboard("qwerty/es");

    configure_keyboard_m();

    boxFinished();
}
#endif
