
#include <stdio.h>
#include <assert.h>
#include <sys/sysmacros.h>
#include "dbootstrap.h"
#include "lang.h"
#include <linux/termios.h>
#include <linux/serial.h>
#include <syslog.h> 
#include "util.h"

static int failedBaseInstall = 0;

int true (void) {
	return 0;
}

#ifdef _TESTING_

int next_action(void);
int alternate_action(void);
int alternate1_action(void);
int previous_action(void);
int previous1_action(void);
int partition_disk(void);
int init_swap(void);
int activate_swap(void);
int no_swap(void);
int init_linux(void);
int mount_any(void);
int unmount_any(void);
int extract_kernel_and_modules(void); 
int extract_base(void);
int configure_drivers(void);
int configure_base(void);
int configure_network(void);
int make_bootable(void);
int make_boot_floppy(void);
int reboot_system(void);
int chroot_start(void);
int view_partitions(void);
int interactive_shell(void);
int configure_pcmcia(void);
int do_eject(void);
int load_modules_after_boot(void);
int load_modules_after_boot_ac(void);
int edit_append_line();

#else //!_TESTING_

static char*
find_root (void)
{
	char                   *root_device;
	char                   *target_device;
	struct fdisk_partition *p;

	if ((root_device = block_device ( "/" )) == NULL) {
		return NULL;
	}
	if ((target_device = block_device ("/target" )) == NULL) {
		/* Perhaps it's a loop-mounted fs, or NFS */
		if ((p = fdisk_find_partition_by_mntpoint ("/target")) == NULL) {
			free (root_device);
			return NULL;
		}
		target_device = strdup (p->name);
	}
	if (strcmp (root_device,target_device)){
		return target_device;
	}
	root_device = strdup("");
	return root_device;
}

static int
require_root (void)
{
	if (!Root) {
		problemBox (_("The requested operation can't be performed until the root filesystem is mounted. \nBefore you begin installation, you must first partition your disk, and then initialize and mount your root filesystem, and initialize a swap partition. Please use the main menu to complete any of those steps that you have not done, and then use the main menu to return to this step."),
			    _("No root filesystem mounted"));
		return 1;
	}
	return 0;
}

#ifdef DO_EJECT
void
eject_floppy (const char *device)
{
	sprintf (prtbuf, "eject %s", device);
	execlog (prtbuf, LOG_INFO);
}
#endif

#endif //_TESTING_

int
main_menu (void)
{
#ifndef _TESTING_
	char *found_root = NULL;
#endif
	struct stat statbuf;
	int (*next_action) (void);
	int (*alternate_action) (void);
	int (*alternate1_action) (void);
	int (*previous_action) (void);
	int (*previous1_action) (void);
	char *bufT, *bufN, *bufA, *bufA1, *bufP, *bufP1;
#define OPT_Next		1001
#define OPT_Alternate		1002
#define OPT_Alternate1		1003
#define OPT_Previous		1004
#define OPT_Previous1		1005
#define OPT_CONFIGURE_KEY	1006
#define OPT_PARTITION_DISK	1007
#define OPT_INITIALIZE_SWAP	1008
#define OPT_ACTIVATE_SWAP	1009
#define OPT_DO_WITHOUT_SWAP	1010
#define OPT_INITIALIZE_LINUX	1011
#define OPT_MOUNT_LINUX		1012
#define OPT_UMOUNT_LINUX	1013
#define OPT_INSTALL_OS		1014
#define OPT_INSTALL_BASE	1015
#define OPT_CONFIGURE_MODULES	1016
#define OPT_CONFIGURE_BASE	1017
#define OPT_CONFIGURE_NET	1018
#define OPT_DISK_BOOT		1019
#define OPT_FLOPPY_BOOT		1020
#define OPT_REBOOT		1021
#define OPT_VIEW_PARTITIONS	1022
#define OPT_EXECUTE_SHELL	1023
#define OPT_CONFIGURE_PCMCIA	1024
#define OPT_EJECT_FLOPPY	1025
#define OPT_RESTART_DBOOTSTRAP	1026
#define OPT_START_NEW_SYSTEM	1027
#define OPT_CONFIGURE_HOSTNAME	1028
#define OPT_LOAD_MODULES_FROM_A_FD_AFTER_BOOT 1029
#define OPT_KERNEL_APPEND	1030
#define NITEMS	31
	int data, ilist[NITEMS], items, i, rs;
	struct d_choices choices[NITEMS];
	struct { char *string; int key; } entries[] = {
		{_("Configure the Keyboard"),				OPT_CONFIGURE_KEY},
/* since this process uses lilo, we only use it with i386 */
#if (#cpu(i386))
		{_("Preload modules from a floppy"),	OPT_LOAD_MODULES_FROM_A_FD_AFTER_BOOT},
#endif
		{_("Partition a Hard Disk"),				OPT_PARTITION_DISK},
		{_("Initialize and Activate a Swap Partition"),		OPT_INITIALIZE_SWAP},
		{_("Activate a Previously-Initialized Swap Partition"),	OPT_ACTIVATE_SWAP},
		{_("Do Without a Swap Partition"),			OPT_DO_WITHOUT_SWAP},
		{_("Initialize a Linux Partition"),			OPT_INITIALIZE_LINUX},
		{_("Mount a Previously-Initialized Partition"),		OPT_MOUNT_LINUX},
		{_("Unmount a Partition"),				OPT_UMOUNT_LINUX},
		{_("Install Operating System Kernel and Modules"),	OPT_INSTALL_OS},
		{_("Configure Device Driver Modules"),			OPT_CONFIGURE_MODULES},
#if !(#cpu(alpha) || #cpu(m68k))
		{_("Configure PCMCIA Support"),				OPT_CONFIGURE_PCMCIA},
#endif
		{_("Configure the Hostname"),				OPT_CONFIGURE_HOSTNAME},
		{_("Configure the Network"),				OPT_CONFIGURE_NET},
		{_("Install the Base System"),				OPT_INSTALL_BASE},
		{_("Configure the Base System"),			OPT_CONFIGURE_BASE},
#if (#cpu(alpha) || #cpu(m68k) || #cpu(i386) || #cpu(sparc))
		{_("Edit Kernel Boot Parameters"),			OPT_KERNEL_APPEND},
#endif
		{_("Make Linux Bootable Directly From Hard Disk"),	OPT_DISK_BOOT},
		{_("Make a Boot Floppy"),				OPT_FLOPPY_BOOT},
#if 0 /* not working yet */
		{_("Start New System"),					OPT_START_NEW_SYSTEM},
#endif
		{_("Reboot the System"),				OPT_REBOOT},
		{_("View the Partition Table"),				OPT_VIEW_PARTITIONS},
		{_("Execute a Shell"),					OPT_EXECUTE_SHELL},
#ifdef DO_EJECT
		{_("Eject Floppy Disks"),				OPT_EJECT_FLOPPY},
#endif
		{_("Restart Installation System"),			OPT_RESTART_DBOOTSTRAP},
		{NULL,0}
	};

#if (#cpu(powerpc))
	struct { char *string; int key; } entries_apus[] = {
		{_("Configure the Keyboard"),				OPT_CONFIGURE_KEY},
		{_("Partition a Hard Disk"),				OPT_PARTITION_DISK},
		{_("Initialize and Activate a Swap Partition"),		OPT_INITIALIZE_SWAP},
		{_("Activate a Previously-Initialized Swap Partition"),	OPT_ACTIVATE_SWAP},
		{_("Do Without a Swap Partition"),			OPT_DO_WITHOUT_SWAP},
		{_("Initialize a Linux Partition"),			OPT_INITIALIZE_LINUX},
		{_("Mount a Previously-Initialized Partition"),		OPT_MOUNT_LINUX},
		{_("Unmount a Partition"),				OPT_UMOUNT_LINUX},
		{_("Install Operating System Modules"),			OPT_INSTALL_OS},
		{_("Configure Device Driver Modules"),			OPT_CONFIGURE_MODULES},
		{_("Configure the Hostname"),				OPT_CONFIGURE_HOSTNAME},
		{_("Configure the Network"),				OPT_CONFIGURE_NET},
		{_("Install the Base System"),				OPT_INSTALL_BASE},
		{_("Configure the Base System"),			OPT_CONFIGURE_BASE},
		{_("Reboot the System"),				OPT_REBOOT},
		{_("View the Partition Table"),				OPT_VIEW_PARTITIONS},
		{_("Execute a Shell"),					OPT_EXECUTE_SHELL},
		{_("Restart Installation System"),			OPT_RESTART_DBOOTSTRAP},
		{NULL,0}
	};
#endif

	for (;;) {
		pleaseWaitBox (
			_("The installation program is determining the current state of your system and the next installation step that should be performed."));
		memset (choices, 0, NITEMS * sizeof (struct d_choices));

#ifndef _TESTING_
	if (Root) {
	    found_root = strdup (Root->name);
	}

	fdisk_reread();
	if (fdisk_disks == NULL) {
	    /* no swap on NFS for diskless workstation */
	    noSwap = 1;
	    /* no boot loader on local disk */
	    notInstalledLILO = 0;
	}

	if (found_root) {
	    Root = fdisk_find_partition_by_name (found_root);
	    free (found_root);
	    found_root = NULL;
	    Boot = fdisk_find_partition_by_mntpoint ("/target/boot");
	    if (Boot == NULL) Boot = Root;
	}

	if (! (found_root = find_root())){
	    if (Root) {
		sprintf (prtbuf, _("I had trouble checking the choice of root device. I'll assume that the root fs is still %s."), Root->name);
	    } else {
		sprintf (prtbuf, _("I had trouble checking the choice of root device. I don't know what to use as the root fs."));
	    }
	    problemBox (prtbuf, _("Problem"));
	}
	else if (! Root) {
	    Root = fdisk_find_partition_by_name (found_root);
	}
	else if (strcmp (Root->name, found_root)) {
	    sprintf (prtbuf, _("The root device has changed unexpectedly, from %s to %s."), Root->name, found_root);
	    problemBox (prtbuf, _("Root File System has Changed"));
	    Root = fdisk_find_partition_by_name (found_root);
	}
	if (found_root) {
            free (found_root);
	    found_root = NULL;
        }

#endif /* !_TESTING_ */

	boxPopWindow();

    done_keyboard:
	/* Start building menu entries. */

	next_action = alternate_action = alternate1_action = true;
	previous_action = previous1_action = true;
	bufA = bufA1 = bufP = bufP1 = "";

	if ((! NAME_ISREG (KEYBD_SETTINGS_FILE, &statbuf))
	    && NAME_ISEXE ("/sbin/loadkmap", &statbuf) 
	    && (serialConsole < 0)
#if #cpu (m68k)
	    && (strcmp(Arch2, "VME") != 0)
#endif
		) {

#ifdef USE_LANGUAGE_CHOOSER
		/* assert (lang != NULL); */
		if (lang->keymap != NULL && lang->keymap[0] != '\0')
		{
			/*
			 * MSS: I am not sure this is needed as we've already
			 * chosen the localized environment
			 */
			configure_keyboard (lang->keymap);
			goto done_keyboard;
		}
#endif

                /* check for boot-args (only if we're not already selected via the lang stuff) */
		if (bootargs.kbd) {
			configure_keyboard (bootargs.kbd);
			goto done_keyboard;
		}

		next_action = configure_keyboard_m;
		bufT = _("Your keyboard has not yet been configured. Please select \"Next\" from the menu to configure the keyboard.");
		bufN = _("Configure the Keyboard");
#if ( #cpu(i386) )
		bufA = _("Preload essential modules from a floppy");
		alternate_action = load_modules_after_boot;
#endif
		/*
		 * Alternate step:
		 *
		 *  Configure the network instead of partitioning hard
		 *  drives, in case there are no hard drives connected
		 *  to the host.  This is to support diskless NFS-root
		 *  installations.
		 *
		 */
		if (fdisk_disks) {
#if ( #cpu(i386) )
			if ( ! load_modules_after_boot_ac() ) {
				alternate_action = load_modules_after_boot;
				bufA = _("Preload essential modules from a floppy");
				alternate1_action = partition_disk;
				bufA1 = _("Partition a Hard Disk");
			} else {
#endif
				alternate_action = partition_disk;
				bufA = _("Partition a Hard Disk");
#if ( #cpu(i386) )
			}
#endif
		}
		else {
			alternate_action = configure_hostname;
			bufA = _("Configure the hostname");
		}
	}
	else if ((swapon_partitions == NULL)
		 && (fdisk_partitions_by_type[FSTYPE_SWAP] == NULL)
		 && (noSwap == 0)) {
		/*
		 * No "Linux swap" partitions have been created.
		 */
		next_action      = partition_disk;
		alternate_action = no_swap;
		bufT = _("There are no \"Linux swap\" partitions present on the system. A swap partition is used to provide virtual memory for Linux. Please select \"Next\" from the menu to partition your hard disk. Use the partitioning program to add \"Linux native\" and \"Linux swap\" partitions to your disks. If you don't want a swap partition, select \"Alternative\".");
		bufN = _("Partition a Hard Disk");
		bufA = _("Do Without a Swap Partition");
#if ( #cpu(i386) )
		if ( ! load_modules_after_boot_ac() ) {
			alternate1_action = load_modules_after_boot;
			bufA1 = _("Preload essential modules from a floppy");
		}
#endif
	}
	else if ((! Root) && (fdisk_disks == NULL) && is_network_up(0)) {
		 /*
		  * No disks found, but ethernet is up
		  *
		  * Rough guess: The user plans to use NFS-Root, so let him mount
		  * the partition.
		  */
		next_action = mount_any;
		bufN = _("Mount a Previously-Initialized Partition");
#if ( #cpu(i386) )
		alternate_action = load_modules_after_boot;
		bufA = _("Preload essential modules from a floppy");
		bufT = _("No hard disk drives could be found but the network is configured.  Please select \"Next\" to mount the root filesystem via NFS. Please select \"Alternate\" if you need to load essential modules from a floppy to make the hard disk drives visible.");
#else
		bufT = _("No hard disk drives could be found but the network is configured.  Please select \"Next\" to mount the root filesystem via NFS.");
#endif
	}
#if ( #cpu(i386) )
	else if ((! Root) && (fdisk_disks == NULL) && (! load_modules_after_boot_ac ())) {
		/*
		 * No disks found:
		 *
		 * Maybe essential modules need to be preloaded so the kernel
		 * knows about the drives.
		 */
		next_action = load_modules_after_boot;
		alternate_action = configure_network;
		bufN = _("Preload essential modules from a floppy");
		bufA = _("Configure the Network");
		bufT = _("No hard disk drives could be found. You either need to load special drivers from a floppy or plan to install the system on a diskless workstation, whose disks are mounted via NFS.  Please select \"Next\" to load essential modules from a floppy or \"Alternate\" to configure the network. ");
	}
#endif

	else if ((! Root) && (fdisk_disks == NULL) && (! is_network_up(0))) {
		 /*
		  * Diskless install:
		  *
		  * Need to configure the network before mounting "/target".
		  */
		next_action = configure_network;
		bufT = _("No hard disk drives could be found.  You're installing the system on a diskless workstation, therefore you need to configure the network before mounting your Linux root filesystem from a NFS server.  Please select \"Next\" to configure the network."); 
		bufN = _("Configure the Network");
#if ( #cpu(i386) )
		if ( ! load_modules_after_boot_ac() ) {
			alternate_action = load_modules_after_boot;
			bufA = _("Preload essential modules from a floppy");
		}
#endif
	}
	else if((! Root) && (fdisk_disks != NULL) && (fdisk_partitions_by_type[FSTYPE_EXT2] == NULL)) {
		/*
		 * No "Linux native" partitions have been created.
		 */
		next_action = partition_disk;
		bufT = _("There are no \"Linux native\" partitions present on the system. You must create at least one \"Linux native\" partition to hold the root filesystem, and you may create additional ones. Please select \"Next\" from the menu to partition your hard disk. Use the partitioning program to add \"Linux native\" partitions to your disks.");
		bufN = _("Partition a Hard Disk");
	}
	else if ((swapon_partitions == NULL) && (noSwap == 0)) {
		/*
		 * The swap partition(s) are not initialized and
		 * activated.
		 */
		next_action       = init_swap;
		alternate_action  = activate_swap;
		alternate1_action = no_swap;
		previous_action   = partition_disk;
		bufT = _("There are \"Linux native\" and \"Linux swap\" partitions present on your system. The next step would be to initialize and activate a swap partition to provide virtual memory to your system. If you have not finished partitioning your disks or wish to change the partitions, please select \"Previous\" from the menu to partition them. If you are satisfied with your partitions, please select \"Next\" from the menu to initialize and activate your swap partition, or \"Alternate\" to activate a previously-initialized swap partition. If you absolutely insist on doing without a swap partition, select \"Alternate1\".");
		bufN = _("Initialize and Activate a Swap Partition");
		bufA = _("Activate a Previously-Initialized Swap Partition");
		bufA1 = _("Do Without a Swap Partition");
		bufP = _("Partition a Hard Disk");
	}
	else if (! Root && fdisk_disks != NULL) {
		/*
		 * The root partition has not been mounted.
		 */
		next_action      = init_linux;
		alternate_action = mount_any;
		bufT = _("There are \"Linux native\" partitions present on your system but none are mounted. You must mount a root filesystem, and you may mount other filesystems, before installing the system. If you have just created the partitions, you must initialize them before you can mount them. Please select \"Next\" to initialize and mount a Linux partition, or \"Alternate\" to mount a previously-initialized partition.");
		bufN = _("Initialize a Linux Partition");
		bufA = _("Mount a Previously-Initialized Partition");
	}
	else if (! Root && fdisk_disks == NULL) {
		/*
		 * The root partition has not been mounted, and this
		 * is a diskless NFS-root install.
		 */
		next_action = mount_any;
		bufT = _("You must mount a root filesystem, and you may mount other filesystems, before installing the system. To do a diskless install you must mount your Linux root filesystem from a NFS server. Please select \"Next\" to mount a NFS partition.");
		bufN = _("Mount a Previously-Initialized Partition");
	}
	else if (((! NAME_ISREG ("/target/vmlinuz", &statbuf)) /* Assumes that NAME_ISREG uses stat() and thus follows the symlink. #### */
		  && (! NAME_ISREG ("/target/vmlinux", &statbuf)))
		 || (! NAME_ISREG ("/target/usr/share/modconf/descr.gz", &statbuf))) {
		/*
		 * The operating system kernel and the modules have
		 * not been installed.
		 */
		next_action               = extract_kernel_and_modules;
		bufT = _("You've mounted your root filesystem. You may initialize and mount additional filesystems, or you may go on to install the operating system kernel and the modules.");
		bufN = _("Install Operating System Kernel and Modules");
		if (fdisk_disks != NULL) {
			alternate_action  = init_linux;
			alternate1_action = mount_any;
			bufA = _("Initialize a Linux Partition");
			bufA1 = _("Mount a Previously-Initialized Partition");
		}
		else {
			alternate_action  = mount_any;
			bufA = _("Mount a Previously-Initialized Partition");
		}
	}
	else if (! NAME_ISREG ("/target/etc/modules", &statbuf)) {
		/*
		 * The modules have not been configured.
		 */
		next_action              = configure_drivers;
		bufN = _("Configure Device Driver Modules");
#if !(#cpu(alpha) || #cpu(m68k))
		if (! NAME_ISREG ("/target/etc/pcmcia.conf", &statbuf)) {
			bufT = _("You've installed the operating system kernel and the modules. Please select \"Next\" to configure the device driver modules, or \"Alternate\" if you have to configure any PCMCIA devices."); 
			alternate_action = configure_pcmcia;
			bufA = _("Configure PCMCIA Support");
#if (#cpu(i386) || #cpu(sparc))
		if (!strlen(append_opts)) {
			alternate1_action = edit_append_line;
			bufA1 = _("Edit Kernel Boot Parameters");
		}
#endif
		} else
#endif
		{
#if (#cpu(alpha) || #cpu(m68k))
		if (!strlen(append_opts)) {
			alternate_action = edit_append_line;
			bufA = _("Edit Kernel Boot Parameters");
		}
#endif
			bufT = _("You've installed the operating system kernel and the modules. Please select \"Next\" to configure the device driver modules.");
		}
	}
	else if (! NAME_ISREG(target_path(NC_HOSTNAME_FILE),&statbuf) && !is_network_up(1)) {
		/*
		 * The hostname has not been configured, and it looks like we
		 * may not have any network devices, so let's configure
		 * the hostname here. The network config can override this
		 * if the user chooses to do so.
		 */
		next_action	= configure_hostname;
		bufN = _("Configure the hostname");
		bufT = _("The hostname is the name of the system. You need it even if you aren't setting up this system on a network.");
#if (#cpu(alpha) || #cpu(m68k) || #cpu(i386) || #cpu(sparc))
		if (!strlen(append_opts)) {
			alternate_action = edit_append_line;
			bufA = _("Edit Kernel Boot Parameters");
		}
#endif
	}
	else if ((! is_network_configured() || ! is_network_up(0)) && is_network_up(1)) {
		/*
		 * The network has not been configured and made active.
		 */
		next_action      = configure_network;
		if (is_network_up(0))
		    bufT = _("Your network is active, but it has not been configured for the system to remember. If your system is configuring itself via hardware (i.e. your system can setup it's network before Linux boots through DHCP or BOOTP), you should still setup the configuration so that the network can be brought up and down after booting. If you configured the network yourself, then you also need to perform this step. Please select \"Next\" to configure the network");
		else if (is_network_configured())
		    bufT = _("Your network is configured, but not activated. This may be caused by a broken previous installation attempt, or because you are installing over another installation. It is ok to skip this step if you do not need to use the network for the rest of the installation, since your network will become active after reboot (assuming it is setup properly). Please select \"Next\" to reconfigure the network");
		else
		    bufT = _("You've configured the device drivers but not the network.  Please select \"Next\" to configure the network.");
		bufN = _("Configure the Network");
		if (! NAME_ISREG ("/target/etc/debian_version", &statbuf)
		    || ! NAME_ISREG ("/target/sbin/init", &statbuf)
		    || failedBaseInstall) {
			alternate_action = extract_base;
			bufA = _("Install the Base System");
#if (#cpu(alpha) || #cpu(m68k) || #cpu(i386) || #cpu(sparc))
			if (!strlen(append_opts)) {
				alternate1_action = edit_append_line;
				bufA1 = _("Edit Kernel Boot Parameters");
			}
#endif
		}
#if (#cpu(alpha) || #cpu(m68k) || #cpu(i386) || #cpu(sparc))
		else {
			if (!strlen(append_opts)) {
				alternate_action = edit_append_line;
				bufA = _("Edit Kernel Boot Parameters");
			}
		}
#endif
	}
	else if (! NAME_ISREG ("/target/etc/debian_version", &statbuf)
		 || ! NAME_ISREG ("/target/sbin/init", &statbuf)
		 || failedBaseInstall) {
		/*
		 * The base system has not been installed.
		 */
		next_action = extract_base;
		if (failedBaseInstall) {
			bufT = _("The previous attempt to install the base system failed. Please select \"Next\" to retry installation of the base system.");
		} else {
			bufT = _("You've configured the device driver modules. Please select \"Next\" to install the base system.");
		}
		bufN = _("Install the Base System");
#if (#cpu(alpha) || #cpu(m68k) || #cpu(i386) || #cpu(sparc))
		if (!strlen(append_opts)) {
			alternate_action = edit_append_line;
			bufA = _("Edit Kernel Boot Parameters");
		}
#endif
	}
	else if (NAME_ISREG ("/target/sbin/unconfigured.sh", &statbuf)) {
		/*
		 * The base system has not been configured.
		 */
		next_action = configure_base;
		bufT = _("You've installed the base system and the operating system kernel. Please select \"Next\" to configure the base system.");
		bufN = _("Configure the Base System");
	}
	else if (notCreatedBootFloppy && notInstalledLILO && ! is_nfs_partition ("/target")
#if #cpu(m68k)
		 && (strcmp(Arch2, "Mac") != 0)
#endif
		) {
		/*
		 * Reboot, chroot, or create a boot floppy.
		 */
		next_action               = make_bootable;
		alternate_action          = make_boot_floppy;
		if (initchroot_cap())
			alternate1_action = chroot_start;
		else
			alternate1_action = reboot_system;
		bufT = _("You will either boot Linux from a floppy disk, or you will have it boot from the hard disk when your system is turned on.  Please select \"Next\" to make Linux bootable the hard disk, select \"Alternate\" to make a boot floppy, or select \"Alternate1\" to reboot the system.");
		bufN = _("Make Linux Bootable Directly From Hard Disk");
		bufA = _("Make a Boot Floppy");
		if (initchroot_cap())
			bufA1 = _("Start New System");
		else
			bufA1 = _("Reboot the System");
	}
	else if (notCreatedBootFloppy
#if #cpu(m68k)
		 && (strcmp(Arch2, "Mac") != 0)
#endif
		) {
		/*
		 * The boot floppy has not been created.
		 */
		next_action              = make_boot_floppy;
		if (initchroot_cap())
			alternate_action = chroot_start;
		else
			alternate_action = reboot_system;
		bufT = _("You've built your system. You should build a boot floppy that will start the system just in case it doesn't start directly from the hard disk.  Please select \"Next\" to build the boot floppy.");
		bufN = _("Make a Boot Floppy");
		if (initchroot_cap())
			bufA = _("Start New System");
		else
			bufA = _("Reboot the System");
	}
	else if (initchroot_cap()) {
		/*
		 * Chroot or reboot.
		 */
		next_action      = chroot_start;
		alternate_action = reboot_system;
		bufT = _("You've built your system and boot floppy. The moment of truth approaches! Please select \"Next\" to enter your new system, and continue configurations steps");
		bufN = _("Start New System");
		bufA = _("Reboot the System");
	} else {
		/*
		 * Nothing left to do but reboot the system.
		 */
		next_action = reboot_system;
		bufT = _("You've built your system and boot floppy. The moment of truth approaches!  Please select \"Next\" to reboot the system.");
		bufN = _("Reboot the System");
	}

	items = 0;
	choices[items].tag    = _("Next");
	choices[items].string = bufN;
	ilist[items] = OPT_Next;
	items++;
	if (bufA[0]) {
	    choices[items].tag    = _("Alternate");
	    choices[items].string = bufA;
	    ilist[items] = OPT_Alternate;
	    items++;
	}
	if (bufA1[0]) {
	    choices[items].tag    = _("Alternate1");
	    choices[items].string = bufA1;
	    ilist[items] = OPT_Alternate1;
	    items++;
	}
	if (bufP[0]) {
	    choices[items].tag    = _("Previous");
	    choices[items].string = bufP;
	    ilist[items] = OPT_Previous;
	    items++;
	}
	if (bufP1[0]) {
	    choices[items].tag    = _("Previous1");
	    choices[items].string = bufP1;
	    ilist[items] = OPT_Previous1;
	    items++;
	}
	items++;
#if (#cpu(powerpc))
	if (strcmp(Arch2, "apus") == 0)
	    for (i = 0 ; entries_apus[i].string ; i++) {
		choices[items].string = entries_apus[i].string;
		ilist[items] = entries_apus[i].key;
		items++;
	    }
	else    
#endif
	for (i = 0 ; entries[i].string ; i++) {
	    choices[items].string = entries[i].string;
	    ilist[items] = entries[i].key;
	    items++;
	}

	rs = menuBox (bufT, _("Debian GNU/Linux Installation Main Menu"), choices, items, 0);
	data = ilist[rs];

#ifndef _TESTING_
	switch (data) {
	    case OPT_Next:             next_action(); break;
	    case OPT_Alternate:        alternate_action(); break;
	    case OPT_Alternate1:       alternate1_action(); break;
	    case OPT_Previous:         previous_action(); break;
	    case OPT_Previous1:        previous1_action(); break;

	    case OPT_CONFIGURE_KEY:    configure_keyboard_m(); break;
	    case OPT_LOAD_MODULES_FROM_A_FD_AFTER_BOOT: load_modules_after_boot(); break;
	    case OPT_PARTITION_DISK:   partition_disk(); break;
	    case OPT_INITIALIZE_SWAP:  init_swap(); break;
	    case OPT_ACTIVATE_SWAP:    activate_swap(); break;
	    case OPT_DO_WITHOUT_SWAP:  no_swap(); break;
	    case OPT_INITIALIZE_LINUX: init_linux(); break;
	    case OPT_MOUNT_LINUX:      mount_any(); break;
	    case OPT_UMOUNT_LINUX:     unmount_any(); break;
	    case OPT_CONFIGURE_HOSTNAME: configure_hostname(); break;
	    case OPT_KERNEL_APPEND:	edit_append_line(); break;
	    case OPT_INSTALL_OS:
	      if (Root) {
		extract_kernel_and_modules(); 
	      } else { require_root(); } break;
	    case OPT_INSTALL_BASE:
	      if (Root) {
		failedBaseInstall = extract_base();
	      } else { require_root(); } break;
	    case OPT_CONFIGURE_MODULES:
	      if (Root) {
		configure_drivers();
	      } else { require_root(); } break;
	    case OPT_CONFIGURE_BASE:
	      if (Root) {
		configure_base(); 
	      } else { require_root(); } break;
	    case OPT_CONFIGURE_NET:    configure_network(); break;
	    case OPT_DISK_BOOT:
	      if (Root) {
		make_bootable();
	      } else { require_root(); } break;
	    case OPT_FLOPPY_BOOT:
	      if (Root) {
		make_boot_floppy();
	      } else { require_root(); } break;
	    case OPT_START_NEW_SYSTEM: chroot_start(); break;
	    case OPT_REBOOT:           reboot_system(); break;
	    case OPT_VIEW_PARTITIONS:  view_partitions(); break;
	    case OPT_EXECUTE_SHELL:    interactive_shell(); break;
	    case OPT_CONFIGURE_PCMCIA:
	      if (Root) {
		configure_pcmcia();
	    } else { require_root(); } break;
#ifdef DO_EJECT
	    case OPT_EJECT_FLOPPY: do_eject(); break;
#endif
	    case OPT_RESTART_DBOOTSTRAP: {  boxFinished(); exit (-1); }
	    default: assert(0);
	}
#else  // _TESTING_
        sprintf (prtbuf, "You've chosen item: %d", data);
        problemBox (prtbuf, "Option chosen");
	if (data == OPT_REBOOT) return(0);
#endif // _TESTING_
    }
    return 0;
}

#ifdef _TESTING_

/*
 * To test, compile using: make main_menu_test
 */
int main ()
{
	LOAD_TRMFILE ("test.trm");
	get_kver();
	boxInit();
	main_menu();
	boxFinished();
}
#endif

/* vi: set sw=8 ts=8: */
/*
 * Local Variables:
 * c-file-style: "linux"
 * End:
 */
