#ifndef _COPYPART_CPP_
#define _COPYPART_CPP_

#include <iostream.h>

#include "copyPart.h"
#include "element.h"
#include "compound.h"

#include "part.h"
#include "track.h"
#include "song.h"
extern Song * sonG;

CopyPart::CopyPart(Position p, Part * pt, Track * src, Track * tgt)
  : _part(0), _src(src), _tgt(tgt), _old(pt->start()), _new(p) {
  _type = COPYPART;
  _description = "copy part";
  _to_be_undone = true;
  if (pt) _part = (Part*) pt->copy();
  if (_part) {
    _tgt->add(_part);
    _part->setTrack(_tgt);
    _part->setStart(_new);
  }
}

CopyPart::CopyPart(const CopyPart& el) : Operation(el) {
  _type = COPYPART;
  _part = el._part;
  _old = el._old;
  _new = el._new;
}

CopyPart::~CopyPart() {
}

void CopyPart::undo() {
  if (_part) {
    _tgt->remove(_part);
    _part->hide();
  }
}

void CopyPart::redo() {
  if (_part) {
    _tgt->add(_part);
    _part->show();
  }
  _part->reorder();
}



// ---------------
// virtuals:
//

ostream & CopyPart::print(int dep, ostream & s) const {
  s << spc(dep) << "<COPYPART part=\"" << _part << "\" old=\"" << _old << "\" new=\"" << _new << "\" />" << endl;
  return s;
}

void CopyPart::flush(const char * c) const {
  cout << c << "COPYPART" << endl;
}

Element * CopyPart::copy() const {
  return new CopyPart(*this);
}




#endif
