/*
 * BRLTTY - A background process providing access to the console screen (when in
 *          text mode) for a blind person using a refreshable braille display.
 *
 * Copyright (C) 1995-2012 by The BRLTTY Developers.
 *
 * BRLTTY comes with ABSOLUTELY NO WARRANTY.
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any
 * later version. Please see the file LICENSE-GPL for details.
 *
 * Web Page: http://mielke.cc/brltty/
 *
 * This software is maintained by Dave Mielke <dave@mielke.cc>.
 */

#include "prologue.h"

#include "ktb_keyboard.h"

BEGIN_KEY_NAME_TABLE(keyboard)
  KEY_NAME_ENTRY(KBD_KEY_LETTER_A, "A"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_A, "LETTER_A"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_B, "B"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_B, "LETTER_B"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_C, "C"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_C, "LETTER_C"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_D, "D"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_D, "LETTER_D"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_E, "E"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_E, "LETTER_E"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_F, "F"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_F, "LETTER_F"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_G, "G"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_G, "LETTER_G"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_H, "H"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_H, "LETTER_H"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_I, "I"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_I, "LETTER_I"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_J, "J"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_J, "LETTER_J"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_K, "K"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_K, "LETTER_K"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_L, "L"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_L, "LETTER_L"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_M, "M"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_M, "LETTER_M"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_N, "N"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_N, "LETTER_N"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_O, "O"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_O, "LETTER_O"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_P, "P"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_P, "LETTER_P"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_Q, "Q"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_Q, "LETTER_Q"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_R, "R"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_R, "LETTER_R"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_S, "S"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_S, "LETTER_S"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_T, "T"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_T, "LETTER_T"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_U, "U"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_U, "LETTER_U"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_V, "V"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_V, "LETTER_V"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_W, "W"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_W, "LETTER_W"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_X, "X"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_X, "LETTER_X"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_Y, "Y"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_Y, "LETTER_Y"),

  KEY_NAME_ENTRY(KBD_KEY_LETTER_Z, "Z"),
  KEY_NAME_ENTRY(KBD_KEY_LETTER_Z, "LETTER_Z"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_One_Exclamation, "One"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_One_Exclamation, "SYMBOL_One_Exclamation"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Two_At, "Two"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Two_At, "SYMBOL_Two_At"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Three_Number, "Three"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Three_Number, "SYMBOL_Three_Number"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Four_Dollar, "Four"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Four_Dollar, "SYMBOL_Four_Dollar"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Five_Percent, "Five"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Five_Percent, "SYMBOL_Five_Percent"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Six_Circumflex, "Six"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Six_Circumflex, "SYMBOL_Six_Circumflex"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Seven_Ampersand, "Seven"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Seven_Ampersand, "SYMBOL_Seven_Ampersand"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Eight_Asterisk, "Eight"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Eight_Asterisk, "SYMBOL_Eight_Asterisk"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Nine_LeftParenthesis, "Nine"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Nine_LeftParenthesis, "SYMBOL_Nine_LeftParenthesis"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Zero_RightParenthesis, "Zero"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Zero_RightParenthesis, "SYMBOL_Zero_RightParenthesis"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Grave_Tilde, "Grave"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Grave_Tilde, "SYMBOL_Grave_Tilde"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Backslash_Bar, "Backslash"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Backslash_Bar, "SYMBOL_Backslash_Bar"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Minus_Underscore, "Minus"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Minus_Underscore, "SYMBOL_Minus_Underscore"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Equals_Plus, "Equals"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Equals_Plus, "SYMBOL_Equals_Plus"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_LeftBracket_LeftBrace, "LeftBracket"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_LeftBracket_LeftBrace, "SYMBOL_LeftBracket_LeftBrace"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_RightBracket_RightBrace, "RightBracket"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_RightBracket_RightBrace, "SYMBOL_RightBracket_RightBrace"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Semicolon_Colon, "Semicolon"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Semicolon_Colon, "SYMBOL_Semicolon_Colon"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Apostrophe_Quote, "Apostrophe"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Apostrophe_Quote, "SYMBOL_Apostrophe_Quote"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Comma_Less, "Comma"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Comma_Less, "SYMBOL_Comma_Less"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Period_Greater, "Period"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Period_Greater, "SYMBOL_Period_Greater"),

  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Slash_Question, "Slash"),
  KEY_NAME_ENTRY(KBD_KEY_SYMBOL_Slash_Question, "SYMBOL_Slash_Question"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Escape, "Escape"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Escape, "FUNCTION_Escape"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Enter, "Enter"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Enter, "FUNCTION_Enter"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Space, "Space"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Space, "FUNCTION_Space"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Tab, "Tab"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Tab, "FUNCTION_Tab"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_DeleteBackward, "DeleteBackward"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_DeleteBackward, "FUNCTION_DeleteBackward"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F1, "F1"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F1, "FUNCTION_F1"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F2, "F2"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F2, "FUNCTION_F2"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F3, "F3"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F3, "FUNCTION_F3"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F4, "F4"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F4, "FUNCTION_F4"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F5, "F5"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F5, "FUNCTION_F5"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F6, "F6"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F6, "FUNCTION_F6"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F7, "F7"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F7, "FUNCTION_F7"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F8, "F8"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F8, "FUNCTION_F8"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F9, "F9"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F9, "FUNCTION_F9"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F10, "F10"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F10, "FUNCTION_F10"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F11, "F11"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F11, "FUNCTION_F11"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F12, "F12"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F12, "FUNCTION_F12"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F13, "F13"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F13, "FUNCTION_F13"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F14, "F14"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F14, "FUNCTION_F14"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F15, "F15"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F15, "FUNCTION_F15"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F16, "F16"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F16, "FUNCTION_F16"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F17, "F17"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F17, "FUNCTION_F17"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F18, "F18"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F18, "FUNCTION_F18"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F19, "F19"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F19, "FUNCTION_F19"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F20, "F20"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F20, "FUNCTION_F20"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F21, "F21"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F21, "FUNCTION_F21"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F22, "F22"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F22, "FUNCTION_F22"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F23, "F23"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F23, "FUNCTION_F23"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F24, "F24"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_F24, "FUNCTION_F24"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Insert, "Insert"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Insert, "FUNCTION_Insert"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_DeleteForward, "DeleteForward"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_DeleteForward, "FUNCTION_DeleteForward"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Home, "Home"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Home, "FUNCTION_Home"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_End, "End"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_End, "FUNCTION_End"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_PageUp, "PageUp"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_PageUp, "FUNCTION_PageUp"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_PageDown, "PageDown"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_PageDown, "FUNCTION_PageDown"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ArrowUp, "ArrowUp"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ArrowUp, "FUNCTION_ArrowUp"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ArrowDown, "ArrowDown"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ArrowDown, "FUNCTION_ArrowDown"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ArrowLeft, "ArrowLeft"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ArrowLeft, "FUNCTION_ArrowLeft"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ArrowRight, "ArrowRight"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ArrowRight, "FUNCTION_ArrowRight"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_PrintScreen, "PrintScreen"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_PrintScreen, "FUNCTION_PrintScreen"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_SystemRequest, "SystemRequest"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_SystemRequest, "FUNCTION_SystemRequest"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Pause, "Pause"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Pause, "FUNCTION_Pause"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ShiftLeft, "ShiftLeft"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ShiftLeft, "FUNCTION_ShiftLeft"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ShiftRight, "ShiftRight"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ShiftRight, "FUNCTION_ShiftRight"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ControlLeft, "ControlLeft"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ControlLeft, "FUNCTION_ControlLeft"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ControlRight, "ControlRight"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ControlRight, "FUNCTION_ControlRight"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_AltLeft, "AltLeft"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_AltLeft, "FUNCTION_AltLeft"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_AltRight, "AltRight"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_AltRight, "FUNCTION_AltRight"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_GuiLeft, "GuiLeft"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_GuiLeft, "FUNCTION_GuiLeft"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_GuiRight, "GuiRight"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_GuiRight, "FUNCTION_GuiRight"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Application, "Application"),
  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Application, "FUNCTION_Application"),

  KEY_NAME_ENTRY(KBD_KEY_LOCK_Capitals, "CapsLock"),
  KEY_NAME_ENTRY(KBD_KEY_LOCK_Capitals, "LOCK_Capitals"),

  KEY_NAME_ENTRY(KBD_KEY_LOCK_Scroll, "ScrollLock"),
  KEY_NAME_ENTRY(KBD_KEY_LOCK_Scroll, "LOCK_Scroll"),

  KEY_NAME_ENTRY(KBD_KEY_LOCKING_Capitals, "LOCKING_Capitals"),

  KEY_NAME_ENTRY(KBD_KEY_LOCKING_Scroll, "LOCKING_Scroll"),

  KEY_NAME_ENTRY(KBD_KEY_LOCKING_Numbers, "LOCKING_Numbers"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_NumLock_Clear, "KEYPAD_NumLock_Clear"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Slash, "KPSlash"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Slash, "KEYPAD_Slash"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Asterisk, "KPAsterisk"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Asterisk, "KEYPAD_Asterisk"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Minus, "KPMinus"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Minus, "KEYPAD_Minus"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Plus, "KPPlus"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Plus, "KEYPAD_Plus"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Enter, "KPEnter"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Enter, "KEYPAD_Enter"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_One_End, "KP1"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_One_End, "KPEnd"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_One_End, "KEYPAD_One_End"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Two_ArrowDown, "KP2"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Two_ArrowDown, "KPArrowDown"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Two_ArrowDown, "KEYPAD_Two_ArrowDown"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Three_PageDown, "KP3"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Three_PageDown, "KPPageDown"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Three_PageDown, "KEYPAD_Three_PageDown"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Four_ArrowLeft, "KP4"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Four_ArrowLeft, "KPArrowLeft"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Four_ArrowLeft, "KEYPAD_Four_ArrowLeft"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Five, "KP5"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Five, "KEYPAD_Five"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Six_ArrowRight, "KP6"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Six_ArrowRight, "KPArrowRight"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Six_ArrowRight, "KEYPAD_Six_ArrowRight"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Seven_Home, "KP7"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Seven_Home, "KPHome"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Seven_Home, "KEYPAD_Seven_Home"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Eight_ArrowUp, "KP8"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Eight_ArrowUp, "KPArrowUp"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Eight_ArrowUp, "KEYPAD_Eight_ArrowUp"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Nine_PageUp, "KP9"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Nine_PageUp, "KPPageUp"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Nine_PageUp, "KEYPAD_Nine_PageUp"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Zero_Insert, "KP0"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Zero_Insert, "KPInsert"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Zero_Insert, "KEYPAD_Zero_Insert"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Period_Delete, "KPPeriod"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Period_Delete, "KPDelete"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Period_Delete, "KEYPAD_Period_Delete"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Equals, "KPEquals"),
  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Equals, "KEYPAD_Equals"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_LeftParenthesis, "KEYPAD_LeftParenthesis"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_RightParenthesis, "KEYPAD_RightParenthesis"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_LeftBrace, "KEYPAD_LeftBrace"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_RightBrace, "KEYPAD_RightBrace"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Modulo, "KEYPAD_Modulo"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_BitwiseAnd, "KEYPAD_BitwiseAnd"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_BitwiseOr, "KEYPAD_BitwiseOr"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_BitwiseXor, "KEYPAD_BitwiseXor"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Less, "KEYPAD_Less"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Greater, "KEYPAD_Greater"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_BooleanAnd, "KEYPAD_BooleanAnd"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_BooleanOr, "KEYPAD_BooleanOr"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_BooleanXor, "KEYPAD_BooleanXor"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_BooleanNot, "KEYPAD_BooleanNot"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Backspace, "KEYPAD_Backspace"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Space, "KEYPAD_Space"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Tab, "KEYPAD_Tab"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Comma, "KEYPAD_Comma"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Colon, "KEYPAD_Colon"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Number, "KEYPAD_Number"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_At, "KEYPAD_At"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_A, "KEYPAD_A"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_B, "KEYPAD_B"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_C, "KEYPAD_C"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_D, "KEYPAD_D"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_E, "KEYPAD_E"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_F, "KEYPAD_F"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_00, "KEYPAD_00"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_000, "KEYPAD_000"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_ThousandsSeparator, "KEYPAD_ThousandsSeparator"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_DecimalSeparator, "KEYPAD_DecimalSeparator"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_CurrencyUnit, "KEYPAD_CurrencyUnit"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_CurrencySubunit, "KEYPAD_CurrencySubunit"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Power, "FUNCTION_Power"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Sleep, "FUNCTION_Sleep"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Wakeup, "FUNCTION_Wakeup"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Stop, "FUNCTION_Stop"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Help, "FUNCTION_Help"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Find, "FUNCTION_Find"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Menu, "FUNCTION_Menu"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Select, "FUNCTION_Select"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Again, "FUNCTION_Again"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Execute, "FUNCTION_Execute"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Copy, "FUNCTION_Copy"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Cut, "FUNCTION_Cut"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Paste, "FUNCTION_Paste"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Undo, "FUNCTION_Undo"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Mute, "FUNCTION_Mute"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_VolumeUp, "FUNCTION_VolumeUp"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_VolumeDown, "FUNCTION_VolumeDown"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Clear, "KEYPAD_Clear"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_ClearEntry, "KEYPAD_ClearEntry"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_PlusMinus, "KEYPAD_PlusMinus"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_MemoryClear, "KEYPAD_MemoryClear"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_MemoryStore, "KEYPAD_MemoryStore"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_MemoryRecall, "KEYPAD_MemoryRecall"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_MemoryAdd, "KEYPAD_MemoryAdd"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_MemorySubtract, "KEYPAD_MemorySubtract"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_MemoryMultiply, "KEYPAD_MemoryMultiply"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_MemoryDivide, "KEYPAD_MemoryDivide"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Binary, "KEYPAD_Binary"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Octal, "KEYPAD_Octal"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Decimal, "KEYPAD_Decimal"),

  KEY_NAME_ENTRY(KBD_KEY_KEYPAD_Hexadecimal, "KEYPAD_Hexadecimal"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Cancel, "FUNCTION_Cancel"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Clear, "FUNCTION_Clear"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Prior, "FUNCTION_Prior"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Return, "FUNCTION_Return"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Separator, "FUNCTION_Separator"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Out, "FUNCTION_Out"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Oper, "FUNCTION_Oper"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_Clear_Again, "FUNCTION_Clear_Again"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_CrSel_Props, "FUNCTION_CrSel_Props"),

  KEY_NAME_ENTRY(KBD_KEY_FUNCTION_ExSel, "FUNCTION_ExSel"),
END_KEY_NAME_TABLE

KEY_NAME_TABLES_DECLARATION(keyboard) = {
  KEY_NAME_TABLE(keyboard),
  LAST_KEY_NAME_TABLE
};
