/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_ATTR_H
#define INCLUDED_ATTR_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_VIEWTABLE_H
#include "ViewTable.h"
#endif // INCLUDED_VIEWTABLE_H

#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

#ifndef INCLUDED_QSTRING_H
#include <qstring.h>
#define INCLUDED_QSTRING_H
#endif // INCLUDED_QSTRING_H

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif // INCLUDED_VECTOR

/*-------- forward declarations:
-------------------------------------------------------------------*/
class QCheckBox;
class QPushButton;
class QLabel;

/*------- class declaration:
-------------------------------------------------------------------*/
class Attr : public QDialog
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	Attr( QWidget* const, const QString&, const ViewTable::SelectedItems& );
private:
	Attr( const Attr& );
	Attr& operator=( const Attr& );
	
// ******* members *******
private:
	static const QString CAPTION;
	static const QString USER_ATTR_TITEL;
	static const QString GROUP_ATTR_TITEL;
	static const QString OTHERS_ATTR_TITEL;
	static const QString READ;
	static const QString WRITE;
	static const QString EXEC;
	static const QString RECURSIVE_LABEL;
	static const QString INFO_FILE;
	static const QString INFO_DIR;
	static const QString FILE_NAME_LABEL;

	const QString&              d_dir;
	const ViewTable::SelectedItems& d_items;
	
	QCheckBox*   d_user_read_checkbox;
	QCheckBox*   d_user_write_checkbox;
	QCheckBox*   d_user_exec_checkbox;
	QCheckBox*   d_group_read_checkbox;
	QCheckBox*   d_group_write_checkbox;
	QCheckBox*   d_group_exec_checkbox;
	QCheckBox*   d_others_read_checkbox;
	QCheckBox*   d_others_write_checkbox;
	QCheckBox*   d_others_exec_checkbox;
	QCheckBox*   d_recursiv_checkbox;
	QPushButton* d_accept_button;
	QPushButton* d_close_button;
	QLabel     * d_fname_label;
		
// ******* methods *******
private:
	QWidget* make_user_attr    ();
	QWidget* make_group_attr   ();
	QWidget* make_others_attr  ();
	void     set_check_boxes   ();
	void     show              ();
	void     display_file_name ( const QString& in_fname );
	bool     are_dirs          ();
	QString  get_selected_attr ();
private slots:
	void     accept            ();
};

#endif // INCLUDED_ATTR_H
