/* themes.c generated by valac 0.32.1, the Vala compiler
 * generated from themes.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define TYPE_THEME_TYPE (theme_type_get_type ())

#define TYPE_THEME_INFO (theme_info_get_type ())
#define THEME_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_INFO, ThemeInfo))
#define THEME_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_INFO, ThemeInfoClass))
#define IS_THEME_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_INFO))
#define IS_THEME_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_INFO))
#define THEME_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_INFO, ThemeInfoClass))

typedef struct _ThemeInfo ThemeInfo;
typedef struct _ThemeInfoClass ThemeInfoClass;
typedef struct _ThemeInfoPrivate ThemeInfoPrivate;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define TYPE_THEME_SCANNER (theme_scanner_get_type ())
#define THEME_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_SCANNER, ThemeScanner))
#define THEME_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_SCANNER, ThemeScannerClass))
#define IS_THEME_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_SCANNER))
#define IS_THEME_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_SCANNER))
#define THEME_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_SCANNER, ThemeScannerClass))

typedef struct _ThemeScanner ThemeScanner;
typedef struct _ThemeScannerClass ThemeScannerClass;
typedef struct _ThemeScannerPrivate ThemeScannerPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ThemeScannerScanThemesData ThemeScannerScanThemesData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ThemeScannerScanThemesDirData ThemeScannerScanThemesDirData;
typedef struct _ThemeScannerScanOneData ThemeScannerScanOneData;
typedef struct _ThemeScannerMaybeAddGtkThemeData ThemeScannerMaybeAddGtkThemeData;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _ThemeScannerMaybeAddIconThemeData ThemeScannerMaybeAddIconThemeData;
typedef struct _ThemeScannerMaybeAddCursorsData ThemeScannerMaybeAddCursorsData;
typedef struct _ThemeScannerMaybeAddIconsData ThemeScannerMaybeAddIconsData;

typedef enum  {
	THEME_TYPE_ICON_THEME,
	THEME_TYPE_GTK_THEME,
	THEME_TYPE_CURSOR_THEME
} ThemeType;

struct _ThemeInfo {
	GObject parent_instance;
	ThemeInfoPrivate * priv;
};

struct _ThemeInfoClass {
	GObjectClass parent_class;
};

struct _ThemeInfoPrivate {
	ThemeType theme_type;
	GList* paths;
};

struct _ThemeScanner {
	GObject parent_instance;
	ThemeScannerPrivate * priv;
};

struct _ThemeScannerClass {
	GObjectClass parent_class;
};

struct _ThemeScannerPrivate {
	gchar** xdg_paths;
	gint xdg_paths_length1;
	gint _xdg_paths_size_;
	gchar** normal_suffixes;
	gint normal_suffixes_length1;
	gint _normal_suffixes_size_;
	gchar** legacy_suffixes;
	gint legacy_suffixes_length1;
	gint _legacy_suffixes_size_;
	gchar** gtk_theme_paths;
	gint gtk_theme_paths_length1;
	gint _gtk_theme_paths_size_;
	GHashTable* gtk_themes;
	GHashTable* cursor_themes;
	GHashTable* icon_themes;
};

struct _ThemeScannerScanThemesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ThemeScanner* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** xdg_path_collection;
	gint xdg_path_collection_length1;
	gint _xdg_path_collection_size_;
	gint xdg_path_it;
	gchar* _tmp1_;
	gchar* xdg_path;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* home_dir;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
};

struct _ThemeScannerScanThemesDirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ThemeScanner* self;
	gchar* base_dir;
	gchar** suffixes;
	gint suffixes_length1;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** suffix_collection;
	gint suffix_collection_length1;
	gint _suffix_collection_size_;
	gint suffix_it;
	gchar* _tmp3_;
	gchar* suffix;
	gchar* full_path;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	GFile* f;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GFileEnumerator* en;
	GFile* _tmp11_;
	GFileEnumerator* _tmp12_;
	GList* files;
	GFileEnumerator* _tmp13_;
	GList* _tmp14_;
	GList* _tmp15_;
	GList* _tmp16_;
	GList* file_collection;
	GList* file_it;
	GFileInfo* _tmp17_;
	GFileInfo* file;
	gchar* display_path;
	GFileInfo* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* sep;
	gchar* _tmp21_;
	gchar* path;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GError* e;
	GError* _tmp29_;
	const gchar* _tmp30_;
	GError * _inner_error_;
};

struct _ThemeScannerScanOneData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ThemeScanner* self;
	gchar* path_type;
	gchar* full_path;
	gchar* display_name;
	gboolean gtk_theme;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** suffix_collection;
	gint suffix_collection_length1;
	gint _suffix_collection_size_;
	gint suffix_it;
	gchar* _tmp3_;
	gchar* suffix;
	gchar* path;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean added;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
};

struct _ThemeScannerMaybeAddGtkThemeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ThemeScanner* self;
	gchar* path;
	gchar* theme_name;
	gboolean result;
	ThemeInfo* info;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	ThemeInfo* _tmp3_;
	ThemeInfo* ninfo;
	ThemeInfo* _tmp4_;
	GHashTable* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	ThemeInfo* _tmp8_;
	ThemeInfo* _tmp9_;
	GHashTable* _tmp10_;
	const gchar* _tmp11_;
	gconstpointer _tmp12_;
	ThemeInfo* _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp15_;
};

struct _ThemeScannerMaybeAddIconThemeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ThemeScanner* self;
	gchar* path;
	gchar* theme_name;
	gchar* test_path;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean icon_theme;
	GKeyFile* f;
	GKeyFile* _tmp4_;
	GKeyFile* _tmp5_;
	const gchar* _tmp6_;
	GError* e;
	gboolean _tmp7_;
	GKeyFile* _tmp8_;
	gboolean _tmp9_;
	GError* _vala1_e;
	gboolean _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* cursor_path;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gboolean _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GError * _inner_error_;
};

struct _ThemeScannerMaybeAddCursorsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ThemeScanner* self;
	gchar* path;
	gchar* theme_name;
	gboolean result;
	ThemeInfo* info;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	ThemeInfo* _tmp3_;
	ThemeInfo* ninfo;
	ThemeInfo* _tmp4_;
	GHashTable* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	ThemeInfo* _tmp8_;
	ThemeInfo* _tmp9_;
	GHashTable* _tmp10_;
	const gchar* _tmp11_;
	gconstpointer _tmp12_;
	ThemeInfo* _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp15_;
};

struct _ThemeScannerMaybeAddIconsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ThemeScanner* self;
	gchar* path;
	gchar* theme_name;
	gboolean result;
	ThemeInfo* info;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	ThemeInfo* _tmp3_;
	ThemeInfo* ninfo;
	ThemeInfo* _tmp4_;
	GHashTable* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	ThemeInfo* _tmp8_;
	ThemeInfo* _tmp9_;
	GHashTable* _tmp10_;
	const gchar* _tmp11_;
	gconstpointer _tmp12_;
	ThemeInfo* _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp15_;
};


static gpointer theme_info_parent_class = NULL;
static gpointer theme_scanner_parent_class = NULL;

GType theme_type_get_type (void) G_GNUC_CONST;
GType theme_info_get_type (void) G_GNUC_CONST;
#define THEME_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_THEME_INFO, ThemeInfoPrivate))
enum  {
	THEME_INFO_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
ThemeInfo* theme_info_new (ThemeType type);
ThemeInfo* theme_info_construct (GType object_type, ThemeType type);
gboolean theme_info_add_path (ThemeInfo* self, const gchar* path);
gboolean theme_info_contains_path (ThemeInfo* self, const gchar* path);
gboolean theme_info_remove_path (ThemeInfo* self, const gchar* path);
static void theme_info_finalize (GObject* obj);
GType theme_scanner_get_type (void) G_GNUC_CONST;
#define THEME_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_THEME_SCANNER, ThemeScannerPrivate))
enum  {
	THEME_SCANNER_DUMMY_PROPERTY
};
ThemeScanner* theme_scanner_new (void);
ThemeScanner* theme_scanner_construct (GType object_type);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _g_object_unref0_ (gpointer var);
static void theme_scanner_scan_themes_data_free (gpointer _data);
void theme_scanner_scan_themes (ThemeScanner* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void theme_scanner_scan_themes_finish (ThemeScanner* self, GAsyncResult* _res_);
static gboolean theme_scanner_scan_themes_co (ThemeScannerScanThemesData* _data_);
static void theme_scanner_scan_themes_dir (ThemeScanner* self, const gchar* base_dir, gchar** suffixes, int suffixes_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void theme_scanner_scan_themes_dir_finish (ThemeScanner* self, GAsyncResult* _res_);
static void theme_scanner_scan_themes_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void theme_scanner_scan_themes_dir_data_free (gpointer _data);
static gboolean theme_scanner_scan_themes_dir_co (ThemeScannerScanThemesDirData* _data_);
static void theme_scanner_scan_themes_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_list_free__g_object_unref0_ (GList* self);
static void theme_scanner_scan_one (ThemeScanner* self, const gchar* path_type, const gchar* full_path, const gchar* display_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void theme_scanner_scan_one_finish (ThemeScanner* self, GAsyncResult* _res_);
static void theme_scanner_scan_one_data_free (gpointer _data);
static gboolean theme_scanner_scan_one_co (ThemeScannerScanOneData* _data_);
static void theme_scanner_maybe_add_gtk_theme (ThemeScanner* self, const gchar* path, const gchar* theme_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean theme_scanner_maybe_add_gtk_theme_finish (ThemeScanner* self, GAsyncResult* _res_);
static void theme_scanner_scan_one_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void theme_scanner_maybe_add_icon_theme (ThemeScanner* self, const gchar* path, const gchar* theme_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void theme_scanner_maybe_add_icon_theme_finish (ThemeScanner* self, GAsyncResult* _res_);
static void theme_scanner_maybe_add_gtk_theme_data_free (gpointer _data);
static gboolean theme_scanner_maybe_add_gtk_theme_co (ThemeScannerMaybeAddGtkThemeData* _data_);
gchar** theme_scanner_get_gtk_themes (ThemeScanner* self, int* result_length1);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
gchar** theme_scanner_get_cursor_themes (ThemeScanner* self, int* result_length1);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
gchar** theme_scanner_get_icon_themes (ThemeScanner* self, int* result_length1);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void theme_scanner_maybe_add_icon_theme_data_free (gpointer _data);
static gboolean theme_scanner_maybe_add_icon_theme_co (ThemeScannerMaybeAddIconThemeData* _data_);
static void theme_scanner_maybe_add_icons (ThemeScanner* self, const gchar* path, const gchar* theme_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean theme_scanner_maybe_add_icons_finish (ThemeScanner* self, GAsyncResult* _res_);
static void theme_scanner_maybe_add_icon_theme_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void theme_scanner_maybe_add_cursors (ThemeScanner* self, const gchar* path, const gchar* theme_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean theme_scanner_maybe_add_cursors_finish (ThemeScanner* self, GAsyncResult* _res_);
static void theme_scanner_maybe_add_cursors_data_free (gpointer _data);
static gboolean theme_scanner_maybe_add_cursors_co (ThemeScannerMaybeAddCursorsData* _data_);
static void theme_scanner_maybe_add_icons_data_free (gpointer _data);
static gboolean theme_scanner_maybe_add_icons_co (ThemeScannerMaybeAddIconsData* _data_);
static void theme_scanner_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType theme_type_get_type (void) {
	static volatile gsize theme_type_type_id__volatile = 0;
	if (g_once_init_enter (&theme_type_type_id__volatile)) {
		static const GEnumValue values[] = {{THEME_TYPE_ICON_THEME, "THEME_TYPE_ICON_THEME", "icon-theme"}, {THEME_TYPE_GTK_THEME, "THEME_TYPE_GTK_THEME", "gtk-theme"}, {THEME_TYPE_CURSOR_THEME, "THEME_TYPE_CURSOR_THEME", "cursor-theme"}, {0, NULL, NULL}};
		GType theme_type_type_id;
		theme_type_type_id = g_enum_register_static ("ThemeType", values);
		g_once_init_leave (&theme_type_type_id__volatile, theme_type_type_id);
	}
	return theme_type_type_id__volatile;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


ThemeInfo* theme_info_construct (GType object_type, ThemeType type) {
	ThemeInfo * self = NULL;
	ThemeType _tmp0_ = 0;
	self = (ThemeInfo*) g_object_new (object_type, NULL);
	_tmp0_ = type;
	self->priv->theme_type = _tmp0_;
	__g_list_free__g_free0_0 (self->priv->paths);
	self->priv->paths = NULL;
	return self;
}


ThemeInfo* theme_info_new (ThemeType type) {
	return theme_info_construct (TYPE_THEME_INFO, type);
}


/**
     * Try to add a path
     */
gboolean theme_info_add_path (ThemeInfo* self, const gchar* path) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = path;
	_tmp1_ = theme_info_contains_path (self, _tmp0_);
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = path;
	_tmp3_ = g_strdup (_tmp2_);
	self->priv->paths = g_list_append (self->priv->paths, _tmp3_);
	result = TRUE;
	return result;
}


gboolean theme_info_contains_path (ThemeInfo* self, const gchar* path) {
	gboolean result = FALSE;
	GList* g = NULL;
	GList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GCompareFunc _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = self->priv->paths;
	_tmp1_ = path;
	_tmp2_ = g_strcmp0;
	_tmp3_ = g_list_find_custom (_tmp0_, _tmp1_, _tmp2_);
	g = _tmp3_;
	result = g != NULL;
	return result;
}


/**
     * Try to remove a path, and return true when we've been emptied
     */
gboolean theme_info_remove_path (ThemeInfo* self, const gchar* path) {
	gboolean result = FALSE;
	GList* g = NULL;
	GList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GCompareFunc _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = self->priv->paths;
	_tmp1_ = path;
	_tmp2_ = g_strcmp0;
	_tmp3_ = g_list_find_custom (_tmp0_, _tmp1_, _tmp2_);
	g = _tmp3_;
	_tmp4_ = g;
	if (_tmp4_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp5_ = g;
	self->priv->paths = g_list_remove_link (self->priv->paths, _tmp5_);
	_tmp6_ = g;
	_tmp7_ = g_list_length (_tmp6_);
	result = _tmp7_ == ((guint) 0);
	return result;
}


static void theme_info_class_init (ThemeInfoClass * klass) {
	theme_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ThemeInfoPrivate));
	G_OBJECT_CLASS (klass)->finalize = theme_info_finalize;
}


static void theme_info_instance_init (ThemeInfo * self) {
	self->priv = THEME_INFO_GET_PRIVATE (self);
}


static void theme_info_finalize (GObject* obj) {
	ThemeInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEME_INFO, ThemeInfo);
	__g_list_free__g_free0_0 (self->priv->paths);
	G_OBJECT_CLASS (theme_info_parent_class)->finalize (obj);
}


GType theme_info_get_type (void) {
	static volatile gsize theme_info_type_id__volatile = 0;
	if (g_once_init_enter (&theme_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ThemeInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) theme_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThemeInfo), 0, (GInstanceInitFunc) theme_info_instance_init, NULL };
		GType theme_info_type_id;
		theme_info_type_id = g_type_register_static (G_TYPE_OBJECT, "ThemeInfo", &g_define_type_info, 0);
		g_once_init_leave (&theme_info_type_id__volatile, theme_info_type_id);
	}
	return theme_info_type_id__volatile;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


ThemeScanner* theme_scanner_construct (GType object_type) {
	ThemeScanner * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	GHashFunc _tmp14_ = NULL;
	GEqualFunc _tmp15_ = NULL;
	GHashTable* _tmp16_ = NULL;
	GHashFunc _tmp17_ = NULL;
	GEqualFunc _tmp18_ = NULL;
	GHashTable* _tmp19_ = NULL;
	GHashFunc _tmp20_ = NULL;
	GEqualFunc _tmp21_ = NULL;
	GHashTable* _tmp22_ = NULL;
	self = (ThemeScanner*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	self->priv->xdg_paths = (_vala_array_free (self->priv->xdg_paths, self->priv->xdg_paths_length1, (GDestroyNotify) g_free), NULL);
	self->priv->xdg_paths = _tmp2_;
	self->priv->xdg_paths_length1 = 1;
	self->priv->_xdg_paths_size_ = self->priv->xdg_paths_length1;
	_tmp4_ = _tmp3_ = g_get_system_data_dirs ();
	{
		gchar** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp4_;
		item_collection_length1 = _vala_array_length (_tmp3_);
		for (item_it = 0; item_it < _vala_array_length (_tmp3_); item_it = item_it + 1) {
			gchar* _tmp5_ = NULL;
			gchar* item = NULL;
			_tmp5_ = g_strdup (item_collection[item_it]);
			item = _tmp5_;
			{
				const gchar* _tmp6_ = NULL;
				gchar** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gchar** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				_tmp6_ = item;
				_tmp7_ = self->priv->xdg_paths;
				_tmp7__length1 = self->priv->xdg_paths_length1;
				if (_vala_string_array_contains (_tmp7_, _tmp7__length1, _tmp6_)) {
					_g_free0 (item);
					continue;
				}
				_tmp8_ = self->priv->xdg_paths;
				_tmp8__length1 = self->priv->xdg_paths_length1;
				_tmp9_ = item;
				_tmp10_ = g_strdup (_tmp9_);
				_vala_array_add2 (&self->priv->xdg_paths, &self->priv->xdg_paths_length1, &self->priv->_xdg_paths_size_, _tmp10_);
				_g_free0 (item);
			}
		}
	}
	_tmp11_ = g_strdup_printf ("gtk-%d.0", GTK_MAJOR_VERSION);
	_tmp12_ = g_strdup_printf ("gtk-%d-%d", GTK_MAJOR_VERSION, GTK_MINOR_VERSION);
	_tmp13_ = g_new0 (gchar*, 2 + 1);
	_tmp13_[0] = _tmp11_;
	_tmp13_[1] = _tmp12_;
	self->priv->gtk_theme_paths = (_vala_array_free (self->priv->gtk_theme_paths, self->priv->gtk_theme_paths_length1, (GDestroyNotify) g_free), NULL);
	self->priv->gtk_theme_paths = _tmp13_;
	self->priv->gtk_theme_paths_length1 = 2;
	self->priv->_gtk_theme_paths_size_ = self->priv->gtk_theme_paths_length1;
	_tmp14_ = g_str_hash;
	_tmp15_ = g_str_equal;
	_tmp16_ = g_hash_table_new_full (_tmp14_, _tmp15_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->gtk_themes);
	self->priv->gtk_themes = _tmp16_;
	_tmp17_ = g_str_hash;
	_tmp18_ = g_str_equal;
	_tmp19_ = g_hash_table_new_full (_tmp17_, _tmp18_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->cursor_themes);
	self->priv->cursor_themes = _tmp19_;
	_tmp20_ = g_str_hash;
	_tmp21_ = g_str_equal;
	_tmp22_ = g_hash_table_new_full (_tmp20_, _tmp21_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->icon_themes);
	self->priv->icon_themes = _tmp22_;
	return self;
}


ThemeScanner* theme_scanner_new (void) {
	return theme_scanner_construct (TYPE_THEME_SCANNER);
}


static void theme_scanner_scan_themes_data_free (gpointer _data) {
	ThemeScannerScanThemesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ThemeScannerScanThemesData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void theme_scanner_scan_themes (ThemeScanner* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ThemeScannerScanThemesData* _data_;
	ThemeScanner* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ThemeScannerScanThemesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, theme_scanner_scan_themes);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, theme_scanner_scan_themes_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	theme_scanner_scan_themes_co (_data_);
}


void theme_scanner_scan_themes_finish (ThemeScanner* self, GAsyncResult* _res_) {
	ThemeScannerScanThemesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Scan all theme types
     */
static void theme_scanner_scan_themes_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ThemeScannerScanThemesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	theme_scanner_scan_themes_co (_data_);
}


static gboolean theme_scanner_scan_themes_co (ThemeScannerScanThemesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0__length1 = 0;
	_data_->_tmp0_ = _data_->self->priv->xdg_paths;
	_data_->_tmp0__length1 = _data_->self->priv->xdg_paths_length1;
	{
		_data_->xdg_path_collection_length1 = 0;
		_data_->_xdg_path_collection_size_ = 0;
		_data_->xdg_path_collection = _data_->_tmp0_;
		_data_->xdg_path_collection_length1 = _data_->_tmp0__length1;
		for (_data_->xdg_path_it = 0; _data_->xdg_path_it < _data_->_tmp0__length1; _data_->xdg_path_it = _data_->xdg_path_it + 1) {
			_data_->_tmp1_ = NULL;
			_data_->_tmp1_ = g_strdup (_data_->xdg_path_collection[_data_->xdg_path_it]);
			_data_->xdg_path = _data_->_tmp1_;
			{
				_data_->_tmp2_ = NULL;
				_data_->_tmp2_ = _data_->xdg_path;
				_data_->_tmp3_ = NULL;
				_data_->_tmp3__length1 = 0;
				_data_->_tmp3_ = _data_->self->priv->normal_suffixes;
				_data_->_tmp3__length1 = _data_->self->priv->normal_suffixes_length1;
				_data_->_state_ = 1;
				theme_scanner_scan_themes_dir (_data_->self, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp3__length1, theme_scanner_scan_themes_ready, _data_);
				return FALSE;
				_state_1:
				theme_scanner_scan_themes_dir_finish (_data_->self, _data_->_res_);
				_g_free0 (_data_->xdg_path);
			}
		}
	}
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_get_home_dir ();
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_strdup (_data_->_tmp4_);
	_data_->home_dir = _data_->_tmp5_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->home_dir;
	if (_data_->_tmp7_ == NULL) {
		_data_->_tmp6_ = TRUE;
	} else {
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->home_dir;
		_data_->_tmp9_ = 0;
		_data_->_tmp9_ = strlen (_data_->_tmp8_);
		_data_->_tmp10_ = 0;
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp6_ = _data_->_tmp10_ < 1;
	}
	if (_data_->_tmp6_) {
		_g_free0 (_data_->home_dir);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->home_dir;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12__length1 = 0;
	_data_->_tmp12_ = _data_->self->priv->legacy_suffixes;
	_data_->_tmp12__length1 = _data_->self->priv->legacy_suffixes_length1;
	_data_->_state_ = 2;
	theme_scanner_scan_themes_dir (_data_->self, _data_->_tmp11_, _data_->_tmp12_, _data_->_tmp12__length1, theme_scanner_scan_themes_ready, _data_);
	return FALSE;
	_state_2:
	theme_scanner_scan_themes_dir_finish (_data_->self, _data_->_res_);
	_g_free0 (_data_->home_dir);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void theme_scanner_scan_themes_dir_data_free (gpointer _data) {
	ThemeScannerScanThemesDirData* _data_;
	_data_ = _data;
	_g_free0 (_data_->base_dir);
	_g_object_unref0 (_data_->self);
	g_slice_free (ThemeScannerScanThemesDirData, _data_);
}


static void theme_scanner_scan_themes_dir (ThemeScanner* self, const gchar* base_dir, gchar** suffixes, int suffixes_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ThemeScannerScanThemesDirData* _data_;
	ThemeScanner* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_data_ = g_slice_new0 (ThemeScannerScanThemesDirData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, theme_scanner_scan_themes_dir);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, theme_scanner_scan_themes_dir_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = base_dir;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->base_dir);
	_data_->base_dir = _tmp2_;
	_tmp3_ = suffixes;
	_tmp3__length1 = suffixes_length1;
	_data_->suffixes = _tmp3_;
	_data_->suffixes_length1 = _tmp3__length1;
	theme_scanner_scan_themes_dir_co (_data_);
}


static void theme_scanner_scan_themes_dir_finish (ThemeScanner* self, GAsyncResult* _res_) {
	ThemeScannerScanThemesDirData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Scan a directory for all theme types
     */
static void theme_scanner_scan_themes_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ThemeScannerScanThemesDirData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	theme_scanner_scan_themes_dir_co (_data_);
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean theme_scanner_scan_themes_dir_co (ThemeScannerScanThemesDirData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->base_dir;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = g_file_test (_data_->_tmp0_, G_FILE_TEST_IS_DIR);
	if (!_data_->_tmp1_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp2_ = NULL;
		_data_->_tmp2__length1 = 0;
		_data_->_tmp2_ = _data_->suffixes;
		_data_->_tmp2__length1 = _data_->suffixes_length1;
		{
			_data_->suffix_collection_length1 = 0;
			_data_->_suffix_collection_size_ = 0;
			_data_->suffix_collection = _data_->_tmp2_;
			_data_->suffix_collection_length1 = _data_->_tmp2__length1;
			for (_data_->suffix_it = 0; _data_->suffix_it < _data_->_tmp2__length1; _data_->suffix_it = _data_->suffix_it + 1) {
				_data_->_tmp3_ = NULL;
				_data_->_tmp3_ = g_strdup (_data_->suffix_collection[_data_->suffix_it]);
				_data_->suffix = _data_->_tmp3_;
				{
					_data_->_tmp4_ = NULL;
					_data_->_tmp4_ = _data_->base_dir;
					_data_->_tmp5_ = NULL;
					_data_->_tmp5_ = _data_->suffix;
					_data_->_tmp6_ = NULL;
					_data_->_tmp6_ = g_strdup_printf ("%s%s%s", _data_->_tmp4_, G_DIR_SEPARATOR_S, _data_->_tmp5_);
					_data_->full_path = _data_->_tmp6_;
					_data_->_tmp7_ = NULL;
					_data_->_tmp7_ = _data_->full_path;
					_data_->_tmp8_ = FALSE;
					_data_->_tmp8_ = g_file_test (_data_->_tmp7_, G_FILE_TEST_IS_DIR);
					if (!_data_->_tmp8_) {
						_g_free0 (_data_->full_path);
						_g_free0 (_data_->suffix);
						continue;
					}
					_data_->_tmp9_ = NULL;
					_data_->_tmp9_ = _data_->full_path;
					_data_->_tmp10_ = NULL;
					_data_->_tmp10_ = g_file_new_for_path (_data_->_tmp9_);
					_data_->f = _data_->_tmp10_;
					_data_->_tmp11_ = NULL;
					_data_->_tmp11_ = _data_->f;
					_data_->_state_ = 1;
					g_file_enumerate_children_async (_data_->_tmp11_, "standard::*", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, G_PRIORITY_DEFAULT, NULL, theme_scanner_scan_themes_dir_ready, _data_);
					return FALSE;
					_state_1:
					_data_->_tmp12_ = NULL;
					_data_->_tmp12_ = g_file_enumerate_children_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
					_data_->en = _data_->_tmp12_;
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						_g_object_unref0 (_data_->f);
						_g_free0 (_data_->full_path);
						_g_free0 (_data_->suffix);
						goto __catch11_g_error;
					}
					while (TRUE) {
						_data_->_tmp13_ = NULL;
						_data_->_tmp13_ = _data_->en;
						_data_->_state_ = 2;
						g_file_enumerator_next_files_async (_data_->_tmp13_, 10, G_PRIORITY_DEFAULT, NULL, theme_scanner_scan_themes_dir_ready, _data_);
						return FALSE;
						_state_2:
						_data_->_tmp14_ = NULL;
						_data_->_tmp14_ = g_file_enumerator_next_files_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error_);
						_data_->files = _data_->_tmp14_;
						if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
							_g_object_unref0 (_data_->en);
							_g_object_unref0 (_data_->f);
							_g_free0 (_data_->full_path);
							_g_free0 (_data_->suffix);
							goto __catch11_g_error;
						}
						_data_->_tmp15_ = NULL;
						_data_->_tmp15_ = _data_->files;
						if (_data_->_tmp15_ == NULL) {
							__g_list_free__g_object_unref0_0 (_data_->files);
							break;
						}
						_data_->_tmp16_ = NULL;
						_data_->_tmp16_ = _data_->files;
						{
							_data_->file_collection = _data_->_tmp16_;
							for (_data_->file_it = _data_->file_collection; _data_->file_it != NULL; _data_->file_it = _data_->file_it->next) {
								_data_->_tmp17_ = NULL;
								_data_->_tmp17_ = _g_object_ref0 ((GFileInfo*) _data_->file_it->data);
								_data_->file = _data_->_tmp17_;
								{
									_data_->_tmp18_ = NULL;
									_data_->_tmp18_ = _data_->file;
									_data_->_tmp19_ = NULL;
									_data_->_tmp19_ = g_file_info_get_display_name (_data_->_tmp18_);
									_data_->_tmp20_ = NULL;
									_data_->_tmp20_ = g_strdup (_data_->_tmp19_);
									_data_->display_path = _data_->_tmp20_;
									_data_->_tmp21_ = NULL;
									_data_->_tmp21_ = g_strdup (G_DIR_SEPARATOR_S);
									_data_->sep = _data_->_tmp21_;
									_data_->_tmp22_ = NULL;
									_data_->_tmp22_ = _data_->full_path;
									_data_->_tmp23_ = NULL;
									_data_->_tmp23_ = _data_->sep;
									_data_->_tmp24_ = NULL;
									_data_->_tmp24_ = _data_->display_path;
									_data_->_tmp25_ = NULL;
									_data_->_tmp25_ = g_strdup_printf ("%s%s%s", _data_->_tmp22_, _data_->_tmp23_, _data_->_tmp24_);
									_data_->path = _data_->_tmp25_;
									_data_->_tmp26_ = NULL;
									_data_->_tmp26_ = _data_->suffix;
									_data_->_tmp27_ = NULL;
									_data_->_tmp27_ = _data_->path;
									_data_->_tmp28_ = NULL;
									_data_->_tmp28_ = _data_->display_path;
									_data_->_state_ = 3;
									theme_scanner_scan_one (_data_->self, _data_->_tmp26_, _data_->_tmp27_, _data_->_tmp28_, theme_scanner_scan_themes_dir_ready, _data_);
									return FALSE;
									_state_3:
									theme_scanner_scan_one_finish (_data_->self, _data_->_res_);
									_g_free0 (_data_->path);
									_g_free0 (_data_->sep);
									_g_free0 (_data_->display_path);
									_g_object_unref0 (_data_->file);
								}
							}
						}
						__g_list_free__g_object_unref0_0 (_data_->files);
					}
					_g_object_unref0 (_data_->en);
					_g_object_unref0 (_data_->f);
					_g_free0 (_data_->full_path);
					_g_free0 (_data_->suffix);
				}
			}
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->e;
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = _data_->_tmp29_->message;
		g_message ("themes.vala:151: Error in scan_themes_dir: %s\n", _data_->_tmp30_);
		_g_error_free0 (_data_->e);
	}
	__finally11:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void theme_scanner_scan_one_data_free (gpointer _data) {
	ThemeScannerScanOneData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path_type);
	_g_free0 (_data_->full_path);
	_g_free0 (_data_->display_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (ThemeScannerScanOneData, _data_);
}


static void theme_scanner_scan_one (ThemeScanner* self, const gchar* path_type, const gchar* full_path, const gchar* display_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ThemeScannerScanOneData* _data_;
	ThemeScanner* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	_data_ = g_slice_new0 (ThemeScannerScanOneData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, theme_scanner_scan_one);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, theme_scanner_scan_one_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = path_type;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->path_type);
	_data_->path_type = _tmp2_;
	_tmp3_ = full_path;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->full_path);
	_data_->full_path = _tmp4_;
	_tmp5_ = display_name;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->display_name);
	_data_->display_name = _tmp6_;
	theme_scanner_scan_one_co (_data_);
}


static void theme_scanner_scan_one_finish (ThemeScanner* self, GAsyncResult* _res_) {
	ThemeScannerScanOneData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Scan one directory with the given type, i.e. "icons", or "themes"
     */
static void theme_scanner_scan_one_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ThemeScannerScanOneData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	theme_scanner_scan_one_co (_data_);
}


static gboolean theme_scanner_scan_one_co (ThemeScannerScanOneData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->gtk_theme = FALSE;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->path_type;
	if (g_strcmp0 (_data_->_tmp0_, "themes") == 0) {
		_data_->gtk_theme = TRUE;
	}
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->gtk_theme;
	if (_data_->_tmp1_) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2__length1 = 0;
		_data_->_tmp2_ = _data_->self->priv->gtk_theme_paths;
		_data_->_tmp2__length1 = _data_->self->priv->gtk_theme_paths_length1;
		{
			_data_->suffix_collection_length1 = 0;
			_data_->_suffix_collection_size_ = 0;
			_data_->suffix_collection = _data_->_tmp2_;
			_data_->suffix_collection_length1 = _data_->_tmp2__length1;
			for (_data_->suffix_it = 0; _data_->suffix_it < _data_->_tmp2__length1; _data_->suffix_it = _data_->suffix_it + 1) {
				_data_->_tmp3_ = NULL;
				_data_->_tmp3_ = g_strdup (_data_->suffix_collection[_data_->suffix_it]);
				_data_->suffix = _data_->_tmp3_;
				{
					_data_->_tmp4_ = NULL;
					_data_->_tmp4_ = _data_->full_path;
					_data_->_tmp5_ = NULL;
					_data_->_tmp5_ = _data_->suffix;
					_data_->_tmp6_ = NULL;
					_data_->_tmp6_ = g_strdup_printf ("%s%s%s", _data_->_tmp4_, G_DIR_SEPARATOR_S, _data_->_tmp5_);
					_data_->path = _data_->_tmp6_;
					_data_->_tmp7_ = NULL;
					_data_->_tmp7_ = _data_->path;
					_data_->_tmp8_ = NULL;
					_data_->_tmp8_ = _data_->display_name;
					_data_->_state_ = 1;
					theme_scanner_maybe_add_gtk_theme (_data_->self, _data_->_tmp7_, _data_->_tmp8_, theme_scanner_scan_one_ready, _data_);
					return FALSE;
					_state_1:
					_data_->_tmp9_ = FALSE;
					_data_->_tmp9_ = theme_scanner_maybe_add_gtk_theme_finish (_data_->self, _data_->_res_);
					_data_->added = _data_->_tmp9_;
					_data_->_tmp10_ = FALSE;
					_data_->_tmp10_ = _data_->added;
					if (_data_->_tmp10_) {
						_g_free0 (_data_->path);
						_g_free0 (_data_->suffix);
						if (_data_->_state_ == 0) {
							g_simple_async_result_complete_in_idle (_data_->_async_result);
						} else {
							g_simple_async_result_complete (_data_->_async_result);
						}
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_g_free0 (_data_->path);
					_g_free0 (_data_->suffix);
				}
			}
		}
	} else {
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->full_path;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->display_name;
		_data_->_state_ = 2;
		theme_scanner_maybe_add_icon_theme (_data_->self, _data_->_tmp11_, _data_->_tmp12_, theme_scanner_scan_one_ready, _data_);
		return FALSE;
		_state_2:
		theme_scanner_maybe_add_icon_theme_finish (_data_->self, _data_->_res_);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void theme_scanner_maybe_add_gtk_theme_data_free (gpointer _data) {
	ThemeScannerMaybeAddGtkThemeData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_free0 (_data_->theme_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (ThemeScannerMaybeAddGtkThemeData, _data_);
}


static void theme_scanner_maybe_add_gtk_theme (ThemeScanner* self, const gchar* path, const gchar* theme_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ThemeScannerMaybeAddGtkThemeData* _data_;
	ThemeScanner* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_data_ = g_slice_new0 (ThemeScannerMaybeAddGtkThemeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, theme_scanner_maybe_add_gtk_theme);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, theme_scanner_maybe_add_gtk_theme_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->path);
	_data_->path = _tmp2_;
	_tmp3_ = theme_name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->theme_name);
	_data_->theme_name = _tmp4_;
	theme_scanner_maybe_add_gtk_theme_co (_data_);
}


static gboolean theme_scanner_maybe_add_gtk_theme_finish (ThemeScanner* self, GAsyncResult* _res_) {
	gboolean result;
	ThemeScannerMaybeAddGtkThemeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


/**
     * Attempt to add a unique theme into the set
     */
static gboolean theme_scanner_maybe_add_gtk_theme_co (ThemeScannerMaybeAddGtkThemeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->gtk_themes;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->theme_name;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_hash_table_lookup (_data_->_tmp0_, _data_->_tmp1_);
	_data_->info = (ThemeInfo*) _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->info;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = theme_info_new (THEME_TYPE_GTK_THEME);
		_data_->ninfo = _data_->_tmp4_;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->self->priv->gtk_themes;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->theme_name;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->ninfo;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
		g_hash_table_insert (_data_->_tmp5_, _data_->_tmp7_, _data_->_tmp9_);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->self->priv->gtk_themes;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->theme_name;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_hash_table_lookup (_data_->_tmp10_, _data_->_tmp11_);
		_data_->info = (ThemeInfo*) _data_->_tmp12_;
		_g_object_unref0 (_data_->ninfo);
	}
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->info;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->path;
	_data_->_tmp15_ = FALSE;
	_data_->_tmp15_ = theme_info_add_path (_data_->_tmp13_, _data_->_tmp14_);
	if (_data_->_tmp15_) {
		_data_->result = TRUE;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Return a unique list of currently known gtk themes
     */
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** theme_scanner_get_gtk_themes (ThemeScanner* self, int* result_length1) {
	gchar** result = NULL;
	gchar** t = NULL;
	gchar** _tmp0_ = NULL;
	gint t_length1 = 0;
	gint _t_size_ = 0;
	const gchar* name = NULL;
	ThemeInfo* info = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp1_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	t = _tmp0_;
	t_length1 = 0;
	_t_size_ = t_length1;
	name = NULL;
	info = NULL;
	_tmp1_ = self->priv->gtk_themes;
	g_hash_table_iter_init (&iter, _tmp1_);
	while (TRUE) {
		gconstpointer _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp4_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp2_), (gpointer*) (&_tmp3_));
		name = _tmp2_;
		info = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = t;
		_tmp5__length1 = t_length1;
		_tmp6_ = name;
		_tmp7_ = g_strconcat ("", _tmp6_, NULL);
		_vala_array_add3 (&t, &t_length1, &_t_size_, _tmp7_);
	}
	_tmp8_ = t;
	_tmp8__length1 = t_length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}


/**
     * Return a unique list of currently known cursor themes
     */
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** theme_scanner_get_cursor_themes (ThemeScanner* self, int* result_length1) {
	gchar** result = NULL;
	gchar** t = NULL;
	gchar** _tmp0_ = NULL;
	gint t_length1 = 0;
	gint _t_size_ = 0;
	const gchar* name = NULL;
	ThemeInfo* info = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp1_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	t = _tmp0_;
	t_length1 = 0;
	_t_size_ = t_length1;
	name = NULL;
	info = NULL;
	_tmp1_ = self->priv->cursor_themes;
	g_hash_table_iter_init (&iter, _tmp1_);
	while (TRUE) {
		gconstpointer _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp4_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp2_), (gpointer*) (&_tmp3_));
		name = _tmp2_;
		info = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = t;
		_tmp5__length1 = t_length1;
		_tmp6_ = name;
		_tmp7_ = g_strconcat ("", _tmp6_, NULL);
		_vala_array_add4 (&t, &t_length1, &_t_size_, _tmp7_);
	}
	_tmp8_ = t;
	_tmp8__length1 = t_length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}


/**
     * Return a unique list of currently known icon themes
     */
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** theme_scanner_get_icon_themes (ThemeScanner* self, int* result_length1) {
	gchar** result = NULL;
	gchar** t = NULL;
	gchar** _tmp0_ = NULL;
	gint t_length1 = 0;
	gint _t_size_ = 0;
	const gchar* name = NULL;
	ThemeInfo* info = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp1_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	t = _tmp0_;
	t_length1 = 0;
	_t_size_ = t_length1;
	name = NULL;
	info = NULL;
	_tmp1_ = self->priv->icon_themes;
	g_hash_table_iter_init (&iter, _tmp1_);
	while (TRUE) {
		gconstpointer _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp4_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp2_), (gpointer*) (&_tmp3_));
		name = _tmp2_;
		info = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = t;
		_tmp5__length1 = t_length1;
		_tmp6_ = name;
		_tmp7_ = g_strconcat ("", _tmp6_, NULL);
		_vala_array_add5 (&t, &t_length1, &_t_size_, _tmp7_);
	}
	_tmp8_ = t;
	_tmp8__length1 = t_length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}


static void theme_scanner_maybe_add_icon_theme_data_free (gpointer _data) {
	ThemeScannerMaybeAddIconThemeData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_free0 (_data_->theme_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (ThemeScannerMaybeAddIconThemeData, _data_);
}


static void theme_scanner_maybe_add_icon_theme (ThemeScanner* self, const gchar* path, const gchar* theme_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ThemeScannerMaybeAddIconThemeData* _data_;
	ThemeScanner* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_data_ = g_slice_new0 (ThemeScannerMaybeAddIconThemeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, theme_scanner_maybe_add_icon_theme);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, theme_scanner_maybe_add_icon_theme_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->path);
	_data_->path = _tmp2_;
	_tmp3_ = theme_name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->theme_name);
	_data_->theme_name = _tmp4_;
	theme_scanner_maybe_add_icon_theme_co (_data_);
}


static void theme_scanner_maybe_add_icon_theme_finish (ThemeScanner* self, GAsyncResult* _res_) {
	ThemeScannerMaybeAddIconThemeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Attempt to add cursor/icon theme to the set
     */
static void theme_scanner_maybe_add_icon_theme_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ThemeScannerMaybeAddIconThemeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	theme_scanner_maybe_add_icon_theme_co (_data_);
}


static gboolean theme_scanner_maybe_add_icon_theme_co (ThemeScannerMaybeAddIconThemeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->path;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_strdup_printf ("%s%s%s", _data_->_tmp0_, G_DIR_SEPARATOR_S, "index.theme");
	_data_->test_path = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->test_path;
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = g_file_test (_data_->_tmp2_, G_FILE_TEST_EXISTS);
	if (!_data_->_tmp3_) {
		_g_free0 (_data_->test_path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->icon_theme = TRUE;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_key_file_new ();
	_data_->f = _data_->_tmp4_;
	{
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->f;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->test_path;
		g_key_file_load_from_file (_data_->_tmp5_, _data_->_tmp6_, G_KEY_FILE_NONE, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->e);
		_g_key_file_unref0 (_data_->f);
		_g_free0 (_data_->test_path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally12:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_key_file_unref0 (_data_->f);
		_g_free0 (_data_->test_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	{
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->f;
		_data_->_tmp9_ = FALSE;
		_data_->_tmp9_ = g_key_file_has_key (_data_->_tmp8_, "Icon Theme", "Directories", &_data_->_inner_error_);
		_data_->_tmp7_ = _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch13_g_error;
		}
		if (!_data_->_tmp7_) {
			_data_->icon_theme = FALSE;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->icon_theme = FALSE;
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally13:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_key_file_unref0 (_data_->f);
		_g_free0 (_data_->test_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp10_ = FALSE;
	_data_->_tmp10_ = _data_->icon_theme;
	if (_data_->_tmp10_) {
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->path;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->theme_name;
		_data_->_state_ = 1;
		theme_scanner_maybe_add_icons (_data_->self, _data_->_tmp11_, _data_->_tmp12_, theme_scanner_maybe_add_icon_theme_ready, _data_);
		return FALSE;
		_state_1:
		theme_scanner_maybe_add_icons_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->path;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_strdup_printf ("%s%s%s", _data_->_tmp13_, G_DIR_SEPARATOR_S, "cursors");
	_data_->cursor_path = _data_->_tmp14_;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->cursor_path;
	_data_->_tmp16_ = FALSE;
	_data_->_tmp16_ = g_file_test (_data_->_tmp15_, G_FILE_TEST_EXISTS);
	if (_data_->_tmp16_) {
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->path;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->theme_name;
		_data_->_state_ = 2;
		theme_scanner_maybe_add_cursors (_data_->self, _data_->_tmp17_, _data_->_tmp18_, theme_scanner_maybe_add_icon_theme_ready, _data_);
		return FALSE;
		_state_2:
		theme_scanner_maybe_add_cursors_finish (_data_->self, _data_->_res_);
	}
	_g_free0 (_data_->cursor_path);
	_g_key_file_unref0 (_data_->f);
	_g_free0 (_data_->test_path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void theme_scanner_maybe_add_cursors_data_free (gpointer _data) {
	ThemeScannerMaybeAddCursorsData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_free0 (_data_->theme_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (ThemeScannerMaybeAddCursorsData, _data_);
}


static void theme_scanner_maybe_add_cursors (ThemeScanner* self, const gchar* path, const gchar* theme_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ThemeScannerMaybeAddCursorsData* _data_;
	ThemeScanner* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_data_ = g_slice_new0 (ThemeScannerMaybeAddCursorsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, theme_scanner_maybe_add_cursors);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, theme_scanner_maybe_add_cursors_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->path);
	_data_->path = _tmp2_;
	_tmp3_ = theme_name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->theme_name);
	_data_->theme_name = _tmp4_;
	theme_scanner_maybe_add_cursors_co (_data_);
}


static gboolean theme_scanner_maybe_add_cursors_finish (ThemeScanner* self, GAsyncResult* _res_) {
	gboolean result;
	ThemeScannerMaybeAddCursorsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


/**
     * Try adding unique cursor theme
     */
static gboolean theme_scanner_maybe_add_cursors_co (ThemeScannerMaybeAddCursorsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->cursor_themes;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->theme_name;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_hash_table_lookup (_data_->_tmp0_, _data_->_tmp1_);
	_data_->info = (ThemeInfo*) _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->info;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = theme_info_new (THEME_TYPE_CURSOR_THEME);
		_data_->ninfo = _data_->_tmp4_;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->self->priv->cursor_themes;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->theme_name;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->ninfo;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
		g_hash_table_insert (_data_->_tmp5_, _data_->_tmp7_, _data_->_tmp9_);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->self->priv->cursor_themes;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->theme_name;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_hash_table_lookup (_data_->_tmp10_, _data_->_tmp11_);
		_data_->info = (ThemeInfo*) _data_->_tmp12_;
		_g_object_unref0 (_data_->ninfo);
	}
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->info;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->path;
	_data_->_tmp15_ = FALSE;
	_data_->_tmp15_ = theme_info_add_path (_data_->_tmp13_, _data_->_tmp14_);
	if (_data_->_tmp15_) {
		_data_->result = TRUE;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void theme_scanner_maybe_add_icons_data_free (gpointer _data) {
	ThemeScannerMaybeAddIconsData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_free0 (_data_->theme_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (ThemeScannerMaybeAddIconsData, _data_);
}


static void theme_scanner_maybe_add_icons (ThemeScanner* self, const gchar* path, const gchar* theme_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ThemeScannerMaybeAddIconsData* _data_;
	ThemeScanner* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_data_ = g_slice_new0 (ThemeScannerMaybeAddIconsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, theme_scanner_maybe_add_icons);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, theme_scanner_maybe_add_icons_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->path);
	_data_->path = _tmp2_;
	_tmp3_ = theme_name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->theme_name);
	_data_->theme_name = _tmp4_;
	theme_scanner_maybe_add_icons_co (_data_);
}


static gboolean theme_scanner_maybe_add_icons_finish (ThemeScanner* self, GAsyncResult* _res_) {
	gboolean result;
	ThemeScannerMaybeAddIconsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


/**
     * Try adding unique icon theme
     */
static gboolean theme_scanner_maybe_add_icons_co (ThemeScannerMaybeAddIconsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->icon_themes;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->theme_name;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_hash_table_lookup (_data_->_tmp0_, _data_->_tmp1_);
	_data_->info = (ThemeInfo*) _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->info;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = theme_info_new (THEME_TYPE_ICON_THEME);
		_data_->ninfo = _data_->_tmp4_;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->self->priv->icon_themes;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->theme_name;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->ninfo;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
		g_hash_table_insert (_data_->_tmp5_, _data_->_tmp7_, _data_->_tmp9_);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->self->priv->icon_themes;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->theme_name;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_hash_table_lookup (_data_->_tmp10_, _data_->_tmp11_);
		_data_->info = (ThemeInfo*) _data_->_tmp12_;
		_g_object_unref0 (_data_->ninfo);
	}
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->info;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->path;
	_data_->_tmp15_ = FALSE;
	_data_->_tmp15_ = theme_info_add_path (_data_->_tmp13_, _data_->_tmp14_);
	if (_data_->_tmp15_) {
		_data_->result = TRUE;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void theme_scanner_class_init (ThemeScannerClass * klass) {
	theme_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ThemeScannerPrivate));
	G_OBJECT_CLASS (klass)->finalize = theme_scanner_finalize;
}


static void theme_scanner_instance_init (ThemeScanner * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	self->priv = THEME_SCANNER_GET_PRIVATE (self);
	self->priv->xdg_paths = NULL;
	self->priv->xdg_paths_length1 = 0;
	self->priv->_xdg_paths_size_ = self->priv->xdg_paths_length1;
	_tmp0_ = g_strdup ("themes");
	_tmp1_ = g_strdup ("icons");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	self->priv->normal_suffixes = _tmp2_;
	self->priv->normal_suffixes_length1 = 2;
	self->priv->_normal_suffixes_size_ = self->priv->normal_suffixes_length1;
	_tmp3_ = g_strdup (".themes");
	_tmp4_ = g_strdup (".icons");
	_tmp5_ = g_new0 (gchar*, 2 + 1);
	_tmp5_[0] = _tmp3_;
	_tmp5_[1] = _tmp4_;
	self->priv->legacy_suffixes = _tmp5_;
	self->priv->legacy_suffixes_length1 = 2;
	self->priv->_legacy_suffixes_size_ = self->priv->legacy_suffixes_length1;
	self->priv->gtk_theme_paths = NULL;
	self->priv->gtk_theme_paths_length1 = 0;
	self->priv->_gtk_theme_paths_size_ = self->priv->gtk_theme_paths_length1;
	self->priv->gtk_themes = NULL;
	self->priv->cursor_themes = NULL;
	self->priv->icon_themes = NULL;
}


static void theme_scanner_finalize (GObject* obj) {
	ThemeScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEME_SCANNER, ThemeScanner);
	self->priv->xdg_paths = (_vala_array_free (self->priv->xdg_paths, self->priv->xdg_paths_length1, (GDestroyNotify) g_free), NULL);
	self->priv->normal_suffixes = (_vala_array_free (self->priv->normal_suffixes, self->priv->normal_suffixes_length1, (GDestroyNotify) g_free), NULL);
	self->priv->legacy_suffixes = (_vala_array_free (self->priv->legacy_suffixes, self->priv->legacy_suffixes_length1, (GDestroyNotify) g_free), NULL);
	self->priv->gtk_theme_paths = (_vala_array_free (self->priv->gtk_theme_paths, self->priv->gtk_theme_paths_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (self->priv->gtk_themes);
	_g_hash_table_unref0 (self->priv->cursor_themes);
	_g_hash_table_unref0 (self->priv->icon_themes);
	G_OBJECT_CLASS (theme_scanner_parent_class)->finalize (obj);
}


GType theme_scanner_get_type (void) {
	static volatile gsize theme_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&theme_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ThemeScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) theme_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThemeScanner), 0, (GInstanceInitFunc) theme_scanner_instance_init, NULL };
		GType theme_scanner_type_id;
		theme_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "ThemeScanner", &g_define_type_info, 0);
		g_once_init_leave (&theme_scanner_type_id__volatile, theme_scanner_type_id);
	}
	return theme_scanner_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



