/*
 * Calcoo: b_info.c
 *
 * Copyright (C) 2001 Alexei Kaminski
 *
 * creates and operates the info window
 *
 * some code used in this file is taken from about.c of
 * XMMS - Cross-platform multimedia player
 * Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, 
 * Thomas Nilsson, and 4Front Technologies
 * Copyright (C) 2000 Havard Kvalen <havardk@xmms.org>
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>

#include "body.h"
#include "b_headers.h"
#include "texts.h"

#include "pixmaps/main.xpm"

#define INFO_SCROLLWIN_HEIGHT 250
#define INFO_SPACING 10
#define INFO_LINE_SPACING 5

GtkWidget *close_button;

void info_key_press_handler(GtkWidget*, GdkEventKey*, gpointer);

void call_info (void)
{
	static GtkWidget *info_window = NULL;

	GdkPixmap *main_pixmap;
	GdkBitmap *main_mask;

	GtkWidget *info_vbox;
	GtkWidget *info_notebook;
	GtkWidget *button_box;

	GtkWidget *about_vbox, *about_label;

	GtkWidget *license_vbox, *license_clist, *license_scrollwin;
	GtkWidget *shortcuts_vbox, *shortcuts_clist, *shortcuts_scrollwin;
	GtkWidget *help_vbox, *help_clist, *help_scrollwin;

	gint i;
	char *tit[3];

	if (info_window)
		return;
	
/* Main info window */
	info_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(info_window), "About Calcoo");
	gtk_window_set_policy(GTK_WINDOW(info_window), FALSE, TRUE, FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(info_window), 
				       INFO_SPACING);
	gtk_signal_connect(GTK_OBJECT(info_window), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroyed), 
			   &info_window);
	gtk_signal_connect (GTK_OBJECT (info_window), "key_press_event",
			    GTK_SIGNAL_FUNC (info_key_press_handler), NULL);
	/* this is to have Escape close the window. Creating an accelerator
	 * group does not work, because the accelerator is not called when
	 * a page with a scrollable text (like license) is open */

	gtk_widget_realize(info_window);
	
/* Main info window icon */
	main_pixmap = gdk_pixmap_create_from_xpm_d ( 
		info_window->window,
		&main_mask,
		&(body->style)->bg[GTK_STATE_NORMAL],
		(gchar **) main_xpm 
		);

  	gdk_window_set_icon (info_window->window, NULL,  
  			     main_pixmap, main_mask); 




	info_vbox = gtk_vbox_new(FALSE, INFO_SPACING);
	gtk_container_add(GTK_CONTAINER(info_window), info_vbox);
	
	info_notebook = gtk_notebook_new();
	gtk_box_pack_start(GTK_BOX(info_vbox), info_notebook, TRUE, TRUE, 0);
	

	/* About */
	about_vbox = gtk_vbox_new(TRUE, INFO_LINE_SPACING);
	gtk_container_set_border_width(GTK_CONTAINER(about_vbox), 
				       INFO_SPACING);
	
  	i = 0; 
  	while (about_text[i] || about_text[i + 1]) { 
		about_label = gtk_label_new(about_text[i]);
		gtk_box_pack_start(GTK_BOX(about_vbox), about_label, 
				   FALSE, FALSE, 0);
		
		i++;
	}

	gtk_notebook_append_page(GTK_NOTEBOOK(info_notebook), 
				 about_vbox,
				 gtk_label_new("About"));
	
	/* License */
  	license_clist = gtk_clist_new(1); 

  	i = 0; 
  	while ( license_text[i] || license_text[i + 1]) { 
		char **temp;
		char *temp1;
		guint row;
		
		temp1 = license_text[i];
		temp = &temp1;
		row = gtk_clist_append(GTK_CLIST(license_clist), temp);
		gtk_clist_set_selectable(GTK_CLIST(license_clist), row, FALSE);
		i++;
	}

	gtk_clist_columns_autosize(GTK_CLIST(license_clist));
	gtk_clist_set_column_justification(GTK_CLIST(license_clist), 0, 
					   GTK_JUSTIFY_LEFT);
	
	license_scrollwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(license_scrollwin),
				       GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	gtk_container_add(GTK_CONTAINER(license_scrollwin), license_clist);


	license_vbox = gtk_vbox_new(FALSE, INFO_SPACING);
	gtk_container_set_border_width(GTK_CONTAINER(license_vbox), 
				       INFO_SPACING);
  	gtk_box_pack_start(GTK_BOX(license_vbox), license_scrollwin, 
			   TRUE, TRUE, 0); 
  	gtk_widget_set_usize(license_scrollwin, -1, INFO_SCROLLWIN_HEIGHT); 


	gtk_notebook_append_page(GTK_NOTEBOOK(info_notebook), 
				 license_vbox,
				 gtk_label_new("License"));

	/* Shortcuts */
	tit[0] = "Shortcuts";
	tit[1] = " ";
	tit[2] = "Actions";
  	shortcuts_clist = gtk_clist_new_with_titles(3, tit); 

  	i = 0; 
  	while ( shortcuts_text[i] || shortcuts_text[i + 2]) { 
		char *temp[3];
		char *temp1, *temp2;
		guint row;
		
		temp1 = shortcuts_text[i];
		temp2 = shortcuts_text[i+1];
		temp[0] = temp1;
		temp[1] = "   ";
		temp[2] = temp2;
		row = gtk_clist_append(GTK_CLIST(shortcuts_clist), temp);
		gtk_clist_set_selectable(GTK_CLIST(shortcuts_clist), row, 
					 FALSE);
		i++; i++;
	}

	gtk_clist_columns_autosize(GTK_CLIST(shortcuts_clist));
	gtk_clist_set_column_resizeable(GTK_CLIST(shortcuts_clist), 0, FALSE);
	gtk_clist_set_column_justification(GTK_CLIST(shortcuts_clist), 0, 
					   GTK_JUSTIFY_RIGHT);
	gtk_clist_set_column_resizeable(GTK_CLIST(shortcuts_clist), 1, FALSE);
	gtk_clist_set_column_resizeable(GTK_CLIST(shortcuts_clist), 2, FALSE);
	gtk_clist_set_column_justification(GTK_CLIST(shortcuts_clist), 2, 
					   GTK_JUSTIFY_LEFT);
	
	shortcuts_scrollwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(
		GTK_SCROLLED_WINDOW(shortcuts_scrollwin),
		GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	gtk_container_add(GTK_CONTAINER(shortcuts_scrollwin), shortcuts_clist);


	shortcuts_vbox = gtk_vbox_new(FALSE, INFO_SPACING);
	gtk_container_set_border_width(GTK_CONTAINER(shortcuts_vbox), 
				       INFO_SPACING);
  	gtk_box_pack_start(GTK_BOX(shortcuts_vbox), shortcuts_scrollwin, 
			   TRUE, TRUE, 0); 
  	gtk_widget_set_usize(shortcuts_scrollwin, -1, INFO_SCROLLWIN_HEIGHT); 


	gtk_notebook_append_page(GTK_NOTEBOOK(info_notebook), 
				 shortcuts_vbox,
				 gtk_label_new("Shortcuts"));

	/* Help */
  	help_clist = gtk_clist_new(1); 

  	i = 0; 
  	while ( help_text[i] || help_text[i + 1]) { 
		char **temp;
		char *temp1;
		guint row;
		
		temp1 = help_text[i];
		temp = &temp1;
		row = gtk_clist_append(GTK_CLIST(help_clist), temp);
		gtk_clist_set_selectable(GTK_CLIST(help_clist), row, FALSE);
		i++;
	}

	gtk_clist_columns_autosize(GTK_CLIST(help_clist));
	gtk_clist_set_column_justification(GTK_CLIST(help_clist), 0, 
					   GTK_JUSTIFY_LEFT);
	
	help_scrollwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(help_scrollwin),
				       GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	gtk_container_add(GTK_CONTAINER(help_scrollwin), help_clist);


	help_vbox = gtk_vbox_new(FALSE, INFO_SPACING);
	gtk_container_set_border_width(GTK_CONTAINER(help_vbox), 
				       INFO_SPACING);
  	gtk_box_pack_start(GTK_BOX(help_vbox), help_scrollwin, 
			   TRUE, TRUE, 0); 
  	gtk_widget_set_usize(help_scrollwin, -1, INFO_SCROLLWIN_HEIGHT); 

	gtk_notebook_append_page(GTK_NOTEBOOK(info_notebook), 
				 help_vbox,
				 gtk_label_new("Help"));

	/* "Close" button */
	button_box = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(button_box), 
				  GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(button_box), INFO_SPACING);
	gtk_box_pack_start(GTK_BOX(info_vbox), button_box, FALSE, FALSE, 0);

	close_button = gtk_button_new_with_label("Close");
	gtk_signal_connect_object(GTK_OBJECT(close_button), "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(info_window));
	gtk_box_pack_start(GTK_BOX(button_box), close_button, TRUE, TRUE, 0);

	gtk_widget_show_all(info_window);
}

void process_options(char *argv1)
{
	if ( !strcmp(argv1,"-v") || !strcmp(argv1,"--version"))
		output_text(version_console);
	else if ( !strcmp(argv1,"-h") || !strcmp(argv1,"--help"))
		output_text(help_console);
	else 
		output_text(invalid_console);
}

void output_text(char **t)
{
	int i;
	for ( i = 0; t[i] != NULL; i++ )
		printf("%s\n",t[i]);
}

void info_key_press_handler(GtkWidget* widget, GdkEventKey* event, 
			    gpointer data)
{
  switch (event->keyval)
    {
    case GDK_Escape:
	    gtk_signal_emit_by_name(GTK_OBJECT(close_button),
					"clicked");
    default:
	    break;
    }
}

