/*
 * Calcoo: b_loadsave.c
 *
 * Copyright (C) 2001,2002 Alexei Kaminski
 *
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "const.h"
#include "defaults.h"
#include "b_headers.h"
#include "aux_headers.h"


/* Careful with these strings! 
 * Their maximum possible length is defined below */
#define RPN_TRUE_STRING "RPN=True\n"
#define RPN_FALSE_STRING "RPN=False\n"

#define ENTER_TRADITIONAL_STRING "Enter_Mode=Traditional\n"
#define ENTER_HP28_STRING "Enter_Mode=HP-28\n"

#define STACK_INFINITE_STRING "Stack_Type=Infinite"
#define STACK_XYZT_STRING "Stack_Type=XYZT"

#define ARC_AUTORELEASE_TRUE_STRING "Arc_Autorelease=True"
#define ARC_AUTORELEASE_FALSE_STRING "Arc_Autorelease=False"

#define HYP_AUTORELEASE_TRUE_STRING "Hyp_Autorelease=True"
#define HYP_AUTORELEASE_FALSE_STRING "Hyp_Autorelease=False"

#define MAX_OPTIONLINE_LENGTH 32
#define MAX_FILENAME_LENGTH 64

static char options_filename[MAX_FILENAME_LENGTH];

void load_options(void)
{
	char s1[MAX_OPTIONLINE_LENGTH], s2[MAX_OPTIONLINE_LENGTH],
		s3[MAX_OPTIONLINE_LENGTH], s4[MAX_OPTIONLINE_LENGTH],
		s5[MAX_OPTIONLINE_LENGTH];
	FILE *fp;
/*  	char read_result;  */

	strcpy(options_filename, getenv("HOME"));
	strcat(options_filename, "/.calcoo");

	strcpy(s1," ");
	strcpy(s2," ");
	strcpy(s3," ");
	strcpy(s4," ");
	strcpy(s5," ");

	fp = fopen(options_filename, "r");

	if( fp != NULL )
	{	
		fgets(s1, MAX_OPTIONLINE_LENGTH, fp);
		if (strcmp(s1, RPN_TRUE_STRING) == 0){
			set_rpn_mode(TRUE);
		} else if (strcmp(s1, RPN_FALSE_STRING) == 0){
			set_rpn_mode(FALSE);
		} else {			
			set_rpn_mode(DEFAULT_RPN_MODE);
		}

		fgets(s2, MAX_OPTIONLINE_LENGTH, fp);
		if (strcmp(s2, ENTER_TRADITIONAL_STRING) == 0){
			set_enter_mode(ENTER_MODE_TRADITIONAL);
		} else if (strcmp(s2, ENTER_HP28_STRING) == 0){
			set_enter_mode(ENTER_MODE_HP28);
		} else {			
			set_enter_mode(DEFAULT_ENTER_MODE);
		}

		fgets(s3, MAX_OPTIONLINE_LENGTH, fp);
		if (strcmp(s3, STACK_INFINITE_STRING) == 0){
			set_stack_mode(STACK_MODE_INFINITE);
		} else if (strcmp(s3, STACK_XYZT_STRING) == 0){
			set_stack_mode(STACK_MODE_XYZT);
		} else {			
			set_stack_mode(DEFAULT_STACK_MODE);
		}

		fgets(s4, MAX_OPTIONLINE_LENGTH, fp);
		if (strcmp(s4, ARC_AUTORELEASE_TRUE_STRING) == 0){
			set_arc_autorelease(TRUE);
		} else if (strcmp(s4, ARC_AUTORELEASE_FALSE_STRING) == 0){
			set_arc_autorelease(FALSE);
		} else {			
			set_arc_autorelease(DEFAULT_ARC_AUTORELEASE);
		}

		fgets(s5, MAX_OPTIONLINE_LENGTH, fp);
		if (strcmp(s5, HYP_AUTORELEASE_TRUE_STRING) == 0){
			set_hyp_autorelease(TRUE);
		} else if (strcmp(s4, HYP_AUTORELEASE_FALSE_STRING) == 0){
			set_hyp_autorelease(FALSE);
		} else {			
			set_hyp_autorelease(DEFAULT_HYP_AUTORELEASE);
		}

		fclose(fp);
	} else {
		set_rpn_mode(DEFAULT_RPN_MODE);
		set_enter_mode(DEFAULT_ENTER_MODE);
		set_stack_mode(DEFAULT_STACK_MODE);
		error_occured("load_options(): could not open options file",
			      FALSE);
	}
}

void save_options(void)
{
	FILE *fp;

	fp = fopen(options_filename,"w");
	if( fp != NULL ){
		if (get_rpn_mode())
			fprintf(fp,"%s", RPN_TRUE_STRING);
		else
			fprintf(fp,"%s", RPN_FALSE_STRING);
		if (get_enter_mode() == ENTER_MODE_TRADITIONAL)
			fprintf(fp,"%s", ENTER_TRADITIONAL_STRING);
		else
			fprintf(fp,"%s", ENTER_HP28_STRING);
		if (get_stack_mode() == STACK_MODE_INFINITE)
			fprintf(fp,"%s", STACK_INFINITE_STRING);
		else
			fprintf(fp,"%s", STACK_XYZT_STRING);
		fclose(fp);
	} else
		error_occured("save_options(): could not open options file",
			      FALSE);
}
