﻿// For questions about the spanish hyphenation patterns
// ask Luis Pabon (lpabon at metagrama dot es)
Hyphenator.languages.es = {
	leftmin : 2,
	rightmin : 2,
	shortestPattern : 1,
	longestPattern : 13,
	specialChars : 'áéíóúñ',
	patterns : {
		2 : '1b1c1d1f1g1j1k1l1m1n1ñ1p1q1r1s1t1v1w1x1y1z',
		3 : '_a22bb2bc2bd2bf2bg2bj2bkb2l2bm2bn2bp2bqb2r2bs2bt2bv2bw2bx2by2bz2cb2cc2cd2cf2cgc4h2cjc2kc2l2cm2cn2cp2cqc2r2cs2ct2cv2cw2cx2cy2cz2db2dc2dd2df2dg2dj2dk2dl2dm2dn2dp2dqd2r2ds2dt2dv2dw2dx2dy2dz4e_4é_4és2fb2fc2fd2ff2fg2fj2fkf2l2fm2fn2fp2fqf2r2fs2ft2fv2fw2fx2fy2fz2gb2gc2gd2gf2gg2gj2gkg2l2gm2gn2gp2gqg2r2gs2gt2gv2gw2gx2gy2gz2hb2hc2hd2hf2hg2hj2hk2hl2hm2hn2hp2hq2hr2hs2ht2hv2hw2hx2hy2hz4í_2jb2jc2jd2jf2jg2jj2jk2jl2jm2jn2jp2jq2jr2js2jt2jv2jw2jx2jy2jz2kb2kc2kd2kf2kg2kj2kkk2l2km2kn2kp2kqk2r2ks2kt2kv2kw2kx2ky2kz2lb2lc2ld2lf2lg2lj2lkl4l2lm2ln2lp2lq2lr2ls2lt2lv2lw2lx2ly2lz2mb2mc2md2mf2mg2mj2mk2ml2mm2mn2mp2mq2mr2ms2mt2mv2mw2mx2my2mz2nb2nc2nd2nf2ng2nj2nk2nl2nm2nn2np2nq2nr2ns2nt2nv2nw2nx2ny2nz2o_2pb2pc2pd2pf2pg2pj2pkp2l2pm2pn2pp2pqp2r2ps2pt2pv2pw2px2py2pz2qb2qc2qd2qf2qg2qj2qk2ql2qm2qn2qp2qq2qr2qs2qt2qv2qw2qx2qy2qz2rb2rc2rd2rf2rg2rj2rk2rl2rm2rn2rp2rqr2r2rs2rt2rv2rw2rx2ry2rz2sb2sc2sd2sf2sg2sj2sk2sl2sm2sn2sp2sq2sr2ss2st2sv2sw2sx2sy2sz2tb2tc2td2tf2tg2tj2tk2tm2tn2tp2tqt2r2ts2tt2tv2twt2x2ty2tz2vb2vc2vd2vf2vg2vj2vkv2l2vm2vn2vp2vqv2r2vs2vt2vv2vw2vx2vy2vz2wb2wc2wd2wf2wg2wj2wkw2l2wm2wn2wp2wqw2r2ws2wt2wv2ww2wx2wy2wz2xb2xc2xd2xf2xg2xj2xk2xl2xm2xn2xp2xq2xr2xs2xt2xv2xw2xx2xy2xz2yb2yc2yd2yf2yg2yj2yk2yl2ym2yn2yp2yq2yr2ys2yt2yv2yw2yx2yy2yz2zb2zc2zd2zf2zg2zj2zk2zl2zm2zn2zp2zq2zr2zs2zt2zv2zw2zx2zy2zz',
		4 : '4ad_2al_4an_4ar_4as_4ás_2b1h2bl_2br_2ch_2cl_4cn_2cr_4ct_4cz_2d1h2dr_4ed_4en_4er_4es_2f1h2fl_2fr_4ft_2g2h2gl_4gn_2gr_2h1hi2a_4ía_i2o_2j1h2k2h2kl_2kr_2l1h2ll_mal22m1h4mn_2n1h2no_4ón_2os_4pc_2p1h2pl_4pn_2pr_4pt_2q1h2r1h2rr_3sa_2s1h2t1h2t2l2tr_4ts_4tz_2v1h2vl_2vr_2w1h2wl_2wr_2x1h2y1h2z1h',
		5 : '_an3h4áis_4ando4aos_bien2bio1heco1h4éis_4eos_geo1h4ían_i2as_4ías_i2os_iso1hmal3bmal3cmal3dmal3fmal3gmal3mmal3pmal3qmal3smal3tmal3v4meo_neo1ho2os_2ótic3sas_s3te_',
		6 : '_an2a2_an2á2_an2e2_an2é2_an2i2_an2í2_ani3m_aniña_ani3q_an2o2_an2ó2_an2u2_anu3l_bi1ox_bi1un_co2a2_co2á2_co2e2_co2é2_co2i2_co2í2_co3o4_co2ó2_co2u2_co2ú2_en2a2_en2á2_en2e2_en2é2_en1ej_en2i2_en2í2_en2o2_en2ó2_en2u2_en2ú2_in2a2_in2á2_in2e2_in2é2_in2i2_in2í2_in2o2_in2ó2_in2u2_in2ú2_re2a2_re2á2_re3e4_re2é2_re2i2_re2í2_re2o2_re2ó2_re1oc_re1oj_re2u2_re2ú24a3ba_acto1h4a3da_4adle_4adlo_4adme_4a3do_4adte_aero1hafro1haí5so_2ales_ana3líanfi1hante1h4a3ra_4a3rá_4a3re_4a3ré_a3rio_4a3se_4aste_asu3b24ates_auto1h2b3c2n2b3c2t2b3c2z2b3f2t2b3g2nbien3hbien3mbien3qbien3tbien3vbio1a2bio1á2bio1e2bio1é2bio1i2bio1í2bio1o2bio1ó2bio1u2bio1ú22b3m2n2b3p2n2b3p2s2b3p2t2b3t2s2b3t2z4caca44caga44cago42c3c2n2c3c2t2c3c2z2c3f2t2c3g2ncito1h2c3m2nco4artco4ártco4ercco4erzco4optco4ord2c3p2n2c3p2s2c3p2t2c3t2s2c3t2z4culo42d3c2n2d3c2t2d3c2zdeca1hde3seo2d3f2t2d3g2n2d3m2n2d3p2n2d3p2s2d3p2t2d3t2s2d3t2zeco1a2eco1á2eco1e2eco1é2eco1i2eco1í2eco1o2eco1ó2eco1u2eco1ú24edle_4edlo_4edme_4edte_emi2o2endo1hento1h4e3rá_4e3ré_4erla_4erle_4erlo_4erme_4erse_4erte_euco1heuro1hfono1hfoto1hgeo1a2geo1á2geo1e2geo1é2geo1i2geo1í2geo1o2geo1ó2geo1u2geo1ú2hemi1hhemo1hhexa1hhomo1h4íais_2i3ca_2i3co_4í3da_4í3do_4i4er_4i3ga_4i3go_4ísmo_iso1a2iso1á2iso1e2iso1é2iso1i2iso1í2iso1o2iso1ó2iso1u2iso1ú24ísta_kilo1h2l3c2n2l3c2t2l3c2z2l3f2t2l3g2n2l3m2n2l3p2n2l3p2s2l3p2t2l3t2s2l3t2zma4l3hmaxi1h2m3c2n2m3c2t2m3c2zmega1h2m3f2t2m3g2nmili1hmini1h2m3m2nmono1h2m3p2n2m3p2s2m3p2t2m3t2s2m3t2znamo1h2n3c2n2n3c2t2n3c2zneo1a2neo1á2neo1e2neo1é2neo1i2neo1í2neo1o2neo1ó2neo1u2neo1ú2neto1h2n3f2t2n3g2n2n3m2n2n3p2n2n3p2s2n3p2t2n3t2s2n3t2zocta1hocto1homni1h4ones_2o3sa_2o3so_para1h4pedo4poli1h3p2sic3p2siq4puta44puto42r3c2n2r3c2t2r3c2z2r3f2t2r3g2n2r3m2nromo1h2r3p2n2r3p2s2r3p2t2r3t2s2r3t2z2s3c2n2s3c2t2s3c2zsemi1h2s3f2t2s3g2n2s3m2n2s3p2n2s3p2s2s3p2ts3tal_s3tes_s3tor_2s3t2s2s3t2zsup6ra2t3c2n2t3c2t2t3c2ztele1h4teta_2t3f2t2t3g2n2t3m2ntopo1h2t3p2n2t3p2s2t3p2t2t3t2s2t3t2zu4teriwa3s4h2x3c2n2x3c2t2x3c2zxeno1h2x3f2t2x3g2n2x3m2n2x3p2n2x3p2s2x3p2t2x3t2s2x3t2z2y3c2n2y3c2t2y3c2z2y3f2t2y3g2n2y3m2n2y3p2n2y3p2s2y3p2t2y3t2s2y3t2z',
		7 : '_ana3li_aná3li_ane3xa_ane3xá_ane3xe_ane3xé_ani3ll_ano5ta_ano3tá_anti1h_an2ú2__anua3l_anu3bl_anu3da_bi1aur_bi1ó2x_en1apa_en1arb_en1art_he4mee_hu4mea_hu4meo_mala1e_pre2a2_pre2á2_pre2e2_pre2é2_pre2h2_pre2i2_pre2í2_pre2o2_pre2ó2_pre2u2_pre2ú2_pro2a2_pro2á2_pro2e2_pro2é2_pro2h2_pro2i2_pro2í2_pro2o2_pro2ó2_pro2u2_pro2ú2_re3abr_re3ábr_re3a2q_re3a2z_re3i2m_re3inc_re3ing_re3ins_re3int_re3o2b_re1unt_so3a4s4a3ban_4a3bas_acante2acto1a2acto1á2acto1e2acto1é2acto1i2acto1í2acto1o2acto1ó2acto1u2acto1ú24a3das_4adlas_4adles_4adlos_4adnos_4a3dor_4a3dos_aero1a2aero1á2aero1e2aero1é2aero1i2aero1í2aero1o2aero1ó2aero1u2aero1ú2afro1a2afro1á2afro1e2afro1é2afro1i2afro1í2afro1o2afro1ó2afro1u2afro1ú2aí5sos_4a3mos_anfi1a2anfi1á2anfi1e2anfi1é2anfi1i2anfi1í2anfi1o2anfi1ó2anfi1u2anfi1ú2anglo1hante1a2ante1á2ante1e2ante1é2ante1i2ante1í2ante1o2ante1ó2ante1u2ante1ú24áosla_4áosle_4áoslo_4a3ran_4a3rán_4a3ras_4a3rás_archi1h4a3ren_4a3res_4a3rés_4a3ría_a3rios_4a3rís_4a4rme_4a3ron_4a3ros_4a3sen_4a3ses_4astes_auto1a2auto1á2auto1e2auto1é2auto1i2auto1í2auto1o2auto1ó2auto1u2auto1ú2bi1u2ní4cagas_centi1hciclo1hcito1a2cito1á2cito1e2cito1é2cito1i2cito1í2cito1o2cito1ó2cito1u2cito1ú23c2neorcnico1hco4accico4actico4adjuco4adyuco3agenco4e3táco3exisco4imbrco4incico4i3tocon1urbcrono1hdeca1a2deca1á2deca1e2deca1é2deca1i2deca1í2deca1o2deca1ó2deca1u2deca1ú2decimo1desa3fidesa3fídesa3güde4s3eqde3signde3sollea3cia_ea3cio_4eadla_ecano1hectro1h4edlas_4edles_4edlos_4ednos_4e3dro_4eedla_4emboca4e3mos_endo1a2endo1á2endo1e2endo1é2endo1i2endo1í2endo1o2endo1ó2endo1u2endo1ú2ento1a2ento1á2ento1e2ento1é2ento1i2ento1í2ento1o2ento1ó2ento1u2ento1ú2entre1h4éosla_4éosle_4éoslo_e5r4ad_e5r4an_4e3rán_e5r4as_4e3rás_4e3rés_4e3ría_4e3rís_4erlas_4erles_4erlos_4ernos_4e3ros_euco1a2euco1á2euco1e2euco1é2euco1i2euco1í2euco1o2euco1ó2euco1u2euco1ú2euro1a2euro1á2euro1e2euro1é2euro1i2euro1í2euro1o2euro1ó2euro1u2euro1ú2expoli4extra1hfono1a2fono1á2fono1e2fono1é2fono1i2fono1í2fono1o2fono1ó2fono1u2fono1ú2foto1a2foto1á2foto1e2foto1é2foto1i2foto1í2foto1o2foto1ó2foto1u2foto1ú2gluco1hhecto1hhelio1hhemi1a2hemi1á2hemi1e2hemi1é2hemi1i2hemi1í2hemi1o2hemi1ó2hemi1u2hemi1ú2hemo1a2hemo1á2hemo1e2hemo1é2hemo1i2hemo1í2hemo1o2hemo1ó2hemo1u2hemo1ú2hexa1a2hexa1á2hexa1e2hexa1é2hexa1i2hexa1í2hexa1o2hexa1ó2hexa1u2hexa1ú2hidro1hhisto1hhomo1a2homo1á2homo1e2homo1é2homo1i2homo1í2homo1o2homo1ó2homo1u2homo1ú2ia5res_2i3cas_icono1h2i3cos_4i2dal_4í3das_4i3deo_4í3dos_4i3gas_4i3gás_4í3mos_infra1hintra1h4ísmos_4ístas_4í3tes_kilo1a2kilo1á2kilo1e2kilo1é2kilo1i2kilo1í2kilo1o2kilo1ó2kilo1u2kilo1ú2li5áreamacro1hmante4amaxi1a2maxi1á2maxi1e2maxi1é2maxi1i2maxi1í2maxi1o2maxi1ó2maxi1u2maxi1ú2mega1a2mega1á2mega1e2mega1é2mega1i2mega1í2mega1o2mega1ó2mega1u2mega1ú23mente_micro1hmili1a2mili1á2mili4armili1e2mili1é2mili1i2mili1í2mili1o2mili1ó2mili1u2mili1ú2mini1a2mini1á2mini1e2mini1é2mini1i2mini1í2mini1o2mini1ó2mini1u2mini1ú2miria1hmono1a2mono1á2mono1e2mono1é2mono1i2mono1í2mono1o2mono1ó2mono1u2mono1ú2multi1hnamo1a2namo1á2namo1e2namo1é2namo1i2namo1í2namo1o2namo1ó2namo1u2namo1ú2necro1hneto1a2neto1á2neto1e2neto1é2neto1i2neto1í2neto1o2neto1ó2neto1u2neto1ú2norte1hocta1a2octa1á2octa1e2octa1é2octa1i2octa1í2octa1o2octa1ó2octa1u2octa1ú2octo1a2octo1á2octo1e2octo1é2octo1i2octo1í2octo1o2octo1ó2octo1u2octo1ú24o2ica_4o2ico_oligo1homni1a2omni1á2omni1e2omni1é2omni1i2omni1í2omni1o2omni1ó2omni1u2omni1ú22o3sas_2o3sos_4ósteo_paleo1hpara1a2para1á2para1e2para1é2para1i2para1í2para1o2para1ó2para1u2para1ú2penta1hpiezo1hpluri1hpoi3de_poli1a2poli1á2poli1e2poli1é2poli1i2poli1í2poli1o2poli1ó2poli1u2poli1ú2pos3ta_pre3olíproto1hradio1hranco1hretro1hrmano1hromo1a2romo1á2romo1e2romo1é2romo1i2romo1í2romo1o2romo1ó2romo1u2romo1ú2san4c5tsemi1a2semi1á2semi1e2semi1é2semi1i2semi1í2semi1o2semi1ó2semi1u2semi1ú2seudo1hsobre1hsocio1hs3tora_supra1htalmo1htele1a2tele1á2tele1e2tele1é2tele1i2tele1í2tele1o2tele1ó2tele1u2tele1ú2termo1h4tetas_tetra1hti2o3coti2o3qutopo1a2topo1á2topo1e2topo1é2topo1i2topo1í2topo1o2topo1ó2topo1u2topo1ú2tropo1hultra1hxeno1a2xeno1á2xeno1e2xeno1é2xeno1i2xeno1í2xeno1o2xeno1ó2xeno1u2xeno1ú2',
		8 : '_an3aero_ane3xio_ane3xió_ani3dar_ani3mad_ani3mád_an3i2so_an3i2só_ani3vel_ano5che_ano5din_ano5mal_anó5mal_ano5nad_ano5nim_anó3nim_anti1a2_anti1á2_anti1e2_anti1é2_anti1i2_anti1í2_anti1o2_anti1ó2_anti1u2_anti1ú2_anua4lm_de2s2a2_de2s2á2_de2s2e2_de2s2é2_de2s2i2_de2s2í2_de2s2o2_de2s2ó2_de2s2u2_de2s2ú2_en1aciy_en1anch_en2artr_eno3jar_hepta1e_ina3nic_in3anim_iná3nim_in3apel_iné3dit_in3efic_ini3cia_ini3ciá_ini3cie_ino3cua_ino3cuo_intra1o_intra1u_inú3til_mal1est_mal1int_pos3tin_pos3tín_re3a2eg_re3alim_re3anim_re3aním_re3orga_retro1a_re3unir_re3unír_re3usar_re3usár_su2b2a2_su2b2á2_sub3arr_su2b2e2_su2b2é2_su2b2i2_su2b2í2_sub3ími_sub3índ_su2b2o2_su2b2ó2_su2b2u2_su2b2ú2_sur1est_sur1oes_tra2s1a_tra2s1o_tri1ó2x4a3bais_4a3ción_4ádmele_4ádmelo_4a3dora_4ádsela_4ádsele_4ádselo_4ádtele_4ádtelo_4ándola_4ándole_4ándolo_4ándome_4ándoos_4ándose_4ándote_anglo1a2anglo1á2anglo1e2anglo1é2anglo1i2anglo1í2anglo1o2anglo1ó2anglo1u2anglo1ú24áoslas_4áosles_4áoslos_4a3rais_archi1a2archi1á2archi1e2archi1é2archi1i2archi1í2archi1o2archi1ó2archi1u2archi1ú24a3reis_4a3réis_4a3ríais4a3rían_4a3rías_4a4r3la_4a4r3le_4a4r3lo_4árosla_4árosle_4ároslo_4a4r3se_4a4r3te_4a3seis_4asteis_biblio1hcardio1hcefalo1hcenti1a2centi1á2centi1e2centi1é2centi1i2centi1í2centi1o2centi1ó2centi1u2centi1ú2ciclo1a2ciclo1á2ciclo1e2ciclo1é2ciclo1i2ciclo1í2ciclo1o2ciclo1ó2ciclo1u2ciclo1ú2cnico1a2cnico1á2cnico1e2cnico1é2cnico1i2cnico1í2cnico1o2cnico1ó2cnico1u2cnico1ú2co4a3dunco4a3gulco4á3gulco4a3licco4aptacco4e3ficcon1imbrcontra1hco4o3perco4o3pércripto1hcrono1a2crono1á2crono1e2crono1é2crono1i2crono1í2crono1o2crono1ó2crono1u2crono1ú2de4s3abrde4s3agudesa3lindesa3livde4s3almdesa3lojde4s3anddesa3pañdesa3pegde4s3armdes4armede4s3asndesa3tindesa3yundesa3zondesa3zónde3semejde4s3endde4s3enjde4s3enmde4s3enrde4s3ensde3s4ertde3s4értde3siderde3sidiade3sidiode3siertde3socupde3solacde3soladde3soncede4s3ovade4s3ovide4s3oxide4s3oyede4s3oyéde3suelldodeca1hea3cias_ea3cios_ecano1a2ecano1á2ecano1e2ecano1é2ecano1i2ecano1í2ecano1o2ecano1ó2ecano1u2ecano1ú2ectro1a2ectro1á2ectro1e2ectro1é2ectro1i2ectro1í2ectro1o2ectro1ó2ectro1u2ectro1ú24édmele_4édmelo_4e3dros_4édsela_4édsele_4édselo_4édtele_4édtelo_entre1a2entre1á2entre1e2entre1é2entre1i2entre1í2entre1o2entre1ó2entre1u2entre1ú24éoslas_4éosles_4éoslos_e5r4áis_4e3réis_4e3rían_4e3rías_4e3rior_4érmele_4érmelo_4érsela_4érsele_4érselo_4értele_4értelo_extra1a2extra1á2extra1e2extra1é2extra1i2extra1í2extra1o2extra1ó2extra1u2extra1ú2gastro1hgluco1a2gluco1á2gluco1e2gluco1é2gluco1i2gluco1í2gluco1o2gluco1ó2gluco1u2gluco1ú2hecto1a2hecto1á2hecto1e2hecto1é2hecto1i2hecto1í2hecto1o2hecto1ó2hecto1u2hecto1ú2helio1a2helio1á2helio1e2helio1é2helio1i2helio1í2helio1o2helio1ó2helio1u2helio1ú2hemato1hhidro1a2hidro1á2hidro1e2hidro1é2hidro1i2hidro1í2hidro1o2hidro1ó2hidro1u2hidro1ú2hipe2r3rhisto1a2histo1á2histo1e2histo1é2histo1i2histo1í2histo1o2histo1ó2histo1u2histo1ú24ía3mos_icono1a2icono1á2icono1e2icono1é2icono1i2icono1í2icono1o2icono1ó2icono1u2icono1ú24i3deos_4i3gáis_infra1a2infra1á2infra1e2infra1é2infra1i2infra1í2infra1o2infra1ó2infra1u2infra1ú2inter4ésinter4inintra1a2intra1á2intra1e2intra1é2intra1i2intra1í2intra1o2intra1ó2intra1u2intra1ú24í4s3te_4ística_4ístico_macro1a2macro1á2macro1e2macro1é2macro1i2macro1í2macro1o2macro1ó2macro1u2macro1ú24meable_megalo1hmelano1hmicro1a2micro1á2micro1e2micro1é2micro1i2micro1í2micro1o2micro1ó2micro1u2micro1ú2miria1a2miria1á2miria1e2miria1é2miria1i2miria1í2miria1o2miria1ó2miria1u2miria1ú2multi1a2multi1á2multi1e2multi1é2multi1i2multi1í2multi1o2multi1ó2multi1u2multi1ú2necro1a2necro1á2necro1e2necro1é2necro1i2necro1í2necro1o2necro1ó2necro1u2necro1ú2norte1a2norte1á2norte1e2norte1é2norte1i2norte1í2norte1o2norte1ó2norte1u2norte1ú24o2icas_4o2icos_o4i3dal_4o2i3de_o4i3dea_oligo1a2oligo1á2oligo1e2oligo1é2oligo1i2oligo1í2oligo1o2oligo1ó2oligo1u2oligo1ú24ó3loga_4ó3logo_4ósteos_paleo1a2paleo1á2paleo1e2paleo1é2paleo1i2paleo1í2paleo1o2paleo1ó2paleo1u2paleo1ú2para2is_para4ísopenta1a2penta1á2penta1e2penta1é2penta1i2penta1í2penta1o2penta1ó2penta1u2penta1ú2piezo1a2piezo1á2piezo1e2piezo1é2piezo1i2piezo1í2piezo1o2piezo1ó2piezo1u2piezo1ú2plan4c5tpluri1a2pluri1á2pluri1e2pluri1é2pluri1i2pluri1í2pluri1o2pluri1ó2pluri1u2pluri1ú2poi3des_poli4arqpoli4árqpoli4u3rpos3tas_pre3eligpre3elijpre3eminpre3exispreo3cuppreo2cúppre3opinproto1a2proto1á2proto1e2proto1é2proto1i2proto1í2proto1o2proto1ó2proto1u2proto1ú2radio1a2radio1á2radio1e2radio1é2radio1i2radio1í2radio1o2radio1ó2radio1u2radio1ú2ranco1a2ranco1á2ranco1e2ranco1é2ranco1i2ranco1í2ranco1o2ranco1ó2ranco1u2ranco1ú2retro1a2retro1á2retro1e2retro1é2retro1i2retro1í2retro1o2retro1ó2retro1u2retro1ú2rmano1a2rmano1á2rmano1e2rmano1é2rmano1i2rmano1í2rmano1o2rmano1ó2rmano1u2rmano1ú2seudo1a2seudo1á2seudo1e2seudo1é2seudo1i2seudo1í2seudo1o2seudo1ó2seudo1u2seudo1ú2sobre1a2sobre1á2sobre1e2sobre1é2sobre1i2sobre1í2sobre1o2sobre1ó2sobre1u2sobre1ú2socio1a2socio1á2socio1e2socio1é2socio1i2socio1í2socio1o2socio1ó2socio1u2socio1ú2s3toras_s3tores_su4d3oessupe2r3rsupra1a2supra1á2supra1e2supra1é2supra1i2supra1í2supra1o2supra1ó2supra1u2supra1ú2talmo1a2talmo1á2talmo1e2talmo1é2talmo1i2talmo1í2talmo1o2talmo1ó2talmo1u2talmo1ú23te3ri3ntermo1a2termo1á2termo1e2termo1é2termo1i2termo1í2termo1o2termo1ó2termo1u2termo1ú2tetra1a2tetra1á2tetra1e2tetra1é2tetra1i2tetra1í2tetra1o2tetra1ó2tetra1u2tetra1ú2trans4artrans4ittropo1a2tropo1á2tropo1e2tropo1é2tropo1i2tropo1í2tropo1o2tropo1ó2tropo1u2tropo1ú2ultra1a2ultra1á2ultra1e2ultra1é2ultra1i2ultra1í2ultra1o2ultra1ó2ultra1u2ultra1ú2',
		9 : '_bi1anual_bien1and_bien1apa_bien1ave_bien1est_bien1int_dieci1o2_en1aceit_en1aguaz_enu3mera_enu3merá_enu3mere_in3abarc_in3abord_in3acent_in3adapt_in3aplic_in3arrug_in3asist_in3efici_in3eludi_ine3narr_ino3cula_ino3culá_ino3cule_inte2r3r_mal1acon_mal1acos_pos2t2a2_pos2t2á2_pos2t2e2_pos2t2é2_pos3terg_pos2t2i2_pos2t2í2_post3ind_pos2t2o2_pos2t2ó2_post3ope_post3rev_pos2t2u2_pos2t2ú2_re3afirm_re3afírm_re3ajust_rea3júst_rea3lism_rea3list_rea3liza_rea3lizá_rea3líza_re3ubica_re3ubíca_reu3mati_reu3máti_su3b4ien_sub2i3ll_su4b3ray_sub3urba_su2d1est_sur1a2me_tele1imp_tele1obj_tra2s2oñ4á3bamos_4ád3mela_4ádmeles_4ádmelos_4ádnosla_4ádnosle_4ádnoslo_4a3doras_4a3dores_4ádselas_4ádseles_4ádselos_4ád3tela_4ádteles_4ádtelos_4a4i3gan_4ándolas_4ándoles_4ándolos_4ándonos_4á3ramos_4a3remos_4á3remos_4a4r3las_4a4r3les_4a4r3los_4á4rmele_4á4rmelo_4a4r3nos_4ároslas_4árosles_4ároslos_4á3semos_biblio1a2biblio1á2biblio1e2biblio1é2biblio1i2biblio1í2biblio1o2biblio1ó2biblio1u2biblio1ú2b4ien3do_cardio1a2cardio1á2cardio1e2cardio1é2cardio1i2cardio1í2cardio1o2cardio1ó2cardio1u2cardio1ú2cefalo1a2cefalo1á2cefalo1e2cefalo1é2cefalo1i2cefalo1í2cefalo1o2cefalo1ó2cefalo1u2cefalo1ú2contra1a2contra1á2contra1e2contra1é2contra1i2contra1í2contra1o2contra1ó2contra1u2contra1ú2cripto1a2cripto1á2cripto1e2cripto1é2cripto1i2cripto1í2cripto1o2cripto1ó2cripto1u2cripto1ú2desa3briddesa3certde4s3acotde4s3aficde4s3afilde4s3afinde4s3afordesa3garrde4s3ahijde4s3aliñdesa3marrdesa3moblde4s3anidde4s3animde4s3anímde4s3anudde4s3apoyde4s3arende4s3avisde4s3empéde4s3enamde4s3enchde4s3enclde4s3encode4s3encrde4s3encude3senfadde3senfádde4s3enfide4s3enfode4s3enfóde3sengañde3sengáñde4s3enlode4s3entade4s3entode4s3entrde4s3entude3s4ercide4s3espade3sesperde3sigualde3siluside4s3imande3sinencde3sinfecde4s3inflde3sistende4s3odorde4s3ordede4s3órdede4s3orejde3s4osegde3su3dande3su3darde3su3dasde4s3unimde4s3unirdodeca1a2dodeca1á2dodeca1e2dodeca1é2dodeca1i2dodeca1í2dodeca1o2dodeca1ó2dodeca1u2dodeca1ú24éd3mela_4édmeles_4édmelos_4édnosla_4édnosle_4édnoslo_4é3drica_4é3drico_4édselas_4édseles_4édselos_4éd3tela_4édteles_4édtelos_e5r4a3ba_e5r4a3da_e5r4a3do_e5r4a3ra_e5r4a3rá_e5r4a3re_e5r4a3ré_e5r4a3se_e5r4aste_e5r4ates_4e3ríais_4e3riora_4ér3mela_4érmeles_4érmelos_4érnosla_4érnosle_4érnoslo_4é3rosla_4é3rosle_4é3roslo_4érselas_4érseles_4érselos_4ér3tela_4érteles_4értelos_gastro1a2gastro1á2gastro1e2gastro1é2gastro1i2gastro1í2gastro1o2gastro1ó2gastro1u2gastro1ú2hemato1a2hemato1á2hemato1e2hemato1é2hemato1i2hemato1í2hemato1o2hemato1ó2hemato1u2hemato1ú2hipe2r1a2hipe2r1á2hipe2r1e2hipe2r1é2hipe2r1i2hipe2r1í2hipe2r1o2hipe2r1ó2hipe2r1u2hipe2r1ú24i2dales_4i3gamos_inter4inointer4ior4ís3teis_4í4s3tes_4ísticas_4ísticos_4meables_megalo1a2megalo1á2megalo1e2megalo1é2megalo1i2megalo1í2megalo1o2megalo1ó2megalo1u2megalo1ú2melano1a2melano1á2melano1e2melano1é2melano1i2melano1í2melano1o2melano1ó2melano1u2melano1ú2mili4arioo4i3deas_4o2i3des_4ó3logas_4o3logía_4ó3logos_pe5r4antepoli4andrpoli4éstes3ta3les_s3ti3lla_supe2r1a2supe2r1á2supe2r1e2supe2r1é2supe2r1i2supe2r1í2super4iorsupe2r1o2supe2r1ó2supe2r1u2supe2r1ú2t4eo3nes_tran4sacctrans4ido',
		10 : '_an3e2pigr_ante2o3je_en1aguach_in3aguant_ina3movib_in3analiz_in3apreci_in3aprens_inte2r1a2_inte2r1á2_inte2r1e2_inte2r1é2_inte2r1i2_inte2r1í2_inte2r1o2_inte2r1ó2_inte2r1u2_inte2r1ú2_inu3tiliz_ma4l3e4du_pa4n1afri_pa4n1ópti_post3elec_pos3te3ri_pos3ti3go_pos3ti3la_post3impr_pos3ti3ne_pos3ti3za_pos3ti3zo_pos3tó3ni_pos3tu3la_pos3tu3lá_pos3tu3le_pos3tu3lé_pos3tu3ra_re3a2grup_re3aparec_re3utiliz_re3utilíz_sub3aflue_sub3enten_sub3estim_sub3estím_sub3ofici_su2d1a2fr_su2d1a2me_tran2s1ur4a3ciones_4ád3melas_4ádnoslas_4ádnosles_4ádnoslos_4ád3telas_4ándomela_4ándomele_4ándomelo_4ándosela_4ándosele_4ándoselo_4ándoseme_4ándotela_4ándotele_4ándotelo_4ándoteme_4a3ríamos_4á4r3mela_4á4r3sela_4á4r3sele_4á4r3selo_4á4r3tela_4á4r3tele_4á4r3telo_b4ien3das_centi5áreaco3n4imbride4s3abastde4s3abollde4s3abotode4s3aceitdesa3ciertde4s3acompde4s3aconsde4s3acoplde4s3acorrde4s3activde4s3adeudde4s3adornde4s3aferrde4s3agradde4s3agregde4s3agrupde4s3aherrde4s3ajustde4s3alentde4s3alfomde4s3alforde4s3aliende4s3alinede4s3almidde4s3alterde4s3amoldde4s3amortde4s3angeldesa3pacibde4s3apadrde4s3aparedesa3parecdesa3paricde4s3aplicde4s3apretde4s3aprobde4s3arbolde4s3arrimdesa3rrollde4s3arropde4s3arrugde4s3asentde4s3asistdesa3sosegde4s3atencde4s3atendde4s3atentde4s3atornde4s3autorde4s3embalde4s3embálde4s3embarde4s3embárde4s3embotde4s3empacde4s3empañde4s3empáñde4s3empatde4s3empegde4s3emplede4s3empozde4s3encabde4s3encadde4s3encajde4s3encájde4s3encamde3sencantde4s3encapde4s3encarde4s3encárde3senfrende4s3enfurde4s3engarde4s3engasde4s3engomde4s3engozde4s3engrade4s3enladde4s3enlazde3sentendde4s3enterde3sentiende3sentiénde4s3estimde4s3imponde4s3inhibde3s4interde4s3intoxde4s3inverde4s3obligde4s3obstrde4s3ub4icde4s3unierde3s4ustane4a3miento4éd3melas_4édnoslas_4édnosles_4édnoslos_4é3dricas_4é3dricos_4éd3telas_e5r4a3ban_e5r4a3bas_4e3ra3ble_e5r4a3das_e5r4a3dor_e5r4a3dos_e5r4a3mos_e5r4a3ran_e5r4a3rán_e5r4a3ras_e5r4a3rás_e5r4a3ren_e5r4a3res_e5r4a3rés_e5r4a3ría_e5r4a3rís_e5r4a3ron_e5r4a3sen_e5r4a3ses_e5r4astes_4e3re3mos_4e3ríamos_4e3rioras_4e3riores_4ér3melas_4érnoslas_4érnosles_4érnoslos_4é3roslas_4é3rosles_4é3roslos_4ér3telas_familia3riinter4esarmini4a5turo4i3dales_4o3logías_4o3lógica_4o3lógico_para4ulatape3r4e3miaperpon5d6rpoli4anteapoli4o5mies3ti3llas_s3ti3llón_super4ablesupe4r4a3rsupe4r4á3rtrans4ibertrans4igentrans4igirtrans4itabultra4ísmo',
		11 : '_mal1andant_mal1andanz_pa4n1europ_sub2i3mien_tran2s1alp_tran2s1and_tran2s1atl_tran2s1oce4ándomelas_4ándomeles_4ándomelos_4ándoselas_4ándoseles_4ándoselos_4ándosenos_4ándotelas_4ándoteles_4ándotelos_4ándotenos_4á4r3melas_4á4r3meles_4á4r3melos_4á4r3nosla_4á4r3nosle_4á4r3noslo_4á4r3selas_4á4r3seles_4á4r3selos_4á4r3telas_4á4r3teles_4á4r3telos_de4s3abrochde4s3acelerde4s3acobarde4s3acomoddesa3cralizde4s3acuartde4s3aderezde4s3adorarde4s3advertde4s3agracide4s3agravide4s3alagarde4s3alquilde4s3alumbrde4s3amuebldesa3percibde4s3aprenddesa3prenside4s3aprietde4s3apropide4s3arraigde4s3arreglde4s3arrenddesa3sosiegde4s3atiendde4s3atrancde4s3embargde4s3embolsde4s3emborrde4s3emboscde4s3embragde4s3embrágde4s3embrujde4s3embrújde4s3empedrde4s3empeorde4s3empernde4s3empolvde4s3empotrde4s3encallde4s3encállde4s3enfundde4s3enhebrde4s3entierde4s3entiérde4s3envainde3sesperacde4s3imaginde4s3impresde4s3incentde4s3inclinde4s3incorpde4s3inflamde4s3informde4s3insectde4s3instalde3s4integrde4s3obedecde3s4ubstane5r4a3bais_4e3ra3bles_e5r4a3dora_e5r4a3rais_e5r4a3reis_e5r4a3réis_e5r4a3ríaise5r4a3rían_e5r4a3rías_e5r4a3seis_e5r4asteis_4i3gá3moos_4o3lógicas_4o3lógicos_2o3samente_super4ación4te4r5i4nsutrans4eúntetrans4icióntrans4istortrans4ubsta',
		12 : '_in3ter2e3sa_in3ter2e3sá_in3ter2e3se_in3ter2e3sé_in3ter2e3so_in3ter2e3só_in3te3r4rog_pa4n1a4meri4á4r3noslas_4á4r3nosles_4á4r3noslos_deca2i3mientde4s3acostumde4s3acreditde4s3adormecdesa3guisadode4s3apolillde4s3articulde4s3embravede4s3embrávede4s3embrollde4s3embróllde4s3emparejde4s3emparéjde4s3emperezde4s3enganchde3senvolvimde4s3estabilde4s3impresXde4s3incruste5r4á3bamos_e5r4a3doras_e5r4a3dores_e5r4á3ramos_e5r4a3remos_e5r4á3remos_e5r4á3semos_4e3rioridad_4i3gá3monos_4i3gá3mosla_4i3gá3mosle_4i3gá3moslo_4i3gá3mosme_4i3gá3moste_s3ti3llones_trans4itorio',
		13 : '_in3te3r4rump_in3te3r4rupc_in3te3r4ruptde4s3aprovechde4s3empaquetde4s3empaquétde4s3emparentde4s3esperanze5r4a3ríamos_4e3riormente_4i3gá3moosla_4i3gá3moosle_4i3gá3mooslo_4i3gá3mosela_4i3gá3mosele_4i3gá3moselo_4i3gá3moslas_4i3gá3mosles_4i3gá3moslos_supe3r4á3vit_',
		14 : '4e3rioridades_4i3gá3monosla_4i3gá3monosle_4i3gá3monoslo_4i3gá3mooslas_4i3gá3moosles_4i3gá3mooslos_4i3gá3moselas_4i3gá3moseles_4i3gá3moselos_4i3gá3mosmele_4i3gá3mosmelo_4i3gá3mostele_4i3gá3mostelo_supe3r4á3vits_',
		15 : '4e3ra3blemente_4i3gá3monoslas_4i3gá3monosles_4i3gá3monoslos_4i3gá3mos3mela_4i3gá3mosmeles_4i3gá3mosmelos_4i3gá3mos3tela_4i3gá3mosteles_4i3gá3mostelos_4o3lógicamente_',
		16 : '4i3gá3mos3melas_4i3gá3mos3telas_',
		17 : '_de3s4in3ter2e3sa_de3s4in3ter2e3sá_de3s4in3ter2e3se_de3s4in3ter2e3sé_de3s4in3ter2e3so_de3s4in3ter2e3só'
	}
};