// Generic resizable hash table

#include "global.h"

typedef struct _rhash_entry rhash_entry;
typedef struct _rhash rhash;

struct _rhash_entry {
  rhash_entry* next;
  UInt hash;
};

struct _rhash {
  /* for statistics output */
  char* name;

  UInt size;
  rhash_entry* (*new_entry)(void*);
  Bool (*has_key)(rhash_entry*, void*);

  UInt entries;
  UInt resizes;
  rhash_entry** table;
};
  
void SK_(rhash_init)(rhash*);
rhash_entry* SK_(rhash_get)(rhash*, int hash, void* data);
void SK_(rhash_forall)(rhash*, void (*f)(rhash_entry*) );
