/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2001 The Caudium Group
 * Based on IMHO  Stefan Wallstrm and Bosse Lincoln.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * $Id: functions.h,v 1.10.2.1.2.1 2001/09/30 23:20:16 kiwi Exp $
 */

#include "ldap.h"

string fix_coding (string str) {
  if (!str)
    return "?";

  array a = Array.map ((str / " "), MIME.decode_word);
  string spaces = " ";
  string ret = "";
  if (sizeof (a)) {
    mixed err = catch { ret += Locale.Charset.decoder (a[0][1])->feed (a[0][0])->drain (); };
    if (err) {
      //write ("fix_coding: " + err[0] + "\n");
      ret += a[0][0];
    }
  }

  int last_coded = sizeof (a) && a[0][1];
  for (int i = 1; i < sizeof (a); i++) {
    if (a[i][0] != "") {
      if (!(last_coded && a[i][1]))
	ret += spaces;
      mixed err = catch { ret += Locale.Charset.decoder (a[i][1])->feed (a[i][0])->drain (); };
      if (err) {
	//write ("fix_coding: " + err[0] + "\n");
	ret += a[i][0];
      }
      spaces = " ";
      last_coded = !!a[i][1];
    }
    else {
      if (last_coded)
	spaces += " ";
      else
	ret += " ";
    }
  }
  //write ("fix_coding (" + str + ") = [" + ret + "]\n");
  return ret;
}

array
address_split(string s) {
  array i=({ 0 });
  return (Array.map(s/"\"",
		    lambda(string s,array i){return (i[0]=i[0]?0:1)?replace(s,({",",";"}),({"\0","\0"})):s;},
		    i)*"\"")/"\0";
}

// Make sure the all email addresses are on correct form
array fixaddresses(string addr) {
  array ret = ({ "", "" });
  foreach(address_split(addr), string s) {
    string fixedaddr = "";
    string name = "", address = "";
    int endlimit = ')';
    int pos = 0,pos2=0, quote = 0;
    int broken = 0;
    while (pos < sizeof(s) && ( quote || 
				(s[pos] != '(' && s[pos] != '<'))) {
      if (s[pos] == '"')
	quote = quote?0:1;
      pos++;
    }
    if (pos < sizeof(s)) {
      if (s[pos] == '<') {
	endlimit = '>';
	if (pos > 1)
	  name = s[0..pos-2];
      } else {
	if (pos > 1)
	  address = s[0..pos-2];
      }
      pos++;
      pos2 = pos;
      while (pos < sizeof(s) && ( quote || s[pos] != endlimit)) {
	if (s[pos] == '"')
	  quote = quote?0:1;
	pos++;
      }
      if (pos == sizeof(s))
	broken = 1;
      if (endlimit == '>')
	address = s[pos2..pos-1];
      else
	name = s[pos2..pos-1];
    } else {
      address = s;
    }
    while (sizeof(name) > 0 && name[0] == ' ')
      name = name[1..];
    while (sizeof(name) > 0 && name[-1] == ' ')
      name = name[0..sizeof(name)-2];
    while (sizeof(address) > 0 && address[0] == ' ')
      address = address[1..];
    while (sizeof(address) > 0 && address[-1] == ' ')
      address = address[0..sizeof(address)-2];
    if (search(address, " ") >= 0)
      broken = 1;
    if (name == "")
      fixedaddr = address;
    else {
      name = replace(name, "\"", "");
      fixedaddr = "\""+name+"\" <"+address+">";
    }
    if (sizeof(ret[0]) == 0)
      ret[0] = fixedaddr;
    else
      ret[0] += ", "+fixedaddr;
    if (broken)
      ret[1] = s;
  }
  return(ret);
}

string fixstring (string s) {
  //if(!s) s="";
  //return replace(s,({"<",">","&","\n", "\r"}),({"&lt;","&gt;","&amp;","<br />", "" }));
  return (s ? 
	  replace (s, ({"<",">","&","\n", "\r", "\""}), ({"&lt;","&gt;","&amp;","<br />", "", "&quot;" }))
	  : "");
}

string fix_header (string str) {
  if (!str || !sizeof (str))
    return "?";
  else {
    string tmp = fix_coding (str);
    // Experimentat RFC1522 decoding of headers
    tmp = MIME.decode_word(tmp)[0];
    return replace (tmp,
		    ({ "<", ">", "&", "\n", "\r" }),
		    ({ "&lt;", "&gt;", "&amp;", "<br />", "" }));
  }
}

// IMAP Client
#define CMD_VAR_POINTER 0x12149313

inline array (string) imap_cmd_var (string var) {
  return ({ CMD_VAR_POINTER, var });
} 

inline mapping imap_cmd (string cmd, mixed ... args) {
  mapping _imap_cmd = ([ ]);

  _imap_cmd->cmd = cmd;
  _imap_cmd->abortfail = 1;
  for (int i = 0; i + 1 < sizeof (args); i += 2)
    _imap_cmd[args[i]] = args[i + 1];
  return _imap_cmd;
}
