/*
  imho_hungarian.pike v0.3 for IMHO v0.97.1
  
  Copyright  
  Tams Tevesz <ice@telnet.hu> 2000

  Language fixes by 
  Laszlo Vertike <tike@agria.hu>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.

*/

#include <camas/language.h>

string imho_lang() {
  return "Magyar";
}

string imho_lang_short() {
  return "hu";
}

string imho_lang_charset() {
  return "iso-8859-2";
}

string imho_lang_replacement_string() {
  //this is a UNICODE string that MUST be encodable by the local charset
  return "?";
}

string msg(object sessobj,int m,array arg) {
  switch(m) {
    
    // Login page
    
  case M_LOGIN:
    //return "Login:";
    return "Azonost:";
  case M_PASSWORD:
    //return "Password:";
    return "Jelsz:";
  case M_NOLOGIN:
    //return "<b>Zalogowanie niemoliwe:</b> Ze haso lub nazwa uytkownika. Sprbuj ponownie. ";
    return "<b>Sikertelen belps:</b> Rossz azonost vagy jelsz, prblja jra. ";
  case M_IMAPERROR:
    //return "There was a problem talking to the mail (IMAP) server. Please contact the administrator.";
    return "A bejv levelek kezelst vgz (IMAP) kiszolglval val kommunikci kzben hiba lpett fel, krem lpjen kapcsolatba az adminisztrtorral.";
  case M_SMTPERROR:
    //return "There was a problem talking to the outgoing mail (SMTP) server. The recipient of the mail might not exist.";
    return "A kimen levelek kezelst vgz (SMTP) kiszolglval val kommunikci kzben hiba lpett fel. (tipp: lehet, hogy a levl cmzettje nem ltezik ?)";
  case M_SAVEDUSERINTERFACE:
    //return "From preferences";
    return "A felad belltsok";
  case M_USERINTERFACE:
    //return "User interface:";
    return "Felhasznli fellet:";
  case M_LOGIN_OK:
    //return "OK";
    return "OK";

  case M_NEWMAIL:
    //return "Compose";
    return "j levl";
  case M_MAILBOX:
    //return sprintf("Mailbox: %s",@arg);
    return sprintf("Mappa: %s",@arg);
  case M_MAILBOXES:
    //return "Mailboxes";
    return "Mappk";
  case M_FILES:
    //return "Files";
    return "Fjlok";
  case M_PREFS:
    //return "Preferences";
    return "Belltsok";
  case M_LOGOUT:
    //return "Logout";
    return "Kilps";
  case M_CURRMAILBOX:
    // return "Current Mailbox";
    return "Aktulis mappa";
  case M_CHECKACTIVEMAILBOXES:
    // return "Check active mailboxes";
    return "Aktv mappk ellenrzse";

  case M_FROM:
    //return "From";
    return "Felad";
  case M_TO:
    //return "To";
    return "Cmzett";
  case M_CC:
    //return "Cc";
    return "Msolatot kap";
  case M_BCC:
    //return "Bcc";
    return "Vak msolatot kap";
  case M_SUBJECT:
    //return "Subject";
    return "Trgy";
  case M_ATTACHMENTS:
    //return "Attachments";
    return "Kapcsolt fjlok";
  case M_TIME:
    //return "Time";
    return "Id";
  case M_DATE:
    //return "Date";
    return "Dtum";
    
  case  M_MARKFLAG:
    //return "M";
    return "J";
  case M_NEWFLAG:
    //return "N";
    return "";
  case M_ANSWEREDFLAG:
    //return "A";
    return "V";
    
    
  case M_SEND:
    //return "Send";
    return "Klds";
  case M_CANCELSEND:
    //return "Cancel";
    return "Mgse";
  case M_SENDMOREFILES:
    //return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
    return "Vlassza ki az elkldend fjlokat. Tbb fjl kijellse a 'Ctrl' gomb nyomva tartsval lehetsges";
  case M_COMPOSEMAIL:
    //return "Compose mail";
    return "j levl";
  case M_SPELLCHECK:
    // return "Sprawd ortografi";
    return "Helyesrs-ellenrzs";
  case M_DONTSAVEMAIL:
    //return "Do not save this mail.";
    return "Ne mentsem el ezt a levelet.";
  case M_ADDFILEASATTACHMENT:
    //return "Add file as attachment";
    return "A fjlok kapcsolt dokumentumknt kerljenek tovbbtsra";
  case M_NOATTACHMENTS:
    //return "No attachments";
    return "Nincs kapcsolt dokumentum";
  case M_ADDATTACHMENT:
    //return "Add attachment...";
    return "Kapcsolt dokumentum hozzadsa";
  case M_REMOVEMARKEDATTACHMENTS:
    //return "Remove marked attachments";
    return "A megjellt kapcsolt dokumentumok eltvoltsa";
  case M_UPLOADATTACHMENT:
    //return "Upload attachment";
    return "A kapcsolt dokumentumok feltltse";
  case M_ADDMARKEDTOATTACHMENTS:
    //return "Add marked to attachments";
    return "A kijellt fjlok hozzadsa a kapcsolt dokumentumok listjhoz";
  case M_UPLOADTOATTACHMENTS:
    //return "Upload to attachments";
    return "Feltlts a kapcsolt dokumentumokhoz";
  case M_BACKTOCOMPOSE:
    //return "Back to compose";
    return "Visszatrs a levlrshoz";
  case M_NOATTACHFILES:
    //return "No files";
    return "Nincsenek fjlok";
  case  M_ATTACHMENTSHEADER:
    return "Csatols";
  case M_SENDSAVEFAILED:
    //return "Mail was sent successfully, but save in folder failed.";
    return "A levl elkldse sikeres, de az elkldtt levelek mappba nem sikerlt elmenteni.";
  case M_SENDNORECV:
    //return "You must specify a recipient of the mail.";
    return "Meg kell adnia a levl cmzettjt.";
  case M_DSN_DELAY:
    //return("Report delayed delivery.");
    //FIXME!
    return "(A levelet ksleltetve kzbestik.)";
  case M_DSN_SUCCESS:
    // return("Report successful delivery.");
    //FIXME!
    return "(A levl kzbestse sikeresen megtrtnt.)";

  case M_DELETEMARKED:
    //return "Delete marked";
    return "A kijellt levelek trlse";
  case M_MOVEMARKED:
    //return "Move marked to";
    return "A kijellt levelek mozgatsa msik mappba";
  case M_SELECTMBOX:
    //return "(Select a mailbox)";
    return "(Vlasszon ki egy mappt)";
  case M_CHECKNEWMAIL:
    //return "Check for new mail";
    return "j levelek letltse";
  case M_MAILSHOWN:
    // return sprintf("Mail %d-%d of %d", @arg);
    return sprintf("A(z) %d. levl a %d levlbl", @arg);
  case M_BACKN:
    //return sprintf("[<< Prev %d]", @arg);
    return sprintf("[<< Elz %d]", @arg);
  case M_FORWARDN:
    // return sprintf("[Next %d >>]", @arg);
    return sprintf("[Kvetkez %d >>]", @arg);
  case M_NUMBER:
    return "#";
  case M_DELETEMARKEDP:
    //sprintf("Are you sure you want to delete the %d marked message(s)?", 
    return 
      sprintf("Biztosan trlni akarja mind a(z) %d kijellt levelet ?", @arg);
  case M_DELETEMARKEDNONE:
    //return "Please mark some messages first.";
    return "Ki kell jellnie legalbb egy levelet.";
  case M_CHANGESORTORDER:
    //return "Change sort order";
    return "A megjelentsi sorrend megvltoztatsa";
  case M_MOVETOTRASH:
    //return "Move marked to trash";
    return "A kijellt levelek mozgatsa a szemetesbe";
  case M_DELETEALLTRASH:
    //return "Delete ALL trash";
    return "A szemetes trlse";
  case M_NOMAILS:
    // return "[No mail]";
    return "[Nincs levl]";
  case M_MARKALL:
    //return "Mark all";
    return "Az sszes levl kijellse";

  case M_MBOXNAME:
    //return "Mailbox";
    return "Mappa";
  case M_DELETEMARKEDMBOX:
    //return "Delete marked";
    return "A kijellt mappa trlse";
  case M_CREATEMBOX:
    //return "Create a new mailbox";
    return "j mappa ltrehozsa";
  case M_NEWMBOXNAME:
    //return "(Name)";
    return "(A mappa neve)";
  case M_MBOXREMOVEP:
    //return "Are you sure you want to delete the following mailboxes?";
    return "Biztosan trlni akarja a kvetkez mappkat?";
  case M_MBOXMARKONE:
    //return "Mark at least one mailbox.";
    return "Legalbb egy mappt ki kell jellnie";
  case M_NEWMBOXNONAME:
    // return "Type in a name first.";
    return "Krem rja be az j mappa nevt";
  case M_CREATEMBOXERROR:
    //return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
    return "A mappa ltrehozsa sikertelen. Vagy nem megengedett a mappa neve, vagy a mappa mr ltezik.";
  case M_INBOX:
    //return "Inbox";
    return "Bejv levelek";
  case M_PREVIOUS_LEVEL:
    //return "[Poprzedni poziom]";
    return "[Elz szint]";
  case M_FOLDER_PATH:
    //return "Path:";
    return "Elrsi t:";
	
  case M_FILENAME:
    //return "Filename";
    return "Fjlnv";
  case M_SIZE:
    //return "Size";
    return "Mret";
  case M_MIMETYPE:
    //return "Type";
    return "Tpus";
  case M_DELETEMARKEDFILES:
    //return "Delete marked";
    return "A kijellt fjlok trlse";
  case M_UPLOAD:
    //return "Upload";
    return "Feltlts";
  case M_AVAILSPACE:
    //return sprintf("You have %d Kb available for upload.",@arg);
    return sprintf("%d kbyte feltltsre van lehetsg",@arg);
  case M_WINDOWSBUG :
    //return "Windowsusers: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
    return "Windows felhasznlk: nhny bngsz rosszul mkdik, megvltoztathatja a fjl nevt. Ezt elkerlend, az utols \\-t cserlje le \\\\-re, s utna nyomja meg a 'Klds' gombot.";
  case M_NOFILES:
    //return "You have no uploades files.";
    return "Nincs feltlttt fjl.";

  case M_PNAME:
    //return "Name";
    return "Nv";
  case M_PMAILADDRESS:
    //return "Mail address";
    return "E-mail cm";
  case M_PMAILPATH:
    //return "Mail searchpath";
    return "Levl elrsi tja";
  case M_PINCLUDEMAIL:
    //return "Include mail when replying";
    return "Vlaszadskor az eredeti levl beidzse";
  case M_PQUOTEPREFIX :
    //return "Prefix";
    return "Eltag";
  case M_PSIGNATURE:
    //return "Signature";
    return "Alrs";
  case M_PINACTIVELOGOUT:
    //return "Inactive logout (minutes)";
    return "Automatikus kilps (perc)";
  case M_PSAVEANDUSE:
    //return "Save and use";
    return "Belltsok mentse s rvnyestse";
  case M_PVISIBLEMESSAGES:
    //return "Messages shown in mailbox";
    return "A Postaldban tallhat levelek";
  case M_PSORTORDER:
    //return "Mail sort order";
    return "Rendezs irnya";
    case M_PSORTORDERS:
    //return ([ "forward": "forward", "backward":"backward"])[arg[0]];
    return ([ "forward": "nvekv", "backward":"cskken"])[arg[0]];
  case M_PTRASHFOLDER:
    //return "Trash folder";
    return "Kuka";
  case M_PSENTFOLDER:
    //return "Sent mail folder";
    return "Elkldtt levelek";
  case M_PDEFAULTBCC:
    //return "Default Bcc address";
    return "Alaprtelmezett Bcc cm";
  case M_PSAVEATTACHMENTS:
    //return "Save attachments";
    return "Csatols mentse";
  case M_PLANGUAGE:
    //return "Language";
    return "Nyelv";
  case M_PUSERINTERFACE:
    //return "User interface";
    return "Felhasznli fellet";
  case M_PHEADER:
    //return "Extra headers";
    return "Extra fejlc";
  case M_PHEADERDESC:
    //return "(Lines with headers in this format: header:value )";
    return "(Sorok a kvetkez formban: <b>fejlc: tartalom</b> )";
  case M_PSORTCOLUMN:
    //return "Sort on column";
    return "Rendezend oszlop";
  case M_PSHOWHTML:                                                  
    //return "Show HTML messages";
    return "HTML zenetek megmutatsa";
  case M_PSHOWTEXT:                                                  
    //return "Show text messages";
    //FIXME!
    return "Szveges zenetek megmutatsa";
  case M_PSHOWHIDDENHEADERS:
    //return "Enable <i>\"Show full headers\"</i>-button";
    return "A <i>\"sszes fejlc\"</i> gomb engedlyezse";
  case M_PADDRESSBOOK:
    //return "Default addressbook (not extended)";
    //FIXME!
    return "Alaprtelmezett cmjegyzk";

  case M_SPELLDONE:
    //return "Done";
    return "Ksz";
  case M_SPELLPREV:
    //return "Previous";
    return "Elz";
  case M_SPELLNEXT:
    //return "Next";
    return "Kvetkez";
  case  M_SPELLCHANGETO:
    //return "Zmie na";
    return "Vltoztats";
  case M_SPELLSUGGESTIONS:
    //return "Suggestions";
    return "Javaslat";

  case M_LOGOUTMSG:
    //return "You are logged out. Close this browser window to make sure no one can read your mail.<br><br>Reload this page to login.";
    return "<center><b>Kilpett a levelezsbl!</b><br>Krem zrja be a bngszablakot, hogy biztos legyen benne, senki nem frhet hozz a leveleihez.<br><br>Frisstse ezt az oldalt ha be akar lpni.</center>";
    
  case M_LOGGEDOUT:
    //return "Logged out";
    return "Kilptetve";

  case M_QUESTION:
    //return "Question"; 
    return "Krds";
  case M_INFO:
    //return "Info"; 
    return "Informci";

  case M_REPLY:
    //return "Reply";
    return "Vlasz";
  case M_READPREV:
    //return "Read previous";
    return "Elz olvassa";
  case M_READNEXT:
    //return "Read next";
    return "Kvetkez olvassa";
  case M_ATTACHMENTLINK:
    //return sprintf("%sattachment of type %s",@arg);
    return sprintf("%s csatols tipusa %s",@arg);
  case M_MAILMISSING:
    //return "<b>Error:</b> Failed to fetch mail. Try again. <br>";
    return "<b>Hiba:</b> Sikertelen levlletlts. Prblja jra..<br>";
  case M_MAILMISSINGBACK:
    //return "Back";
    return "Vissza";
  case M_DELETE:
    //return "Delete";
    return "Trls";
  case M_FORWARD:
    //return "Forward";
    return "Tovbbts";
  case M_MAIL:
    // return "Mail";
    return "Levl";
  case M_SHOWFULLHEADERS:
    //return "Show full headers";
    return "sszes fejlc";
  case M_HIDEFULLHEADERS:
    //return "Hide full headers";
    return "Teljes fejlc elrejtse";
  case M_MAILTOOBIG:
    // return "Mail is too big to be shown. Click here to download it.";
    return "A levl tl nagy, tartalmnak letltsshez kattintson ide.";
  case M_REPLYTOALL:
    //return "Reply to all";
    return "Vlasz mindenkinek";
  case M_MOVETHISTOTRASH:
    //return "Move to trash";
    return "thelyezs a kukba";
  case M_CHARSETWARNING:
    //return sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg);
    //FIXME!
    return sprintf("Figyelem! A \"%s\" karakterkszletet nem sikerlt dekdolni. Az zenet dekdolatlanul jelenik meg.",@arg);

  case M_ADDRESSBOOKTITLE: 
    //return("Address Book");         
    return("Cmjegyzk");
  case M_ADDRESSBOOK:
    //return("Address book...");
    return("Cmjegyzk...");
  case M_INDEXNAMERECIPIENT:
    //return("Intex name (click to add as recipient)");
    return("Index nv (hozzads)");
  case M_INDEXNAMEEDIT:
    //return("Index name (click to edit)");
    return("Index nv (szerkeszts)");
  case M_ADDRESS:
    //return("Address");
    return("Cm");
  case M_NOADDRESSES:
    //return("No addresses");
    return("Nincsenek cmek");
  case M_NEWADDRESS:
    //return("New address...");
    return("j cm");
  case M_EDITADDRESS:
    //return("Edit address");
    return("Cm szerkesztse");
  case M_ADDADDRESS:
    //return("Add to address book");
    return("Hozzads a cmjegyzkhez");
  case M_INDEXNAME:
    //return("Index name");
    return("Index nv");
  case M_ADDRESSFORMAT:
    //return("Address(es), comma separated");
    return("Vesszvel elvlasztott cmek");
  case M_SAVEADDRESS:
    //return("Save and use");
    return("Ments");
  case M_DELETEADDRESS:
    //return("Delete address");
    return("Cm trlse");
  case M_CANCELADDRESS:
    //return("Cancel");
    return("Mgsem");
  case M_CANNOTIMPORT:
    //return("Cannot import this addressbook, since its\nformat is not recognized.");
    return("A megadott cmjegyzket nem sikerlt importlni,\nmert a file formtuma ismeretlen.");
    
  case M_IMPORTADDRESSBOOKTITLE:
    //return("Import address book");
    return("Cmjegytk importlsa");
  case M_UPLOADADDRESSBOOK:
    //return("Upload a Pine or exported Netscape (.ldif) address book");
    return("Pine, vagy Netscape (.ldif) cimjegyzk feltltse");
  case M_PINELOCATION:
    //return("The Pine address book is often in ~/.addressbook");
    return("A Pine cmjegyzk gyakran ~/.addressbook nven tallhat");
  case M_UPLOADANDIMPORT:
    //return("Upload and import");
    return("Feltlts s importls");
  case M_IMPORTADDRESSBOOK:
    // return("Import address book...");
    return("Cmjegyzk importlsa...");
  case M_GLOBALADDRESSES:
    //return("Adres globalny:");
    return("Kzs cmjegyzk");

  case M_LDAPTITLE:
    //return("LDAP addresses");
    return("LDAP cmjegyzk");
  case M_LDAP:
    //return("LDAP");
    return("LDAP");
  case M_SEARCHLDAP:
    //return("Search LDAP");
    return("LDAP keress");
  case M_NAMECONT:
    //return("Search name containing:");
    return("A keresett nv tartalmazza:");
  case M_OU:
    //return("OU");
    return("OU");

  case M_MAILNOTIFYWINDOW:
    //return("Mail notification...");
    return("rtests j levlrl...");
  case M_GETNEWMAIL:
    //return("Get new mail...");
    return("j zenet keresse...");

  case M_SEARCHMAILTITLE:
    //return("Search mail");
    return("Keress a levelekben");
  case M_SEARCHMAIL:
    //return("Search...");
    return("Keress...");
  case M_SEARCHMAILBOX:
    //return(sprintf("Find mail in mailbox <b>%s</b> which contains",arg[0]));
    //FIXME!
    return(sprintf("Olyan levl keresse a <b>%s</b> mappban, ami tartalmazza",arg[0]));
  case M_SEARCHANYWHERE:
    //return("anywhere");
    return("brhol");
  case M_SEARCHFROMFIELD:
    //return("in 'from' field");
    return("a 'felad' mezben");
  case M_SEARCHTOFIELD:
    //return("in 'to' field");
    return("a 'cmzett' mezben");
  case M_SEARCHSUBJECT:
    //return("in subject");
    return("a tmban");
  case M_SEARCHBODY:
    //return("in mail body");
    return("a levl szvegben");
  case M_SEARCHAND:
    //return("AND");
    return("s");
  case M_SEARCHSHOWINGMAIL:
    //return("Showing mail with ");
    return("Levelek mutatsa ");

								      
  case M_YES:
    //return "Yes";
    return "Igen";
  case M_NO:
    //return "No";
    return "Nem";
  case M_DIALOGOK:
    // return "OK";
    return "OK";
  case M_DIALOGCANCEL:
    // return "Cancel";
    return "Mgsem";

   case M_PADDRESSBOOKFILTER:
    //return "Default filterbook (not extended)";
    //FIXME!
    return "Alaprtelmezs szerinti szrs)";
   case M_FILTERBOOKTITLE: 
    //return("Mail Filter");         
    return("Levelek szrse");         
   case M_EMPTYADDRESSFILTER:
    //return "You must specify non-empty index folder and filter(s).";
    return "Vlasszon mappt s szr(ke)t!";
   case M_NOADDRESSESFILTER:
    //return("No filter");
    return("Nincs szr");
   case M_INDEXNAMEEDITFILTER:
    //return("Index filter (click to edit)");
    return("Index szr (szerkeszts)");
   case M_ADDRESSFILTER:
    //return("Folder");
    return("Mappa");
   case M_INDEXNAMERECIPIENTFILTER:
    //return("Index name (click to add as recipient)");
    return("Index nv (hozzads cmzettknt)");
   case M_INDEXNAMEFIELDFILTER:
    //return("Index field (click to select a field)");
    return("Index mez (mez kivlasztsa)");
   case M_INDEXNAMEEDITFIELDFILTER:
    //return("Index field");
    return("Index mez");
   case M_NEWADDRESSFILTER:
    //return("New filter...");
    return("j szr");
   case M_SAVEADDRESSFILTER:
    //return("Save and use");
    //FIXME!
    return("Szr mentse s hasznlata");
   case M_DELETEADDRESSFILTER:
    //return("Delete filter");
    return("Szr trlse");
   case M_CANCELADDRESSFILTER:
    //return("Cancel");
    return("Mgsem");
   case M_ADDADDRESSFILTER:
    //return("Add to filter book");
    //FIXME!
    return("Hozzads a szrkhz");
   case M_INDEXNAMEFILTER:
    //return("Index filter");
    return("Index szr");
   case M_INDEXFIELDFILTER:
    //return("Index field");
    return("Index mez");
   case M_FILTERFOLDER:
    //return("Index folder");
    return("Index mappa");
   case M_EDITADDRESSFILTER:
    //return("Edit filter");
    return("Szr szerkesztse");
   case M_SELECTFIELD:
    //return "(Select a field)";
    return "(Mez vlasztsa)";

   case M_ADDRECIPIENTS:
    //return "Add recipients";
    return "Cmzett hozzadsa";
   case M_PORGANIZATION:
    //return "Organization";
    return "Szervezet";

   case M_MDNMESSAGE:
    //return sprintf("This is a Return Receipt for the mail that you sent to %s. "
    //		   "Note: this Return Receipt only acknowledges that the message was "
    //             "displayed on the recipient's machine. There is no guarantee that the "
    //             "content has been read or understood.", @arg);
    return sprintf("Ez egy nyugta a %s-nek kldtt levlrl "
                   "Megj.: Ez a nyugta csak azt igazolja, hogy az zenet "
                   "meg lett jelentve a cmzett gpn, de nem garantlja, hogy annak tartalmt "
                   "elolvastk s megrtettk.", @arg);
 
   case M_MDNHEADER:
    //return "Return Receipt (displayed) - ";
    return "Nyugta (megjelentett) - ";

  }
  return 0;
}





