(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(* Gtk initializations *)
let _ = GMain.Main.init ()


class gui ()=
  object
    inherit Guibase.hello ()
      
    initializer
      (* Exit the event loop when the window is destroyed *)
      ignore (win#connect#destroy GMain.Main.quit);

      (* Display "Hello world" when the button is clicked. *)
      ignore (wbutton#connect#clicked 
		(fun () -> wlabel#set_text "Hello world"));

      (* Show the window *)
      win#show ()
  end

(* Build the window *)
let c = new gui ()

(* Enter event loop *)
let _ = GMain.Main.main ()
