(*********************************************************************************)
(*                Cameleon                                                       *)
(*                                                                               *)
(*    Copyright (C) 2005,2006 Institut National de Recherche en Informatique     *)
(*    et en Automatique. All rights reserved.                                    *)
(*                                                                               *)
(*    This program is free software; you can redistribute it and/or modify       *)
(*    it under the terms of the GNU Library General Public License as            *)
(*    published by the Free Software Foundation; either version 2 of the         *)
(*    License, or  any later version.                                            *)
(*                                                                               *)
(*    This program is distributed in the hope that it will be useful,            *)
(*    but WITHOUT ANY WARRANTY; without even the implied warranty of             *)
(*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *)
(*    GNU Library General Public License for more details.                       *)
(*                                                                               *)
(*    You should have received a copy of the GNU Library General Public          *)
(*    License along with this program; if not, write to the Free Software        *)
(*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA                   *)
(*    02111-1307  USA                                                            *)
(*                                                                               *)
(*    Contact: Maxence.Guesdon@inria.fr                                          *)
(*                                                                               *)
(*********************************************************************************)

module CF = Config_file

let factory_name = "ocamloutput"
let rc_file = Ed_config.rc_file factory_name

let group = new CF.group

let default_special_filename = "*ocamloutput*";;
let default_special_filename_exp = "\\*ocamloutput\\*";;

let special_filename = new CF.string_cp ~group
  ["special_filename"] default_special_filename
    "Special filename to use to represent the view of ocaml output.";;
    
let special_filename_exp = new CF.string_cp ~group
  ["special_filename_exp"] default_special_filename_exp
    "Expression to match the special filename in associations between filenames and views."

let read () = group#read rc_file
let write () = group#write rc_file



