/**
  \class CCamWindow
  \brief Base class for use on \ref CCamStreamMainWindow

  This class includes a gross hack :-)

  I wanted a MDI (multiple document interface) application; each window
  would then show a webcam viewer, a video-conferencing receiver, etc.  But
  I wanted each class of windows to have their own toolbar(s) and status
  bar. The only Qt class that maintains toolbars properly is the QMainWindow
  class. However, QMainWindow is normally used as the app's main window, and
  therefor a QMainWindow is a top-level window by default. But by surpressing
  the top-level flag, I can create QMainWindows upon other widgets.

  In fact, CamStream's main window (CCamStreamMainWindow) is a QMainWindow,
  with a QWorkspace as central widget (for the MDI stuff). The windows
  placed on this central widget/workspace are themselves now QMainWindows,
  but as a simple child-class. The full functionality of the QMainWindow
  is still available.

  The only thing that should not be used is a Menu on these child windows,
  because it would be VERY confusing to have menubars on MDI windows.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <qpixmap.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qwidget.h>

#include "CamWindow.h"
#include "tracer.h"

TR_MODULE("CCamWindow");

/**
  \brief Constructor
  \param The parent widget
  \param name The name of this object

  This constructor is protected since calling this class directly is useless.
*/
CCamWindow::CCamWindow(QWidget *parent, const char *name)
	: QMainWindow(parent, name, WDestructiveClose)
{
   TR_ENTER();
   TR_LEAVE();
}



CCamWindow::~CCamWindow()
{
   TR_ENTER();
   TR_LEAVE();
}
