#ifndef VIDEODEVICETUNER_HPP
#define VIDEODEVICETUNER_HPP

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qobject.h>

#include "TVChannel.h"

class CVideoDeviceLinux;

class CVideoDeviceTuner: public QObject
{
   Q_OBJECT
public:

private:
   CVideoDeviceLinux *pVideo;
   int Tuner;

   QString Name;
   int Flags;
   float FreqLow, FreqHigh;
   float FreqStep;
   ulong ufreq;

public:
   CVideoDeviceTuner(CVideoDeviceLinux *_video, int _tuner);

   const QString GetName();

   float GetLowestFrequency() const;
   float GetHighestFrequency() const;
   float GetFrequency() const;

   bool HasNorm() const;
   TVChannel::TunerNorms GetNorm() const;

   bool Select();

public slots:
   bool SetFrequency(float freq);
   void SetNorm(TVChannel::TunerNorms norm);

signals:
   void Selected(int);
};

#endif
