/* interface.c
 * Copyright (C) 2000-2001 Christopher R. Gabriel <cgabriel@softwarelibero.org>
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>

#include "interface.h"
#include "callbacks.h"
#include "cappuccino.h"

static void 
exit_cb(GtkWidget *widget, gpointer data)
{
  gtk_timeout_remove(timeout);
  gtk_main_quit();
}


GtkWidget*
create_window ()
{
  GtkWidget *intwindow2;
  GtkWidget *vbox2;
  GtkWidget *canvas;
  GtkWidget *animator1;
  GnomeCanvasGroup *root;
  GnomeCanvasGroup *group;
  GtkStyle *style, *style2;
  gchar *imgloc;

  intwindow2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (intwindow2), "window2", intwindow2);
  gtk_window_set_title (GTK_WINDOW (intwindow2), _("Attention!"));
  gtk_window_set_position(GTK_WINDOW(intwindow2), GTK_WIN_POS_CENTER_ALWAYS);  
  gtk_signal_connect(GTK_OBJECT(intwindow2), "delete_event",
         GTK_SIGNAL_FUNC(exit_cb), NULL);

  style2 = gtk_style_copy (GTK_WIDGET(intwindow2)->style);
  style2->bg[GTK_STATE_NORMAL] = style2->white;
  gtk_widget_set_style (GTK_WIDGET(intwindow2), style2);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox2);
  gtk_object_set_data_full (GTK_OBJECT (intwindow2), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);

 
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (intwindow2), vbox2);

  gtk_widget_push_visual (gdk_imlib_get_visual ());
  gtk_widget_push_colormap (gdk_imlib_get_colormap ());
  canvas = gnome_canvas_new ();
  gtk_widget_pop_colormap ();
  gtk_widget_pop_visual ();

  gtk_widget_set_usize (canvas, 400,170);
  gnome_canvas_set_scroll_region (GNOME_CANVAS (canvas), 0, 0, 
          400,
          170);

  style = gtk_style_copy (GTK_WIDGET(canvas)->style);
  style->bg[GTK_STATE_NORMAL] = style->white;
  gtk_widget_set_style (GTK_WIDGET(canvas), style);

  root = gnome_canvas_root(GNOME_CANVAS(canvas));  
  group = GNOME_CANVAS_GROUP (gnome_canvas_item_new (root,
                 gnome_canvas_group_get_type (),
                 "x", 10.0,
                 "y", 10.0,
                 NULL));
  gnoca = gnome_canvas_item_new (group,
         gnome_canvas_text_get_type (),
         "text", " ",
         "x", 180.0, 
         "y", 10.0,
         "font", "-adobe-helvetica-bold-r-normal--24-240-75-75-p-138-iso8859-1",
         "anchor", GTK_ANCHOR_CENTER, 
         "fill_color_rgba", 0x000000ff,
         NULL);
  

  gnoca2 = gnome_canvas_item_new (group,
         gnome_canvas_text_get_type (),
         "text", " ",
         "x", 180.0,
         "y", 100.0,
         "font", "-adobe-helvetica-bold-r-normal--24-240-75-75-p-138-iso8859-1",
         "anchor", GTK_ANCHOR_CENTER,
         "justification", GTK_JUSTIFY_CENTER,
         "fill_color_rgba", 0x000000ff,
         NULL);

  gtk_box_pack_start (GTK_BOX (vbox2), canvas, TRUE, TRUE, 0);
  gtk_widget_show(canvas);

  animator1 = gnome_animator_new_with_size (45, 34);

  if (g_file_exists(IMAGESDIR "/pleasewait.png"))
    imgloc = IMAGESDIR "/pleasewait.png";
  else
    imgloc = "../pixmaps/pleasewait.png";

  gnome_animator_append_frames_from_file_at_size (GNOME_ANIMATOR (animator1),
              imgloc,
              0, 0,
              50,
              45, 
              45, 34);
  gtk_widget_ref (animator1);
  gtk_object_set_data_full (GTK_OBJECT (intwindow2), "animator1", animator1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (animator1);
  gtk_box_pack_start (GTK_BOX (vbox2), animator1, TRUE, TRUE, 0);
  gtk_widget_set_usize (animator1, 0, 0);
  gnome_animator_start(GNOME_ANIMATOR(animator1));
  gnome_animator_set_loop_type (GNOME_ANIMATOR (animator1), GNOME_ANIMATOR_LOOP_RESTART);

  progressbar1 = gtk_progress_bar_new ();
  gtk_widget_ref (progressbar1);
  gtk_object_set_data_full (GTK_OBJECT (intwindow2), "progressbar1", progressbar1,
                            (GtkDestroyNotify) gtk_widget_unref);
  
  gtk_widget_show (progressbar1);
  gtk_box_pack_start (GTK_BOX (vbox2), progressbar1, FALSE, FALSE, 0);
  gtk_progress_set_activity_mode (GTK_PROGRESS (progressbar1), TRUE);


  gtk_signal_connect(GTK_OBJECT(canvas),"event",
                     GTK_SIGNAL_FUNC(canvas_event),
                     NULL);
 
  return intwindow2;
}

GtkWidget*
create_config (void)
{
  GtkWidget *config;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox4;
  GtkWidget *hbox18;
  GtkWidget *label34;
  GtkWidget *cptitle;
  GtkWidget *hbox20;
  GtkWidget *label36;
  GtkWidget *sent1;
  GtkObject *sentc1_adj;
  GtkWidget *sentc1;
  GtkWidget *hbox22;
  GtkWidget *label38;
  GtkWidget *sent2;
  GtkObject *sentc2_adj;
  GtkWidget *sentc2;
  GtkWidget *hbox24;
  GtkWidget *label40;
  GtkWidget *sent3;
  GtkObject *sentc3_adj;
  GtkWidget *sentc3;
  GtkWidget *hbox26;
  GtkWidget *label41;
  GtkWidget *sent4;
  GtkObject *sentc4_adj;
  GtkWidget *sentc4;
  GtkWidget *hbox28;
  GtkWidget *label43;
  GtkWidget *sent5;
  GtkObject *sentc5_adj;
  GtkWidget *sentc5;
  GtkWidget *hbox30;
  GtkWidget *label45;
  GtkWidget *sent6;
  GtkObject *sentc6_adj;
  GtkWidget *sentc6;
  GtkWidget *hbox32;
  GtkWidget *label48;
  GtkObject *ncycles_adj;
  GtkWidget *ncycles;
  GtkWidget *hbox33;
  GtkWidget *label52;
  GtkWidget *lastone;
  GtkWidget *dialog_action_area1;
  GtkWidget *buttok;
  GtkWidget *buttapp;
  GtkWidget *buttcan;
  GtkWidget *hbox35;
  GtkWidget *label54;
  GSList *hbox35_group = NULL;
  GtkWidget *remyes;
  GtkWidget *remno;

  config = gnome_dialog_new (_("Cappuccino configuration"), NULL);
  gtk_object_set_data (GTK_OBJECT (config), "config", config);
  gtk_window_set_policy (GTK_WINDOW (config), FALSE, FALSE, FALSE);

  dialog_vbox1 = GNOME_DIALOG (config)->vbox;
  gtk_object_set_data (GTK_OBJECT (config), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox4);
  gtk_object_set_data_full (GTK_OBJECT (config), "vbox4", vbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox4);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox4, TRUE, TRUE, 0);

  hbox18 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox18);
  gtk_object_set_data_full (GTK_OBJECT (config), "hbox18", hbox18,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox18);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox18, TRUE, TRUE, 0);

  label34 = gtk_label_new (_("First  row:  "));
  gtk_widget_ref (label34);
  gtk_object_set_data_full (GTK_OBJECT (config), "label34", label34,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label34);
  gtk_box_pack_start (GTK_BOX (hbox18), label34, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label34), GTK_JUSTIFY_LEFT);

  cptitle = gtk_entry_new_with_max_length (35);
  gtk_widget_ref (cptitle);
  gtk_object_set_data_full (GTK_OBJECT (config), "cptitle", cptitle,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cptitle);
  gtk_box_pack_start (GTK_BOX (hbox18), cptitle, FALSE, TRUE, 0);
  gtk_widget_set_usize (cptitle, 240, -2);
  gtk_entry_set_text (GTK_ENTRY (cptitle), title);

  hbox20 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox20);
  gtk_object_set_data_full (GTK_OBJECT (config), "hbox20", hbox20,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox20);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox20, TRUE, TRUE, 0);

  label36 = gtk_label_new (_("1st sentence:  "));
  gtk_widget_ref (label36);
  gtk_object_set_data_full (GTK_OBJECT (config), "label36", label36,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label36);
  gtk_box_pack_start (GTK_BOX (hbox20), label36, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label36), GTK_JUSTIFY_LEFT);

  sent1 = gtk_entry_new_with_max_length (25);
  gtk_widget_ref (sent1);
  gtk_object_set_data_full (GTK_OBJECT (config), "sent1", sent1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sent1);
  gtk_box_pack_start (GTK_BOX (hbox20), sent1, FALSE, TRUE, 0);
  gtk_entry_set_text (GTK_ENTRY (sent1), rows[0]);

  sentc1_adj = gtk_adjustment_new ((gfloat) cycles[0], 0, 100, 1, 10, 10);
  sentc1 = gtk_spin_button_new (GTK_ADJUSTMENT (sentc1_adj), 1, 0);
  gtk_widget_ref (sentc1);
  gtk_object_set_data_full (GTK_OBJECT (config), "sentc1", sentc1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sentc1);
  gtk_box_pack_start (GTK_BOX (hbox20), sentc1, FALSE, TRUE, 0);
  
  hbox22 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox22);
  gtk_object_set_data_full (GTK_OBJECT (config), "hbox22", hbox22,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox22);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox22, TRUE, TRUE, 0);

  label38 = gtk_label_new (_("2nd sentence:  "));
  gtk_widget_ref (label38);
  gtk_object_set_data_full (GTK_OBJECT (config), "label38", label38,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label38);
  gtk_box_pack_start (GTK_BOX (hbox22), label38, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label38), GTK_JUSTIFY_LEFT);

  sent2 = gtk_entry_new_with_max_length (25);
  gtk_widget_ref (sent2);
  gtk_object_set_data_full (GTK_OBJECT (config), "sent2", sent2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sent2);
  gtk_box_pack_start (GTK_BOX (hbox22), sent2, FALSE, TRUE, 0);
  gtk_entry_set_text (GTK_ENTRY (sent2), rows[1]);

  sentc2_adj = gtk_adjustment_new ((gfloat) cycles[1], 0, 100, 1, 10, 10);
  sentc2 = gtk_spin_button_new (GTK_ADJUSTMENT (sentc2_adj), 1, 0);
  gtk_widget_ref (sentc2);
  gtk_object_set_data_full (GTK_OBJECT (config), "sentc2", sentc2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sentc2);
  gtk_box_pack_start (GTK_BOX (hbox22), sentc2, FALSE, TRUE, 0);

  hbox24 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox24);
  gtk_object_set_data_full (GTK_OBJECT (config), "hbox24", hbox24,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox24);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox24, TRUE, TRUE, 0);

  label40 = gtk_label_new (_("3rd sentence:  "));
  gtk_widget_ref (label40);
  gtk_object_set_data_full (GTK_OBJECT (config), "label40", label40,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label40);
  gtk_box_pack_start (GTK_BOX (hbox24), label40, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label40), GTK_JUSTIFY_LEFT);

  sent3 = gtk_entry_new_with_max_length (25);
  gtk_widget_ref (sent3);
  gtk_object_set_data_full (GTK_OBJECT (config), "sent3", sent3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sent3);
  gtk_box_pack_start (GTK_BOX (hbox24), sent3, FALSE, TRUE, 0);
  gtk_entry_set_text (GTK_ENTRY (sent3), rows[2]);
  
  sentc3_adj = gtk_adjustment_new ((gfloat) cycles[2], 0, 100, 1, 10, 10);
  sentc3 = gtk_spin_button_new (GTK_ADJUSTMENT (sentc3_adj), 1, 0);
  gtk_widget_ref (sentc3);
  gtk_object_set_data_full (GTK_OBJECT (config), "sentc3", sentc3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sentc3);
  gtk_box_pack_start (GTK_BOX (hbox24), sentc3, FALSE, TRUE, 0);

  hbox26 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox26);
  gtk_object_set_data_full (GTK_OBJECT (config), "hbox26", hbox26,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox26);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox26, TRUE, TRUE, 0);

  label41 = gtk_label_new (_("4th sentence:  "));
  gtk_widget_ref (label41);
  gtk_object_set_data_full (GTK_OBJECT (config), "label41", label41,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label41);
  gtk_box_pack_start (GTK_BOX (hbox26), label41, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label41), GTK_JUSTIFY_LEFT);

  sent4 = gtk_entry_new_with_max_length (25);
  gtk_widget_ref (sent4);
  gtk_object_set_data_full (GTK_OBJECT (config), "sent4", sent4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sent4);
  gtk_box_pack_start (GTK_BOX (hbox26), sent4, FALSE, TRUE, 0);
  gtk_entry_set_text (GTK_ENTRY (sent4), rows[3]);

   sentc4_adj = gtk_adjustment_new ((gfloat) cycles[3], 0, 100, 1, 10, 10);
  sentc4 = gtk_spin_button_new (GTK_ADJUSTMENT (sentc4_adj), 1, 0);
  gtk_widget_ref (sentc4);
  gtk_object_set_data_full (GTK_OBJECT (config), "sentc4", sentc4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sentc4);
  gtk_box_pack_start (GTK_BOX (hbox26), sentc4, FALSE, TRUE, 0);

  hbox28 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox28);
  gtk_object_set_data_full (GTK_OBJECT (config), "hbox28", hbox28,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox28);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox28, TRUE, TRUE, 0);

  label43 = gtk_label_new (_("5th sentence:  "));
  gtk_widget_ref (label43);
  gtk_object_set_data_full (GTK_OBJECT (config), "label43", label43,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label43);
  gtk_box_pack_start (GTK_BOX (hbox28), label43, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label43), GTK_JUSTIFY_LEFT);

  sent5 = gtk_entry_new_with_max_length (25);
  gtk_widget_ref (sent5);
  gtk_object_set_data_full (GTK_OBJECT (config), "sent5", sent5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sent5);
  gtk_box_pack_start (GTK_BOX (hbox28), sent5, FALSE, TRUE, 0);
  gtk_entry_set_text (GTK_ENTRY (sent5), rows[4]);

  sentc5_adj = gtk_adjustment_new ((gfloat) cycles[4], 0, 100, 1, 10, 10);
  sentc5 = gtk_spin_button_new (GTK_ADJUSTMENT (sentc5_adj), 1, 0);
  gtk_widget_ref (sentc5);
  gtk_object_set_data_full (GTK_OBJECT (config), "sentc5", sentc5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sentc5);
  gtk_box_pack_start (GTK_BOX (hbox28), sentc5, FALSE, TRUE, 0);

  hbox30 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox30);
  gtk_object_set_data_full (GTK_OBJECT (config), "hbox30", hbox30,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox30);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox30, TRUE, TRUE, 0);

  label45 = gtk_label_new (_("6th sentence:  "));
  gtk_widget_ref (label45);
  gtk_object_set_data_full (GTK_OBJECT (config), "label45", label45,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label45);
  gtk_box_pack_start (GTK_BOX (hbox30), label45, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label45), GTK_JUSTIFY_LEFT);

  sent6 = gtk_entry_new_with_max_length (25);
  gtk_widget_ref (sent6);
  gtk_object_set_data_full (GTK_OBJECT (config), "sent6", sent6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sent6);
  gtk_box_pack_start (GTK_BOX (hbox30), sent6, FALSE, TRUE, 0);
  gtk_entry_set_text (GTK_ENTRY (sent6), rows[5]);

  sentc6_adj = gtk_adjustment_new ((gfloat) cycles[5], 0, 100, 1, 10, 10);
  sentc6 = gtk_spin_button_new (GTK_ADJUSTMENT (sentc6_adj), 1, 0);
  gtk_widget_ref (sentc6);
  gtk_object_set_data_full (GTK_OBJECT (config), "sentc6", sentc6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sentc6);
  gtk_box_pack_start (GTK_BOX (hbox30), sentc6, FALSE, TRUE, 0);

  hbox32 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox32);
  gtk_object_set_data_full (GTK_OBJECT (config), "hbox32", hbox32,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox32);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox32, TRUE, TRUE, 0);

  label48 = gtk_label_new (_("# of loop cycles:  "));
  gtk_widget_ref (label48);
  gtk_object_set_data_full (GTK_OBJECT (config), "label48", label48,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label48);
  gtk_box_pack_start (GTK_BOX (hbox32), label48, FALSE, FALSE, 0);

  ncycles_adj = gtk_adjustment_new ((gfloat) loops, 0, 100, 1, 10, 10);
  ncycles = gtk_spin_button_new (GTK_ADJUSTMENT (ncycles_adj), 1, 0);
  gtk_widget_ref (ncycles);
  gtk_object_set_data_full (GTK_OBJECT (config), "ncycles", ncycles,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ncycles);
  gtk_box_pack_start (GTK_BOX (hbox32), ncycles, FALSE, TRUE, 0);

  hbox33 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox33);
  gtk_object_set_data_full (GTK_OBJECT (config), "hbox33", hbox33,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox33);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox33, TRUE, TRUE, 0);

  label52 = gtk_label_new (_("Final sentence:"));
  gtk_widget_ref (label52);
  gtk_object_set_data_full (GTK_OBJECT (config), "label52", label52,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label52);
  gtk_box_pack_start (GTK_BOX (hbox33), label52, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label52), GTK_JUSTIFY_LEFT);

  lastone = gtk_entry_new_with_max_length (35);
  gtk_widget_ref (lastone);
  gtk_object_set_data_full (GTK_OBJECT (config), "lastone", lastone,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (lastone);
  gtk_box_pack_start (GTK_BOX (hbox33), lastone, FALSE, TRUE, 0);
  gtk_widget_set_usize (lastone, 240, -2);
  gtk_entry_set_text (GTK_ENTRY (lastone), final);

  dialog_action_area1 = GNOME_DIALOG (config)->action_area;
  gtk_object_set_data (GTK_OBJECT (config), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

  gnome_dialog_append_button (GNOME_DIALOG (config), GNOME_STOCK_BUTTON_OK);
  buttok = GTK_WIDGET (g_list_last (GNOME_DIALOG (config)->buttons)->data);
  gtk_widget_ref (buttok);
  gtk_object_set_data_full (GTK_OBJECT (config), "buttok", buttok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (buttok);
  GTK_WIDGET_SET_FLAGS (buttok, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (config), GNOME_STOCK_BUTTON_APPLY);
  buttapp = GTK_WIDGET (g_list_last (GNOME_DIALOG (config)->buttons)->data);
  gtk_widget_ref (buttapp);
  gtk_object_set_data_full (GTK_OBJECT (config), "buttapp", buttapp,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (buttapp);
  GTK_WIDGET_SET_FLAGS (buttapp, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (config), GNOME_STOCK_BUTTON_CANCEL);
  buttcan = GTK_WIDGET (g_list_last (GNOME_DIALOG (config)->buttons)->data);
  gtk_widget_ref (buttcan);
  gtk_object_set_data_full (GTK_OBJECT (config), "buttcan", buttcan,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (buttcan);
  GTK_WIDGET_SET_FLAGS (buttcan, GTK_CAN_DEFAULT);

  hbox35 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox35);
  gtk_object_set_data_full (GTK_OBJECT (config), "hbox35", hbox35,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox35);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox35, TRUE, TRUE, 0);
 
  label54 = gtk_label_new (_("Remember this changes:  "));
  gtk_widget_ref (label54);
  gtk_object_set_data_full (GTK_OBJECT (config), "label54", label54,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label54);
  gtk_box_pack_start (GTK_BOX (hbox35), label54, FALSE, FALSE, 0);
 
  remyes = gtk_radio_button_new_with_label (hbox35_group, _("yes"));
  hbox35_group = gtk_radio_button_group (GTK_RADIO_BUTTON (remyes));
  gtk_widget_ref (remyes);
  gtk_object_set_data_full (GTK_OBJECT (config), "remyes", remyes,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (remyes);
  gtk_box_pack_start (GTK_BOX (hbox35), remyes, FALSE, FALSE, 0);
 
  remno = gtk_radio_button_new_with_label (hbox35_group, _("no"));
  hbox35_group = gtk_radio_button_group (GTK_RADIO_BUTTON (remno));
  gtk_widget_ref (remno);
  gtk_object_set_data_full (GTK_OBJECT (config), "remno", remno,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (remno);
  gtk_box_pack_start (GTK_BOX (hbox35), remno, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (remyes), TRUE);

  gtk_signal_connect (GTK_OBJECT (buttok), "clicked",
                      GTK_SIGNAL_FUNC (on_buttok_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (buttapp), "clicked",
                      GTK_SIGNAL_FUNC (on_buttapp_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (buttcan), "clicked",
                      GTK_SIGNAL_FUNC (on_buttcan_clicked),
                      NULL);
  gtk_signal_connect(GTK_OBJECT(config), "destroy",
                     GTK_SIGNAL_FUNC(on_config_destroyed),
                     &config);
  gtk_signal_connect (GTK_OBJECT (remyes), "toggled",
                      GTK_SIGNAL_FUNC (on_remyes_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (remno), "toggled",
                      GTK_SIGNAL_FUNC (on_remno_toggled),
                      NULL);

  return config;
}


