/* main.c
 * Copyright (C) 2000-2001 Christopher R. Gabriel <cgabriel@softwarelibero.org>
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <unistd.h>
#include <gnome.h>

#include "interface.h"
#include "callbacks.h"
#include "cappuccino.h"

int 
main (int argc, char *argv[])
{
  
#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);
#endif

  /* Load sentence to display or use default values */
  load_data();
  
  gnome_init ("cappuccino", VERSION, argc, argv);
  window = create_window ();
  gtk_widget_show (window);
  
  timeout = gtk_timeout_add (5, update_progressbar, NULL);


  gtk_main ();
  return 0;
}

