/* 
 
Copyright 2006 Eric Hakenholz

This file is part of C.a.R. software.

    C.a.R. is a free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, version 3 of the License.

    C.a.R. is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 
 */
 
 
 package eric;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;

import javax.swing.BoxLayout;

public class JOldJavaVersionDialog extends Frame implements MouseListener,
WindowListener {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	static public void main(final String[] args) {
		new JOldJavaVersionDialog();

	}

	public JOldJavaVersionDialog() {
		this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		this.setResizable(false);
		this.addWindowListener(this);
		this.setBackground(new Color(255, 255, 255));

		final ResourceBundle Strs = ResourceBundle
		.getBundle("eric/docs/JZirkelProperties");

		final TextArea message = new TextArea(Strs
				.getString("java.old.message"), 5, 50, TextArea.SCROLLBARS_NONE);
		message.setEditable(false);
		// message.setSize(new Dimension(200,175));
		this.add(message);

		final Panel pan = new Panel();
		pan.setSize(new Dimension(200, 25));
		pan.setLayout(new BoxLayout(pan, BoxLayout.X_AXIS));

		final Button quitbtn = new Button(Strs.getString("java.old.quit"));
		quitbtn.setName("quitbtn");
		final Button gobtn = new Button(Strs.getString("java.old.go"));
		gobtn.setName("gobtn");
		quitbtn.addMouseListener(this);
		gobtn.addMouseListener(this);
		pan.add(quitbtn);
		pan.add(new Panel());
		pan.add(gobtn);

		this.add(pan);

		this.setSize(new Dimension(200, 150));
		this.pack();
		final Dimension screenSize = Toolkit.getDefaultToolkit()
		.getScreenSize();
		final int x = (screenSize.width - this.getWidth()) / 2;
		final int y = (screenSize.height - this.getHeight()) / 2;
		this.setLocation(x, y);

		this.setVisible(true);
	}

	public void mouseClicked(final MouseEvent arg0) {
	}

	public void mousePressed(final MouseEvent e) {
		final Button btn = (Button) e.getSource();
		if (btn.getName().equals("quitbtn")) {
			System.exit(0);
		} else {
			JBrowserLauncher.openURL("http://www.java.com/");
		}
	}

	public void mouseReleased(final MouseEvent arg0) {
	}

	public void mouseEntered(final MouseEvent arg0) {
	}

	public void mouseExited(final MouseEvent arg0) {
	}

	public void windowOpened(final WindowEvent arg0) {
	}

	public void windowClosing(final WindowEvent arg0) {
		System.exit(0);
	}

	public void windowClosed(final WindowEvent arg0) {
	}

	public void windowIconified(final WindowEvent arg0) {
	}

	public void windowDeiconified(final WindowEvent arg0) {
	}

	public void windowActivated(final WindowEvent arg0) {
	}

	public void windowDeactivated(final WindowEvent arg0) {
		System.exit(0);
	}

}
