#define MUSICNUM 2

#include "main.h"
#ifdef USE_SOUND
#include "SDL_mixer.h"

Mix_Chunk *CannonSound,*DropSound;

    Mix_Music *Music[MUSICNUM];
    char text[200],ModName[MUSICNUM][20]=
	{"FDREAM.XM","FARMOR8.XM"};
#endif
    int sound=1,CurrentMusic;

void PlayMusic()
{
#ifdef USE_SOUND
    CurrentMusic=abrand(0,MUSICNUM-1);
    if ( (!Mix_PlayingMusic()) && (sound) ) 
	Mix_PlayMusic(Music[CurrentMusic],1);
#endif
}

void InitSound()
{
#ifdef USE_SOUND
    int i;
    
    if (sound) {
	if ( Mix_OpenAudio(22050, AUDIO_S16, 2, 1024) < 0 ) {
	    //fprintf(stderr,"Warning: Couldn't set 22025 Hz 16-bit audio\n- Reason: %s\n",SDL_GetError());
	    fprintf(stderr,"Warning: Couldn't set 22025 Hz 16-bit audio\n");
	    fprintf(stderr,"\t**\nSOUND TURNED OFF\n\t**\n");
	    sound=0;
	} else {
	    for (i=0;i<MUSICNUM;i++) {
		sprintf(text,"%s/sound/%s",DATAPATH,ModName[i]);
	        Music[i] = Mix_LoadMUS(text);
		if (Music==NULL) printf("COULD NOT LOAD MUSIC: %s\n", SDL_GetError());
	    }
	    sprintf(text,"%s/sound/%s",DATAPATH,"cannon.wav");
	    CannonSound = Mix_LoadWAV(text);
	    CannonSound->volume = 100;
	    sprintf(text,"%s/sound/%s",DATAPATH,"drop.wav");
	    DropSound = Mix_LoadWAV(text);
	    DropSound->volume = 60;
	    CurrentMusic = abrand(0,MUSICNUM-1);
	}
	Mix_HookMusicFinished(PlayMusic);
    }
#endif
}

#ifdef USE_SOUND
void PlaySound(Mix_Chunk *Sample)
{
    int i=0;
    
    if (sound) {
	while ((Mix_Playing(i))&&(i<2)) i++;
	if (i<2) 
	    Mix_PlayChannel(i,Sample,0);
	else
	    Mix_PlayChannel(0,Sample,0);
//	printf("Playing on channel %d\n",i);
    }
}
#else
void PlaySound(void *Sample)
{}
#endif
