/*
 * Decompiled with CFR 0.152.
 */
package sun.servlet.util;

public class Pool {
    protected Class cl;
    protected Object[] free;
    protected int count;

    public Pool(String string, int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid count");
        }
        this.count = n;
        try {
            this.init(Class.forName(string));
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("class not found");
        }
    }

    public Pool(String string) throws IllegalArgumentException {
        this(string, 1);
    }

    public Pool(Class clazz, int n) throws IllegalArgumentException {
        this.count = n;
        this.init(clazz);
    }

    public Pool(Class clazz) throws IllegalArgumentException {
        this(clazz, 1);
    }

    protected void init(Class clazz) throws IllegalArgumentException {
        this.free = new Object[this.count];
        try {
            int n = 0;
            while (n < this.count) {
                this.free[n] = clazz.newInstance();
                ++n;
            }
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("class could not be instantiated");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("class not accessible");
        }
        this.cl = clazz;
    }

    public Object alloc() {
        Pool pool = this;
        synchronized (pool) {
            if (this.count > 0) {
                Object object = this.free[--this.count];
                Object var3_3 = null;
                return object;
            }
        }
        try {
            return this.cl.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError();
        }
    }

    public synchronized void free(Object object) {
        if (this.count >= this.free.length) {
            Object[] objectArray = new Object[this.free.length * 2];
            System.arraycopy(this.free, 0, objectArray, 0, this.free.length);
            this.free = objectArray;
        }
        this.free[this.count++] = object;
    }
}

