/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2001-2002 The Caudium Group
 * Copyright  2001 Davies, Inc
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: 404file.pike,v 1.2.2.5 2003/03/27 21:48:12 kiwi Exp $
 */
/*
 * See http://www.daviesinc.com/modules/ for more informations.
 */

#include <module.h>

inherit "module";
inherit "caudiumlib";

//#define DEBUG

#ifdef DEBUG
# define DEBUGLOG(X) werror("REFER: "+X+"\n")
#else
# define DEBUGLOG(X)
#endif

//! module: 404 file
//!  Error 404 file: simple MODULE_LAST that presents and parses a file
//!  when no modules can handle the request.<br />Based on Chris Davies 
//!  <a href="http://www.daviesinc.com/modules/">module.</a>
//! type: MODULE_LAST
//! inherits: module
//! inherits: caudiumlib
//! cvs_version: $Id: 404file.pike,v 1.2.2.5 2003/03/27 21:48:12 kiwi Exp $

constant module_type = MODULE_LAST;
constant module_name = "404 file";
constant module_doc  = "Error 404 file: simple MODULE_LAST that presents "
                       "and parses a file when no modules can handle the request. "
                       "<br/>Based on Chris Davies <a href=\"" 
                       "http://www.daviesinc.com/modules/\">module.</a>";
constant module_unique = 1;
constant cvs_version = "$Id: 404file.pike,v 1.2.2.5 2003/03/27 21:48:12 kiwi Exp $";
constant thread_safe = 1;

void create() {
  defvar ("error404document", "NONE/", "Filename",
          TYPE_STRING,
          "The filename to use.",
          );

  defvar("msie", 1, "Return a 200 to MSIE", TYPE_FLAG,
         "Returns a 200 response to Microsoft Internet Explorer browser "
         "instead of 404.");
}

mapping|int last_resort(object id)
{ 
  string html;
  array dbinfo;

  dbinfo = cache_lookup("404Cache",QUERY(error404document));

  if (!(dbinfo)) {
    html = Stdio.read_bytes( QUERY(error404document) );
    DEBUGLOG("not in cache: " + QUERY(error404document));
    dbinfo = ({
      QUERY(error404document),
      html
    });
    cache_set("TemplateCache",QUERY(error404document),dbinfo,30*60);
  } else {
    DEBUGLOG("in cache: "+QUERY(error404document));
    html = dbinfo[1];
  }
  if(QUERY(msie)) {
    if(id->supports->msie404)
      return http_string_answer(parse_rxml(html,id),"text/html");
    else
      return http_low_answer(404, parse_rxml(html,id));
  }
  // If we do not support MSIE hell, then fail back to old system.
  return http_string_answer(parse_rxml(html,id),"text/html");
}

/* START AUTOGENERATED DEFVAR DOCS */

//! defvar: error404document
//! The filename to use.
//!  type: TYPE_STRING
//!  name: Filename
//
//! defvar: msie
//! Returns a 200 response to Microsoft Internet Explorer browser instead of 404.
//!  type: TYPE_FLAG
//!  name: Return a 200 to MSIE
//

/*
 * If you visit a file that doesn't contain these lines at its end, please
 * cut and paste everything from here to that file.
 */

/*
 * Local Variables:
 * c-basic-offset: 2
 * End:
 *
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

