;;; @file c64.s
;;; Commodore 64 definitions
;;; @author Marko Mkel (msmakela@nic.funet.fi)
host = 64

;;; start address for the server program
serverstart = $cc00
;;; start address for the utility programs
utilstart = $c000

#include "c64common.s"
bstart	= $2b	; start of basic program text
bend	= $2d	; end of basic program text
blnsw	= $cc
crsw	= $d0

stack	= $104	; offset to the stack while in interrupt

clr	= $a659
linkprg = $a533
stxpt	= $a68e
newstt	= $a7ae

	;; exit from an interrupt
#define irqexit jmp $ea81
	;; disable timer interrupts
#define deactirq lda #$2:sta $dc0d
	;; re-enable timer interrupts
#define reactirq jsr $fddd
	;; store the speed settings and enable fast speed
#define phfast lda $d011:pha:lda #$0:sta $d011
	;; restore original speed from fast speed
#define plfast pla:sta $d011
	;; store the speed settings and enable slow speed (no badlines)
#define phslow lda $d011:pha:lda $d015:pha:lda #$0:sta $d015:sta $d011:\
	.(:vblank bit $d011:bpl vblank:.)
	;; restore original speed from slow speed
#define plslow pla:sta $d015:pla:sta $d011
