/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


//
// $Id: Volume.H,v 1.16 2000/10/02 20:53:11 lijewski Exp $
//

// ---------------------------------------------------------------
// Volume.H
// ---------------------------------------------------------------
#ifndef _VOLUME_H_
#define _VOLUME_H_

#ifdef BL_VOLUMERENDER
#include <volpack.h>
#else
#define VP_NORM_MAX             7923    /* maximum value of a 13 bit normal */
#endif

#define SWF_HEADER	62			/* bytes of header in file */

  typedef struct {		/* contents of a voxel */
    short normal;			/*   encoded surface normal vector */
      //the short is unused in the non-lighting model
    unsigned char density;	/*   original density */
    unsigned char gradient;	/*   original gradient */
      //gradient becomes the normal in the non-lighting model
  } RawVoxel;


#define DENSITY_PARAM		0		/* classification parameters */
#define OCTREE_DENSITY_THRESH	4
#define GRADIENT_PARAM		1
#define OCTREE_GRADIENT_THRESH	4
#define OCTREE_BASE_NODE_SIZE	4


#define BYTES_PER_VOXEL	sizeof(RawVoxel)	// voxel size in bytes

#endif
