/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "CONSTANTS.H"

#define DIMS lo_1,lo_2,hi_1,hi_2

c *************************************************************************
c ** XINIT **
c ** Create the one-dimensional radius arrays for r-z geometry.
c *************************************************************************

      subroutine xinit(x,xhalf,hx,DIMS,irz)

      integer DIMS
      REAL_T     x(lo_1-1:hi_1+1)
      REAL_T xhalf(lo_1  :hi_1+2)
      REAL_T hx
      integer irz

c     Local variables
      integer i

      if (irz .eq. 0) then

        do i = lo_1-1,hi_1+1 
          x(i) = one
        enddo

        do i = lo_1,hi_1+2 
          xhalf(i) = one
        enddo

      elseif (irz .eq. 1) then

        do i = lo_1,hi_1+1 
              x(i) = ((i-lo_1) + half)*hx
          xhalf(i) = (i-lo_1)        *hx
        enddo

        xhalf(hi_1+2) = (hi_1-lo_1+2)*hx
            x(lo_1-1) = x(lo_1)

      else
        print *,' bogus irz in xinit ',irz
        stop
      endif
      return
      end
