/***************************************************************************
                          cdbakeoven.cpp  -  description
                             -------------------
    begin                : Fri May 18 23:05:50 EDT 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <iostream.h>

// include files for QT
#include <qdir.h>
#include <qpainter.h>
#include <qtooltip.h>
#include <qpushbutton.h>
#include <qpopupmenu.h>

// include files for KDECDBakeOvenApp
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kio/job.h>
#include <kio/jobclasses.h>
#include <kstdaction.h>
#include <kprogress.h>

// application specific includes
#include "cdbakeoven.h"
#include "cdbakeovenview.h"
#include "dialogs/CdboDialogBase.h"
#include "dialogs/MainDialog.h"
#include "dialogs/EraseDialog.h"
#include "dialogs/CdCopyDialog.h"
#include "dialogs/NewCdDialog.h"
#include "dialogs/SettingsDialog.h"

//#define ID_STATUS_MSG 1
//#define CONFIG_DIR

CDBakeOvenApp::CDBakeOvenApp(QWidget* , const char* name):KMainWindow(0, name){
  	config = kapp->config();
   	config->setGroup("System Settings");		
	config->writeEntry("User Name", "Unknown");
		
	eTimeId = -1;

     initStatusBar();
     initActions();
     initView();
     readOptions();

}
//------------------------------------------------------------------------------------
CDBakeOvenApp::~CDBakeOvenApp(){
	delete showMainDialog;
	delete quit;
}
//------------------------------------------------------------------------------------
void CDBakeOvenApp::initActions(){
	
	fileOpen = KStdAction::open(this, SLOT(slotFileOpen()), actionCollection());	
  	fileOpenRecent = KStdAction::openRecent(this, SLOT(slotFileOpenRecent(const KURL&)), actionCollection());
  	fileSave = KStdAction::save(this, SLOT(slotFileSave()), actionCollection());
     	fileSaveAs = KStdAction::saveAs(this, SLOT(slotFileSaveAs()), actionCollection());

    	quit = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());

     	QPopupMenu* settingsMenu = new QPopupMenu(this);

     	viewToolBar = KStdAction::showToolbar(this, SLOT(slotViewToolBar()), this);
     	viewToolBar->plug(settingsMenu);
    	viewStatusBar = KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), this);
    	viewStatusBar->plug(settingsMenu);
    	//settingsMenu->insertSeparator();

     	fileOpen->setStatusText(i18n("Open an existing ISO Image"));
     	fileOpenRecent->setStatusText(i18n("Opens a recently used file"));

    	quit->setStatusText(i18n("Quits the application"));
     	viewToolBar->setStatusText(i18n("Enables/disables the toolbar"));
  	viewStatusBar->setStatusText(i18n("Enables/disables the statusbar"));

	createGUI();
  	KToolBar *toolbar = toolBar();
  	
  	fileNewAction = new KToolBarPopupAction(i18n("Creates a new compilation list"), "filenew",
  					CTRL+Key_N, this,
       				SLOT(slotFileNew()), this);
	//fileNewAction->setStickyMenu(false);
  	QPopupMenu* newMenu = fileNewAction->popupMenu();
  	
  	fileNewData = new KAction(i18n("Data Backup CD"), SmallIcon("cdrom_unmount"),
                               CTRL+Key_D, this,
                               SLOT(slotDataNew()), this);
  	fileNewAdvancedData = new KAction(i18n("Data CD With Custom Layout"), SmallIcon("cdwriter_unmount"),
                               CTRL+SHIFT+Key_D, this,
                               SLOT(slotAdvancedNew()), this);

  	fileNewMusic = new KAction(i18n("Music CD"), SmallIcon("multimedia"),
                               CTRL+Key_N, this,
                               SLOT(slotAudioNew()), this);
   	fileNewMix = new KAction(i18n("Mix Mode CD"), SmallIcon("package_applications"),
                               CTRL+Key_M, this,
                               SLOT(slotFileNew()), this);
	
  	showFilterPnl = new KToggleAction(i18n("Show File Filter Panel"), QIconSet( SmallIcon("filefind"), BarIcon("filefind")),
                               CTRL+Key_F, this,
                               SLOT(slotShowFilterPnl()), this);
	/*showEstimatePnl = new KToggleAction(i18n("Show Estimate Panel"), SmallIcon("date"),
                               CTRL+Key_E, this,
                               SLOT(slotShowEstimatePnl()), this);*/
       showEstimatePnl = new KToggleAction(i18n("Show Estimate Panel"), QIconSet( SmallIcon("date"), BarIcon("date")),
                               CTRL+Key_E, this,
                               SLOT(slotShowEstimatePnl()), this);

	showSourceContPnl = new KToggleAction(i18n("Show Source Tree Control"),
                               0, this,
                               SLOT(slotShowSourceContPnl()), this);
	showCompilContPnl = new KToggleAction(i18n("Show Compilation List Control"),
                               0, this,
                               SLOT(slotShowCompilContPnl()), this);

   	newMenu->insertSeparator();
  	fileNewData->plug(newMenu);
  	fileNewAdvancedData->plug(newMenu);
  	fileNewMusic->plug(newMenu);
  	
  	newMenu->insertSeparator();
  	fileNewMix->plug(newMenu);
  	
  	fileNewAction->plug(toolbar,0);
  	
  	fileNewListAction = new KListAction(i18n("&New..."), "filenew",
  					CTRL+Key_N, this,
       				SLOT(slotFileNew()), this);
  	newMenu = fileNewListAction->popupMenu();
  	fileNewData->plug(newMenu);
  	fileNewAdvancedData->plug(newMenu);
  	fileNewMusic->plug(newMenu);
  	
  	newMenu->insertSeparator();
  	fileNewMix->plug(newMenu);
  	
  	fileNewListAction->plug(quit->container(0),0);
  	
  	
  	QPopupMenu* actionsMenu = new QPopupMenu(this);
  	
  	
  	showMainDialog = new KAction(i18n("Popup Main Dialog"), QIconSet( SmallIcon("wizard"), BarIcon("wizard")),//MainBarIcon("wizard"),
                               Key_F3, this,
                               SLOT(slotShowMainDialog()), this);
   	showCopyDialog = new KAction(i18n("Copy CD"), UserIcon("cdcopySm"),
   						Key_F5 , this,
                               SLOT(popupCopyDialog()), this);
    showSettingsDialog = new KAction(i18n("Configure CDBakeOven..."), QIconSet( SmallIcon("package_utilities"),UserIcon("setUpSm")),
                               Key_F2, this,
                               SLOT(popupSettingsDialog()), this);
    showEraseDialog = new KAction(i18n("Erase CD-RW"), QIconSet( UserIcon("eraseSm"), UserIcon("erase")),
                               Key_F6, this,
                               SLOT(popupEraseDialog()), this);
	 showCreateDialog = new KAction(i18n("Create New CD"), QIconSet( UserIcon("cdImageVerySm"), UserIcon("cdImageSm")),
                               Key_F7, this,
                               SLOT(popupNewDataCdDialog()), this);
	showFixateDialog = new KAction(i18n("Fixate Unfixated CD-R(W)"),
                               Key_F8, this,
                               SLOT(popupFixateCdDialog()), this);

	loadSessionAction = new KAction(i18n("Load Previous Session"),
                               Key_F4, this,
                               SLOT(loadSessionSlot()), this);

	showMainDialog->plug(toolbar);
	showMainDialog->plug(actionsMenu);
	
	actionsMenu->insertSeparator();
	
	toolbar->insertLineSeparator();
	
	showCopyDialog->plug(toolbar);
	showCopyDialog->plug(actionsMenu);
	
	showEraseDialog->plug(toolbar);
	showEraseDialog->plug(actionsMenu);
	
	showCreateDialog->plug(actionsMenu);
	actionsMenu->insertSeparator();
	showFixateDialog->plug(actionsMenu);
	loadSessionAction->plug(actionsMenu);
	
	showSettingsDialog->plug(toolbar);
	
	showSourceContPnl->plug(settingsMenu);
	showCompilContPnl->plug(settingsMenu);
	
	settingsMenu->insertSeparator();
	
	showFilterPnl->plug(settingsMenu);
	showEstimatePnl->plug(settingsMenu);
	
	settingsMenu->insertSeparator();
	showSettingsDialog->plug(settingsMenu);
	
	
	toolbar->insertLineSeparator();
	showFilterPnl->plug(toolbar);
	showEstimatePnl->plug(toolbar);
	
	toolbar->insertLineSeparator();
	
	quit->plug(toolbar);
	
	menuBar()->insertItem("&Actions", actionsMenu, 9, 1);
	menuBar()->insertItem("&Settings", settingsMenu, 10, 2);
}
//------------------------------------------------------------------------------------
void CDBakeOvenApp::initStatusBar(){
 	
 	status = new QLabel("Ready", statusBar(), "status");
	status->setMaximumHeight(18);
	statusBar()->addWidget(status,7, true);
	
 	//statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG, 5);
	
	QLabel *spacer = new QLabel(statusBar(), "spacer");
	spacer->setMaximumHeight(18);
	statusBar()->addWidget(spacer,1, true);
	
	info = new QLabel(statusBar(), "info");
	info->setMaximumHeight(18);
  	statusBar()->addWidget(info, 4, true);
  	
  	QLabel *spacer2 = new QLabel(statusBar(), "spacer2");
	spacer2->setMaximumHeight(18);
	statusBar()->addWidget(spacer2,1, true);
	
  	cancelOperationBtn = new QPushButton( statusBar(), "cancelOperationBtn" );
    	QFont cancelOperationBtn_font(  cancelOperationBtn->font() );
    	cancelOperationBtn_font.setBold( TRUE );
    	cancelOperationBtn->setFont( cancelOperationBtn_font ); 	
    	cancelOperationBtn->setText( i18n( "&Cancel" ) );
    	cancelOperationBtn->setMaximumHeight(22);
    	QToolTip::add(  cancelOperationBtn, tr( "Cancel Running Operation" ) );
    	cancelOperationBtn->setEnabled(false);
    	
    	connect( cancelOperationBtn, SIGNAL( clicked() ),
    		this, SLOT( cancelOperation() ) );
    	
    	statusBar()->addWidget( cancelOperationBtn, 2, true);

    	progress = new KProgress(KProgress::Horizontal, statusBar(), "progress");
	progress->setTextEnabled(false);
	progress->setMaximumHeight(20);
  	statusBar()->addWidget(progress, 5, true);
  	
}
//------------------------------------------------------------------------------------
void CDBakeOvenApp::initView(){
  	view = new CDBakeOvenView(this, "mainView");
  	setCentralWidget(view);
  	
}
//------------------------------------------------------------------------------------
void CDBakeOvenApp::openDocumentFile(const KURL& url){
	if(isRunningSomething())
		return;
		
	QString fileToOpen = url.path();
	if(fileToOpen.find(".cdbo", -5, false) == -1){
		NewCdDialog *ncd = new NewCdDialog(this,"eraseD", fileToOpen);
		ncd->exec();
		delete ncd;
	}
	else{
		KConfig *file = new KConfig(fileToOpen);
		file->setGroup("CD Bake Oven - CD File List");
		QString buff = file->readEntry("Type of CD", "New Data CD");
		
		if(buff == "New Audio CD")
  			view->showAudio();
		if(buff == "Advanced Layout Data CD")
  			view->showAdvanced();
  		else
			view->showData();

		newList(fileToOpen);
	}
}
//------------------------------------------------------------------------------------
void CDBakeOvenApp::saveOptions(){	
     config->setGroup("General Options");
     config->writeEntry("Geometry", size());
     config->writeEntry("Show Toolbar", viewToolBar->isChecked());
     config->writeEntry("Show Statusbar",viewStatusBar->isChecked());
     config->writeEntry("ToolBarPos", (int) toolBar("mainToolBar")->barPos());

     config->writeEntry("Show Filter Panel", showFilterPnl->isChecked());
     config->writeEntry("Show Estimate Panel", showEstimatePnl->isChecked());
     config->writeEntry("Show Source Cont Panel", showSourceContPnl->isChecked());
     config->writeEntry("Show Compilation Cont Panel", showCompilContPnl->isChecked());

     fileOpenRecent->saveEntries(config);

	config->sync();
}
//------------------------------------------------------------------------------------
void CDBakeOvenApp::readOptions(){
	
  	config->setGroup("General Options");

  	// bar status settings
  	bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
	viewToolBar->setChecked(bViewToolbar);
	slotViewToolBar();

	
  	showFilterPnl->setChecked(config->readBoolEntry("Show Filter Panel", true));
  	slotShowFilterPnl();
  	showEstimatePnl->setChecked(config->readBoolEntry("Show Estimate Panel", true));
  	slotShowEstimatePnl();
  	showSourceContPnl->setChecked(config->readBoolEntry("Show Source Cont Panel", true));
  	slotShowSourceContPnl();
  	showCompilContPnl->setChecked(config->readBoolEntry("Show Compilation Cont Panel", true));
	slotShowCompilContPnl();


  	bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  	viewStatusBar->setChecked(bViewStatusbar);
  	slotViewStatusBar();


 	// bar position settings
 	KToolBar::BarPosition toolBarPos;
 	toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);
 	toolBar("mainToolBar")->setBarPos(toolBarPos);
	
	QSize size=config->readSizeEntry("Geometry");
	if(!size.isEmpty()){
		resize(size);
	}
	
  	///////////////////////////////////////////////////////////
  	config->setGroup("Default Settings");	
  	shouldShowMainDialog = config->readBoolEntry("show Main Dialog on start", true);
  	
  	fileOpenRecent->loadEntries(config);
}
//------------------------------------------------------------------------------------
bool CDBakeOvenApp::queryExit(){
  saveOptions();
  return true;
}
//------------------------------------------------------------------------------------
void CDBakeOvenApp::tryToShowMainDialog(){
	if(shouldShowMainDialog)
		slotShowMainDialog();
}
//---------------------------------------------------------------------------------------------
void CDBakeOvenApp::popUpSettings(int type){
	SettingsDialog *sd = new SettingsDialog(this,"settingsD", true,type);
	connect( sd, SIGNAL(applied()), this, SLOT(emitSettingsChanged()));
	sd->exec();
	delete sd;
	emit settingsChanged();
}
//---------------------------------------------------------------------------------------------
void CDBakeOvenApp::emitSettingsChanged(){
	emit settingsChanged();
}
/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void CDBakeOvenApp::slotShowMainDialog(){
	MainDialog *md = new MainDialog(this,"MainDialog");
	switch(md->popUp()){
		case CdboDialogBase::CdCopyDialogType: popupCopyDialog(); break;
		case CdboDialogBase::NewCdDialogType: popupNewCdDialog(); break;
		case CdboDialogBase::MusicDialogType: popupMusicDialog(); break;
		case CdboDialogBase::EraseDialogType: popupEraseDialog(); break;
		case CdboDialogBase::SettingsDialogType: popupSettingsDialog(); break;
	}
    	//delete md;
}
//=====================================
void CDBakeOvenApp::popupCopyDialog(){
	CdCopyDialog *ccd = new CdCopyDialog(this,"copyD");
	ccd->exec();
	delete ccd;
}
//======================================
void CDBakeOvenApp::popupSettingsDialog(){
	popUpSettings(SettingsDialog::Specifications);
}

//=======================================
void CDBakeOvenApp::popupEraseDialog(){
	EraseDialog *ed = new EraseDialog(this,"eraseD");
	ed->exec();
	delete ed;
}
//=======================================
void CDBakeOvenApp::popupFixateCdDialog(){
	EraseDialog *ed = new EraseDialog(false,this,"fixateD");
	ed->exec();
	delete ed;
}
//==========================================
void CDBakeOvenApp::popupMusicDialog(){
	//QStringList *list = new QStringList();
	//NewAudioCdDialog *ncd = new NewAudioCdDialog(list, this,"newMusicD");
	//ncd->exec();
	//delete ncd;
}
//=====================================
void CDBakeOvenApp::popupNewCdDialog(){
	NewCdDialog *ncd = new NewCdDialog(this,"newCdD");
	ncd->exec();
	delete ncd;
}
//=====================================
void CDBakeOvenApp::popupNewDataCdDialog(){
	NewCdDialog *ncd = new NewCdDialog(this,"newCdD");
	ncd->exec();
	delete ncd;
}
//=====================================
void CDBakeOvenApp::cancelOperation(){
	if(jobs.isEmpty()){
		//cerr << "empty\n";
		return;
	}
	
	KIO::Job *jobToKill;
	for(jobToKill = jobs.first(); jobToKill; jobToKill = jobs.next()){
		
		QString b = jobToKill->name();
		emit longProcessCanceled();
		emit longProcessCanceled(b);
		if(jobToKill)
			jobToKill->kill();
		removeJob(jobToKill);
	}
}
//==============================================
//---------------------------------------------------------------------------------------------
void CDBakeOvenApp::startShowProgress(){
	if(eTimeId != -1) return;
	lastPercent = 0;
	eTimeId = startTimer(45);
}
//---------------------------------------------------------------------------------------------
void CDBakeOvenApp::stopShowProgress(){
	killTimer(eTimeId);
	progress->setValue(100);
	eTimeId = -1;
}
//---------------------------------------------------------------------------------------------
void CDBakeOvenApp::timerEvent(QTimerEvent *event){
	if(event->timerId() == eTimeId){
		lastPercent += 10;
		if(lastPercent > 100)
			lastPercent = 0;
		progress->setValue(lastPercent);
	}
}
//=======================================
void CDBakeOvenApp::slotFileNew(){
	if(isRunningSomething())
		return;
	if(!view->newActive())
		return;
	emit newList();
}

//=======================================
void CDBakeOvenApp::slotAudioNew(){
	if(isRunningSomething())
		return;
	
  	if(!view->showAudio())
  		return;
	emit newList();
	//emit settingsChanged();
}
//=======================================
void CDBakeOvenApp::slotDataNew(){
	if(isRunningSomething())
		return;
	
  	if(!view->showData())
  		return;
  	emit newList();		
	//emit settingsChanged();
}
//==========================================
void CDBakeOvenApp::slotAdvancedNew(){
	if(isRunningSomething())
		return;
  	if(!view->showAdvanced())
  		return;
  	emit newList();		
	//emit settingsChanged();
}
//==========================================
void CDBakeOvenApp::loadSessionSlot(){
	if(isRunningSomething())
		return;
  	if(!view->showAdvanced())
  		return;
  	emit loadSession();		
	//emit settingsChanged();
}
//=======================================
bool CDBakeOvenApp::isRunningSomething(){
	if(!jobs.isEmpty()){
		KMessageBox::error(this,
			"There is still a running process! Please cancel it with 'Cancel'\n"\
			"button and try this Action again, or wait for it to finish.");
		return true;
	}
	return false;
}
//------------------------------------------------------------------------------------
void CDBakeOvenApp::saveProperties(KConfig *)
{
  /*if(doc->URL().fileName()!=i18n("Untitled") && !doc->isModified())
  {
    // saving to tempfile not necessary

  }
  else
  {
    KURL url=doc->URL();	
    _cfg->writeEntry("filename", url.url());
    _cfg->writeEntry("modified", doc->isModified());
    QString tempname = kapp->tempSaveName(url.url());
    QString tempurl= KURL::encode_string(tempname);
    KURL _url(tempurl);
    doc->saveDocument(_url);
  }*/
}


void CDBakeOvenApp::readProperties(KConfig*)// _cfg)
{
/*
  QString filename = _cfg->readEntry("filename", "");
  KURL url(filename);
  bool modified = _cfg->readBoolEntry("modified", false);
  if(modified)
  {
    bool canRecover;
    QString tempname = kapp->checkRecoverFile(filename, canRecover);
    KURL _url(tempname);
  	
    if(canRecover)
    {
      doc->openDocument(_url);
      doc->setModified();
      //setCaption("CD Bake Oven",true);
      QFile::remove(tempname);
    }
  }
  else
  {
    if(!filename.isEmpty())
    {
      doc->openDocument(url);
      //setCaption("CD Bake Oven",false);
    }
  }*/
}		
//=======================================
bool CDBakeOvenApp::queryClose(){
	return view->queryClose();
}
//-------------------------------------------------------------------------
void CDBakeOvenApp::slotFileOpen(){
	if(isRunningSomething())
		return;
	slotStatusMsg(i18n("Openning file..."));
    	KURL url=KFileDialog::getOpenURL(QDir::homeDirPath(),
       	 i18n("*.iso *.ISO *.cdbo|Supported Files (*.iso, *.cdbo)\n*|All files"),
       	 this, i18n("Open ISO Image or CD List File..."));
    	if(!url.isEmpty()){
     		openDocumentFile( url );
      		fileOpenRecent->addURL( url );
      		
    	}
  	slotStatusMsg(i18n("Ready."));
}
//------------------------------------------------------------------------------------------------------
void CDBakeOvenApp::slotFileOpenRecent(const KURL &url){
  	openDocumentFile( url );
}
//------------------------------------------------------------------------------------
void CDBakeOvenApp::slotFileQuit(){
  	slotStatusMsg(i18n("Exiting..."));
  	if(!queryClose()) return;
  	saveOptions();
  	view->saveOptions();
 	kapp->exit();
}
//------------------------------------------------------------------------------------
void CDBakeOvenApp::slotViewToolBar(){
  	slotStatusMsg(i18n("Toggling toolbar..."));
 	 ///////////////////////////////////////////////////////////////////
 	 // turn Toolbar on or off
  	if(!viewToolBar->isChecked())
    		toolBar("mainToolBar")->hide();
  	else
    		toolBar("mainToolBar")->show();	
  	slotStatusMsg(i18n("Ready."));
}
//------------------------------------------------------------------------------------
void CDBakeOvenApp::slotViewStatusBar(){
  	slotStatusMsg(i18n("Toggle the statusbar..."));
  	///////////////////////////////////////////////////////////////////
  	//turn Statusbar on or off
  	if(!viewStatusBar->isChecked())
    		statusBar()->hide();
 	 else
    		statusBar()->show();
  	slotStatusMsg(i18n("Ready."));
}
//====================================
void CDBakeOvenApp::slotShowCompilContPnl(){
	view->showTargetControl(showCompilContPnl->isChecked());
}
//====================================
void CDBakeOvenApp::slotShowSourceContPnl(){
	view->showSrcControl(showSourceContPnl->isChecked());
}
//====================================
void CDBakeOvenApp::slotShowEstimatePnl(){
	view->showEstimate(showEstimatePnl->isChecked());
}
//====================================
void CDBakeOvenApp::slotShowFilterPnl(){
	view->showFilterPnl(showFilterPnl->isChecked());
}
//------------------------------------------------------------------------------------
void CDBakeOvenApp::slotStatusMsg(const QString &text){
  status->setText(text);
}
//------------------------------------------------------------------------------------
/*void CDBakeOvenApp::slotNewFileName(const QString &text){
  	info->setText(text);
    	setCaption(text,false);
}
*/
//====================================
void CDBakeOvenApp::slotFileSave(){
	if(isRunningSomething())
		return;
  	slotStatusMsg(i18n("Saving file..."));
	emit saveList();
  	slotStatusMsg(i18n("Ready."));
}
//=====================================
void CDBakeOvenApp::slotFileSaveAs(){
	if(isRunningSomething())
		return;
  	slotStatusMsg(i18n("Saving file with a new filename..."));
	emit saveListAs();
  	slotStatusMsg(i18n("Ready."));
}
