/***************************************************************************
                          EraseDialog.h  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                :  alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ERASEDIALOG_H
#define ERASEDIALOG_H

#include <qwidget.h>
#include <qstring.h>
#include <qevent.h>

#include <kconfig.h>
#include <kprocess.h>

#include "EraseDialogBase.h"
#include "CdboDialogBase.h"
#include "CdboDialogActionFactory.h"
#include "dialogParts/DriveInfoPnl.h"
#include "dialogParts/SpeedPnl.h"
#include "dialogParts/DialogCntPnl.h"

/**
  *@author
  */

class EraseDialog : public EraseDialogBase, public CdboDialogBase  {
   Q_OBJECT
public:
	EraseDialog(QWidget *parent=0, const char *name=0);
	EraseDialog(bool eraseMode,QWidget *parent=0, const char *name=0);
	~EraseDialog();

//protected:
	
	//implementing pure virtuals
	virtual void blockBtns(bool) const;
	virtual QString getActionType() const;
	
	inline virtual void output(int type, QString message) const { dialogCntPnl->output(type, message); }
	inline virtual void status(QString message) const { dialogCntPnl->status(message); }
	
	inline virtual QString getScsiDevice() const { return targetDevicePnl->getScsiDevice(); }
	inline virtual QString getSpeed() const { return speedPnl->getSpeed(); }

	
protected slots:
	virtual void closeEvent(QCloseEvent *e);
	
	void taskDone(bool);
	void taskFailedToStart();

    void startBtnSlot();
    void quitSlot();
    void settingsSlot();
    void cancelSlot();
    void previewSlot();
    void customBtnSlot();

    void detectDestSlot();

    virtual void keyPressEvent(QKeyEvent *e);

private:	
	bool stillErasing;
	bool stillFixating;
	bool stillChecking;	
	
	KConfig *config;
	CdboDialogActionFactory *factory;
	
	//methods
	void init();
	void saveOptions();
	void readOptions();
	void initBtns();
	bool confermExit();
	void popUpSettings(int);
	bool eraseMode;
};
#endif